prompt --application/set_environment
set define off verify off feedback off
whenever sqlerror exit sql.sqlcode rollback
--------------------------------------------------------------------------------
--
-- ORACLE Application Express (APEX) export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_190200 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_api.import_begin (
 p_version_yyyy_mm_dd=>'2019.10.04'
,p_release=>'19.2.0.00.18'
,p_default_workspace_id=>22073081542601549
,p_default_application_id=>100
,p_default_id_offset=>22073620492601560
,p_default_owner=>'CRONOLOGY'
);
end;
/

prompt APPLICATION 100 - Cronology Console
--
-- Application Export:
--   Application:     100
--   Name:            Cronology Console
--   Exported By:     CRONOLOGY
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     14
--       Items:                  512
--       Validations:             26
--       Processes:               30
--       Regions:                174
--       Buttons:                193
--       Dynamic Actions:        378
--     Shared Components:
--       Logic:
--         Items:                  1
--         Computations:           1
--         App Settings:           1
--         Build Options:          2
--       Navigation:
--         Lists:                  2
--         Breadcrumbs:            1
--       Security:
--         Authentication:         1
--         Authorization:          6
--         ACL Roles:              3
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                 9
--           Region:              16
--           Label:                7
--           List:                12
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               3
--           Report:              11
--         LOVs:                  17
--         Shortcuts:              1
--         Plug-ins:               1
--       Globalization:
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         19.2.0.00.18
--   Instance ID:     200183879779049
--

prompt --application/delete_application
begin
wwv_flow_api.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_api.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'CRONOLOGY')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Cronology Console')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'CRONOLOGY_CONSOLE')
,p_page_view_logging=>'NO'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt=>'62B2C6FBB3287D33E6F6FF65725969A72AE5AD0A2D46F8E1DF7A6C5931CD67FB'
,p_bookmark_checksum_function=>'SH1'
,p_max_session_length_sec=>0
,p_on_max_session_timeout_url=>'#LOGOUT_URL#'
,p_max_session_idle_sec=>864000
,p_on_max_idle_timeout_url=>'#LOGOUT_URL#'
,p_compatibility_mode=>'19.2'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'FLOW_PRIMARY_LANGUAGE'
,p_date_format=>'DD-MON-YYYY HH24:MI:SS'
,p_date_time_format=>'DD-MON-YYYY HH24:MI:SS'
,p_timestamp_format=>'DD-MON-YYYY HH24:MI:SS'
,p_timestamp_tz_format=>'DD-MON-YYYY HH24:MI:SS'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'https://static.oracle.com/cdn/apex/19.2.0.00.18/')
,p_documentation_banner=>'Application created from create application wizard 2020.03.30.'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_api.id(31715813513464739)
,p_application_tab_set=>0
,p_logo_type=>'T'
,p_logo_text=>'&AP_NAME. Console | &DB_DETAILS.&P2_ENV_LABEL.'
,p_app_builder_icon_name=>'cronology.ico'
,p_favicons=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<link rel="shortcut icon" href="#APP_IMAGES#cronology.ico">',
'<link rel="icon" sizes="16x16" href="#APP_IMAGES#cronology.ico">',
'<link rel="icon" sizes="32x32" href="#APP_IMAGES#cronology.ico">',
'<link rel="apple-touch-icon" sizes="180x180" href="#APP_IMAGES#cronology.ico">'))
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'4.2.7'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_build_status=> 'RUN_ONLY'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_security_scheme=>wwv_flow_api.id(24344738422782061)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'external.apex_error_handling'
,p_default_error_display_loc=>'INLINE_WITH_FIELD'
,p_substitution_string_01=>'APP_NAME'
,p_substitution_value_01=>'CRONOLOGY'
,p_substitution_string_02=>'AP_NAME'
,p_substitution_value_02=>'Cronology'
,p_substitution_string_03=>'VER_REVISION'
,p_substitution_value_03=>'$Revision: #11 $'
,p_last_updated_by=>'CRON_DEV'
,p_last_upd_yyyymmddhh24miss=>'20250506155632'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>203
,p_ui_type_name => null
);
end;
/
prompt --application/shared_components/navigation/lists/desktop_navigation_bar
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(24318688776742456)
,p_name=>'Desktop Navigation Bar'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24334015650742872)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'&APP_USER.'
,p_list_item_link_target=>'#'
,p_list_item_icon=>'fa-user-circle-o'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24333665510742871)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'About'
,p_list_item_link_target=>'f?p=&APP_ID.:10010:&SESSION.::&DEBUG.:10010:::'
,p_list_item_icon=>'fa-info-circle-o'
,p_parent_list_item_id=>wwv_flow_api.id(24334015650742872)
,p_required_patch=>wwv_flow_api.id(24321029955742629)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24332837281742869)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'Help'
,p_list_item_link_target=>'javascript:apex.navigation.openInNewWindow(''https://www.&APP_NAME..co.uk/console-guide-4-2'');'
,p_list_item_icon=>'fa-question-circle-o'
,p_parent_list_item_id=>wwv_flow_api.id(24334015650742872)
,p_list_text_02=>'icon-only'
,p_security_scheme=>wwv_flow_api.id(24344738422782061)
,p_required_patch=>wwv_flow_api.id(24321029955742629)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24619886158653555)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(24334015650742872)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(24334868148742872)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Sign Out'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-sign-out'
,p_parent_list_item_id=>wwv_flow_api.id(24334015650742872)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/main_menu
begin
wwv_flow_api.create_list(
 p_id=>wwv_flow_api.id(32851726542400017)
,p_name=>'Main Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32852495834401633)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Job Parameters'
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-list-alt'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33582910932515426)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(34655266984982872)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Create Job'
,p_list_item_icon=>'fa-plus-square-o'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38378811455936365)
,p_list_item_display_sequence=>32
,p_list_item_link_text=>'New'
,p_list_item_icon=>'fa-square-o'
,p_parent_list_item_id=>wwv_flow_api.id(34655266984982872)
,p_list_text_01=>'create-job'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38379221874943304)
,p_list_item_display_sequence=>33
,p_list_item_link_text=>'Copy Selected'
,p_list_item_icon=>'fa-clone'
,p_parent_list_item_id=>wwv_flow_api.id(34655266984982872)
,p_list_text_01=>'copy-job'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(34799476846046355)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Bring Job Online'
,p_list_item_icon=>'fa-redo-alt'
,p_list_text_01=>'bring-online'
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32866498512157378)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32851949528400018)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'Schedule'
,p_list_item_icon=>'fa-format'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(33599766089543532)
,p_list_item_display_sequence=>57
,p_list_item_link_text=>'Manage'
,p_list_item_link_target=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-wrench'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35599721369712956)
,p_list_item_display_sequence=>58
,p_list_item_link_text=>'Settings'
,p_list_item_icon=>'fa-gear'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_list_text_01=>'schedule-settings'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37305714984135002)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Global Update'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-pencil'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(35201745787263994)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Messaging Options'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-envelope-wrench'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37948042838026416)
,p_list_item_display_sequence=>85
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37948795921036693)
,p_list_item_display_sequence=>87
,p_list_item_link_text=>'Audit History'
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::P4_AUDIT_ID,P4_AUDIT_ID_TYPE:,:'
,p_list_item_icon=>'fa-history'
,p_parent_list_item_id=>wwv_flow_api.id(32851949528400018)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37302075633099345)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(32866947118178429)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Background Processes'
,p_list_item_icon=>'fa-network-triangle'
,p_list_text_01=>'bg-process'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37302333427101562)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37531552869898768)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Status Summary'
,p_list_item_icon=>'fa-table-search'
,p_list_text_01=>'status-summary'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37757699923035561)
,p_list_item_display_sequence=>125
,p_list_item_link_text=>'Job Analysis'
,p_list_item_link_target=>'f?p=&APP_ID.:5:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-table-chart'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37538858178129418)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41242063337997765)
,p_list_item_display_sequence=>133
,p_list_item_link_text=>'Database Sessions'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa-database-user'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(41242774354030503)
,p_list_item_display_sequence=>134
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38304503790746199)
,p_list_item_display_sequence=>135
,p_list_item_link_text=>'Console'
,p_list_item_icon=>'fa-desktop'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37275665145742723)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Refresh'
,p_list_item_icon=>'fa-refresh'
,p_parent_list_item_id=>wwv_flow_api.id(38304503790746199)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(37276018359745729)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'10 seconds|30 seconds|1 minute|2 minutes|5 minutes|Off'
,p_parent_list_item_id=>wwv_flow_api.id(37275665145742723)
,p_list_text_01=>'console-refresh'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38304927132752745)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Fit to Screen'
,p_list_item_icon=>'fa-fit-to-size'
,p_parent_list_item_id=>wwv_flow_api.id(38304503790746199)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_api.create_list_item(
 p_id=>wwv_flow_api.id(38303504765509908)
,p_list_item_display_sequence=>175
,p_list_item_link_text=>'On|Off'
,p_parent_list_item_id=>wwv_flow_api.id(38304927132752745)
,p_list_text_01=>'console-zoom'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/files/app_icon_svg
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '3C73766720786D6C6E733D22687474703A2F2F7777772E77332E6F72672F323030302F7376672220786D6C6E733A786C696E6B3D22687474703A2F2F7777772E77332E6F72672F313939392F786C696E6B222076696577426F783D223020302036342036';
wwv_flow_api.g_varchar2_table(2) := '34223E3C646566733E3C7374796C653E2E636C732D317B66696C6C3A75726C282372616469616C2D6772616469656E74293B7D2E636C732D327B6F7061636974793A302E313B7D2E636C732D332C2E636C732D347B66696C6C3A236666663B7D2E636C73';
wwv_flow_api.g_varchar2_table(3) := '2D337B6F7061636974793A302E363B7D3C2F7374796C653E3C72616469616C4772616469656E742069643D2272616469616C2D6772616469656E74222063783D223332222063793D222E30352220723D22363422206772616469656E74556E6974733D22';
wwv_flow_api.g_varchar2_table(4) := '7573657253706163654F6E557365223E3C73746F70206F66667365743D2230222073746F702D636F6C6F723D2223666666222073746F702D6F7061636974793D22302E3135222F3E3C73746F70206F66667365743D222E35222073746F702D636F6C6F72';
wwv_flow_api.g_varchar2_table(5) := '3D2223666666222073746F702D6F7061636974793D22302E31222F3E3C73746F70206F66667365743D2231222073746F702D636F6C6F723D2223666666222073746F702D6F7061636974793D2230222F3E3C2F72616469616C4772616469656E743E3C73';
wwv_flow_api.g_varchar2_table(6) := '796D626F6C2069643D22616D6269656E742D6C69676874696E67222076696577426F783D22302030203634203634223E3C7061746820636C6173733D22636C732D312220643D224D302030683634763634682D36347A222F3E3C2F73796D626F6C3E3C2F';
wwv_flow_api.g_varchar2_table(7) := '646566733E3C7469746C653E6261722D6C696E652D63686172743C2F7469746C653E3C726563742077696474683D22363422206865696768743D223634222066696C6C3D2223434135383944222F3E3C672069643D2269636F6E73223E3C706174682063';
wwv_flow_api.g_varchar2_table(8) := '6C6173733D22636C732D322220643D224D313920343668357631682D357A4D323620343668357631682D357A4D333320343668357631682D357A4D343020343668357631682D357A222F3E3C7061746820636C6173733D22636C732D332220643D224D31';
wwv_flow_api.g_varchar2_table(9) := '3920333868357638682D357A4D32362033326835763134682D357A4D33332033326835763134682D357A4D34302032376835763139682D357A222F3E3C6720636C6173733D22636C732D32223E3C636972636C652063783D2234322E35222063793D2232';
wwv_flow_api.g_varchar2_table(10) := '302E352220723D22312E35222F3E3C636972636C652063783D2233352E35222063793D2232352E352220723D22312E35222F3E3C636972636C652063783D2232382E35222063793D2232352E352220723D22312E35222F3E3C636972636C652063783D22';
wwv_flow_api.g_varchar2_table(11) := '32312E35222063793D2233312E352220723D22312E35222F3E3C7061746820643D224D32312E3832352033312E3837396C2D2E36352D2E37353820372E31342D362E31323168372E3032356C362E3836392D342E3930372E3538322E3831342D372E3133';
wwv_flow_api.g_varchar2_table(12) := '3120352E303933682D362E3937356C2D362E383620352E3837397A222F3E3C2F673E3C636972636C6520636C6173733D22636C732D34222063783D2234322E35222063793D2231392E352220723D22312E35222F3E3C636972636C6520636C6173733D22';
wwv_flow_api.g_varchar2_table(13) := '636C732D34222063783D2233352E35222063793D2232342E352220723D22312E35222F3E3C636972636C6520636C6173733D22636C732D34222063783D2232382E35222063793D2232342E352220723D22312E35222F3E3C636972636C6520636C617373';
wwv_flow_api.g_varchar2_table(14) := '3D22636C732D34222063783D2232312E35222063793D2233302E352220723D22312E35222F3E3C7061746820636C6173733D22636C732D342220643D224D32312E3832352033302E3837396C2D2E36352D2E37353820372E31342D362E31323168372E30';
wwv_flow_api.g_varchar2_table(15) := '32356C362E3836392D342E3930372E3538322E3831342D372E31333120352E303933682D362E3937356C2D362E383620352E3837397A222F3E3C2F673E3C7573652077696474683D22363422206865696768743D2236342220786C696E6B3A687265663D';
wwv_flow_api.g_varchar2_table(16) := '2223616D6269656E742D6C69676874696E67222069643D226C69676874696E67222F3E3C2F7376673E';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(24319837536742619)
,p_file_name=>'app-icon.svg'
,p_mime_type=>'image/svg+xml'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/app_icon_css
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2E6170702D69636F6E207B0A202020206261636B67726F756E642D696D6167653A2075726C286170702D69636F6E2E737667293B0A202020206261636B67726F756E642D7265706561743A206E6F2D7265706561743B0A202020206261636B67726F756E';
wwv_flow_api.g_varchar2_table(2) := '642D73697A653A20636F7665723B0A202020206261636B67726F756E642D706F736974696F6E3A203530253B0A202020206261636B67726F756E642D636F6C6F723A20234341353839443B0A7D';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(24320171743742629)
,p_file_name=>'app-icon.css'
,p_mime_type=>'text/css'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/cronology_css
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2A2066697820666F72204368726F6D6520393420627567202D205465787420696E206669656C647320626563616D6520696E76697369626C65207768656E2070616765206974656D20696E20666F6375732F636C69636B6564206F6E2E202A2F0D0A2E';
wwv_flow_api.g_varchar2_table(2) := '617065782D6974656D2D73656C6563742C202E617065782D6974656D2D746578742C202E617065782D6974656D2D74657874617265612C202E617065782D6974656D2D6D756C74692C202E612D4952522D7365617263682D6669656C64200D0A7B0D0A20';
wwv_flow_api.g_varchar2_table(3) := '6261636B666163652D7669736962696C6974793A2068696464656E3B0D0A7D200D0A0D0A0D0A2E757070657263617365207B20746578742D7472616E73666F726D3A7570706572636173653B207D0D0A2E6C6F77657263617365207B20746578742D7472';
wwv_flow_api.g_varchar2_table(4) := '616E73666F726D3A6C6F776572636173653B207D0D0A0D0A2E742D4865616465722D6272616E64696E672C202E742D4865726F526567696F6E2D69636F6E207B0D0A202020206261636B67726F756E642D636F6C6F723A20726762283432203535203637';
wwv_flow_api.g_varchar2_table(5) := '293B0D0A7D0D0A0D0A2E612D4D656E752D636F6E74656E74207B0D0A202020206261636B67726F756E642D636F6C6F723A20726762283432203535203637293B0D0A7D202020200D0A0D0A2F2A20202D2D6974656D5F6C6162656C735F7267623A207267';
wwv_flow_api.g_varchar2_table(6) := '62283138392C203132362C203020202920203B20202A2F0D0A3A726F6F74207B0D0A20202D2D6974656D5F6C6162656C735F7267623A202020726762283230392C203137302C20393120293B0D0A20202D2D655F7265645F7267623A2020202020202020';
wwv_flow_api.g_varchar2_table(7) := '20726762283134382C203135202C20313520290D0A7D0D0A0D0A0D0A2F2A20646F776E6C6F6164206469616C6F672043686F6F736520466F726D6174202A2F0D0A0D0A2E752D466F726D2D6C6162656C207B0D0A20202020636F6C6F723A20766172282D';
wwv_flow_api.g_varchar2_table(8) := '2D6974656D5F6C6162656C735F726762293B0D0A7D202020200D0A0D0A2F2A20746F6E6520646F776E2074686520686F7420627574746F6E20636F6C6F7572202A2F0D0A2E612D427574746F6E2D2D686F742C202E742D427574746F6E2D2D686F743A6E';
wwv_flow_api.g_varchar2_table(9) := '6F74282E742D427574746F6E2D2D73696D706C65292C20626F6479202E75692D627574746F6E2E75692D627574746F6E2D2D686F742C20626F6479202E75692D73746174652D64656661756C742E75692D7072696F726974792D7072696D617279207B0D';
wwv_flow_api.g_varchar2_table(10) := '0A202020206261636B67726F756E642D636F6C6F723A2072676228343620383920313237293B0D0A7D202020200D0A0D0A0D0A2F2A206869646520616E7920415045582068656C7020627574746F6E73206567206F6E2074686520646F776E6C6F616420';
wwv_flow_api.g_varchar2_table(11) := '6469616C6F67202A2F0D0A626F6479202E75692D627574746F6E2D68656C70207B0D0A20202020646973706C61793A206E6F6E653B0D0A7D0D0A0D0A2F2A20696E74657261637469766520677269642073656C656374656420726F7720686967686C6967';
wwv_flow_api.g_varchar2_table(12) := '68740D0A0D0A2E612D47562D7461626C652074722E69732D73656C6563746564202E612D47562D63656C6C207B0D0A20202020206261636B67726F756E642D636F6C6F723A20726762283235352C302C30293B0D0A7D0D0A0D0A2A2F0D0A0D0A2F2A206C';
wwv_flow_api.g_varchar2_table(13) := '6F7365207468652074696E7920626C616E6B206C696E65202D207768696368206973207768617473206C656674206F66207468652064697361626C656420746F6F6C626172210D0A2E612D49472D686561646572207B0D0A20202020646973706C61793A';
wwv_flow_api.g_varchar2_table(14) := '206E6F6E653B0D0A7D0D0A2A2F0D0A0D0A2F2A2064617461207069636B657220686F75727320616E64206D696E75746573202A2F0D0A626F6479202E75692D646174657069636B6572207370616E2E7370616E54696D652073656C656374207B0D0A2020';
wwv_flow_api.g_varchar2_table(15) := '2020206261636B67726F756E642D636F6C6F723A20626C61636B3B0D0A7D0D0A0D0A2F2A207365742074686520677265656E20616C65727420666F6E742073697A6520746F2073616D652061732041706578206275696C646572202D206D6F7265207375';
wwv_flow_api.g_varchar2_table(16) := '62746C65202A2F0D0A2E742D416C6572742D2D70616765202E742D416C6572742D7469746C65207B0D0A20202020666F6E742D73697A653A20313470783B0D0A7D0D0A0D0A0D0A2F2A20616C6C2073696E676C6520636F6C756D6E20706F707570206C6F';
wwv_flow_api.g_varchar2_table(17) := '767320746F20707265736572766520616E79206C656164696E672077686974657370616365202A2F0D0A2E75692D6469616C6F67202E75692D6469616C6F672D636F6E74656E742E612D506F7075704C4F562D6469616C6F67207B0D0A20202077686974';
wwv_flow_api.g_varchar2_table(18) := '652D73706163653A207072653B0D0A7D0D0A0D0A2F2A206D756C746920636F6C756D6E20706F70206C6F767320746F20707265736572766520616E79206C656164696E672077686974657370616365202A2F0D0A2E612D47562D7461626C65207464207B';
wwv_flow_api.g_varchar2_table(19) := '0D0A20202077686974652D73706163653A207072653B0D0A7D0D0A0D0A2F2A2068696465207468652053656C656374203120726F7720696E20746865206D617374657220726567696F6E206D65737361676520696620696E2061206368696C6420616E64';
wwv_flow_api.g_varchar2_table(20) := '206E6F206D6173746572207265636F7264202A2F0D0A2E612D47562D6E6F446174614D7367202E612D47562D616C744D6573736167652D74657874207B20646973706C6179203A6E6F6E653B7D0D0A2F2A206869646520746865206D61676E696679696E';
wwv_flow_api.g_varchar2_table(21) := '6720676C6173732069636F6E207768656E206E6F206461746120666F756E6420696E204947202A2F0D0A2E612D47562D6E6F446174614D7367202E612D49636F6E207B20646973706C6179203A6E6F6E653B7D0D0A0D0A2E742D466F6F7465727B0D0A20';
wwv_flow_api.g_varchar2_table(22) := '20646973706C61793A206E6F6E653B0D0A7D0D0A0D0A2F2A206D616B65206E6F74696669636174696F6E73206175746F206865696768742073697A65202D20696D706F7274616E742069662077652077616E7420746F20616D656E6420746865206D6573';
wwv_flow_api.g_varchar2_table(23) := '73616765202D20776869636820776520646F202A2F0D0A626F6479202E75692D6469616C6F672D2D6E6F74696669636174696F6E2E75692D6469616C6F67202E75692D6469616C6F672D636F6E74656E74207B0D0A202020206865696768743A20617574';
wwv_flow_api.g_varchar2_table(24) := '6F21696D706F7274616E743B0D0A7D0D0A0D0A2F2A206F766572726964652064656661756C74207769647468206F6620343030202A2F0D0A2E75692D6469616C6F672D2D6E6F74696669636174696F6E207B0D0A2020202077696474683A203535307078';
wwv_flow_api.g_varchar2_table(25) := '21696D706F7274616E743B0D0A7D0D0A202020200D0A2F2A206D616B65207375726520646174657069636B6572206B656570732075707065722063617365206D6F6E7468202D206F6E6C7920776F726B7320666F72206974656D73202D206E6F74204947';
wwv_flow_api.g_varchar2_table(26) := '20636F6C756D6E73207361646C79202A2F0D0A696E7075742E617065782D6974656D2D646174657069636B6572207B0D0A20202020746578742D7472616E73666F726D3A207570706572636173653B0D0A7D0D0A0D0A2F2A207374616E64617264206275';
wwv_flow_api.g_varchar2_table(27) := '74746F6E207769647468202A2F0D0A2E627574746F6E5F7769647468207B0D0A2020202077696474683A20383870783B0D0A7D20202020200D0A0D0A2E627574746F6E5F77696474685F736D6C207B0D0A2020202077696474683A20373570783B0D0A7D';
wwv_flow_api.g_varchar2_table(28) := '20202020200D0A0D0A2F2A20616C69676E20627574746F6E207769647468206F6E20637573746F6D204150455820616C65727473202A2F0D0A2E75692D6469616C6F67202E75692D6469616C6F672D627574746F6E70616E6520627574746F6E207B0D0A';
wwv_flow_api.g_varchar2_table(29) := '2020202077696474683A20383870783B0D0A7D0D0A0D0A2F2A20626F6479202E75692D627574746F6E2E75692D627574746F6E2D2D686F74207B206261636B67726F756E642D636F6C6F723A20726762283134382C2031352C203135292021696D706F72';
wwv_flow_api.g_varchar2_table(30) := '74616E743B207D206F7665727269646520686F7420627574746F6E20636F6C6F7572202A2F0D0A2F2A206D616B65207375726520616C6C206469616C6F677320617070656172206F6E20746F70206F662065616368206F74686572202D206D7573742068';
wwv_flow_api.g_varchar2_table(31) := '6176652074686520696D706F7274616E742070617274202A2F0D0A0D0A626F6479202E75692D6469616C6F672E75692D66726F6E747B7A2D696E6465783A313030312021696D706F7274616E747D0D0A0D0A2F2A206D616B652073757265206E6F746966';
wwv_flow_api.g_varchar2_table(32) := '69636174696F6E73202F20616C6572747320706F70207570206F6E20746F702F6174207468652066726F6E74202A2F0D0A2E742D416C6572742D2D70616765207B207A2D696E6465783A20313030313B207D202020200D0A0D0A2E6E6F2D636C6F736520';
wwv_flow_api.g_varchar2_table(33) := '2E75692D6469616C6F672D7469746C656261722D636C6F7365207B0D0A2020646973706C61793A206E6F6E653B0D0A7D0D0A0D0A2E7965732D636C6F7365202E75692D6469616C6F672D7469746C656261722D636C6F7365207B0D0A2020646973706C61';
wwv_flow_api.g_varchar2_table(34) := '793A20696E6C696E653B0D0A7D0D0A0D0A2E612D5377697463682D746F67676C65207B0D0A2020202070616464696E673A203170783B0D0A7D202020200D0A0D0A2E742D426F64792D636F6E74656E74496E6E6572207B0D0A202020206D617267696E3A';
wwv_flow_api.g_varchar2_table(35) := '202D31367078206175746F3B0D0A7D202020200D0A0D0A2E617065782D6974656D2D74657874207B0D0A202020206865696768743A20322E3072656D3B0D0A207D0D0A0D0A2F2A207A65726F206C65667420616E642072696768742070616464696E6720';
wwv_flow_api.g_varchar2_table(36) := '666F7220627574746F6E7320736F20726573697A652067697665732062657374206368616E676520746F20646973706C617920746865206C6162656C202A2F0D0A2E742D427574746F6E207B0D0A202020206C696E652D6865696768743A20312E377265';
wwv_flow_api.g_varchar2_table(37) := '6D3B0D0A2020202070616464696E673A202E3672656D203072656D3B0D0A7D0D0A0D0A2E612D47562D63656C6C207B0D0A202020206865696768743A20333270783B0D0A2020202070616464696E673A20327078203870783B0D0A7D0D0A0D0A2E612D47';
wwv_flow_api.g_varchar2_table(38) := '562D6865616465722C202E612D47562D68656164657247726F7570207B0D0A202020206865696768743A20323070783B0D0A2020202070616464696E673A203470783B0D0A7D0D0A0D0A2F2A2057696E6764696E677320322052203D20592C20C2A3203D';
wwv_flow_api.g_varchar2_table(39) := '204E2062757420666F6E74206E6F7420746865726520696E2077696E646F77733130202A2F0D0A2E77696E67207B20666F6E742D66616D696C793A202257696E6764696E6773223B0D0A666F6E742D73697A653A206C61726765207D0D0A0D0A2E666C6F';
wwv_flow_api.g_varchar2_table(40) := '61742D7269676874207B0D0A20202020666C6F61743A2072696768743B0D0A7D0D0A0D0A2E646973707B0D0A20206865696768743A31303070783B0D0A202077696474683A31303070783B0D0A7D20200D0A0D0A2F2A20696E7465726163746976652067';
wwv_flow_api.g_varchar2_table(41) := '72696420636F6C756D6E2068656164657220636F6C6F72202A2F0D0A2E612D47562D686561646572207B0D0A202020636F6C6F723A20766172282D2D6974656D5F6C6162656C735F726762290D0A7D0D0A0D0A2F2A20696E746572616374697665207265';
wwv_flow_api.g_varchar2_table(42) := '706F727420636F6C756D6E2068656164657220636F6C6F72202A2F0D0A2E612D4952522D686561646572207B0D0A202020636F6C6F723A20766172282D2D6974656D5F6C6162656C735F726762290D0A7D0D0A0D0A2F2A206D616B652073757265206469';
wwv_flow_api.g_varchar2_table(43) := '7361626C65642074657874206974656D7320617070656172206E6F726D616C206F706163697479202A2F0D0A0D0A2E617065785F64697361626C65642C20627574746F6E5B64697361626C65645D207B0D0A202020206F7061636974793A20313B0D0A7D';
wwv_flow_api.g_varchar2_table(44) := '0D0A0D0A2F2A2062656C6F7720697320666F7220646973706C6179206974656D7320202A2F0D0A0D0A2E617065782D6974656D2D646973706C61792D6F6E6C79207B0D0A202020206D696E2D6865696768743A20312E3072656D3B0D0A20202020626F78';
wwv_flow_api.g_varchar2_table(45) := '2D736861646F773A206E6F6E653B0D0A20202020666F6E742D7765696768743A203430303B0D0A207D0D0A0D0A2E742D466F726D2D6C6162656C207B0D0A2020202070616464696E673A202E3472656D20303B0D0A202020206C696E652D686569676874';
wwv_flow_api.g_varchar2_table(46) := '3A20312E3072656D3B0D0A20202020646973706C61793A20696E6C696E652D626C6F636B3B0D0A202020202D7765626B69742D68797068656E733A206175746F3B0D0A202020202D6D732D68797068656E733A206175746F3B0D0A202020206879706865';
wwv_flow_api.g_varchar2_table(47) := '6E733A206175746F3B0D0A20202020666F6E742D73697A653A20312E3172656D3B0D0A20202020636F6C6F723A20766172282D2D6974656D5F6C6162656C735F726762293B0D0A7D0D0A0D0A2E742D466F726D2D2D6C6162656C7341626F7665202E742D';
wwv_flow_api.g_varchar2_table(48) := '466F726D2D6669656C64436F6E7461696E6572202E742D466F726D2D6C6162656C436F6E7461696E65722C202E742D466F726D2D6669656C64436F6E7461696E65722D2D737461636B6564202E742D466F726D2D6C6162656C436F6E7461696E6572207B';
wwv_flow_api.g_varchar2_table(49) := '0D0A2020202077696474683A206175746F3B0D0A20202020746578742D616C69676E3A206C6566743B0D0A20202020666C6F61743A206E6F6E653B0D0A2020202070616464696E672D626F74746F6D3A20303B0D0A2020202070616464696E672D746F70';
wwv_flow_api.g_varchar2_table(50) := '3A20303B0D0A202020206865696768743A20313970783B0D0A7D0D0A0D0A2E742D466F726D2D2D6C6162656C7341626F7665202E742D466F726D2D6669656C64436F6E7461696E6572202E742D466F726D2D696E707574436F6E7461696E65722C202E74';
wwv_flow_api.g_varchar2_table(51) := '2D466F726D2D6669656C64436F6E7461696E65722D2D737461636B6564202E742D466F726D2D696E707574436F6E7461696E6572207B0D0A2020202070616464696E672D746F703A20303B0D0A2020202070616464696E672D626F74746F6D3A20302E32';
wwv_flow_api.g_varchar2_table(52) := '72656D3B0D0A7D0D0A0D0A2F2A2073656C656374696F6E20636F6C6F7572207768656E2046382070726573736564202A2F0D0A0D0A2E612D47562E612D47562D2D73656C65637443656C6C73202E612D47562D63656C6C2E69732D73656C656374656420';
wwv_flow_api.g_varchar2_table(53) := '7B206261636B67726F756E642D636F6C6F723A20233365353536383B207D';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(27399668162932826)
,p_file_name=>'cronology.css'
,p_mime_type=>'text/css'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/cronology_ico
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '00000100050010100000010020006804000056000000181800000100200088090000BE0400002020000001002000A8100000460E00003030000001002000A8250000EE1E00000000000001002000CA940000964400002800000010000000200000000100';
wwv_flow_api.g_varchar2_table(2) := '20000000000000040000C30E0000C30E000000000000000000000000000000000000FEFEFE00FFFFFF01E0D8D225C8BAAF76BBAA9DB2B4A192C0BBAA9CC0CDC0B7B2E0D8D276F5F2F125FFFFFF01FFFFFF00000000000000000000000000D4CAC100E3DC';
wwv_flow_api.g_varchar2_table(3) := 'D709B4A193659E8673D6957A65FC957B66FF9B826EFFA28B79FFAB9787FFB8A89AFCCDC1B7D6E5DFDA65FFFFFF09F9F8F70000000000C0B0A400D0C4BB089E8673848B6F58F78A6D56FF927660FF99806CFFA18977FFA89382FFAF9C8CFFB6A496FFBDAE';
wwv_flow_api.g_varchar2_table(4) := 'A1FFCDC1B7F7E4DDD884FFFFFF08F9F7F60010000000957C6766866951F6896C55FF937861FF9B816CFFA28A77FFA99482FFB19D8DFFB8A698FFC0B0A2FFC7B9ADFFCCC0B6FFD7CEC6F6EBE6E266A1897600987E6A26876951D4886B53FF8A6F5AFF6D5A';
wwv_flow_api.g_varchar2_table(5) := '4BFF5D4E43FF5F5248FF665A50FF6A5F56FF6F655DFF736A63FF776F69FFACA39CFFDAD1C9FFE5DFDAD4F8F6F4268B6E5776886A53FC8D715BFF45392EFF040303FF0A0908FF504740FF766B61FF7B7168FF80776FFF857D76FF89827CFFB8B0A9FFE0D8';
wwv_flow_api.g_varchar2_table(6) := 'D2FFE8E2DDFCF3F0ED768B6E57B88E725BFF8A715DFF1C1713FF000000FF3B342FFFB09E8FFFBCAB9DFFC3B4A8FFCBBDB3FFD3C7BDFFDAD0C8FFE0D7D1FFE5DFDAFFEDE8E5FFF5F3F1B88F735DD7947964FF8E7765FF1A1613FF000000FF48403AFFB8A7';
wwv_flow_api.g_varchar2_table(7) := '99FFBFB0A3FFC7B9AEFFCEC2B8FFD5CBC3FFDDD4CEFFE4DED8FFECE7E3FFF3F0EEFFF9F8F7D7957B66D79A816DFF947E6DFF1B1815FF000000FF4A433EFFBEAFA2FFC5B7ACFFCDC1B7FFD4CAC1FFDCD3CCFFE3DCD7FFEAE5E1FFF2EEECFFF9F7F5FFFCFC';
wwv_flow_api.g_varchar2_table(8) := 'FBD79E8572B8A18976FF998575FF1C1916FF000000FF4C4642FFC6B7ACFFCCBFB5FFD3C8C0FFDBD2CAFFE2DBD5FFE9E4DFFFF1EDEAFFF8F5F4FFFCFBFBFFFEFEFEB8A9948376A79180FCA39081FF282421FF000000FF302D2AFFB4A99FFFCFC5BCFFD6CD';
wwv_flow_api.g_varchar2_table(9) := 'C6FFDED6D0FFE5DFDBFFECE8E5FFF5F3F1FFFCFAFAFFFEFEFEFCFFFFFF76BEAFA226B19E8FD4B3A192FF81766CFF2B2826FF171615FF3C3937FF5E5A57FF625F5CFF666361FF696765FF6A6968FFBDBCBBFFFFFFFFFFFFFFFFD4FFFFFF266A472900C6B8';
wwv_flow_api.g_varchar2_table(10) := 'AD66BDADA0F6C1B2A6FFBCB0A6FFB3AAA2FFB6ADA7FFBBB4AFFFC1BCB8FFC7C3C0FFCDCBC9FFD1D0CFFFEBEBEBFFFFFFFFF6FFFFFF66FFFFFF00E7E1DC00EFEBE808D4C9C184CCBFB6F7CFC3B9FFD7CDC5FFDFD7D0FFE7E0DBFFEEE9E5FFF6F2F0FFFCFA';
wwv_flow_api.g_varchar2_table(11) := 'F9FFFFFEFEFFFFFFFFF7FFFFFF84FFFFFF08FFFFFF0000000000F3F1EE00F9F7F609E6DFDB65DFD7D1D6DFD7D1FCE4DDD8FFEBE6E2FFF2EFECFFF9F7F6FFFDFCFCFCFFFFFFD6FFFFFF65FFFFFF09FFFFFF00000000000000000000000000FFFFFF00FFFF';
wwv_flow_api.g_varchar2_table(12) := 'FF01F9F8F725F3F1EE76F3EFEDB2F5F2F0C0F9F8F7C0FDFCFCB2FFFEFE76FFFFFF25FFFFFF01FFFFFF000000000000000000E0070000C0030000800100008001000000000000000000000000000000000000000000000000000000000000000000008001';
wwv_flow_api.g_varchar2_table(13) := '000080010000C0030000E0070000280000001800000030000000010020000000000000090000C30E0000C30E000000000000000000000000000000000000000000000000000000000000FFFFFF00F4F2F000FFFFFF11F1EDEB47E0D8D27ED2C6BD95CABC';
wwv_flow_api.g_varchar2_table(14) := 'B299CEC2B899DCD4CD95ECE8E47EFAF9F847FFFFFF11FFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000FFFFFF00F0ECE900FBFAF90FD7CDC55EBBAA9DBDA89381EF9E8672FE9B836FFF9D8572FFA28B';
wwv_flow_api.g_varchar2_table(15) := '79FFAA9585FFB6A496FEC8BAB0EFDDD5CFBDF3F0EE5EFFFFFF0FFEFEFE00FFFFFF000000000000000000000000000000000000000000FFFFFF006B462900DAD2CA2DB29F90AD967C67F88B6E57FF8D705AFF927761FF987E69FF9D8471FFA28A78FFA690';
wwv_flow_api.g_varchar2_table(16) := '7FFFAA9685FFAF9C8CFFB7A698FFCBBEB4F8E5DFDAADFBFAF92DE4DDD800FFFFFF00000000000000000000000000FDFCFC0066402200C5B6AB3B9C8470D0876951FF876A52FF8D715AFF927761FF977D69FF9C8470FFA18A77FFA6907EFFAA9686FFAF9C';
wwv_flow_api.g_varchar2_table(17) := '8DFFB4A293FFB9A89AFFBDADA0FFC8BAB0FFE0D8D2D0F8F6F53BE2DBD500FFFFFF0000000000FFFFFF00A38D7B00BBAA9D2D937863D083644CFF876A52FF8D7059FF917660FF967D68FF9B836FFFA08976FFA58F7DFFA99584FFAE9B8BFFB3A192FFB8A7';
wwv_flow_api.g_varchar2_table(18) := '99FFBDADA0FFC2B3A8FFC7B9AEFFCEC2B8FFE3DCD6D0FAF9F82DF5F2F000FFFFFF00BAA99B00C6B8AC0F917761AD82644BFF876951FF8C6F58FF917660FF977D67FF9C836FFFA18976FFA6907EFFAB9685FFAF9C8CFFB4A293FFB9A89AFFBFAEA1FFC3B4';
wwv_flow_api.g_varchar2_table(19) := 'A8FFC9BBB0FFCDC0B6FFD0C4BBFFD7CDC5FFEBE6E2ADFFFFFF0FFDFCFC00633D1E00967C675E84664DF8866850FF8B6E57FF91765FFF8F7661FF846E5DFF826E5EFF857364FF887769FF8B7B6FFF8F8074FF93857AFF978A7FFF9B8F85FF9F948BFFA398';
wwv_flow_api.g_varchar2_table(20) := '90FFB6ACA4FFD4CAC1FFD9D0C8FFE2DBD6F8F4F2F05EE6E0DB00AC978711886B54BC85674FFF8A6D56FF8F745DFF6C5848FF2A231DFF100E0CFF0B0908FF0E0C0BFF201C19FF26221FFF272320FF282421FF292623FF2A2725FF2B2826FF292725FF6A65';
wwv_flow_api.g_varchar2_table(21) := '61FFD8CEC7FFDDD5CFFFE3DBD6FFEFEAE7BCFFFFFF1192786246866951EE896C55FF90745DFF7B6452FF14110EFF000000FF000000FF0F0D0CFF63574EFF98887BFFA29285FFA6978BFFAA9C91FFAEA298FFB3A79EFFB7ADA4FFBBB2AAFFC9C0B9FFDCD4';
wwv_flow_api.g_varchar2_table(22) := 'CDFFE2DAD4FFE6E0DBFFEEE9E6EEFAF8F7468D715A83896C54FE8E725BFF957A64FF5F4F42FF010100FF000000FF000000FF4F463EFFB19E8EFFB6A495FFBAA99CFFBFB0A3FFC4B6AAFFC9BCB1FFCEC2B8FFD3C8BFFFD8CEC6FFDDD4CDFFE1D9D3FFE6DF';
wwv_flow_api.g_varchar2_table(23) := 'DAFFEBE5E1FFF0ECE9FEF9F7F5838D715AAE8D7059FF927761FF997F6AFF5D4E42FF000000FF000000FF000000FF645950FFB6A495FFB8A799FFBDADA1FFC2B4A8FFC7BAAFFFCCC0B6FFD1C6BDFFD6CCC4FFDBD2CBFFE0D8D2FFE5DED9FFEAE4E0FFEFEA';
wwv_flow_api.g_varchar2_table(24) := 'E7FFF4F1EFFFFAF8F7AE90745EC391755FFF967C67FF9E8470FF605146FF000000FF000000FF000000FF665C53FFBAA99BFFBCADA0FFC1B3A7FFC6B9AEFFCBBFB5FFD0C5BCFFD5CBC3FFDAD1CAFFDFD7D1FFE4DDD8FFE9E3DFFFEEE9E6FFF3F0EDFFF8F5';
wwv_flow_api.g_varchar2_table(25) := 'F4FFFCFAFAC3947A64C3957B65FF9A816DFFA28976FF62544AFF000000FF000000FF000000FF685F57FFBFAEA1FFC1B2A6FFC6B8ADFFCABEB4FFCFC4BBFFD4CAC2FFD9D0C9FFDED6D0FFE3DCD7FFE8E2DEFFEDE8E5FFF2EFECFFF7F4F3FFFAF9F8FFFDFC';
wwv_flow_api.g_varchar2_table(26) := 'FCC39A816CAE99806BFF9E8673FFA68F7CFF65584DFF000000FF000000FF000000FF6A615AFFC3B3A7FFC5B7ACFFCABDB3FFCFC3B9FFD4C9C0FFD9CFC8FFDED5CFFFE2DBD6FFE7E1DDFFECE7E4FFF1EEEBFFF6F4F2FFFAF8F7FFFCFCFBFFFEFEFEAEA28B';
wwv_flow_api.g_varchar2_table(27) := '78839E8572FEA28B79FFAA9482FF675B51FF000000FF000000FF000000FF6D645EFFC7B9ADFFC9BCB1FFCEC2B8FFD3C8BFFFD8CEC6FFDDD4CEFFE2DAD5FFE7E0DCFFECE7E2FFF1EDEAFFF5F3F1FFF9F8F7FFFCFBFAFFFEFEFEFEFFFFFF83B09C8C46A38D';
wwv_flow_api.g_varchar2_table(28) := '7BEEA6907FFFAE9989FF6F6359FF010101FF000000FF000000FF57514CFFCABCB2FFD0C3B9FFD4C9C0FFD9CFC7FFDED5CEFFE3DBD5FFE8E1DCFFEDE8E3FFF2EEEBFFF6F3F1FFF9F7F6FFFCFAFAFFFEFDFDFFFFFFFFEEFFFFFF46CDC0B611AD9989BCAA95';
wwv_flow_api.g_varchar2_table(29) := '85FFB09D8DFF98897CFF1C1A18FF000000FF000000FF0F0E0DFF6B6560FFADA49CFFB9B0A9FFBDB5AFFFC1BAB5FFC5BFBBFFC9C5C1FFCECAC7FFD1CFCDFFE3E1E0FFFBFAF9FFFDFDFDFFFFFFFFFFFFFFFFBCFFFFFF119B837000C1B2A65EB19E8FF8B3A0';
wwv_flow_api.g_varchar2_table(30) := '91FFB8A799FF91857BFF413C38FF1C1A19FF111010FF131211FF252322FF2C2A28FF2C2B2AFF2D2C2BFF2E2D2CFF2F2E2EFF302F2FFF2D2D2DFF7B7A7AFFFCFCFBFFFFFFFFFFFFFFFFF8FFFFFF5EFFFFFF00E0D9D300E8E3DF0FC3B5A9ADB8A799FFBCAC';
wwv_flow_api.g_varchar2_table(31) := '9EFFC3B4A7FFC2B4A9FFB5AAA1FFB0A69EFFB3AAA3FFB6AEA8FFBAB3AEFFBEB8B4FFC2BDB9FFC6C2BFFFCAC7C5FFCDCCCBFFCFCECEFFE1E1E1FFFEFEFEFFFFFFFFFFFFFFFFADFFFFFF0FFFFFFF00FFFFFF00D7CDC500E3DCD72DCABEB4D0C1B2A6FFC5B7';
wwv_flow_api.g_varchar2_table(32) := 'ACFFCABDB3FFD0C4BBFFD6CBC3FFDBD1CAFFE0D8D1FFE5DED8FFEAE4DFFFEFEAE6FFF4F0EDFFF9F6F5FFFDFBFAFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFD0FFFFFF2DFFFFFF00FFFFFF0000000000FFFFFF00C2B3A700EAE6E23BD6CCC4D0CCBFB5FFCEC2';
wwv_flow_api.g_varchar2_table(33) := 'B8FFD3C8BFFFD8CEC7FFDDD4CEFFE2DBD5FFE7E1DCFFECE7E3FFF1EDEAFFF6F3F1FFFAF8F7FFFCFBFBFFFEFEFEFFFFFFFFFFFFFFFFD0FFFFFF3BFFFFFF00FFFFFF00000000000000000000000000FFFFFF00D2C8BF00F6F3F22DE6DFDAADDBD2CBF8D8CF';
wwv_flow_api.g_varchar2_table(34) := 'C7FFDCD3CCFFE1D9D3FFE6E0DBFFEBE6E2FFF0ECE9FFF5F2F0FFF9F7F6FFFCFBFAFFFEFEFDFFFFFFFFF8FFFFFFADFFFFFF2DFFFFFF00FFFFFF000000000000000000000000000000000000000000FFFFFF00FDFDFD00FFFFFF0FF6F4F25EEEEAE7BDEAE5';
wwv_flow_api.g_varchar2_table(35) := 'E1EFEAE4E0FEECE7E4FFF0ECE9FFF5F2F0FFF9F7F6FFFCFBFAFEFEFDFDEFFFFFFFBDFFFFFF5EFFFFFF0FFFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF11FEFEFD47FBFA';
wwv_flow_api.g_varchar2_table(36) := 'F97EFAF8F795FAF8F799FCFBFA99FEFDFD95FFFEFE7EFFFFFF47FFFFFF11FFFFFF00FFFFFF000000000000000000000000000000000000000000FE007F00F8001F00F0000F00E0000700C000030080000100800001000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(37) := '00000000000000000000000000000000000000000000000000008000010080000100C0000300E0000700F0000F00F8001F00FE007F00280000002000000040000000010020000000000000100000C30E0000C30E00000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(38) := '0000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF05FFFFFF22FDFCFC4DF3F0EE68E7E1DC6FE2DBD571E4DDD871EEEAE66FF9F8F768FFFFFF4DFFFFFF22FFFFFF05FFFFFF00FFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(39) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF0BF5F2F045DED6CF97C8BAAFD4B7A596F2AC9787FBA6907EFDA6907EFEAA9584FEB29F90FDBEAEA1FBCEC2';
wwv_flow_api.g_varchar2_table(40) := 'B8F2E0D9D3D4F2EFED97FEFEFD45FFFFFF0BFFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF02F0EDEA38CDC0B6A7AC9787EF957B66FF8D715BFF8E72';
wwv_flow_api.g_varchar2_table(41) := '5CFF927761FF967C67FF9A816DFF9E8672FFA18A77FFA48E7CFFA89382FFAF9C8DFFBFB0A3FFD7CEC6EFF0ECE9A7FFFFFE38FFFFFF02FFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000F8F6F400FFFF';
wwv_flow_api.g_varchar2_table(42) := 'FF0AD4C9C06DA99482E18C7059FF866951FF8B6E57FF8F745DFF937862FF977D68FF9A816DFF9E8673FFA28B78FFA58F7EFFA89483FFAC9888FFB09D8DFFB3A091FFB7A697FFC6B8ADFFE1DAD4E1F9F7F66DFFFFFF0AFFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(43) := '000000000000000000000000000000000000EAE5E000FAF9F80FBDADA08A937963F583654CFF876951FF8B6E57FF8F735CFF927862FF967C67FF9A816CFF9E8572FFA18A77FFA58E7DFFA89382FFAB9887FFAF9C8DFFB3A192FFB7A597FFBAAA9CFFBDAD';
wwv_flow_api.g_varchar2_table(44) := 'A1FFC3B5A9FFDAD1CAF5F4F2F08AFFFFFF0FFFFFFF000000000000000000000000000000000000000000E7E1DC00FEFEFE0AB19E8F8A8A6D56F982634AFF876951FF8A6E56FF8E725CFF927761FF967B66FF99806CFF9D8471FFA18976FFA48E7CFFA792';
wwv_flow_api.g_varchar2_table(45) := '81FFAB9787FFAE9B8CFFB2A091FFB6A496FFBAA99BFFBDAEA1FFC1B2A6FFC5B7ABFFC8BBB0FFDAD1C9F9F4F1EF8AFFFFFF0AFFFFFF00000000000000000000000000F0ECE900FFFFFF01AE9A8A6D886B53F582634AFF866850FF8A6D56FF8E715BFF9176';
wwv_flow_api.g_varchar2_table(46) := '60FF957B65FF997F6BFF9C8470FFA08876FFA38D7BFFA79180FFAA9686FFAE9B8BFFB29F90FFB5A495FFB9A89BFFBDADA0FFC1B1A5FFC4B6ABFFC8BBB0FFCCBFB5FFCFC3BAFFDFD8D1F5F7F5F46DFFFFFF01FFFFFF0000000000FFFFFF00967D6800B4A1';
wwv_flow_api.g_varchar2_table(47) := '92398A6E57E1816249FF856850FF896C55FF8D715AFF91755FFF947A64FF987F6AFF9C8370FFA08875FFA38D7AFFA79180FFAA9685FFAE9A8BFFB19F90FFB5A395FFB9A89AFFBDAD9FFFC0B1A5FFC4B6AAFFC8BAB0FFCBBFB5FFCFC3BAFFD2C8BFFFD6CC';
wwv_flow_api.g_varchar2_table(48) := 'C4FFE8E2DEE1FDFCFC39F9F8F600FFFFFF00C7B9AE00D9D0C90A917660A781634AFF85674FFF896B54FF8C7059FF91755FFF967B65FF977E69FF967E6BFF99826FFF9C8674FF9F8A7AFFA38F7FFFA69384FFAA9889FFAD9C8EFFB1A093FFB4A598FFB8A9';
wwv_flow_api.g_varchar2_table(49) := '9DFFBCAEA3FFBFB2A8FFC3B6ADFFC8BCB3FFD1C6BDFFD6CBC3FFD9D0C8FFDFD7D1FFF2EEECA7FFFFFF0AFFFFFF0085684F009E86734584664EEF84664EFF886B53FF8C6F58FF90755EFF8B725DFF645244FF3C322AFF2A241EFF28221DFF28231EFF2722';
wwv_flow_api.g_varchar2_table(50) := '1EFF28231FFF282420FF292521FF2A2623FF2B2724FF2C2825FF2D2926FF2E2A28FF2E2B29FF2D2A28FF504C49FFCBC1B9FFD9D0C8FFDCD4CDFFE0D8D2FFEAE5E1EFFBFAFA45F9F7F600FFFFFF048D715A9784654DFF876A52FF8B6F57FF90745DFF856D';
wwv_flow_api.g_varchar2_table(51) := '59FF332A23FF040302FF000000FF000000FF000000FF060505FF292521FF423B35FF443D38FF453F39FF47413CFF48423EFF494440FF4B4642FF4C4744FF4E4945FF4D4946FF6B6662FFD0C6BFFFDCD4CDFFE0D8D2FFE3DCD7FFE8E2DEFFF5F3F197FFFF';
wwv_flow_api.g_varchar2_table(52) := 'FF04A38C7A22876A53D4876951FF8B6E57FF8E725CFF937862FF4C3E33FF000000FF000000FF000000FF000000FF151311FF72655AFFA79586FFB3A091FFB6A596FFBAA99CFFBEAEA1FFC1B3A7FFC5B7ACFFC9BCB1FFCDC0B6FFD0C5BBFFD4C9C1FFD8CE';
wwv_flow_api.g_varchar2_table(53) := 'C6FFDBD2CBFFDFD7D1FFE3DCD6FFE6E0DBFFEAE5E0FFF3F0EDD4FFFFFF22947A6550876A52F28A6D56FF8E725BFF927660FF907662FF27211BFF000000FF000000FF000000FF000000FF60554CFFB19E8EFFB2A091FFB6A496FFB9A99BFFBDADA0FFC1B2';
wwv_flow_api.g_varchar2_table(54) := 'A6FFC4B6ABFFC8BBB0FFCCBFB5FFD0C4BBFFD3C9C0FFD7CDC5FFDBD2CBFFDED6D0FFE2DBD5FFE6DFDAFFE9E4E0FFEDE8E5FFF3F0EDF2FCFCFB508F745E7D896C55FD8D715AFF91755FFF957A65FF907865FF221C18FF000000FF000000FF000000FF0404';
wwv_flow_api.g_varchar2_table(55) := '03FF7D6F64FFB4A192FFB5A395FFB9A89AFFBCAC9FFFC0B1A5FFC4B5AAFFC7BAAFFFCBBFB5FFCFC3BAFFD3C8BFFFD6CCC4FFDAD1CAFFDED5CFFFE1DAD4FFE5DFDAFFE9E3DFFFEDE8E4FFF0ECE9FFF5F2F0FDFCFAFA7D90745E9D8C7059FF90755EFF9479';
wwv_flow_api.g_varchar2_table(56) := '64FF987E6AFF937C69FF231D19FF000000FF000000FF000000FF050404FF807368FFB7A596FFB8A799FFBCAC9EFFBFB0A4FFC3B5A9FFC7B9AFFFCBBEB4FFCEC2B9FFD2C7BEFFD6CCC3FFD9D0C9FFDDD5CEFFE1D9D4FFE5DED9FFE8E2DEFFECE7E3FFF0EC';
wwv_flow_api.g_varchar2_table(57) := 'E8FFF3F0EEFFF7F5F4FFFCFBFB9D917660AC8F745DFF937963FF977D68FF9B826EFF967F6DFF231E1AFF000000FF000000FF000000FF050504FF82766BFFBAA99AFFBBAB9EFFBFAFA3FFC3B4A8FFC6B9AEFFCABDB3FFCEC2B8FFD1C6BDFFD5CBC3FFD9CF';
wwv_flow_api.g_varchar2_table(58) := 'C8FFDDD4CDFFE0D9D3FFE4DDD8FFE8E2DDFFEBE6E2FFEFEBE8FFF3EFEDFFF6F4F2FFFAF8F7FFFDFCFCAC947A65AC937862FF967C67FF9A816DFF9E8673FF998372FF241F1BFF000000FF000000FF000000FF050504FF85786EFFBDAD9FFFBEAFA2FFC2B3';
wwv_flow_api.g_varchar2_table(59) := 'A8FFC6B8ADFFC9BCB2FFCDC1B7FFD1C6BCFFD5CAC2FFD8CFC7FFDCD3CDFFE0D8D2FFE3DCD7FFE7E1DCFFEBE6E1FFEEEAE7FFF2EFECFFF6F3F2FFF9F7F6FFFBFAF9FFFDFDFDAC99806C9D967C66FF9A806CFF9D8571FFA18A77FF9C8776FF25201CFF0000';
wwv_flow_api.g_varchar2_table(60) := '00FF000000FF000000FF050504FF877B71FFC0B1A4FFC1B3A7FFC5B7ACFFC9BCB1FFCCC0B6FFD0C5BCFFD4C9C1FFD8CEC6FFDBD3CCFFDFD7D1FFE3DCD6FFE6E0DBFFEAE5E1FFEEE9E6FFF2EEEBFFF5F3F1FFF9F7F6FFFBF9F9FFFDFCFBFFFEFEFE9DA088';
wwv_flow_api.g_varchar2_table(61) := '757D99806BFD9D8471FFA08976FFA48E7CFF9F8A7AFF25211DFF000000FF000000FF000000FF050504FF897E75FFC4B4A8FFC4B6ABFFC8BBB0FFCCC0B6FFD0C4BBFFD3C9C0FFD7CDC5FFDBD2CBFFDED6D0FFE2DBD5FFE6E0DBFFEAE4E0FFEDE9E5FFF1ED';
wwv_flow_api.g_varchar2_table(62) := 'EAFFF5F2F0FFF8F6F5FFFAF9F8FFFCFBFBFFFEFEFDFDFFFFFF7DAB9685509D8572F2A08875FFA38D7BFFA79280FFA18E7EFF26211EFF000000FF000000FF000000FF050504FF8B8178FFC7B8ADFFC8BAB0FFCBBFB5FFCFC3BAFFD3C8BFFFD6CCC4FFDAD1';
wwv_flow_api.g_varchar2_table(63) := 'CAFFDED6CFFFE2DAD5FFE5DFDAFFE9E3DFFFEDE8E4FFF0ECE9FFF4F1EFFFF8F5F4FFFAF9F8FFFCFBFAFFFEFDFDFFFFFFFFF2FFFFFF50BFAFA222A48D7BD4A28B79FFA6907FFFAA9585FFA69384FF2A2521FF000000FF000000FF000000FF020101FF7E74';
wwv_flow_api.g_varchar2_table(64) := '6DFFCBBEB3FFCBBEB4FFCEC3B9FFD2C7BEFFD6CCC4FFDAD0C9FFDDD5CEFFE1D9D4FFE5DED9FFE8E3DEFFECE7E3FFF0ECE9FFF4F0EEFFF7F5F3FFFAF8F7FFFCFBFAFFFDFDFDFFFFFFFFFFFFFFFFD4FFFFFF22FFFFFF04AF9C8C97A6907EFFA99484FFAD99';
wwv_flow_api.g_varchar2_table(65) := '89FFB09D8EFF4A423CFF000000FF000000FF000000FF000000FF2E2B29FFA89D95FFCFC3BAFFD5CAC1FFD9CFC6FFDDD3CCFFE0D8D1FFE4DDD7FFE8E1DCFFECE6E1FFF0EAE6FFF3EFECFFF7F4F1FFFAF7F6FFFAF8F7FFFBFAFAFFFDFCFCFFFFFEFEFFFFFF';
wwv_flow_api.g_varchar2_table(66) := 'FFFFFFFFFF97FFFFFF04B29F9100C4B6AB45AD9989EFAC9888FFB09D8DFFB5A394FF97887DFF23201EFF000000FF000000FF000000FF000000FF1C1A19FF5F5955FF827C76FF857F7BFF88827EFF8A8581FF8C8884FF8F8B88FF918D8BFF93908EFF9593';
wwv_flow_api.g_varchar2_table(67) := '91FF979594FFADACABFFF5F4F3FFFDFCFCFFFEFEFEFFFFFFFFFFFFFFFFEFFFFFFF45FFFFFF00E6E0DB00F5F3F10ABEAFA2A7AF9D8DFFB3A091FFB6A597FFBBAB9DFFA2948AFF59534DFF292624FF151413FF100F0EFF0F0E0DFF0E0E0DFF111010FF1211';
wwv_flow_api.g_varchar2_table(68) := '10FF121111FF121211FF121212FF131212FF131312FF131313FF131313FF101010FF414141FFEDEDECFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFA7FFFFFF0AFFFFFF00FFFFFF00CCC0B600DDD5CE39BEAEA2E1B5A495FFB9A99BFFBDADA1FFC3B3A7FFC5B7';
wwv_flow_api.g_varchar2_table(69) := 'ACFFBBAFA5FFAFA59CFFACA39BFFAFA69FFFB2AAA3FFB5AEA8FFB8B1ACFFBBB5B1FFBEB9B5FFC1BDB9FFC4C0BDFFC7C4C2FFCAC8C6FFCCCBCAFFCDCCCBFFD8D7D7FFFBFBFAFFFFFFFFFFFFFFFFFFFFFFFFE1FFFFFF39FFFFFF00FFFFFF0000000000FCFC';
wwv_flow_api.g_varchar2_table(70) := 'FB00FFFFFF01DBD2CB6DC1B3A6F5BCAC9FFFC0B1A5FFC4B6ABFFC8BAB0FFCCC0B6FFD1C5BCFFD5CAC1FFD9CFC7FFDDD3CCFFE0D8D2FFE4DDD7FFE8E1DCFFECE6E1FFEFEBE7FFF3EFECFFF7F4F2FFFBF8F7FFFDFBFBFFFFFEFDFFFFFFFFFFFFFFFFFFFFFF';
wwv_flow_api.g_varchar2_table(71) := 'FFFFFFFFFFF5FFFFFF6DFFFFFF01FFFFFF00000000000000000000000000FAF8F800FFFFFF0AE0D8D28AC8BBB1F9C3B4A9FFC7BAAFFFCBBEB4FFCFC3B9FFD2C7BEFFD6CCC4FFDAD1C9FFDDD5CFFFE1DAD4FFE5DED9FFE9E3DEFFECE7E3FFF0ECE9FFF4F1';
wwv_flow_api.g_varchar2_table(72) := 'EEFFF7F5F4FFFAF8F7FFFCFBFAFFFDFDFDFFFFFFFFFFFFFFFFFFFFFFFFF9FFFFFF8AFFFFFF0AFFFFFF000000000000000000000000000000000000000000FBFAFA00FFFFFF0FE8E3DF8AD3C9C0F5CBBEB4FFCEC2B8FFD2C7BEFFD5CBC3FFD9D0C8FFDDD4';
wwv_flow_api.g_varchar2_table(73) := 'CEFFE1D9D3FFE4DDD8FFE8E2DDFFECE7E3FFEFEBE8FFF3F0EDFFF7F4F3FFFAF8F7FFFBFAFAFFFDFDFCFFFFFEFEFFFFFFFFFFFFFFFFF5FFFFFF8AFFFFFF0FFFFFFF0000000000000000000000000000000000000000000000000000000000FFFEFE00FFFF';
wwv_flow_api.g_varchar2_table(74) := 'FF0AF4F1EF6DE2DBD6E1D6CCC4FFD5CAC2FFD8CFC7FFDCD4CDFFE0D8D2FFE4DDD7FFE7E1DDFFEBE6E2FFEFEAE7FFF3EFEDFFF6F4F2FFF9F7F6FFFBFAF9FFFDFCFCFFFEFEFEFFFFFFFFFFFFFFFFE1FFFFFF6DFFFFFF0AFFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(75) := '0000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF02FDFDFC38F3F0EEA7E8E3DEEFE2DAD5FFE0D9D3FFE3DCD6FFE6E0DBFFEAE5E1FFEEEAE6FFF2EEEBFFF6F3F1FFF9F7F6FFFBFAF9FFFDFCFCFFFEFEFEFFFFFFFFEFFFFF';
wwv_flow_api.g_varchar2_table(76) := 'FFA7FFFFFF38FFFFFF02FFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF0BFEFEFE45FAF8F797F5F2F0D4F2EEECF2F1EDEAFBF2EEEBFDF4F1EFFEF7F5';
wwv_flow_api.g_varchar2_table(77) := 'F3FEFAF8F8FDFCFBFBFBFEFDFDF2FFFEFED4FFFFFF97FFFFFF45FFFFFF0BFFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFF';
wwv_flow_api.g_varchar2_table(78) := 'FF00FFFFFF05FFFFFF22FFFFFF4DFFFEFE68FEFDFD6FFDFDFD71FEFEFD71FFFFFE6FFFFFFF68FFFFFF4DFFFFFF22FFFFFF05FFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000FFC003FFFF0000FFFC00';
wwv_flow_api.g_varchar2_table(79) := '003FF800001FF000000FE0000007C0000003C000000380000001800000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000008000000180000001C0000003C0000003E0000007F000';
wwv_flow_api.g_varchar2_table(80) := '000FF800001FFC00003FFF0000FFFFC003FF280000003000000060000000010020000000000000240000C30E0000C30E00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(81) := '00000000000000000000000000000000000000000000FFFFFF00FFFFFF02FFFFFF0EFFFFFF1EFFFFFF27FFFFFF2BFFFFFF2CFFFFFF2CFFFFFF2CFFFFFF2CFFFFFF2BFFFFFF27FFFFFF1EFFFFFF0EFFFFFF02FFFFFF000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(82) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(83) := '0000FFFFFF00FFFFFF01FFFFFF15FFFFFF46FDFCFC82F3F0EDB4E7E2DDD3DCD4CDE0D1C6BCE5CABDB3E6CABDB2E7CCBFB5E7D2C7BEE6DDD4CDE5E8E3DEE0F2EFEDD3FBFBFAB4FFFFFF82FFFFFF46FFFFFF15FFFFFF01FFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(84) := '0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF02FFFFFF24FBFA';
wwv_flow_api.g_varchar2_table(85) := 'F970E9E4DFBFCFC3BAEEB7A596FEA48D7BFF99806CFF957B66FF957B65FF967C67FF987F6AFF9B826EFF9E8673FFA28B79FFA89382FFB29F90FFC2B3A8FFD6CCC4FEEBE6E3EEFAF9F8BFFFFFFF70FFFFFF24FFFFFF02FFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(86) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF19F6F4F370DAD1C9CEB4A193FA987E6AFF8B6F';
wwv_flow_api.g_varchar2_table(87) := '58FF8A6E56FF8D715BFF91755FFF937963FF967C67FF997F6BFF9B826EFF9E8572FFA08875FFA28B79FFA48E7CFFA6917FFFA89382FFAB9786FFB3A193FFC6B8ADFFE1DAD4FAF7F5F3CEFFFFFF70FFFFFF19FFFFFF00FFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(88) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF05FBFAF944DAD1CAB8AD9888F88D715AFF85674FFF886B54FF8C6F58FF8E735CFF9176';
wwv_flow_api.g_varchar2_table(89) := '5FFF937963FF967C66FF987F6AFF9B826EFF9D8571FFA08875FFA28B79FFA48E7CFFA69180FFA99483FFAB9787FFAE9A8AFFB09D8DFFB19F90FFB6A496FFC6B9AEFFE4DED9F8FAF9F8B8FFFFFF44FFFFFF05FFFFFF000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(90) := '000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF0DEBE6E270B9A89AE18F735DFF83644CFF866850FF896C55FF8B6F58FF8E725BFF90755FFF937862FF957B66FF987E';
wwv_flow_api.g_varchar2_table(91) := '6AFF9A816DFF9D8471FF9F8774FFA28A78FFA48D7CFFA6907FFFA89483FFAB9786FFAD9A8AFFB09D8DFFB2A091FFB5A394FFB7A698FFB9A89AFFBEAEA1FFD3C8C0FFF1EEEBE1FFFFFF70FFFFFF0DFFFFFF00FFFFFF000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(92) := '000000000000000000000000000000000000000000000000000000000000FFFFFF00FBFAF900FFFFFF14D7CDC68CA18A77F283644CFF83644CFF866851FF896B54FF8B6E57FF8E725BFF90755EFF927862FF957B65FF977E69FF9A816DFF9C8470FF9F87';
wwv_flow_api.g_varchar2_table(93) := '74FFA18A77FFA38D7BFFA6907FFFA89382FFAA9686FFAD9989FFAF9C8DFFB29F90FFB4A294FFB7A597FFB9A89BFFBCAB9EFFBEAEA2FFC0B0A4FFCBBFB5FFE9E3DFF2FDFDFC8CFFFFFF14FFFFFF00FFFFFF00000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(94) := '000000000000000000000000000000000000FFFFFF00F5F3F100FFFFFF14CABDB395947964F8806047FF83654CFF866850FF886B53FF8B6E57FF8D715AFF90745EFF927761FF957A65FF977D68FF99806CFF9C8370FF9E8673FFA18977FFA38C7AFFA590';
wwv_flow_api.g_varchar2_table(95) := '7EFFA89382FFAA9685FFAC9989FFAF9C8CFFB19F90FFB4A293FFB6A597FFB9A89AFFBBAB9EFFBEAEA1FFC0B1A5FFC3B4A9FFC5B6ABFFCABEB3FFE5DFDAF8FCFBFA95FFFFFF14FFFFFF00FFFFFF0000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(96) := '00000000000000000000F8F6F400FFFFFF0DC4B6AA8C8D725BF87F6047FF83644CFF85674FFF886A53FF8A6E56FF8D715AFF8F745DFF927761FF947A64FF977D68FF99806BFF9C836FFF9E8673FFA08976FFA38C7AFFA58F7EFFA79281FFAA9585FFAC98';
wwv_flow_api.g_varchar2_table(97) := '88FFAE9B8CFFB19E8FFFB3A193FFB6A496FFB8A79AFFBBAA9DFFBDAEA1FFC0B1A4FFC2B4A8FFC5B7ACFFC7BAAFFFC9BCB2FFCDC1B7FFE5DFDAF8FCFCFB8CFFFFFF0DFFFFFF0000000000000000000000000000000000000000000000000000000000FCFB';
wwv_flow_api.g_varchar2_table(98) := 'FA00FFFFFF04C3B5A9708E725BF27F6046FF82644BFF85674FFF876A52FF8A6D56FF8C7059FF8F735DFF917660FF947964FF967C67FF997F6BFF9B826EFF9E8572FFA08876FFA28C79FFA58F7DFFA79281FFA99584FFAC9888FFAE9B8BFFB19E8FFFB3A1';
wwv_flow_api.g_varchar2_table(99) := '92FFB5A495FFB8A799FFBAAA9CFFBDADA0FFBFB0A4FFC2B3A7FFC4B6ABFFC7B9AEFFC9BCB2FFCCBFB5FFCEC2B8FFD2C7BEFFE9E4E0F2FEFDFD70FFFFFF04FFFFFF000000000000000000000000000000000000000000FFFFFF00633C1E00CEC1B8459277';
wwv_flow_api.g_varchar2_table(100) := '61E17F5F46FF82634BFF85664EFF876952FF896D55FF8C7059FF8E735CFF917660FF937963FF967C67FF987F6AFF9B826EFF9D8571FFA08875FFA28B79FFA48E7CFFA79180FFA99484FFAB9787FFAE9A8BFFB09D8EFFB3A091FFB5A395FFB8A698FFBAAA';
wwv_flow_api.g_varchar2_table(101) := '9CFFBCADA0FFBFB0A3FFC1B3A7FFC4B6AAFFC6B9AEFFC9BCB1FFCBBFB5FFCEC2B8FFD0C5BCFFD2C8BFFFD8CEC6FFF0ECE9E1FFFFFF45FDFCFB00FFFFFF00000000000000000000000000FFFFFF00D6CCC300E6E0DA199A816DB8806047FF82634AFF8466';
wwv_flow_api.g_varchar2_table(102) := '4EFF876951FF896C55FF8C6F58FF8E725BFF91755FFF937862FF957B66FF987E6AFF9A816DFF9D8471FF9F8775FFA28B78FFA48E7CFFA6917FFFA89483FFAB9787FFAD9A8AFFB09D8DFFB2A091FFB5A394FFB7A698FFBAA99BFFBCAC9FFFBFAFA3FFC1B2';
wwv_flow_api.g_varchar2_table(103) := 'A6FFC3B5AAFFC6B8ADFFC8BBB1FFCBBEB4FFCDC1B8FFD0C4BBFFD2C7BFFFD5CBC2FFD7CDC5FFDFD7D1FFF7F4F3B8FFFFFF19FFFFFF00FFFFFF000000000000000000F8F6F500FFFFFF01AA95847083654CF8816249FF84654DFF866951FF896C54FF8B6F';
wwv_flow_api.g_varchar2_table(104) := '58FF8E725BFF90755EFF937862FF957B66FF997F6AFF9C836EFF9F8672FFA18976FFA48C79FFA68F7DFFA89281FFAB9584FFAD9888FFAF9C8CFFB29F8FFFB4A293FFB7A596FFB9A89AFFBCAB9DFFBEAEA1FFC1B1A4FFC3B4A8FFC6B7ACFFC9BBAFFFCBBE';
wwv_flow_api.g_varchar2_table(105) := 'B3FFCEC1B6FFD0C4BAFFD0C5BBFFD2C7BEFFD4CAC2FFD7CDC5FFD9D0C9FFDBD3CCFFE9E4E0F8FDFCFC70FFFFFF01FFFFFF0000000000FFFFFF00B6A49600C8BAAF248C7059CE806148FF83654DFF866850FF886B54FF8B6E57FF8D715AFF90745EFF9378';
wwv_flow_api.g_varchar2_table(106) := '62FF977C66FF937A65FF86705EFF7A6757FF766456FF786659FF7A695BFF7B6B5EFF7D6D61FF7F7063FF817266FF827469FF84766BFF86796EFF887B70FF8A7D73FF8C7F76FF8E8278FF8F847BFF91867EFF938980FF958B83FF978D85FF998F88FF9B92';
wwv_flow_api.g_varchar2_table(107) := '8BFFC0B6ADFFD5CAC2FFD6CDC5FFD9D0C8FFDCD3CCFFDED6CFFFE2DBD5FFF4F1EFCEFFFFFF24FFFFFF00FFFFFF00F4F2F000FFFFFF009E86737082644BFA83644CFF856850FF886B53FF8A6E56FF8D715AFF8F745DFF937862FF8A725EFF5D4D40FF2E26';
wwv_flow_api.g_varchar2_table(108) := '20FF14110EFF090807FF060505FF060505FF060505FF060605FF060504FF050404FF050404FF050404FF050504FF050504FF050504FF050504FF050505FF050505FF060505FF060505FF060505FF060505FF060505FF060505FF080808FF8F8882FFDACF';
wwv_flow_api.g_varchar2_table(109) := 'C7FFD9CFC8FFDBD2CBFFDDD5CFFFE0D8D2FFE2DBD5FFECE7E4FAFDFCFB70FFFFFF00FFFFFF00BFAFA200C8BBB0158B6F58BF82634BFF85674FFF876A52FF8A6D56FF8C7059FF8F735DFF937761FF7C6654FF2B241DFF030202FF000000FF000000FF0000';
wwv_flow_api.g_varchar2_table(110) := '00FF000000FF000000FF000000FF010000FF0D0C0BFF1B1816FF1C1917FF1C1917FF1D1A18FF1D1A18FF1D1B19FF1E1B19FF1E1C1AFF1F1C1BFF1F1D1BFF1F1D1CFF201E1CFF201E1DFF211F1DFF211F1EFF232220FF99928CFFDBD1CAFFDBD2CBFFDDD5';
wwv_flow_api.g_varchar2_table(111) := 'CEFFE0D8D2FFE2DBD5FFE5DED9FFE8E2DEFFF7F5F3BFFFFFFF15FFFFFF0076543900A28C794685674FEE84664EFF876A52FF8A6D55FF8C7059FF8F735CFF927660FF886F5BFF29211CFF000000FF000000FF000000FF000000FF000000FF000000FF0000';
wwv_flow_api.g_varchar2_table(112) := '00FF161311FF564C44FF8C7D70FFA08F81FFA29284FFA49487FFA7978AFFA99A8EFFAB9D91FFAD9F94FFB0A297FFB2A59BFFB4A89EFFB6AAA1FFB9ADA4FFBBB0A7FFBDB3AAFFBFB5ADFFC2B9B1FFD1C8C0FFDBD2CAFFDDD4CEFFDFD7D1FFE2DAD5FFE4DD';
wwv_flow_api.g_varchar2_table(113) := 'D8FFE7E0DCFFE9E3DFFFF3EFEDEEFFFFFF46FEFDFD00FFFFFF019277618184664EFF876951FF896C55FF8C6F58FF8E725CFF91755FFF957A64FF5B4B3EFF020201FF000000FF000000FF000000FF000000FF000000FF000000FF241F1CFF89796CFFAF9B';
wwv_flow_api.g_varchar2_table(114) := '8BFFB29F8FFFB3A192FFB6A495FFB8A799FFBBAA9CFFBDADA0FFC0B0A4FFC2B3A7FFC5B6ABFFC7B9AEFFCABCB2FFCCC0B5FFCFC3B9FFD1C6BCFFD4C9C0FFD6CCC3FFD9CFC7FFDAD1CAFFDCD4CDFFDFD7D1FFE1DAD4FFE4DDD8FFE6E0DBFFE9E3DEFFEBE6';
wwv_flow_api.g_varchar2_table(115) := 'E2FFF0ECE9FFFCFBFA81FFFFFF01C8BAAF118C6F59B5866850FF896C54FF8B6F58FF8E725BFF90755FFF937862FF947A65FF372E26FF000000FF000000FF000000FF000000FF000000FF000000FF090807FF7B6D61FFB09C8CFFAF9C8DFFB29F90FFB4A3';
wwv_flow_api.g_varchar2_table(116) := '94FFB7A697FFB9A99BFFBCAC9EFFBEAFA2FFC1B2A6FFC3B5A9FFC6B8ADFFC8BBB0FFCBBEB4FFCDC1B7FFD0C4BBFFD2C7BEFFD4CAC2FFD7CDC5FFD9D0C9FFDCD3CDFFDED6D0FFE1D9D4FFE3DCD7FFE6DFDAFFE8E3DEFFEBE6E1FFEDE9E5FFF0ECE9FFFAF8';
wwv_flow_api.g_varchar2_table(117) := 'F7B5FFFFFF11A6907F2A896C55D8886B53FF8B6E57FF8D715BFF90745EFF927761FF957B65FF947A66FF2C241EFF000000FF000000FF000000FF000000FF000000FF000000FF1E1A17FF9F8D7EFFB09D8DFFB19F90FFB4A293FFB6A597FFB9A89AFFBBAB';
wwv_flow_api.g_varchar2_table(118) := '9EFFBEAEA2FFC0B1A5FFC3B4A9FFC5B7ACFFC8BAB0FFCABDB3FFCDC1B7FFCFC4BAFFD2C7BEFFD4CAC1FFD7CDC5FFD9D0C8FFDCD3CCFFDED6D0FFE1D9D3FFE3DCD7FFE5DFDAFFE8E2DDFFEAE5E1FFEDE8E4FFEFEBE8FFF2EEECFFF9F7F6D8FFFFFF2A9B83';
wwv_flow_api.g_varchar2_table(119) := '6F48896C55EB8A6E56FF8D715AFF8F745DFF927761FF947A64FF977D68FF957D69FF2B241FFF000000FF000000FF000000FF000000FF000000FF000000FF25211DFFA49284FFB29F90FFB4A293FFB6A596FFB8A89AFFBBAB9DFFBDAEA1FFC0B1A5FFC2B4';
wwv_flow_api.g_varchar2_table(120) := 'A8FFC5B7ACFFC7BAAFFFCABDB3FFCCC0B6FFCFC3BAFFD1C6BDFFD4C9C0FFD6CCC4FFD9CFC8FFDBD2CBFFDED5CFFFE0D8D2FFE3DBD6FFE5DFD9FFE8E2DDFFEAE5E0FFECE8E4FFEFEBE7FFF1EEEBFFF4F1EEFFF9F7F6EBFFFFFF48977E69638B6E57F58D70';
wwv_flow_api.g_varchar2_table(121) := '59FF8F735DFF917660FF947964FF977C67FF99806BFF977F6CFF2C251FFF000000FF000000FF000000FF000000FF000000FF000000FF26221EFFA79587FFB4A293FFB6A496FFB8A799FFBBAA9DFFBDADA0FFBFB0A4FFC2B3A8FFC4B6ABFFC7B9AFFFCABC';
wwv_flow_api.g_varchar2_table(122) := 'B2FFCCC0B6FFCEC3B9FFD1C6BCFFD3C9C0FFD6CCC4FFD8CFC7FFDBD2CBFFDDD5CEFFE0D8D2FFE2DBD5FFE5DED9FFE7E1DCFFEAE4E0FFECE7E3FFEFEAE7FFF1EDEAFFF4F0EEFFF6F3F2FFFAF8F7F5FEFEFE63967D68768C7059FA8F735CFF917660FF9479';
wwv_flow_api.g_varchar2_table(123) := '63FF967C67FF987F6BFF9B826EFF99826FFF2D2620FF000000FF000000FF000000FF000000FF000000FF000000FF26221FFFA8978AFFB6A496FFB8A799FFBAAA9CFFBDADA0FFBFB0A3FFC2B3A7FFC4B6ABFFC7B9AEFFC9BCB2FFCBBFB5FFCEC2B8FFD0C5';
wwv_flow_api.g_varchar2_table(124) := 'BCFFD3C8BFFFD5CBC3FFD8CEC7FFDAD1CAFFDDD4CEFFDFD7D1FFE2DAD5FFE4DDD8FFE7E1DCFFE9E4DFFFECE7E3FFEEEAE6FFF1EDEAFFF3F0EDFFF6F3F1FFF8F6F4FFFAF9F8FAFEFEFE76967C67808E725CFC91755FFF937863FF967C66FF987F6AFF9B82';
wwv_flow_api.g_varchar2_table(125) := '6EFF9D8571FF9B8472FF2D2621FF000000FF000000FF000000FF000000FF000000FF000000FF272320FFAB9A8CFFB8A799FFBAA99CFFBCAC9FFFBFAFA3FFC1B2A6FFC4B5AAFFC6B8AEFFC9BBB1FFCBBFB4FFCEC2B8FFD0C5BBFFD3C8BFFFD5CBC2FFD7CE';
wwv_flow_api.g_varchar2_table(126) := 'C6FFDAD1CAFFDDD4CDFFDFD7D1FFE1DAD4FFE4DDD8FFE6E0DBFFE9E3DFFFEBE6E2FFEEE9E6FFF0ECE9FFF3EFEDFFF5F2F0FFF8F5F4FFF9F8F7FFFBFAF9FCFEFEFE80987F6A8090755FFC937862FF957B66FF987E69FF9A816DFF9D8471FF9F8774FF9D87';
wwv_flow_api.g_varchar2_table(127) := '75FF2E2722FF000000FF000000FF000000FF000000FF000000FF000000FF272320FFAC9C8FFFBAA99CFFBCAC9FFFBEAFA2FFC1B2A6FFC3B5A9FFC6B8ADFFC8BBB0FFCBBEB4FFCDC1B7FFD0C4BBFFD2C7BEFFD5CAC2FFD7CDC5FFDAD0C9FFDCD3CDFFDFD6';
wwv_flow_api.g_varchar2_table(128) := 'D0FFE1D9D4FFE3DDD7FFE6E0DBFFE8E3DEFFEBE6E1FFEDE9E5FFF0ECE9FFF2EFECFFF5F2F0FFF7F5F3FFF9F7F6FFFBF9F8FFFCFBFBFCFEFEFE809D857176937862FA957B65FF977E69FF9A816CFF9C8470FF9F8774FFA18A77FF9F8978FF2E2823FF0000';
wwv_flow_api.g_varchar2_table(129) := '00FF000000FF000000FF000000FF000000FF000000FF282421FFAE9F92FFBCAC9FFFBEAEA2FFC0B1A5FFC3B4A9FFC5B7ACFFC8BBB0FFCABEB3FFCDC1B7FFCFC4BAFFD2C7BEFFD4CAC1FFD7CDC5FFD9D0C8FFDCD3CCFFDED6D0FFE1D9D3FFE3DCD7FFE6DF';
wwv_flow_api.g_varchar2_table(130) := 'DAFFE8E2DDFFEAE5E1FFEDE8E4FFEFEBE8FFF2EEECFFF4F1EFFFF7F4F3FFF9F7F6FFFAF9F8FFFBFAFAFFFDFCFCFAFFFFFF76A28C7963957B65F5977D68FF99806CFF9C836FFF9E8673FFA18977FFA38D7AFFA18C7BFF2F2924FF000000FF000000FF0000';
wwv_flow_api.g_varchar2_table(131) := '00FF000000FF000000FF000000FF282421FFB0A195FFBEAEA2FFC0B1A5FFC2B4A8FFC5B7ACFFC7BAAFFFCABDB3FFCCC0B6FFCFC3BAFFD1C6BDFFD4C9C1FFD6CCC4FFD9CFC8FFDBD2CCFFDED5CFFFE0D8D3FFE3DCD6FFE5DFDAFFE8E2DDFFEAE5E0FFEDE8';
wwv_flow_api.g_varchar2_table(132) := 'E4FFEFEBE7FFF1EEEBFFF4F1EFFFF6F4F2FFF9F7F6FFFAF9F8FFFBFAF9FFFCFCFBFFFEFDFDF5FFFFFF63AB968648987E6AEB99806BFF9C836FFF9E8672FFA08976FFA38C7AFFA58F7EFFA38E7EFF2F2925FF000000FF000000FF000000FF000000FF0000';
wwv_flow_api.g_varchar2_table(133) := '00FF000000FF282522FFB2A397FFC0B1A5FFC2B3A8FFC5B6ABFFC7BAAFFFC9BDB2FFCCC0B6FFCFC3B9FFD1C6BDFFD3C9C0FFD6CCC4FFD8CFC7FFDBD2CBFFDDD5CFFFE0D8D2FFE2DBD6FFE5DED9FFE7E1DCFFEAE4E0FFECE7E3FFEFEAE7FFF1EDEAFFF4F0';
wwv_flow_api.g_varchar2_table(134) := 'EEFFF6F3F2FFF8F6F5FFFAF8F7FFFBFAF9FFFCFBFBFFFDFDFDFFFEFEFEEBFFFFFF48BBAA9C2A9C8470D89B826EFF9E8572FFA08876FFA28B79FFA58E7DFFA79281FFA59181FF302A25FF000000FF000000FF000000FF000000FF000000FF000000FF2926';
wwv_flow_api.g_varchar2_table(135) := '23FFB4A69AFFC2B4A8FFC4B6ABFFC7B9AEFFC9BCB2FFCCBFB5FFCEC2B9FFD1C5BCFFD3C8C0FFD6CBC3FFD8CEC7FFDAD1CAFFDDD4CEFFDFD8D2FFE2DBD5FFE4DED8FFE7E1DCFFE9E4DFFFECE7E3FFEEEAE6FFF1EDEAFFF3F0EEFFF6F3F1FFF8F6F5FFFAF8';
wwv_flow_api.g_varchar2_table(136) := 'F7FFFBFAF9FFFCFBFBFFFDFDFCFFFEFEFEFFFFFFFFD8FFFFFF2ADED6CF11A48D7BB59D8471FFA08875FFA28B79FFA48E7CFFA69180FFA99484FFA79383FF302B26FF000000FF000000FF000000FF000000FF000000FF000000FF282523FFB6A89DFFC4B6';
wwv_flow_api.g_varchar2_table(137) := 'ABFFC6B9AEFFC9BCB1FFCBBFB5FFCEC2B8FFD0C5BBFFD3C8BFFFD5CBC3FFD8CEC6FFDAD1CAFFDDD4CDFFDFD7D1FFE2DAD4FFE4DDD8FFE6E0DBFFE9E3DFFFEBE6E2FFEEE9E6FFF0ECE9FFF3EFEDFFF5F3F1FFF8F5F4FFFAF8F7FFFBF9F9FFFCFBFAFFFDFC';
wwv_flow_api.g_varchar2_table(138) := 'FCFFFEFEFEFFFFFFFFFFFFFFFFB5FFFFFF11FFFFFF01AE9A8A819F8875FFA28A78FFA48D7CFFA6907FFFA89483FFAB9787FFA99687FF322D28FF000000FF000000FF000000FF000000FF000000FF000000FF201E1CFFB3A69CFFC7B9AEFFC8BBB1FFCBBE';
wwv_flow_api.g_varchar2_table(139) := 'B4FFCDC1B7FFD0C4BBFFD2C7BEFFD5CAC2FFD7CDC6FFDAD0C9FFDCD4CDFFDFD7D0FFE1DAD4FFE4DDD7FFE6E0DBFFE8E3DEFFEBE6E2FFEDE9E5FFF0ECE9FFF2EFECFFF5F2F0FFF7F5F4FFF9F7F6FFFBF9F8FFFCFBFAFFFDFCFCFFFEFEFDFFFFFFFFFFFFFF';
wwv_flow_api.g_varchar2_table(140) := 'FFFFFFFFFF81FFFFFF01A1897600C2B3A746A58E7DEEA38D7BFFA6907FFFA89382FFAA9686FFAD9989FFAF9C8CFF433C36FF000000FF000000FF000000FF000000FF000000FF000000FF080807FF877E76FFCCBEB3FFCBBEB4FFCDC1B7FFCFC4BAFFD2C7';
wwv_flow_api.g_varchar2_table(141) := 'BEFFD4CAC1FFD7CDC5FFD9D0C9FFDCD3CCFFDED6D0FFE1D9D3FFE3DCD7FFE6DFDAFFE8E2DEFFEBE5E1FFEDE8E5FFF0EBE8FFF2EEECFFF4F1EFFFF7F5F3FFF9F7F6FFFAF9F8FFFBFAFAFFFDFCFBFFFEFDFDFFFFFFFFFFFFFFFFFFFFFFFFEEFFFFFF46FFFF';
wwv_flow_api.g_varchar2_table(142) := 'FF00DED6CF00E5DFDA15AF9C8CBFA58F7EFFA89382FFAA9685FFAC9989FFAF9C8CFFB4A192FF73675EFF040403FF000000FF000000FF000000FF000000FF000000FF000000FF211F1DFF948B83FFCBBFB5FFD2C6BDFFD3C8BFFFD6CBC3FFD8CEC6FFDBD1';
wwv_flow_api.g_varchar2_table(143) := 'CAFFDDD4CEFFE0D8D1FFE2DBD5FFE5DED8FFE7E1DCFFEAE4DFFFECE7E3FFEFEAE6FFF1EDEAFFF4F0EDFFF6F3F1FFF9F6F5FFF9F7F6FFFAF9F8FFFBFAF9FFFCFCFBFFFEFDFDFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFBFFFFFFF15FFFFFF00FDFDFD00FFFF';
wwv_flow_api.g_varchar2_table(144) := 'FF00C5B7AC70AA9585FAA99584FFAC9888FFAE9B8CFFB19E8FFFB4A293FFAB9B8DFF3C3732FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF11100FFF544F4BFF978F89FFB4ABA3FFB7AEA7FFB9B1AAFFBBB3ADFFBDB6B0FFBFB8';
wwv_flow_api.g_varchar2_table(145) := 'B3FFC1BBB6FFC3BEB9FFC5C0BCFFC7C3BFFFCAC5C2FFCCC8C5FFCECBC8FFD0CDCBFFD2D0CEFFD5D3D2FFEEECEBFFFCFAFAFFFCFBFBFFFDFDFDFFFFFEFEFFFFFFFFFFFFFFFFFFFFFFFFFAFFFFFF70FFFFFF00FFFFFF00FFFFFF00DED5CF00E7E1DD24B8A7';
wwv_flow_api.g_varchar2_table(146) := '9ACEAB9787FFAE9B8BFFB09E8FFFB3A192FFB5A495FFB9A89AFFA6978BFF47423DFF090808FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF080807FF151413FF161514FF161514FF171615FF171615FF171616FF171716FF1817';
wwv_flow_api.g_varchar2_table(147) := '16FF181717FF181817FF181817FF191818FF191818FF191919FF191919FF1C1C1CFFAFAEADFFFFFFFEFFFDFDFCFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFCEFFFFFF24FFFFFF00FFFFFF0000000000FFFFFF00FFFFFF01D5CBC370B4A293F8B09D';
wwv_flow_api.g_varchar2_table(148) := '8DFFB3A091FFB5A395FFB7A698FFBAA99CFFBEAEA1FFB9AA9EFF8B8078FF504B46FF2A2725FF161514FF0E0D0CFF0C0C0BFF0C0C0BFF0D0C0BFF0C0C0BFF0B0B0BFF0C0B0BFF0C0B0BFF0C0B0BFF0C0C0BFF0C0C0CFF0C0C0CFF0C0C0CFF0C0C0CFF0C0C';
wwv_flow_api.g_varchar2_table(149) := '0CFF0C0C0CFF0D0C0CFF0D0D0DFF0D0D0DFF0C0C0CFF0F0F0FFFA9A9A9FFFFFFFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8FFFFFF70FFFFFF01FFFFFF000000000000000000FFFFFF00F3F0ED00FBFBFA19CBBFB5B8B3A193FFB4A394FFB7A6';
wwv_flow_api.g_varchar2_table(150) := '98FFBAA99BFFBCAC9FFFBFAFA3FFC1B3A7FFC6B8ACFFC5B8ADFFBCAFA6FFAFA49BFFA69C94FFA59C95FFA79F98FFA9A19BFFABA49DFFADA6A0FFAFA8A3FFB1ABA6FFB3ADA9FFB5B0ABFFB7B2AEFFB9B5B1FFBBB7B4FFBDB9B7FFBFBCB9FFC0BEBCFFC2C0';
wwv_flow_api.g_varchar2_table(151) := 'BFFFC3C2C1FFC4C3C3FFC5C4C4FFC7C6C6FFEBEAEAFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFB8FFFFFF19FFFFFF00FFFFFF00000000000000000000000000FFFFFF00C4B5AA00EFEBE845C8BBB0E1B6A597FFB9A89BFFBCAC9EFFBEAF';
wwv_flow_api.g_varchar2_table(152) := 'A2FFC1B2A6FFC3B5A9FFC6B8ADFFC8BBB0FFCBBFB4FFCFC3B9FFD2C6BDFFD5C9C0FFD7CDC4FFDAD0C8FFDCD3CBFFDFD6CFFFE1D9D3FFE4DCD6FFE6DFDAFFE9E2DDFFEBE5E1FFEEE8E4FFF0EBE8FFF3EEEBFFF5F2EFFFF8F5F3FFFAF8F6FFFCFAF9FFFEFC';
wwv_flow_api.g_varchar2_table(153) := 'FBFFFFFEFDFFFFFFFFFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE1FFFFFF45FFFFFF00FFFFFF000000000000000000000000000000000000000000FFFFFF00FFFFFF04EAE5E170C8BBB0F2BBAA9DFFBEAEA1FFC0B1A5FFC3B4A9FFC5B7';
wwv_flow_api.g_varchar2_table(154) := 'ACFFC8BAB0FFCABDB3FFCDC0B7FFCFC3BAFFD2C6BDFFD4CAC1FFD7CDC5FFD9D0C8FFDBD3CCFFDED6CFFFE0D9D3FFE3DCD6FFE5DFDAFFE8E2DDFFEAE5E1FFEDE8E4FFEFEBE8FFF2EEEBFFF4F1EFFFF7F4F3FFF9F7F6FFFAF9F8FFFBFAF9FFFCFCFBFFFEFD';
wwv_flow_api.g_varchar2_table(155) := 'FDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF2FFFFFF70FFFFFF04FFFFFF0000000000000000000000000000000000000000000000000000000000FEFEFE00FFFFFF0DEBE7E38CCBBFB5F8BFB0A4FFC2B4A8FFC5B7ACFFC7BAAFFFCABDB3FFCCC0';
wwv_flow_api.g_varchar2_table(156) := 'B6FFCFC3B9FFD1C6BDFFD4C9C0FFD6CCC4FFD9CFC8FFDBD2CBFFDED5CFFFE0D8D2FFE2DBD6FFE5DED9FFE7E1DDFFEAE4E0FFECE7E4FFEFEBE7FFF1EEEBFFF4F1EEFFF6F4F2FFF9F6F5FFFAF8F8FFFBFAF9FFFCFBFBFFFDFDFDFFFFFEFEFFFFFFFFFFFFFF';
wwv_flow_api.g_varchar2_table(157) := 'FFFFFFFFFFFFFFFFFFF8FFFFFF8CFFFFFF0DFFFFFF000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FEFEFE00FFFFFF14EFECE995D3C8C0F8C4B6ABFFC7B9AEFFC9BCB2FFCCBFB5FFCEC2B9FFD1C5BCFFD3C9';
wwv_flow_api.g_varchar2_table(158) := 'C0FFD6CCC3FFD8CFC7FFDBD2CBFFDDD5CEFFE0D8D2FFE2DBD5FFE5DED9FFE7E1DCFFE9E4E0FFECE7E3FFEEEAE7FFF1EDEAFFF3F0EEFFF6F3F1FFF8F6F5FFFAF8F7FFFBFAF9FFFCFBFBFFFDFDFCFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF8FFFF';
wwv_flow_api.g_varchar2_table(159) := 'FF95FFFFFF14FFFFFF00FFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF14F5F3F18CDED6CFF2CCBFB5FFCBBEB4FFCEC2B8FFD0C5BCFFD3C8BFFFD5CBC3FFD8CEC6FFDAD1';
wwv_flow_api.g_varchar2_table(160) := 'CAFFDDD4CEFFDFD7D1FFE2DAD5FFE4DDD8FFE7E0DCFFE9E3DFFFECE7E2FFEEEAE6FFF0EDEAFFF3F0EDFFF5F3F1FFF8F6F4FFFAF8F7FFFBF9F9FFFCFBFAFFFDFCFCFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF2FFFFFF8CFFFFFF14FFFFFF00FFFF';
wwv_flow_api.g_varchar2_table(161) := 'FF000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF0DFCFBFB70EBE6E2E1D7CEC6FFD0C5BBFFD2C7BEFFD5CBC2FFD7CEC6FFDAD1CAFFDCD4CDFFDFD7D1FFE1DA';
wwv_flow_api.g_varchar2_table(162) := 'D4FFE4DDD8FFE6E0DBFFE9E3DEFFEBE6E2FFEEE9E5FFF0ECE9FFF3EFEDFFF5F2F0FFF7F5F4FFF9F8F7FFFBF9F8FFFCFBFAFFFDFCFCFFFEFEFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE1FFFFFF70FFFFFF0DFFFFFF00FFFFFF0000000000000000000000';
wwv_flow_api.g_varchar2_table(163) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF05FFFFFF44F8F6F5B8E8E3DEF8DBD2CBFFD7CDC5FFD9D0C8FFDCD3CCFFDED6D0FFE1D9D4FFE3DCD7FFE6DFDAFFE8E2';
wwv_flow_api.g_varchar2_table(164) := 'DEFFEBE6E1FFEDE9E5FFF0ECE8FFF2EFECFFF5F2F0FFF7F5F3FFF9F7F6FFFAF9F8FFFCFAFAFFFDFCFCFFFEFEFDFFFFFFFFFFFFFFFFFFFFFFFFF8FFFFFFB8FFFFFF44FFFFFF05FFFFFF000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(165) := '000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF00FFFFFF19FFFEFE70F8F7F6CEEEE9E6FAE4DED9FFE0D8D2FFE0D9D3FFE3DBD6FFE5DFDAFFE8E2DDFFEAE5E1FFEDE8E4FFEFEB';
wwv_flow_api.g_varchar2_table(166) := 'E8FFF2EEEBFFF4F1EFFFF7F4F3FFF9F7F6FFFAF9F8FFFBFAFAFFFDFCFBFFFEFDFDFFFFFFFFFFFFFFFFFAFFFFFFCEFFFFFF70FFFFFF19FFFFFF00FFFFFF000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(167) := '000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF02FFFFFF24FFFFFF70FDFCFBBFF7F5F4EEF2EEECFEEEE9E6FFECE7E3FFECE7E3FFEDE9E5FFF0EBE8FFF2EEEBFFF4F1EFFFF7F4';
wwv_flow_api.g_varchar2_table(168) := 'F3FFF9F7F6FFFBF9F9FFFCFBFBFFFDFDFDFFFEFEFEFEFFFFFFEEFFFFFFBFFFFFFF70FFFFFF24FFFFFF02FFFFFF00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(169) := '000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF01FFFFFF15FFFFFF46FFFFFF82FEFEFEB4FDFCFCD3FCFBFAE0FBF9F8E5FAF9F8E6FBFAF9E7FCFBFAE7FDFCFCE6FEFDFDE5FEFE';
wwv_flow_api.g_varchar2_table(170) := 'FEE0FFFFFFD3FFFFFFB4FFFFFF82FFFFFF46FFFFFF15FFFFFF01FFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(171) := '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFFFF00FFFFFF02FFFFFF0EFFFFFF1EFFFFFF27FFFFFF2BFFFFFF2CFFFFFF2CFFFFFF2CFFFFFF2CFFFFFF2BFFFFFF27FFFFFF1EFFFF';
wwv_flow_api.g_varchar2_table(172) := 'FF0EFFFFFF02FFFFFF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000FFFF8001FFFF0000FFFC00003FFF0000FFF000000FFF0000FFE0';
wwv_flow_api.g_varchar2_table(173) := '000007FF0000FF80000001FF0000FF00000000FF0000FE000000007F0000FC000000003F0000F8000000001F0000F0000000000F0000F0000000000F0000E000000000070000C000000000030000C000000000030000C000000000030000800000000001';
wwv_flow_api.g_varchar2_table(174) := '00008000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000';
wwv_flow_api.g_varchar2_table(175) := '0000000000000000000000000000000000000000000080000000000100008000000000010000C000000000030000C000000000030000C000000000030000E000000000070000F0000000000F0000F0000000000F0000F8000000001F0000FC000000003F';
wwv_flow_api.g_varchar2_table(176) := '0000FE000000007F0000FF00000000FF0000FF80000001FF0000FFE0000007FF0000FFF000000FFF0000FFFC00003FFF0000FFFF8001FFFF000089504E470D0A1A0A0000000D49484452000001000000010008060000005C72A866000080004944415478';
wwv_flow_api.g_varchar2_table(177) := 'DAEDFD77906649761F86FEF27EA65C9B6AEFA67BBA67BAC7BBF58B85592C084301142080048D408A22298540D908FD45C50B4590A1174FF1F8244588414911E423108F041522410880280004165880EBB03B33BBE3A7C7F4B4999EF6A6DA5497FBBEEF9E';
wwv_flow_api.g_varchar2_table(178) := 'F747DECC3CE7E4C95BD56EA66AA672A6FA73694F9EDFEF9C3C99F75E603DADA7F5B49ED6D37A5A4FEB693DADA7F5B49ED6D37A5A4FEB693DADA7F5F4B14EEEA3EEC027251151907505A003A00BA00F6002C014800D003601D802605BF3B705C0347B9D02';
wwv_flow_api.g_varchar2_table(179) := '3009601CC058F3DA07D06BEA0D7FAEF9E3EF61BC175D64AFFA7DADDE87BF018025000B00169BD73900B7005C0330C35EAF347F33006E00986DF2CD37750C018C9A7AE19C23ACA7FB9ED609E03EA606F401885D78A08E23817D1A1EE83B01EC00B0BDF9DB';
wwv_flow_api.g_varchar2_table(180) := 'D6FC1E003FD194EB367F156CC05BE96EE7985ABED78450C30379084F06F3488470039E002E377F97005C6CBEBB86440A0BF0C4326CEAA37532B87F699D00EE7132403F060FE000F8ED007603D8D5BCEE6CBE9B8627860D4DFE5E53BED3FC554D137CCE56';
wwv_flow_api.g_varchar2_table(181) := 'CBFC91F1BE86B7E82378300FE00961B6F9BB064F0417019C0770A179BD8C4408F3F09EC53A19DCA7B45A14684D27E5DEF7E0DDF22978D0070BBF17C09EE67577F3FD6678C04F366502E083650F69ADCE13076BF01002212CC17B07B300AEC37B02E7019C';
wwv_flow_api.g_varchar2_table(182) := '0570AE790D1EC20D782F62099E48D69709F728AD55C55A15A9017E58D387F5FC66242BBF0FC003CD5F00FD343CE8C7E1C92258F8B8362702DC0A6686884004D4546334AC81CAA11ED518D5B5F8DDD70AB8A609C73FBBD456F8BDAA1C9C0BEF2B38D7AC31';
wwv_flow_api.g_varchar2_table(183) := '9CCF7C974AC3E30BC14318C0BBFEC1330864F041F37706C93BB88E14371801A8D789E0CED33A01DC4162C0EFC1837E2380ADF0203FD0FCED872700EEDE73D047973E8054839E00504DA8A9465D13EA9A301C8D301C8E30AA6B8C463586A311A826B8CAAF';
wwv_flow_api.g_varchar2_table(184) := '3C5C53916B00EE1AB437D86D40EF1A40F3DF1A7260659BFF9BFA5299CA55910C2A97CA20B6777BE26C5E8377A0C9E0323C019C06F07EF3771EC0550037E1C960807522B8A3B44E002B4C6C6D1FACFD247C747E173CD81F0470101EFCBB9ADF362207BD03';
wwv_flow_api.g_varchar2_table(185) := 'BCD66BE18F46359606430C86430C1B708F4675FAAB6B54018C11782E0360A402970099E751A00D008F9FB987E0920780541FD840AA0A70A8A24721CA30EF6325A2464E0637E1770F2EC013C04900A7E049E142F3DB1C9257B01E2B58615A27806512037E';
wwv_flow_api.g_varchar2_table(186) := '08E86D8477E5F7023804E02178E0EF838FE44FC37B057D28D0E775030B8B4B58585CC2E2D20083E10883A1B7F070606077FE7D959C780EECF8EA804A5B6EE42490ACBB0DF0F0B93D0FC4B01237F87C84E02DA4B6AACA893EAF44FC4864B0046FEDAFC1EF';
wwv_flow_api.g_varchar2_table(187) := '209C812782E3004EC0C70CAEC09345081CAE13C132699D000A89013F6CDD6D860FE63D00E0E1E6EF103C116C852786B1267FD51846215F02B0B8B884B98525CCCF2F627130403D228CEA1A44E4815E550D681CBCEE16400B057E2C0FF09427077855A82B';
wwv_flow_api.g_varchar2_table(188) := '2D2BF23CDAB26B1280639F5291A6AE2A96590121F065C2001EE037E1970167E109E0BDE6EF03F8E0E175A42DC5752228A475025049017F02DEA2EF8277F18F00380C6FF1F7C0033F44F03B44E4E0923A13F935FBAD5B0B989D5BC4DCC22286A351F32322';
wwv_flow_api.g_varchar2_table(189) := '3883A54F38516E7A046CBE3E778DBFDE66E5858B5FB0F23A0E60D765E5692A0118E83501C486D8673EAE460EA9C2D629420A20869D84ABF03B0727011C03F02EFC12E102BCC710E204EB44A0D23A013449B9FA13F06BF8DDF056FE1178F01F6CBEDB82B4';
wwv_flow_api.g_varchar2_table(190) := '57DF2122C7ADD8E2D200F30B4BB8796B1E376FCD63B03444D5A93CD0AA02B0C1ADA10234D042027A0D1FF2AC1CE0BC9D6549205A7D5E16588E04E237DC2DE2F99ACF9997B1CCB421C50AE6E16301E7E189E05D00EFC07B07E79BDFE6B1BE3410699D0000';
wwv_flow_api.g_varchar2_table(191) := '1051D8CA0B167F0FFCDAFE5178F01F8207FE3452504FACED87A3116ECCCE63F6D63C6ECD2D626171118043A7539951F208B00C9CB74702A5487E04BEFFB9C96BC70EDAAC7C16C86B595A84D44A028E11051F132B1CBF51FD699B42A4E5C102BCD53F0F0F';
wwv_flow_api.g_varchar2_table(192) := 'FE7700BC0D1F2B3887E4118C9C73F587A15FAB397DA209A0B1FA1DF8B5FB6624E03FD6FC3DD47CB7199E1CC231DC28B71BB3F398B97E13B7E617B1B834C07058A3D371E834FBE7D132B6585DD33D3708439084F6009675E3433B390954AE006CE6555824';
wwv_flow_api.g_varchar2_table(193) := 'A0D7EF2B2181502FFB2A2301A70A5824539A52A4E3C8F3F0718073F0E07FABF90B44701D3E9630FA247B039F480260FBF87DF8FDF95DF056FE09008FC3AFF3F7A271F589A8E7825906B0B8B4848B576EE0DA8D592C0DFC569D73FED04C55B94CB1352833';
wwv_flow_api.g_varchar2_table(194) := 'C041010C1609B0AD3FFF315AF52C76B0D2F680B29537A2FEFC0C011CDB71289100F3ED6F8B04D878B27A56A6B1214EC0970667E1E3034701BC09EF1D5C803F6FB0844FE839824F1C0134EE7E17FEA8EE76F87DFBC7013C05EFF23F00BFCD37A9813F3BB7';
wwv_flow_api.g_varchar2_table(195) := '80CB576FE0D2D5EB18D575B48295B2F615076521F8E68A2490AFDD3909542276609080B5F567B567790FCAC5D700D7CB136B7C804D027C27204AEAFE92002089600E7E9BF003F825C1EBF064F03EFC61A35B00869FB465C127860098BB3F0EBF96DF0F0F';
wwv_flow_api.g_varchar2_table(196) := 'F8A7E02DFF41F87DFC0D04F45CE3EA1311666EDCC2D5999BB8347303A37A845EA76B025C7E46042307B869D54B01BD95C603D002F0429E866B9ABA19C8A2DB5F5E5AE89841463AB132BE14B84B1210456FFBC4218F11CCC29F233809EF09BC0E4F08A7E1';
wwv_flow_api.g_varchar2_table(197) := 'E3030BF8042D0B3EF604A0B6F536C207F30E03781A1EFCC1DDDF847478C701C085CBD77079E606AEDF9CC3603842BFDB31026D8008CA85CFC80117CA955CFBE69372C1439EE54900AEF1108AF18095C40E42FDB617A3C76BC60E58BFE3BF251270F1DB90';
wwv_flow_api.g_varchar2_table(198) := '817F2A93800E1EAE501D90B60F6F202D0B5E07F05AF3FE3CFC19834FC4B6E1C79A0098D59F8077EB1F04F0248067E0ADFE01005B8830E11CBA005C5D13CE5F9EC185CBD7706B6E01A3BA46A7D349DB53C06D03BC129F431EC3EAB6040565DD791DA5D801';
wwv_flow_api.g_varchar2_table(199) := '07276FAF62EDDC31091832C8DDFF7612B0C17D5F4900F04410028533F0CB803701BC0AE00DF833045790760B3EB624F0B1258066ADDF83B7EC7BE0DDFD67E1C1FF30805D44B4C139D703E086C3913B7F6906672E5CC5C2E212880855A76A4EAC51665D83';
wwv_flow_api.g_varchar2_table(200) := '8AAE8404ACB5BC069C270ADBAB08759A75AB788069DD0B6BF912D9D8561E8D0C649FDBCE1BF07CE97D92DD8A49C0895222DF6D1C2BCE5404293E300B1F107C0F9E045E815F169C83F714061FD7D8C0C78E00D45A7F2B7C74FF6900CF2159FD69221A73CE';
wwv_flow_api.g_varchar2_table(201) := '75087057AEDEC0890F2EE0FAEC1C3ACD51DC62900E2B01B861A15BD6EEB6456DBE5B06E05650102B02B86DE523C9997DB2894B6C35DE0E09E878C03224E060D573572400A465C1227C0C2078032FC32F0B4EC09F34FC58C6063E5604D080BF07BFB5B707';
wwv_flow_api.g_varchar2_table(202) := 'FE10CFA7E0C17F187EBB6F039AFDFCEB37E770FADC259CBF740D00D0ED7610CEE8AE0CE0D6FA5707F234E0D46FCB7815A57840530D8B1D8472CBB4C73E8BD8456979529041795743B617FA6605054D12B8A3A0E05D930090CE0F046FE0183C09BC047F98';
wwv_flow_api.g_varchar2_table(203) := 'E85CF3DBE0E344021F0B026081BE70A0E7207C80EFD3F0D6FF20FC9EFE38806A301CB9E3A7CFE3FCA56B985F5844BFD74D02E1DB5CA607908365E5800B405A415090597B9B042408516A4F47E85BDABBADE509ECF196BDA6A643E1DFD5490261B760013E';
wwv_flow_api.g_varchar2_table(204) := '367012DE0BF83E7CA0F024D201A28F4580B07BF7557CB44905FAB6C35BFA4F03F80C804789B0D7396C04D023A2EACC852B3871FA226ECD2FA0AA1C7ADD2E8892D5F757E5012080E0004770E4106EFAE540A0C65213359F9D83238082F7D0C40CA8B9B58F';
wwv_flow_api.g_varchar2_table(205) := '28E37B0D506A2FB50D3847206ADA0D25A879750EE16E41FE2622FE0AC2702561D65ED3279FBFBD3DFD9AEA0E799A9139C0911F73E80CFFECF3309991ACC74B0C70F1860814FBD64886FD166739CA2F88C3356F88914090C35D24AE4B5D7883B109E946AD';
wwv_flow_api.g_varchar2_table(206) := '1BE13D83CB00E68968CD2F09D6340134E0EFC24FCC1EF8033D9F852780C344B4DD393701A033737DD6BD7BEA1CAE5CBD01E71CAA8EB7C435D58DC50AE06DC0D5283AB842432A7C0236039C0B8085025C0298575C4D02508073895C9AFA411AF080046A03';
wwv_flow_api.g_varchar2_table(207) := '02361E4003BDA53D27C713DA4B1C44190968190001FCFE150EA2BF8204D24C42205983BB61854802E12B9304647CE00E5338253A8D740F8869782F7233FC01A273006E12D1702D93C09A250016E5DF0CBFBDF70C80CFC147FA0F12D166E7DCD8FCE2923B';
wwv_flow_api.g_varchar2_table(208) := '71FA823B75E622EA9AD0ED544D7904A39A035C58EC64CDA2956F48205A7970F0C41E1A569759F7E655780644192801C3CA3A0EBB9045B6272D71F24C621ED51E022101D2CA07AF26B3F2411E4879ACF111F73620498081955B7E13DC9C04443E40B289F4';
wwv_flow_api.g_varchar2_table(209) := '28EE22056F600AE90AD140049BE1770B4E01B84E446B7697604D124003FE31F828FFC3F0EEFEE7E0F7F8F701D8E89CEB5DBC72DD1D7DEF34AEDDB8857EAF8B4EC7C53B4B047027A56F94164953C9252D93AE7F029F06B8B4EE64BADE609E425A42348412';
wwv_flow_api.g_varchar2_table(210) := '5A09463180CC458C66AE3632EF0206501551494416AD7C58680750722B0FD74E729174A048955B69BE14C8C0ADBC859C256205D2F2DF531270F04B810EBCC199845F166C822785F7005C25A2C5B548026B8A00D8453C61BDFF2880CF377F8F1261977398';
wwv_flow_api.g_varchar2_table(211) := '04D079EBBD0FDCF1D31730180ED16FD6F90124C28D8E160E8DBB0A986B6B284007282800805B5D929E41B0BA08310363B910A002ED5EC7EA13C0F5D22282337A06CD37597B3266102D3873FD799C008C3605C0972339BD648ACB8624872C1EA04980E76B';
wwv_flow_api.g_varchar2_table(212) := 'BAC2BD82180FB04840786477951C92B7C96F041B9EE1F03680CB44348F357651D19A210016EC9B845FEF3F01E00B003E47444700B7CD398CDD9A5BA85E79EB84BB78F93A3A9D0ADD4E07755CF3EA005758E34AEB2BDDE39C049295850438B39816E0C097';
wwv_flow_api.g_varchar2_table(213) := '0D2E9182A3A60EB15E364827B8CF0101A25C0A48A66542941E02C9A5E54E1E33C8E2000AE0A93DE6E968EB1EC6930546D3D22201BA1014CC4880BD07CBD30CAD4802F72820D024BE24D807EF154C223DBDE94DF8B8C0DC5A0A0EAE090260C1BE0DF0C27F';
wwv_flow_api.g_varchar2_table(214) := '061EFC9F25A2879C73D300FAA7CF5EAA5E7FF77DCC2F2CA1D7ED000EA81B2B68ADAD9D70F5978B6017D6D6225817FB2BAC7C06382376A077066C1230DC69A87E72373D10980A0A026CF953D819C8004E61DB8DBD6FB5F23C308A28DF950605390970B39F';
wwv_flow_api.g_varchar2_table(215) := '08616524706F392092C038FC8563E17E9113CDDFABF0372B9D5D2BC1C1554F000CFC9BE04FF13D07E007007C8A881E74CE6D5E585CEABD75FC8C7BEFD439549543B75335C04FE044D8DEE36AB6A26D2CC81D02A68CDCCAF3AD3FB1B4086D2D03F004B806';
wwv_flow_api.g_varchar2_table(216) := '728C74441EEEAEF3BE076A10240761B9F9F2442E5372573FE655CB91102281B6F28E2FA37460342059052A350914C0CA8382451288F9F4FB7B160FE089C7A0F84361C24D61DF0770632D90C0AA260076B26F13FC91DE4FC383FF3902F63BE7365EBC72BD';
wwv_flow_api.g_varchar2_table(217) := 'FBDADBA7DC95991BE8F7FD706A11DD666E675CDFB3B53B77517DA3E00060264CEDC373373E5F5BC7B5BC1917607BD6D95623A2A515EACC77228C006204B858F5F2722D2420402A8A96773ED46E495CF3C365C4558C1920AE640C8B5D0E0A36CD451230B7';
wwv_flow_api.g_varchar2_table(218) := '0478ACE0FE9040D0CD69A400611FE9116F27E04960559F1C5CB504C0C03F0D0FFECF01F801227AD639B7CF011BDE3971B6F3C6BBA7DC703842AF573ED0232C73331569AF3D282EE2BA59581B63D9900E9C70C59216B20870A708C70F567A1ECC620A2253';
wwv_flow_api.g_varchar2_table(219) := 'DB93D9B69D5E2EB003453CD680503B6B6F25078A026A8B5B9B869537773ED84E44583AF1433CAD24A0DD8496A0604602F72E281812F74E1F447A0274B867E40900D7563309AC4A0250E07F183ECAFF8344F4B4736ECFA8AEA75E7FFB54E7E8B10F5CA7E3';
wwv_flow_api.g_varchar2_table(220) := '6FBC59D77573343505C6A261562BE752802DC50560B8E3F9611C6E39D3DE792895BC0413E062EBAF695B59790D4E6B2702002B5720815007D8F66716146CD9F9000729606DFD65DB9FBC0CF29D08BDFDD9CC3C225C5740022B090A4A8290B19A7B94425C';
wwv_flow_api.g_varchar2_table(221) := '6003FCDDA48237101E0AF31E563109AC3A0250E03F0C1FECFB21227ACA39B767716930F9FD37DEAB8EBF7FC1F5FB1D3838D404013867B9D501FC8E81401D810D6E7C5ADB22B7A0DA0A9A8763D2F2806D18CA13723A6640A12D805BF94058251250217446';
wwv_flow_api.g_varchar2_table(222) := '4CC1F969DBF9402AE70BB7EE7C688F486E7F169627A16E453AC17B2905059BEE9824C0AA5B5150B0101CB8978993C03EA407C6861BC81EC32A258155450006F8BF080FFEA79D73BB6FCD2D4C3CFFEABB9DB317AE342E7F2C0900C92D37001731C7009E9D';
wwv_flow_api.g_varchar2_table(223) := 'C48B4AAAD6D65000676E7C72FDD5E11C68B280882B8832DCD5078FC2C3DC89B0AC2E18E908C233828289B8823C807CE7439240DBF98666F24C2B1F490E4E116329302A49C002EC8A82827A670089EAEE433C00482430097F87A900FED0D2AA2481554300';
wwv_flow_api.g_varchar2_table(224) := '86DB1F2CFFD3CEB9DD33D76727FEF4A5B73A33D767E3053CF2341C188024E074D49BAFADBD928259387B5BCB02389C5A1E60999D01BEA3A09727CC32671721B136B81273AB6B5DAB100F1D2529C798083FE928E20162C9C45C678304B857210F14F1C028';
wwv_flow_api.g_varchar2_table(225) := '14C0DB02A360AF0CB81CDC3A28B80C09A838EAFD2601205D4CB49BAB77F3B7EA9603AB8200D456DF2178F0FF20119E76CEEDBE70F9DAC4B7BE77B43337BF806EB78B9A6A14AD522401EE56674755F2A0208B1D640775945781CCADE6969541C070BDA3D7';
wwv_flow_api.g_varchar2_table(226) := '629D37883F2D0738A4B1AAF306690923BD9814AC432286D2F627924CC4A19D656214A10E307095B63FB3F3147A96F8CE009621816C6780EB16F328EE7F5030244D0275D3BD1A9E04AEAF962DC28F9C0014F80FC247FBBF142CFFFB672F4E7CF3C5A39DD1';
wwv_flow_api.g_varchar2_table(227) := 'A846B75B215DC9D6167D0644045D04F7D85A9E07050558F2A06034D9CBEC0CC4FD74B1779EAFBF4D2BAF0057B2F239E9F0DD0C097E30AB9BADDDF59281C7280C92B37622F49905116CB5763E4A24A002A360791B89964920DB19D007B30A24707F828221';
wwv_flow_api.g_varchar2_table(228) := '7112A8916E383242DA22FCC849E023250076BC7703FC219FCFC06FF53DED9CDB73F4BDD313CFBFFA6EA782BF7CB7AEFD4446F7941F8ED167E719F08249E36E6EB2B22A321E89C4080A466B8DAC9D180C8CED59E5046C1281B17D7209F018E717CA5F0ED6';
wwv_flow_api.g_varchar2_table(229) := '71606B4F67653B1F6E1992638C24965ACB5A7924EF2869BC5AA241C911060934EF963D2EAC49001F6A5030A440027B906E4B3E80278193F097137FA4C7863F6A0FA0423A5BFD1CFC219F679D737B5F7FE7D4E4F3AFBEDBE9753A70557ECCB509D1277D54';
wwv_flow_api.g_varchar2_table(230) := 'EBDF6415E451DB2CA017CB215B8FEA43407C1700A179DD5E9647BAFA09A8D28B017F15310A245280BD13C1CF1B18E2893A6EED7CC84B8E43803301D5F462F8E2C8B0F22930AAE20B085392E227629705494661CCFE2BEB8C80C631232F1824A083827C87';
wwv_flow_api.g_varchar2_table(231) := 'E1FEC5030019180C0F325D6A5E4FC3DF666C74DF5A5F267D6404D05CD21B5CA467E023FECF01D8F7FA3BA7269F7FE59DAAD3E9784509FB7CE2AC79AC295A83F2915406386B8740B9FA3EAF5C299AC1414640228058B4F2F9F2446C7B21075C02CBEDEF44';
wwv_flow_api.g_varchar2_table(232) := 'E4C786A5950FF22B6E7F726F89914E22B9BC3DB13C012793D27983200FA49D0FB5B468F425CE896DF26F87045835A1E4FD25810A9E04F6C12F03169BBF0180334434F7515D4A5C7D148DB2EBF9B7A3B9AA8F883E0560FF3B27CE4E3DFFEABB1DD7CC36D5';
wwv_flow_api.g_varchar2_table(233) := '75F0A841D4A8541307F097F8FA1F29D6ED3F85609BCF4348C528E66972C4BA59D5AC6EFE5B28C5FAC1EACCCBA5FA539EA67DD69EAF9758566AC2C6243F53C8C3FB2C6590EA49AF3E1B253982649F553B20D6C7D47DA4D1F3F660F4291F5F9C7BD879649F';
wwv_flow_api.g_varchar2_table(234) := '91CD2B44CBE91F8A1D047489F88E4486944714D56DDDD31496BA53F04FA4FA147CA0FB09780C8C3598F8D0D387DE28DBEEDB0A7F3DFF1788E8B3CEB983EF9E3CBBF11B2FBED105910B56422826120873C0510170C80097B44C2973A698390980B5174A52';
wwv_flow_api.g_varchar2_table(235) := 'D69E241D91C76C0F06E0D83878190D706BACBC04AF43B597F539C858E4B54887972768B289655A48AE24EB2271F1B98B7D841AA7C828F54EB2844D0274DF4920DCBEEE20FCADEBBE008F81ADF0F7ACBC7F3E48217DA84B0016F1DF8CE6882F117DCE39F7';
wwv_flow_api.g_varchar2_table(236) := 'D0A93397367FE3C537BB44E4AAAA2383578E07E7C05CF5155C78620405C37239B9B0C6DA9A95445812041732AC53AD6DACB6A3C5FAECBEE3AB5FEDC6236AA6153390917AC4CC7A272238BAD92DC55A8282FC68AE8374BBEDED4FC478431C075B3A9502B1';
wwv_flow_api.g_varchar2_table(237) := 'C2C707B225933E4F012439C80D40C3FD0F4BA790272C7FF2C5A35C1AE81D857B9BB8FE3F047FF7E15BF04F201A0098F9B077063E340F4045FC1F04F01922FABC73EEC8FB672F6DF9C36FBFDC1B8D6A575555B3CF6F5BF9681DFC2FD233105EBD767DA5C5';
wwv_flow_api.g_varchar2_table(238) := '115658B9B9DAEA85E29905E3E5F4F200A93DE174282BAF970BDACA4B8B2AFBA26520C627DCA47C69114A4619718F4094A33886366F292E1BD45875192D47DE4FB9448B23CA9711DC1390869D7905AC5E968144065D40C9F0FEA4E0016F017004FE3A97CF';
wwv_flow_api.g_varchar2_table(239) := 'C063620380CE87E9097C984B8010F4DB0BE099C6F23F7AF6C2D5AD5FFBD3577BC361EDAACAA1AEB962E56B6BEE8A662E22D86741026075E62E79BE6E4EA08395174C6F797B64B75772E39BEE9A310AB051E97183B7C7C69CC72860004E039595E124AB88';
wwv_flow_api.g_varchar2_table(240) := '2B14D2ED015C06546C2F8D48E6D100E74B8B2426D55ECCC7279ECB59EA83CA62B8FF2A8F6AEB3E24BD0CFE1C7C207C2F3C463E345C7E280D358CD6870F783CDEACF99F3C7F6966D7EF7FE3A5F185C54195C0CF4108C849B5AC35A402829509F528221160';
wwv_flow_api.g_varchar2_table(241) := 'E50A8992F24ACB288884B76B5A763B28A8630766A0920CE2D0ED15DB96C0D6565796132657922C6B8F0C12C8646E9029ACF145DD60E33302B125EF45CE0358FF4990439904F47B8212C3FD26810AFE6E42BBE06F66FB59F8DBDA6F07D0FFB0BC80FB4E00';
wwv_flow_api.g_varchar2_table(242) := '2CE8B719FE5EFD9F75CE3D77F5FAECBE3FFCF62B93F38B8B5555356B521D705200A74CF96C2BAF5D6469C9B9A2A9C0215F43C0220F4920B10E5646032FB593945B8C8F9509321016DA58C248C0C97EC971294291ECC99096BC9EF4954D72612C649663B2';
wwv_flow_api.g_varchar2_table(243) := '37E65146FD4901D8F62AF2A59669E75740029966AE161208DB83CFC193C06134371FFD3048E0BE12805EF713D1A701F7E9B9F9C5837FFCA7AF6D9CB93EDBE9743AAE668A90BBE39A040A6BDF162BCF1552429CE74940B2AC3AA93E06BE42C86B29BC411E';
wwv_flow_api.g_varchar2_table(244) := '89C88829341B1F589DA17D050E73E7C3904169FB33231DB3EE00548BE4C2DB653C1D314F1AE04CAE860C72626404C6BB21C62F042897091ADCCA1311B564247007CABFB214F01176063EDDFC3D880F291E70BF3D0007EFE6EC817F46DF679CC3E1E75F7D';
wwv_flow_api.g_varchar2_table(245) := '77FA83F3977AFD5ED7D5759DB98899FBA82C96E9BE530E0034E505A164AE6B68C472AB95F5D39A01A5BCAA2F52C9A42597E55662E5898BA02803D33388E588C9438D8BBF66041327C690758BA7632D4F90CB575B7968E2821A1F1B97181BD4F4B02F4C70';
wwv_flow_api.g_varchar2_table(246) := '7379897CBA22BADF24C02F81FF0C3C56F6C063676D1280DAEF7F84883EED9C7BECB5B74F6E7FF5AD13BD7EAFE7EADA9ED4E4CD728B5D0080A598B14CF8ACF2485365B7D7B6B6D6C0832601A4BEC84ECBBA214907D6F80408E5E765773E0AA463ED440819';
wwv_flow_api.g_varchar2_table(247) := '81D5C54063EE9864F3A4DA0BA4A04820E65D06E02BF15E783E56B1902F6F4F6531CBF161C4BAEE3F096C07F018BC17F0083E84F301F7850098EB1F2EEFFD9473EEE9B317AFEEF9C60B6F4E545555C5832150935C589FE74AA7AC62C1CA87977250AA6CF5';
wwv_flow_api.g_varchar2_table(248) := 'CC137A1609A8209315606B6D8F95B3016E58DD50C6682FC903391928C02579708073732CF3C6380593A368C72237C0201D0BE0962EE82589E13D80FD0ED175D18FF45B4E02F97BCBA320F5F99EA6B04B16BCE54FC1636713EEE352E07E79002E0C86084F';
wwv_flow_api.g_varchar2_table(249) := '03786EF6D6FCC1AF7DFBD58D83E1B0E3CFC1181654337BC1ADE6A7D642290D3864804BAA1FDA6B3B8DA6ADAE684B18F49CB858C1048096F6849545AA53F7A9CDAB306316BA0E322C2A233988729ADC98DC747BA44096915BBE84B29727962E68D9E5A423';
wwv_flow_api.g_varchar2_table(250) := '0275BC8E5612D02ABBB2A0E07D7403743CE039A4A5C004EED352E09E1300DBF2DB06E051E7F05C5DD3E13F79FEF52D17AF5CEB75AA8E1313985967231064582733300614148C2B8F61D1523101000DB80C60D024102BC9C12379A90C7063FD2F1491F5A9';
wwv_flow_api.g_varchar2_table(251) := '788D02039C8C895046026CE6A407A3E568B427689874392328A8BD184502D19B31BC0AD1C702E9A48FCB9340066E415860BFE524F0212C05B6C0C7039E833F27B00DF7696BF09E12808EFAD7353D0BE089175E7D67D7DBEF9D19EFF5BA4EAFD16D1200B3';
wwv_flow_api.g_varchar2_table(252) := 'E0FE8B6479DAACBC0E6A1996D9684FAE9B9BF60CC065EE67664678393B826DAD9B531C0312483A4621D6CF9274CC9D01D19EB4B4224FE6BE43CA511094EE337B056F3F8139AB431395E5C52CEB55E444967914A978AEABE1DF361280FC4DEBC77D4A2170';
wwv_flow_api.g_varchar2_table(253) := 'BE0BFE62A167711F7705EEB507103ABF9B889EAC2AF7CCB153E7F67FE7E5B7A73A9DAA222217195E333607B6611DFCAB01D21637DEB2F236E9E4800B6A9A9380AC83032E53BC1209E81805C26F797BA6951786D7B0BA04BB3D4EA4DAABB0D6F20CD876B9';
wwv_flow_api.g_varchar2_table(254) := '821C1548E5D61F95DB637D0CCC6C8E0FA557A857A93FDA0B589604E4978A4DEE1B0938A4FB64EC873F21F824FC65F3F77C57E09E5D0CC4A2FE5B001C76CE3D3B737DF6E13FFAF62B5B86C351AFDBEDBABAF6178698B7ED5AC1DD68E45D690A37AB301FC6';
wwv_flow_api.g_varchar2_table(255) := 'E127CFBEE556CB1D79D0A882B8E516C475F235393857B3BEE6B319EE84E39A0FFC55BC8FE372A24CB80E5E960BB7D576CDAD12421EFD7D789FAE770F7310EE27E05CBA3392A8AFAD2FEC6E4AAE194836565617FF4DE4B5FA5F9009EF3FCF1BF3B838A294';
wwv_flow_api.g_varchar2_table(256) := '37092EB619EFA3C0AEA372CECF6915BFA8D0ED74D3C55B416B885F2BE4F5EF3E2CCE39961E86F702CE02B80E6040444BF7EA82A17B79356038D5F4007CF0E2F13F79FEF55D33D767C7C6C7FBAEA63ADE4946DF722BDCA29A9ABB51F027F494018ED65B6E';
wwv_flow_api.g_varchar2_table(257) := '012BB82330BB9B6F98501449474E8F574807573954AE83AAAA50551D549DE673A7425555E8743A090451B13520147005E05899A8D42E078ACA970347120707B8046B78AFFB23819E138B06E34ADA69EAD59F5D52A880868F2211807A5447B5304980E87E';
wwv_flow_api.g_varchar2_table(258) := 'DD57D0C1DF336317FC11E10F005C80BF8350B8B7E05DA77B4200FCAC3F113DEA9C7BEA8D77DF3F70ECE4B90DFD7EAF538FC8E3965DA61BE02D6FB9C5C09C5DA6AB001E2C74CB2DB7F8BDEAD07CCE2E6745CA172639DEE70F00D535AA4E0795ABE0AAAA01';
wwv_flow_api.g_varchar2_table(259) := '98433D1A617E611EF3F3B7B0B4B8886B335731337305D7AE5EC1ECCD9BB878E13C666FDEC085F367F955B9CBCCB82BE6115F2B37C3B567B6AB743AAB33F3D8DDD116B5A5CF2D97D63A997185634A971AB78F27E545212F28EF5E55F9A74C1D3A7408FFC3';
wwv_flow_api.g_varchar2_table(260) := 'FFF83FE2C0FE03180E87A8AAAA8504703F588AC7D30E00780AFE166297012C10D1C2BDF002EE9A0058E06F23F9A7F53E756B6EE1C8B75E3CBA85A8EE1131BB2540A8AEBBA74002A46E378574AB676A72176EED95709BDF5853DCE3CEBAD125F33950D720';
wwv_flow_api.g_varchar2_table(261) := '22F4C7C6D0EBF5311C2C61696909376F5CC7B9B3A771E6F4FBB872F9022E5D3C8FB31F9CC695CB1771EDDA0CEAD10875FD91DCD9693DDDE374E9D225CCCFCD895B9B953D81E0D5DEF36EF0A5C0117802F800692970D73714BD171E4070557612E171227A';
wwv_flow_api.g_varchar2_table(262) := 'E29BDF3BBAE7F2B51B1363FD9E136E3B0725F9A2E2C69608869AD26DBBF98D2F0A563EDDB843DEE8B2741F7EEBBE7B9E376AB8AAC2C4E4147AFD3E2E5FBC800F4E1DC7BB6FBF89E3C7DEC1F9B31FE0F2A50BB87AE552BE2CC8A422D7B6EB696DA44EA783';
wwv_flow_api.g_varchar2_table(263) := 'D16884E92D5BD0EBF5E3F7D1C82B6B9F3EDE57120807849E00700AC079A41B897C740440EC0E3F35D14355E59E3C76EADCC157DF3AB1A9DBA9D2968572E30373920633A24F8EF4200A09EC540EEAA692697960033CB98EF1AE3EECB663DD6E1755D5C1E2';
wwv_flow_api.g_varchar2_table(264) := 'C21CBEFFFAB7F1CE9BAFE3E81BAFE0D83B6F62F6E6CD7C56D84C9B64601D52594F6B22D5758D8B172EE0CAD52B78F8E187FC4D692B06F5C68841DF4DE8FE9040F0B0C373339E842781ABF05EC05D3D65E86E3D0007609C88F638B8C7E7E6171FFDF6F78E';
wwv_flow_api.g_varchar2_table(265) := 'EE585A1A8C8D8DF52B6AA2FEE6C338905B6EC42D4E1DC54F4E3C7F724C047EDCAECA6FB915D8469042F38908E8763BE874BBB87CE13CDE78ED25FCE937FE08EF1E7D1D376FDE48838C331A8298B40EEC8F690AF37AFDFA75DCB8D1107FD8566531915612';
wwv_flow_api.g_varchar2_table(266) := 'B8F73B03E126BA3BE00F069D0070062920F8E11300DBF69B06DC43CEE1F197DE3CBEFFE4990B1B26C6C7AA7A5407332F037A214A4C80780A8D58D38305F960DFF73F083A7C2E0410F5BDE4080E4423743A5DF4FB63B878E12CBEF3F53FC20BDFF9064E1C';
wwv_flow_api.g_varchar2_table(267) := '7B074B4B8B00BC2B08786B90F694D741FF714F212EB47BF71EECDCB1B3F932FC2AC11DA2461909DC9FA060051F10DC0FBF2B701CC025008B77B32D78371E40BC78C1393C76F1CAF5C3DFFADE9B5B7BBD5EAFAEA971E473603B65ADE3CD3DE31E3DF30C34';
wwv_flow_api.g_varchar2_table(268) := 'C0D96E410C0AEAFBF0B3F6F2A0A00771AF3F86A58579BCF4C2B7F11BFFFBAFE2D489F740CD7D0883B51F8D3EB26735ACA78F3085F99F9A9AC4C4C444F8326C22456315806E3F86FCBE2D05C2D5B587E1AF1A7C1FC00DDCC5B6E01D11005BFB4F03788888';
wwv_flow_api.g_varchar2_table(269) := '1EFBC36FBDBC77717130D9EB752B22158567CFF02316D8437C5A4CCBA11F2749C08B42C703CA4FDB099F896A38E7D0ED76F1DAF79FC7D77EFFFFC2F3DFFEB7D6D8EEE9ACADA7B595C2FCDFBC398BD95BB3FEBB9A800ACB9040531EF7351E10CEDAEC8527';
wwv_flow_api.g_varchar2_table(270) := '8063F06703E689A8BE132FE04E3D800AC00411ED76CE3DFAE26BC71E7AF7E4D92DBD6EB74B295C2F9F7EC39FC0C32D3500EB56DA1909F06DBA658282319E109FA557A3D3EDC181F0D5DFFD4DFCF6BFFCA7B87E6DC6EFEDAEAFE7D7939948BEE746DE2401';
wwv_flow_api.g_varchar2_table(271) := 'E316E3F79E0482E1DD027F5BF1100FB8863BF4026E9B0082F527A269C01D9A9D5B78E4F957DFDD0DB809B8102BE5876942602E7F0AAC791FFE6C1F1F298A6F3D0EBC14140C2440846EAF87D91BD7F0DBBFFECFF0277FF0AF31180CE276CFDA4D5CB16E43';
wwv_flow_api.g_varchar2_table(272) := 'C378566AF9AD25EBC77963B3AA7CEC67E3A64D989A9A6A06CCC3CF4C204A404512B8B74141FE48BD4700BC0DBF2D78475EC09D780021F2BFABAADC23AF1C3D71E8D295EBD3BD5EA74BEC844F1EAC2B07F452E02E894A780E850062786844292858538D5E';
wwv_flow_api.g_varchar2_table(273) := 'AF8733EF9FC03FF9877F1FC78FBDD574CFAD59F03BE7E269B5ECDE032B49B4F2DFE80EAA58EB291CE49ABB750BC3E1500D9C5F4B82FC18708904E40504779BF8F2FB103C091C073003FF7091FB4700CCFA6FAEAAEAE08DD9B923AFBE7572774D34014A3B';
wwv_flow_api.g_varchar2_table(274) := 'A51CE0506EBCF5204F1EBD4FEB7B1D3B08713F5E2E9000B2ADC6BA26F4FB7D9C3DF33EFED13FF8EF71EAF8BBE9B0D11A73F9C3F1635755180D8791BCA6B76CC5CE9DBBD1ED75FD92491F7DB54FF7A677DAE22F7B0C991DC375ED39C5A7D299E196A3C6E1';
wwv_flow_api.g_varchar2_table(275) := '841DAF29737848D7E332C3AC0BE9DF74FB55D5C1FCC23C1E7DF4514C4C8C23DCA93E34E7962301309BCF48E0DE7280F0028E00780BC039782FE0B6CE05DCAE07104FFD0138FCE6BBA70F9E3E7779F3D4C458B76ECEFCA6605D027FF628AAE8B65363D1F5';
wwv_flow_api.g_varchar2_table(276) := '597E4502C5E0209A487F52CA70E96DAFD7C3CCD5CBF895FFE5EF47F0AF35E003695B8AC81F519E9C9AC2134F3E83A79EF9149EFDD467B06FFF83E8F57A08C0AF02D81CD2053961E6D8C53B1CC4D9854768F2862C2D571E866A627D3A8FC82FCF54C4CFBC';
wwv_flow_api.g_varchar2_table(277) := '0ED1B633FB2EDB5CC17878BF74FFA1CA362BD75EAF872D5BA6311C0EE1AA2AF2EAB224A08F0CDE9F9D8178000FFE70D06100EFC17B01B7752EE07609A043441B9D73FB6FCD2D1C7EFED5777777BB9D899AA8CA837548EBFBECE41F13468AAAA01153BC80';
wwv_flow_api.g_varchar2_table(278) := 'A7EDB2607E763F5E4BD0D4D1E954989DBD897FFC3FFFF778EF9DA3D1655E2B89931511617C7C02FB0F3C881FF9CA4FE0339FFF121E3870009B374FA3D7EF63341C46990485AFB8E2333070C084762204186168509980429E07A28EF05E029C83316F277C';
wwv_flow_api.g_varchar2_table(279) := 'C7AE185CA61DEBF2615E37AC3C8AD0429BFEE428E09C0F0ED7F588198D84DC959080B866806BF7BD2301EE051C06F026FC25C30B0056ACEC2B268070C59F736E1B80875E7BE7D4C17317AF6E991CEFF7EABAB9DA8F5FABCF5D7465F55DCA90AFE5F99240';
wwv_flow_api.g_varchar2_table(280) := '6F2506A5308282E95421C1555DFC5FBFFE4FF1D61B2FA3AA3AA8EBB5B1DE0F97DB524356FDFE18BEFC633F812FFFD84FE191C79FC0AE5D7BD0EBF5B0B8B880C16080C16009CE550A30A91E0B441900A1402B00C6C0EB34B0B487A0F22AC0C57EF1BA625F';
wwv_flow_api.g_varchar2_table(281) := '6D6087F98EC415FA687822E638A14880F53F272CDE2700AE42C5DA4CDBD70D1E20EC5600499A044E02F11A14FFC33D22018774A1D041F85D816300AED36D3C60F4763C800AC02411F62E2E2D3DFCADEF1DDDD3EB76264635551EFCCC6A0B30EB605D1266';
wwv_flow_api.g_varchar2_table(282) := 'DAAED724A08F0DC328A7CFF713EA518DA9A90DF8EE37FE08DFFADABF81ABAA3503FEAAAAFC59C3BAC6F61D3BF1852FFD087EEAA77F168F3CF624FAFD3EE080C5A5452C2CCEA3721DB80A704897270795F0CAAF2C2A724517AE770B90200005D19E067771';
wwv_flow_api.g_varchar2_table(283) := '9920EACEEB280137BD97ED71AF050532287A15A60C2451A57E49A0E724C02F3063DF3196289180648E3B571BA40B851E863F1F701EDE0B5891E2AF8800C2B15F22DAEA9C3BF4C2ABEF1EBA3273734BAFD7E9A7CB7794534E3609C0A5C773CB1D823CA0C7';
wwv_flow_api.g_varchar2_table(284) := '5C09E131445260BB085413FA637D9C3D7D12BFF52F7E150B0BF370EEC37CF6E99D27C796285FFAE11FC55FFCA5BF85A79FFD14886A8C86430C0683269FBFD9888B126F167BC4B73F513E0ECDE6C79F9684DC8A554B34B81458B4CF6AA4F751D935796731';
wwv_flow_api.g_varchar2_table(285) := 'A07CCB96DF8F01DAE30B6742597B32A0ACEE1791798790312921036980629F20CFFA73B8E6965F819BEF04F032296BF284EFDE0D70F0F7E1D802BF237008C049003757BA25B8520FC0338D733B6FCD2F3EF4C2ABEFEE053005F2E7A3B825465024679380';
wwv_flow_api.g_varchar2_table(286) := '3C96AB96074DEC4207058308B37800FB9540A8AA2EBEFE87BF830BE7CEAC09D73F2A5B5D63FF8387F0F3BFF84BF8B19FFC696CD8B0A12130872AB8F3EA7C03F79602AA84F7C49663F2E6751CE04199AD9395E9F096001C3BE3912EC4429CFF6CCB161025';
wwv_flow_api.g_varchar2_table(287) := 'F9855F722788D2F28FB703049663EDC91DA44472AC25622454BA1B946716759F8A0209441E4D460B81BFDA48A01814BC672410EE1FB8177E19F006808BF05B82CB0260A504D0A9EB7A635555FB5F78F59D8397676E6EED742A7F9B6243E91C2381480C08';
wwv_flow_api.g_varchar2_table(288) := '834E934919C099F0C2597E714008B082823E50368EB31F9CC44B2F7C9B0509576FE281BE2FFDF057F0D7FFE3FF0C471E79020B0BF3989F9FF7B712B3824CCA5B829235074F504C84A5990570F34A4B15CBE1F532D2D1DBBBFA262E39C05D021A3F1806EE';
wwv_flow_api.g_varchar2_table(289) := 'F9E5E744D20D38587D80B0F2FA3E11FAA631E6DDA05C02A13EC0264920286F9C0CA1D5DC4F90D65E6F071A1EC5DD9340F002B6C2C702F6C35F2E7C0BF782009A3BF9F6AAAADA36BFB0F4E01BEFBCBF6F381A6DEC763B1D1FD0535151450281819D72DFA1';
wwv_flow_api.g_varchar2_table(290) := '27C0C80B30960767E23499604AFBC6CB2FE2D285B3ABDEFA87F1F67A7DFC85BFF2D7F157FFC67F02E71C6EDEBCD1DC5BB0CA8952B8B948C037642D6E8CC201AEACBC00A1005C9AD336D2D196D2BC172323017EC603903E05F4B25194E3ED292BBFDCDDA0';
wwv_flow_api.g_varchar2_table(291) := 'C298438B856D65E1BD384902E20050615B8F63208107CA2BB0E201F78404C20345F6C1DF42FC28802B2B3913B0924572A7269A04B0EBD8A9B307CF5D9AD9D1EB76C7EABA764400DF5BE737760E5FA7DB7423B96FCD2B2F19FFE579E29D7AF8CD35E42DA7';
wwv_flow_api.g_varchar2_table(292) := '0142A7DBC3B5AB57F0275FFDD7CDF7AB77CB2F4CF4D8D838FED6DFFEAFF057FFE6DF061161301CA06AEE3918C6E5E59BE4A8656CC9BA11545A2F73396A99F37961B20EC2D56508D6DC86ED4AD6675EA2E90FC458D878D8AB688F9242685DE2EDC93CA4EA';
wwv_flow_api.g_varchar2_table(293) := '0EDFB1B136F5473970DD2282AC96E9A5D2D1303EBEBA1265D9B72C7BAA45E5BBCB232A0EE97E0107E16F243A094F0CADA99500C2C93FE7DCE6BAA603EF9E3C77E0E6AD85E9AA723D6AEECC49427938C0D9A00A792026AA500F9B8C5884D21452B3777BFA';
wwv_flow_api.g_varchar2_table(294) := 'D47BB878EE03E15AAFB614A2DF5555E12FFED2DFC09FFBF9BF8CE16009C3D1287A46110686D28318C00A64CAE5D54EA652AE310F596D530170300117102601D7FCCBF2B63E2A0D9C6CCAA423F2F0F6441E4812088354A463EBB01A5BFC3725A96E0ADCA2';
wwv_flow_api.g_varchar2_table(295) := '6F522E9204E86E48206C094EC3DF40F400FC21A1743CBF9096F3001C11F52BE7B65D9EB971E0ADE367768D8FF527EB9A2A3DE164B2279FFC1CE0ED96804D8BB24E4949BD3F36AA6BBCF4C2B7EE4540E53E2787BAAEF1E51FFF77F00B7FF9AF633058425D';
wwv_flow_api.g_varchar2_table(296) := 'A765940038C2F8988C799E08B2DCCA877F1566332B6F7B06CDE7CC8323396F06E0529F125033F2E673AD74224DAE456E8AE462658C043263A134899100897EA631EB718AFE72129008572FCB908014B529F73B48E152E15DF004B00D3E36705704102ADD';
wwv_flow_api.g_varchar2_table(297) := '7DFCF485FDE72FCD6CE976AB5E1D9EF023C7674F780BC073974D5B0239A9761EBF05F8CEEB2F0BEBB0DA92F74C6A3C7CF831FC8DFFE4BF82739E0C62EC54596E588A0980ABB44502B6ACA59567E23401404A61A5F52C7B15A91D6AD1099653CCB1B2BA9A';
wwv_flow_api.g_varchar2_table(298) := 'B8286F471B9DCCCA231F4FD9ABC865AD4927BDE624C0496C5912E05E80A847F6EB76550CE960D07EF81382935806E3C51FB9FBBF34183EF0EAD113FB7ADDCE46AAA9C32DB2A52CB9B5CE1553CD7F4B1EC31D636277AEC2CC958BB87163E68EA4F6612522';
wwv_flow_api.g_varchar2_table(299) := 'C2D8D838FED27FF01F61EBD6EDF1141FF79378DE4CBE961CA5AF5D26010BD00500488BAA49DE5AA20964D85E4501A8A90F39C989F6959517ED694F84C92312A4B19489653219B032BCEFDC5473802E4702328B28D74A0277A6663C18F80056B00C686307';
wwv_flow_api.g_varchar2_table(300) := '478431005B2F5FBDF1C0DB27CEECE875BBE3754D95B6C816A34A31AF10E058411EB676A39A50753A78FFE47B180E8658AD292C4D3EFBC51FC20F7DF9C731776B1655D5516EA6F48E2853D292B7A47213939BB5B64E0E06A4A2E5565E829059D0947D79D2';
wwv_flow_api.g_varchar2_table(301) := '61734BA20D0394247527271D5E8E1309322269B3F202E0C2DEABF68C654DCCC7FF6D230165B42431B690C09DB90115FCF30377C013C056F8E0E01D1140E51C2600EC7AE9E8F17DA39AA609E811C8312FD59C703E39C5A0A091475814C5E8593D8DBB5F55';
wwv_flow_api.g_varchar2_table(302) := '1D5C38737A556FFB11113A9D2E7EE6DFFB4B58585C00AA0A6230CAA24A6B19EA48AFDCEAC62AB40555642AE20B06C0C59A38B62FAD2E27160D827CBDAC0287B11ED947ED5A6B9293F021A31CA53885F6625819DE276B09C3E5A93D1F49349278F5F83509';
wwv_flow_api.g_varchar2_table(303) := 'F0EE13FB67252470071CC08381FBE0E3011368C1B9F903BBE7DFA6E170B4F7A5378EEFE954D50622EA884915EC695919C3AA70E514796C774C2A3689B6C2FEE9CCCCA5DB96D4879582F57FE8C8A338F8F0117FA18F72CBB97C2CF73307429E2707B8F628';
wwv_flow_api.g_varchar2_table(304) := '9AF60C12B09616D2185111E03258A7E0BA0CE96496559040AC24AB23D79754AE4D8E5112CA7B213D2E26AB12E9F076939CF2F927D666FCAC494097E16472FB24101E27B607FE74E026B42C034ACCE088A80760FACD63A7F75CBB716BBB736E8C88E2C353';
wwv_flow_api.g_varchar2_table(305) := 'EDC94C2E5F66ADC3C0B36010F300D4A4EA2DA3DCDDF20470F3FA35DFE955B80BE02A2FB2CF7CFE07D1EBF5301AA5330A82F0D8A82064262DB8F6B204C00D1200C106189B339947918322DD98C76A8F583FD2287323A0C6C78D02CC728CA832D201A05F0D';
wwv_flow_api.g_varchar2_table(306) := '8083EB9228A3E523BD97A2C153E4C3BBADBD806549407901FADD6D92407886C07678129886F70A6E8F00E0D712DB5E7CEDD8DEC170B4190E3DF2C4D032998670914F8098502E4C3178CDCC5093DFFCE61C16E66EDD96843ECC140E8C3EFCC863181B1B6F';
wwv_flow_api.g_varchar2_table(307) := 'AE3137AC2EB7B299CC749E0251867F999C9245D5B2962025FE1B5FE3B55879ABBD6501C781CB002E0D401E141486838F8F72590912E2C4B18C1C3372650A99E93A975F8E7F315E31373C917C2FF210FFF9B682826119B019DE03D8068FE595130011759C';
wwv_flow_api.g_varchar2_table(308) := '731BAEDDB8B5FBFD739777136103081D2E11CBCA0749962C150F54E58A69592F4902DAE284BFC160898D7D75A5D0F7F189C94672497E36094805B04E006AEB24E302525D4AB296004FE5B855B400C7AD3C6215B21EB4014ED42FC9BC6D5CDC3858062893';
wwv_flow_api.g_varchar2_table(309) := '23547B42F7647BA22E5186134ACA93C940F4701912A03C3727922209DC9E1B109601BB9BBF0D289C0ACC08A039FBDF05B0E9F8E9F3BBE7E616B6753A6E3CAC21F2C94CEB582DDCE22936210036D00209A8296475FBEF46AB3400E8F7FA47E876BBE8F5FA';
wwv_flow_api.g_varchar2_table(310) := 'DEFDCFC82DC92C0AC6F27434501558A435640003E43C2990E40057EB7FF0BEC83CD9893CE11DD804CF0D8340072B1388C624AEA813091D6D1E552647C3CA976314DAABD01E8B944146024CEE9950C5F0574602B7C101D183872780621CC0F2001CF91344';
wwv_flow_api.g_varchar2_table(311) := 'D3273FB8B8EBE6DCC2E6CA5531FA2F26B3C8A29C71954537049EB97ADCCA9BCAC382675C42ABCF0100004C6ED8885EAF0F7F8D82657525C9E5012F28C594D63A94CCF29021FF2868D65E810434C0956954561E599FE53C95AD6EB6F321ACB5F67088372F';
wwv_flow_api.g_varchar2_table(312) := '49C758CB9B7214B2CB632226A16406EF3E0605B9E5D7F3B53212E0CB805DF07100F354A0E501549DAA9A585A1A6E3B73E1CA2E22DA00870EC83F0A210B4059A066C28C43E3422635702E7031507B4DC6054D24E4B32A53A7EAA44B97912B26B2B15AB2CB';
wwv_flow_api.g_varchar2_table(313) := '011E5067C50EA49791930E97A3453A16C02D2B1FE686CF51E6C1513BE084E7A1C90749267A5C5809C097B1F2B93EF33EA5DFA48153BA2EEA518AC8FBC341BF0212287A14CBEBB9435A06EC82F704CCED40F18577FFD1013075E1CAB51D97AEDED8DEEB76';
wwv_flow_api.g_varchar2_table(314) := '27EB9A3A640D9A77CC9C4CCBCA6B05634AA1989484C00C96BFBD75D1879FC2957FE313E874BBA81910332F28C88D034EADFF9322F13C4A5624E7075AEEA6AC25E9000A34AABDDCADE67A60B9DEB2CFBEFE1C709C34480C50928E4D6E39C0850C0C2B5F8E';
wwv_flow_api.g_varchar2_table(315) := '1D24696B12C848C78A37E4F8677397CF8DCCCC3EAA02820496D7BE0EFC51E0EDF00783A6E06FEA2BBC80DC030075016C3C73E1CA8E0B97AF4D77BBCD8D3F0A6C2D045720014BA1A505B11533B75E866BBA8A4920487A626212DD6ECF3FCC234840032EBC';
wwv_flow_api.g_varchar2_table(316) := 'A3C2F88A32D0CB314626518E24E641CA3A271DAED0DACADB563799CB6C7C82E434E9480968CF21F69F931CE972CAC8700BAD7549809058DDB93CDB0C5E316EC27491EB652B095804CA74A84802B42C09841B854CC313C04618F7FFD004E02A57F58868E3';
wwv_flow_api.g_varchar2_table(317) := 'A93397760C86A30D0EAEDB06708B3D7927A570998C4AAE9E52368B04B87AAE854454A73130A06AE51123E3C057808B7261253810A4E94DF3967663783BA18F64F429CD872605CBCAE7C79395D522A92FE155C803A4E698E7C9492E944B563EF52D6B8FB8';
wwv_flow_api.g_varchar2_table(318) := 'AC92E47219B4033CCA9EF30DC9F6447D5A0EEC8BDC2BE0BAC0BFB7496099D4855F060402C8CE03644B00E730363BB7B0E5FDB397B68FF57B5335D51DF0FD7FC841DB93A9AC839127B36699A5CA5DBD7C4D06EE21AEF2A4E547527992D83232B0DC6A0839';
wwv_flow_api.g_varchar2_table(319) := '2AEB0718CACB08B4B0DE967DB2DB0B55682B9F033C9461752872B3C019E795B70D496ED223C8634E420A060980F7495979D1474502B2CF9C0E9164C0E599BD97BD4B2FA4BF9224C0E42733B5724088034CC12F03B6C0B82E407B001D009397676E6E7BEF';
wwv_flow_api.g_varchar2_table(320) := 'FDF35B7BDDCE445D370FFD8002B81AE0F2DB2F12025279D9E4704686028262EBD5BE04E0492AAB7E85021324E084CC0CCB133329B7965B50D61E65E5722B9F03DCB6F2D07D84CE23095B7B2F196145C0C10438134FEC632B71694F84CA0027DE67B34F06';
wwv_flow_api.g_varchar2_table(321) := '0908D24D1588384016149064C5C70FA3AFE1CBDC2B6032B053B86DF856F840607697A04800E46F70D6013075FADCE56D8B4B83CDCEB97E38FEDB0A70E8411B8CCE5D30CE96DAEA8B8955A423CA4BF1ADE644EC4F78346102D9446A97D43EC6AB0835CB43';
wwv_flow_api.g_varchar2_table(322) := 'B9B2326F428A2D27555E572C5BB0F2726EE5F8A03F33E20A68B3BC092BA097CA09388B71C557B2DAE33694910227B9A29567F3A8F258DE19D76F256C49BA0AD5B90793CF579AF3159140051F07D80C4F0059205078000EE88CEA7AF29D1367B6F4BA9DA9';
wwv_flow_api.g_varchar2_table(323) := 'BAA66E69D0165BC7F595399972EE484C8A0A061514535B8274D865951E004872457087A50C72B7360765C1EA724F013A0FB74E49EEE24426B5C99A64DB42A1570270ADC876BB710E855A2972632420C7A5FA6CB5A7BC4A3B0859CA2365607AB49A74F4F8';
wwv_flow_api.g_varchar2_table(324) := '78BF324F01A9A7256F012C0F136891046CF5EBC2037F0BDA3C80464F7B4B4BC30D6F9F383BDDE9742689EA4E66E50135E1F2554C546EE3720B424A5899156433ABD6CD5AB0AB39696B905B5DED01940017F2185657CB9B7280C398B70C7264B587BC3D2B';
wwv_flow_api.g_varchar2_table(325) := '96C0D4A0E4BDAC8474041F2A19D841413275A2ECBD483D2DB513EBCB8C99413A2D78C8FBA574437CA1F2284FA44802B61B10B603A7E103822210A809A07FEDC6ECA6EB3766B738E72688D021345B808ADD3529488F40B2B51CA065B192B0A49193FCC695';
wwv_flow_api.g_varchar2_table(326) := '2DB6B30662004941C800B8B48212702D318320430E4AAD80B1DD54282F97031958597B7C3EB5951780CBAC764E3A410EB16A05B844724C1F321260FDD28085EA53D69E31563E7B86AB6F1922A9EF799C4A9080C204C3F4F224C0A557F62042207002DE03';
wwv_flow_api.g_varchar2_table(327) := 'D8047522B062F55700C63FB870759A8069108D47F073601B165CA95BCEA2C5C9E42C2C7FD3EBC338094A71B852ACE6D40A709689B23C05ABAB00971432C95C809FCB3B93B561750B6460C76C1491F316E3DC2B92B3BC07F65A5ACBDB9E626EE5A551A26C';
wwv_flow_api.g_varchar2_table(328) := '3CA5805E66E58BE349ED9B414F25757B37206662B3C3BE6E230192155844DAA4705DC074F3370E86FB10E073F02700273E38776533114D11D023421501CD8693BBF169F2E5A432C5CE269309530817599E8C04D4776B2545591924C0D7E796D5E513ABD7';
wwv_flow_api.g_varchar2_table(329) := 'C1C4FE839279D9EA69373EFC15000ED51EF13171220FB10E4D54AC5F617CBC6DD6B79257C10D91B6B2D025338B0EA157E0AFBC3DD68E353E01D465E45BF25E78DB7CFCF958543E361EF99EE4F74296A8E0DDFE29F860E0045820902F013A00C63F387F79';
wwv_flow_api.g_varchar2_table(330) := '13112601EAC4F6855BC52646B3B5B64662F20BC1226541242928A09824B04658202A8F6DE5E3A431B971C949EB42C888505912CACAB1FAB5B5E5ED08F9228299CF91EE232F2348DCB0F2B9E7918F8F5A74429300D783CC025BEDB372B44C7B368136F5B5';
wwv_flow_api.g_varchar2_table(331) := '5979B2743DF4479663AA91E6AF4002FCDBDB24811007D804EF01C440602400E7FC12E0DCA5998D201A2742252D4EB2309AD58445572E3FF44401420826C32A9617CAC6743659C2559E94924B8ACB0117E52648555B63EE1D68CB68C752B86267DE19B7B2';
wwv_flow_api.g_varchar2_table(332) := 'E0329773645B62A9D6CB59790E9A34A7EDA4230C91B41A05F2D0E3C850D54E72AA6CEEE9D856DE5C6A083CB0FA455B52610CCCE79E47F69B450200D2CD4237C25E0200003A57666E8ECFCD2F6C807363045492D5A014256A061B008931929A38CB6DD4EC';
wwv_flow_api.g_varchar2_table(333) := 'A9273CAB0BCCBA659259C5C9F45E14E0344894F224EF41C65C322B2364A7DB611DE2CA4B72DE047861118B4D027999A410E5651C7B0DBDA3924E206B0FFC55793DDCDC67725479F3D8166B6F45565EF65F18BC8C7C0D123040CF7E6D2701E8DFC487709B';
wwv_flow_api.g_varchar2_table(334) := 'B00DB03D0072003A9766AE4F0E86A38D0E18075107F1C080C184C4649B4D9476E2F389E2DE413E99B22D61CD484A612D603FA89C79A2D254CC849BF2FA575A230E38BEB4209129BD5AA4C0CF29A4F672C0A9AA0428F4F834595BD65A1B0B1B7065AB9BB2';
wwv_flow_api.g_varchar2_table(335) := 'C8F171D0944EFE490A360C9E5EB2B2F9C9015E262E41D9810484D804DAC14BF0F68A244059CE90C24E40F000C25980140320F227862E5FBDB16130186D84C318F9C7B5DB6B2443D82B3AFE99B127CA79B4621A0A26DDC2D59B9811CA4820075C586A2980';
wwv_flow_api.g_varchar2_table(336) := '1B80A302E0C23B19CCB2AD6EF9C420523FF89CF2F910163B9F7F0142B38F9A500CE212ED14D6D6C1E8F03A32781BE50C6F290C22D34931AE02C05BF060918E8038C73F270152BF69802B96104441081B7EE1E1A11BE1BD803E1AEC070FA002D0BF74F5C6';
wwv_flow_api.g_varchar2_table(337) := 'D460349C70705D6AB600A3125AEE9812B36509E444296B90E531145A2B1F78DDC65A699527369F713C1270C8C71C4881FB556D24C011A6494193B94102DC954D7597DB13565691825E5AB4038E9102E93A72AF42C82CD4D74A6ED2D868D249B2E672635E';
wwv_flow_api.g_varchar2_table(338) := '4C0B1E625DBC4C46309AF064DFC4BFDA131004A1AD7C211E9044126EF33F01BF1B900880FC4D401C80B14B3337260783D1381C2AB0A7FFDAAC46452B6FB1A77029A93499B605D12E9E607505A8D59A843B6981894FA59907110899F294AC2E0C0584358F';
wwv_flow_api.g_varchar2_table(339) := '06F8C990758104B2F9D34BC03B001C27772EB7925BCD5A2B0095B2F664517B79A2DB2396971F722AC544C478820C84C7609049F8B7400230DF1748C0CBDA21050227D15C154844AE02E20E40EFEACCCDC9515DF78166FF5F54BCF23559B68E536C6D0959';
wwv_flow_api.g_varchar2_table(340) := '41404D2631003045D28258D5893245097248F2E08A6CE7D1564FBBD5DC2297AC6E6E79ECF933DB93F061EDD9A49386942F2DCA649FB427F68FBDC99616A2EF39C971A0667204EB73460286952FB9F15CE6D69295CB8013CA7224606A929AE734810647C4';
wwv_flow_api.g_varchar2_table(341) := '6FC2854193F0E702A20780AAAAAAA5C1B0B7B03418AF9CEB8150890E6A2B8F5C512CD7A66D8D2426C7105CA6C07C0298E9D7AEF16A4D24FE55206CB3F23AAF261206B8588798237B1E63BBC26330E6DAF4E0747B65D209ED68A222F0B995F36A5A5431D3';
wwv_flow_api.g_varchar2_table(342) := 'BA4F5A6FF23536071E6F2F93A3EE63126811E0B9E14B799623398D87F44AE23BED052C4B02820908480782C6C109A0C9E2E616167B4B83E1B873AE174E0995AC7C524E29B01CE0B995CF98105CA05C1194C5902213CCBE2652ECAFB418D6FA5B038E6981';
wwv_flow_api.g_varchar2_table(343) := '49AA421E7CBED4D2C25E3EE4442D2C2F643B7C8EF5BEB8869C182EA53259DF8DB64A004FED29D2B14840033B233B3B4691B5075D3707B8D261A6FF653C286396E1424CF9F22490BE52C06F44E90848770A0E04E077019AFC6E7171A9371C0EC7007409CD';
wwv_flow_api.g_varchar2_table(344) := '1D8059A332121A846728CF6D5B79BD56921624095CD51B19726D3040EA6F1A23B7F23C57C9D56F77130D1280246109E2320944001A80E3EDEBF63260063251EDE52457029CCC23FB9C934EBE4529094B1027939D8E51247D53E3E3ED31622E59F9DCE071';
wwv_flow_api.g_varchar2_table(345) := '39A5F6AC251A440F972101B59C137510D0D8F310081C032780266775F3D642776171D077CE7589A8CA261BACB382E534B3E6565E744A5879C9C4120A9003A5BC6DB9E25903895B5FC3CA339E94522C595D264449D649662973D9EA8692E6924D782CA466';
wwv_flow_api.g_varchar2_table(346) := 'D558CA58D6597B0690BFD900576D11ABBF445CB1BB1C38F96F16510AE123CC47894CD318E2CEC772569E94CCAD65AE32FFF958A40CB5B557B9E3FB663BAF8227807EF31A9600E400B8A5C1B0331C8DFA0EE8827C8470D9AD0EAE7824278A0FD262CFDCAB';
wwv_flow_api.g_varchar2_table(347) := 'B05D350D7801166599566D8A3249D0D66EB565E5F333111A702C5F0170D145D5ED659E583EB78052DED09E00B8413AA24FB23D0114D66ED1CA131F3D23C62209D880B3773E948C884B19F9B8547B922395E55E919557785044C2FB1B6BD624C0A523BC02';
wwv_flow_api.g_varchar2_table(348) := '9EC739240FA08F7410C8C525C0CDD9F9CEC2E2A0E75C730F00A684997BA70620BC01A1F0A9EFD67A270E24CB93144DB8521601AD76F0A7F9520A95C6928F4992C0CA0E5549C069C1E8757789047839D137636DCD955CDB1ECBCA2303B8F60D0A9E404694';
wwv_flow_api.g_varchar2_table(349) := '528314DA8A8013CB3056779B1C73AF270A53E6215EC7F256DEC403CFA7744558B9A2E5B749A0F6FD0827027B1027019B028B4B83CE7038EA01AE43D4840DF8F410A49CF5BA4DB31A9BE0D63512E93265EB9009932BDA5A480D6309765740D6565E28BD26';
wwv_flow_api.g_varchar2_table(350) := '0136F15A798567A0D7F24CE2DC45E5F2CF8899F75181D2222EA913AA4F507D0A44A001CE659391403EAE65D7D6CA78C59E59E42A742FBC679E418B959763970B55EB90533E3E0B4BA9CF9985D72400A87C00720200C0760108E810A14B20751150EA8AE8';
wwv_flow_api.g_varchar2_table(351) := '5469C29942F05ED8AC6B4C546671A405C906BC06D0CF2D69FCE30017632DCB42BBFA7AADC8AD1C27D98C04F47A57910E77BD6D30F3CECABCA5B30B763B9C086D2BAFDBB3BC98D407AEA7D2EA92C8642F37F9F8CC388D9611977821AF3678591F85F76519';
wwv_flow_api.g_varchar2_table(352) := '3C4D024C262512D06E719A83100790D70200700B8B4BD56038EC38B80AE1494005774C5B791BE0D21A656C56708FF800F26D2CF91B88D7BABA530055A6884106DC6287DF14B373CB635B5D9B4CF37533A4B271B9C2986B4ED8C23361DE0CAC3EE9B94A73';
wwv_flow_api.g_varchar2_table(353) := '9CF5290378C1CA03426F323DD5C4959095F5C904A769E519283332E5520B7D6CC78300386BCB1A9706744E8CAC7DC330B23CE13460A7790DDB803ECBD260588DEA51C7B9B8355860EB9620881AB406B8758A4A2805B54D94CA27C0B0DA13535D36060539';
wwv_flow_api.g_varchar2_table(354) := '430636C02308541952E5B805C9025DA5B5B5B0842A36C126DC9A37D927A60B224FEAAB5066D117C916F99249AABE392EE16A2BABCB2DB122535E97363004AB4F8617A1DA4BF543C9C05A46CB7AA0F097BFE79248A2E1D86010E10410BF00FCA3EC1D9AE8';
wwv_flow_api.g_varchar2_table(355) := '3F9A27016780CB009E264C336128A0592DB3E06A4DA6D9B3A8AC5C69D6420A93AF484EBBA29118956226F907F424CBCD2DAAF42AA4527026B5809DF0454201A5EB2909A5B83C31209703BCCDCA4B59B4EF7C48D291955B80CB8D13D8D873396ADDD34491';
wwv_flow_api.g_varchar2_table(356) := 'E381B7972D4F041E922E701930BAC98CB07E5F82806AC3197FFCC1200035170699EE98543336682548E5BE5B6BB2E501AE26C5CAA348692D246D11F8B8D2589250332BCF7E965E96022572E56D6B8F546BB6E7512066DD3E2734632E4DA3615A79260A0B';
wwv_flow_api.g_varchar2_table(357) := '70E1B3D241735C05AB2BCB4970C93C3951A66516EB6381044C99F1B6B23C36E9481DE22DA77F28CB24C616811F522480BAAE516B561603919313FF5582CCD6804A09B892F141676CAD00C0354208772D304094015F1F6A502A2B282CB16D75C3A4F0492F';
wwv_flow_api.g_varchar2_table(358) := '6D2FB5B51765CFD75A004A9E9F98B74C350D1230C6A7CB926A2F77879945E43229020E597B620923E40B7B4E94AC7312B0885211528904484AAE1C37C9F117A5C726BE440292DAF294D6025505E7C0D42717AEC5D61AA49285D9408A004FC22E1D1E81A1';
wwv_flow_api.g_varchar2_table(359) := '3C940D7C1527C7FAA8AD1FCFA7D69E160924056076CB04389B2F834C33C0255393034CE455163D69BB4DDEDAA8846166EEB8E1E908BDB10D90E58596B61A8304046165E3324880B5B71C1E74B99CDC0A00E7BFF1925AAE4C06906FB3363909F069E72A57';
wwv_flow_api.g_varchar2_table(360) := 'B112E9CC0FEB491E4CC8851C195BB1AEE532E60097CC5E5E47F1C9E4F9112E7658D5495A70A9ACFC37B94E94E3E58A9201BC480290F363781550750B50A6E99734CF811FAD9341DEAD565E5BD4CC8C643A515C9E30498B71182490018E93432647832801';
wwv_flow_api.g_varchar2_table(361) := 'D57E1BC0F3F650C243F8C920665295DD565050438C7DCB1E0C4235118D00D45181B8B2F2892AB05AD98DE765B4A2808D5C0A99F8A8C810AE40C7EA4D9C8DB3B527E3642B30CA2D8F0D70C3EA8A76B9D2F3B539FBCD0229D7374AE504F85549B31C8CF60A';
wwv_flow_api.g_varchar2_table(362) := '6EB51C970298229F2C06C4C9AAE0BD44B22A595D934C3932B93CB88EDE8695E7AA00FE5B99E484B78C3C8F1823D7B5E60D5BF4D70022C601A00A8FAEEC763B75555523AAA98E2DAA35921504E12095CA930427E547E6A06DB6E6829313AEB7BE5675E213';
wwv_flow_api.g_varchar2_table(363) := 'CBC6C227CFF29632802B12904ACF816A2F17523D16E0E4B2A43C47296F6E41A56E241250EDF13E318017970B9AB814E072424979B35885229DA4B3DAE0F1E9336206B19CC283EA93E9F51A001798B1488E48F43993819A8728EF341682240002802ADCF6';
wwv_flow_api.g_varchar2_table(364) := '77727C6CD4EB758635511D402A2793758A09395B930152903C4FC995E2EA2006AD278A2B0E1BE55A489249E5A483C94AC8803205C9E42CE688CB1CA20E69439BCFB7617579AB3650599FF9DC44B3D7DE1E441FCBAEBEB584D17A2AC1A4DA932391BAC5E4';
wwv_flow_api.g_varchar2_table(365) := '88B81E462C91E1218C9BE3016A1C90F3570278AED5852593453AB9A2A9FEC4540318C293802780F84B4D23AA690050FCD10C828841B7ADC9A4D296D664A63BD60600365196355DAD897B003999725971593632D716844FBE61E5B9ECE4FB52EC20C93F28';
wwv_flow_api.g_varchar2_table(366) := '1A47866C2FD5C9E751F4998F0BE0A36A5D5B0B1066569E0335C91130CA58E3E36E3B2324B1B4607552498E695698F1D3C0D66D5B446F908032789957A1B194262EE9195302CAFF19011834AF0058107062BC3FEA763B83BAA611A53020032AC4A4F2162C';
wwv_flow_api.g_varchar2_table(367) := '25605E2603AC043888D5C94820815B2A6B460224C6BE8A13531B0B5002E09A6CB552481208F2CCDC77580048FA92791586E58E792DAB27DAC9FBB9FC61310BE0CAD5677AA3CBF04336A46520CC1F03AD61AC60B557304450F2D0D63D5BAE28D2B1B64EA5';
wwv_flow_api.g_varchar2_table(368) := '0CC898EF1CDC56BB64E44BFFBAF09613000140E5FCDD0268C3E4F868ACD75DAAA91EFA6B83020958EB1F1242C84980BD72C545129E9CCC5CC9A1268AAFEDC424AF0D0660931B5420A982153781902784CCA48CD367AED4F9B221CC87045C9150787B9911';
wwv_flow_api.g_varchar2_table(369) := '40DEE7AC5D35664DDE567B59DD5216D91250E84219A8ED5E0565ED6912D5F20D63C80D982E9564C7DFF3B12293758E07DBCB660676191240B2A743004B4804402108588FF57BC34EB7B354D73424506DADD1CCA8AE524E6BABC3746D924CD88092B614D7';
wwv_flow_api.g_varchar2_table(370) := '8050EDDD160A3FBA142D994594ECDF24564D0212E0A9BC6DE535A17039651E5D81BC35E0CC259B2264E9EEA601E52400D99E6515A52A6520B40027ACE68A0067934E26473122CAC69213A5241221837B898712FE58BE661B20ACFF979AD71A00AAE6479A';
wwv_flow_api.g_varchar2_table(371) := '9A1C1FF4BBDDC5BAA6A16F4F5A57C1847C80067B6642864502C68054C7F980B812E46CBDCA13B1BF120944E52156C406A5B60E99EC4CC01975B1EEE9DF787B9C646289A8B0D2EA5AE3CB014752E9A9349E40FA763CC3025CFECA2C6806B83C766083D918';
wwv_flow_api.g_varchar2_table(372) := '172B99B7777B569ECF3F97639231EBE34AF0C0272BE2DF050F60117E194000DF0598E80F7ABDEE425DD703260BE55671E5940D5A6E9C5E93596BC23C30C3AC871E90269DA031AB9D015C5214611BD302B6681D5A036C4A8E5A99350964F3480960797B39';
wwv_flow_api.g_varchar2_table(373) := '0944E5E6E031FB29DBE3800B29F65128322FC762166C5CB1749BD5B50C10D31B392E64FAA92D3784EC0A32E293C4C8DEC411547B052B5F5C9E9878E06495FA12CA39FFC500C002380134D9EBA989F141BFDB59A8890600D5D900B9B038E039FA94B530B7';
wwv_flow_api.g_varchar2_table(374) := '7B4A13A395C9B0F2BA0C336CAB3AF9F97171A2D2045B16A4DDCA73E0488BCA263D2AAD72FDA345558AA6DBCB66D6266F6D6D7539B924610A6ED5C5E637934106706559393165BA27C9477B2C765050010C96CC724B2C65907B4FD94E0463B1DBC143AC9F';
wwv_flow_api.g_varchar2_table(375) := '9761BA9078AEA9C739C0B91A9200FC12C03987BAAEEB7EAF3B181BEFCFD575BD4440BD6C108469713E99E54197DCA3F6A505576EDEABF0C51A618128034346219B21D798572B1D78B9B2959773945BB06C1EB5B2296B264940015C4C9A2EA7E796E90D6F';
wwv_flow_api.g_varchar2_table(376) := '0F467BA46590AFFFB91C621E65DD457B26E04AA4A3F100130F2651F279A2BCBD4C8E402B1E52FE7C7CDA032322B826CE07BFFE9F832280D0D6E2F6E98D73CE550B54534D310E20BA9F29437132F5C4F041931C1037E392D5A420EDF30680BAC271D524D2';
wwv_flow_api.g_varchar2_table(377) := 'EF0DB7DAB4466CEC72BC06B0999715A45FDE8DB1ADBC9635AFB7752722CCB62201AE2711104C06567BC8FAACDA530465C931234C28F9B4005C7813E1B50842668533722C11A51107107972A2D465728360E9922637C03947F0805F8027804500E49C23BF';
wwv_flow_api.g_varchar2_table(378) := '04709E1DB66DD978ABDBA9E66B6A02812407AD5DA99C045A04670C5EB35A71AB230300674D8A7D5AED4902AF00166D1D387894C5CA2D38923C439B25ABABC837076AAAAC35282850834402CA42CA1D0F08C0E6046FB4179B23D1BEB5FD997989A15F4CAE';
wwv_flow_api.g_varchar2_table(379) := '5A06C2EA0A8B2D8981EF7C08BD54849A039C174980B6EB567D52EDC43E96488EE1AFB90300C10700E701DC82F7049A5D00000EAE06B0B46BFB96D96EB773B3AE6991D18FE8989CCC9641B3F7F664DAAC96AF9138C4E51A905BC9D59E7225C84995B3211B';
wwv_flow_api.g_varchar2_table(380) := 'BE691DC85014D3C2A59A4DAB9B59794AB4C395D4DA89C85E755B6C1EE5F22F911C9F40310E8304B8B11024A48C05A9F6A80038BE666A2339BE3B63E7C9094C108A892346585143B84E40B6AF0839232AA60BDC3370002A4F008B006E0298852680862146';
wwv_flow_api.g_varchar2_table(381) := '3BB66E9AEB763B378968818091B0DD94AFE5610D9AAB1DF1CEEBF77C5225AB656E2011B45791D68B6B8601E2F820148303852B69D95BE232CB3C83E500AE95C6225E05384D3A51914BA4A33C3F61B1B23C0C609CD8557B96C7C00D42CCC7E4C30424974C';
wwv_flow_api.g_varchar2_table(382) := 'A2575287797B826478DFC1FB90931CAF4BCE508E87D0C7221EA0FA1FB21597308AE40002DC08DEFDBF09BF0490D702342BE8D1DE9D5B167A9DCE6C5DD322A8B941104985D1CA943AEF7F736AA2A2B8C4645A75E8B54B92AE356821C03590B4C514AE7720';
wwv_flow_api.g_varchar2_table(383) := '38ADC82891803085120C0648245187FA9842593217F388F80F891149422A92809A23B29455B597B9F1B14F90E3B3C02B644E28013C5BC6A6EACA4B0BBD24303D1DDD678907491E612EC8C683C29F65E521EAD2F3E9E0FC127F11DEFA2F405F0BE09C8F12';
wwv_flow_api.g_varchar2_table(384) := 'EED8B679617CAC7FB3265A207F7F00DB1A71F60CEF56C8D65CE923FB9506DDB226E3EE3457CAD5944268D285C3164235DB944EBDD763CB2C8EB446C68A39D619DBCB00AEE6947B0F05E2E2F3115B2BCD63D64FC3A3D36021D9AFD0862601615195ECE298';
wwv_flow_api.g_varchar2_table(385) := '549EBC3D64BA06211F8B0448C8DB2EC7FAA871C1FB27CA95C9541A06C4B158C44544CD0EA00B01C09BCD2BBF1F402C3872700BFBF76EBF01A239906709BEFD920D9A2BA235E86CA2B4A8F49AAC3068D68E00009FD0559842D7161716301C0CFD764C914C';
wwv_flow_api.g_varchar2_table(386) := '73E5E52E65922365A41A958B33464179DAAD60EAB4B024C63CC2A88B4D8ED13EB279D4DB9F1AFC667BA4CB717918792DC071D96BC02992CB0C502401469CCBE1212B97033C55A548C7F07AB5C717FB68188FC6B88FE05DFF1B287800D4AC13E6F7EFD97E';
wwv_flow_api.g_varchar2_table(387) := '1DC02D020D889ABB036540958315830632414B465793605879D3CAB00E50D6D26A4DBE7FF373B7301C2CC13997298F26CA286F3E5EBDAEE33220A5080270C6BC095917C85C2F2D18E034F1E684C2DA2B925B3BC949E9954987B3C78A488048D66F01CE68';
wwv_flow_api.g_varchar2_table(388) := '2FEB7390366FAF0D0F44AC1C449FF2254C4E3A9164141E5ABD6C3401C02A1E00BA05E03AFC4EC0A8D91A4C1E009A7DC287F7EFBE46C035222C00246219527872125B278A4382EC8992002F580BCD8C04A908AB342D2D2D62341AC2475B29573A0654F103';
wwv_flow_api.g_varchar2_table(389) := 'A4127180DBC490BB8812E0E579CB48419170B274A91D6B3B52AE633908117BA6DBCDC6424A462DA453B2F24182B9954F6DA46131CB5468CFF242A51BBF323CA43962622D7A540C0FEC5F3976D617E2FA418073A82A47F056FF5AF3672F019A9D80A507F7';
wwv_flow_api.g_varchar2_table(390) := 'EDBCE1801910CD13F99D00CD5872D0DA5A48A6CA262A1396B620B9951776CB02C0EA3C07D4B0B0C360B084E17018BFD4E3D40AD946A636095800CFADBC6575856217002700AFACBC9A9DF883B5B410D64FC84981C3220F5230CDFAD46651D9A80A323797';
wwv_flow_api.g_varchar2_table(391) := 'B1A93AD30BB548B86D1E0538896B7899048A728C732BE59A08CED7D2A9AA11BCD59F815F022C7131460270FECBC18E6D9B66376F9ABA3622F2DB051A94D964722B1587232C873551D1123221EBF594A9F05042204255C5879DAEAE44045755A0BAC66838';
wwv_flow_api.g_varchar2_table(392) := '049C4B4C2E80902B6DD2930209701829EB646EB782E7A14C59738027C065565F000ED1F28B712DA73744799FC55CDBA41301CE64D01A3350728CD5289967BA17FA991920F99BA5A7C464C7983927960CE00A0FCBC8512E49B81EF83F0707E75C58FF5F83';
wwv_flow_api.g_varchar2_table(393) := 'DF0518A44EC92500008CC67ABDB9278FEC9F190C86B79CC3300A950B84D480B4800553969587AF77C4C4F0F628B56701A02642B7DFBF2D5C7E9829EC00CCCDDD02D535F390128024E0CACAAB89125A313212907508CF40B9F1ED8093324F3A9174230B5E';
wwv_flow_api.g_varchar2_table(394) := '428E87B79BFA64F439E666FFB2F15AF2D0ED8971681928C065AF068131A489FCA62E2B2BCFA7ABB4459A5979901C57017F50E34CA403C001DD6E07F027006FC17B00E10C404CC903F0D7048C3A9DEAD6B38F1DBAB2B434B8EEE096480702F97B36E8A474';
wwv_flow_api.g_varchar2_table(395) := '6CA22407162C483EA9DACA5BCCCEC1D0EB8DDD01343F9C14FAFCDE5BAF6171711155E5A2E04CABCBC7C98951916AE96090841C0738571E2D6305703D8F947FC71B17BCC4C1A980A34947EC3091AC43004CC9A064E533A066563E812AD35D24D2C996A266';
wwv_flow_api.g_varchar2_table(396) := '7B9ADA48823F8E85CB4CE34892692BC9B1727C5EB23EB1BABADD2A5C00741DC0157822880140407900E49F0B30F7F0837BAEF4FBFDAB35D5F300EA3CCAC9D81476278A13053ED8F2A4F2C91062E68326A0AE47D8B465BB9CE85594429F8EBEFA021617E7';
wwv_flow_api.g_varchar2_table(397) := 'E15C253C1F1BCC0651668A19F2183111A588C9FA964987035BCABEBCB44886202710F03E159616A10407426C2FB3B262D198118968CFB0F2E07DB5ACAE001CB3BA4C16ADDB9F86319479E4FA5CC70A96C383F61482E43409C4F97440B7D3A9E1D7FF57E1';
wwv_flow_api.g_varchar2_table(398) := '09A0EC0100CD121558DCB56DF3CC130F3F7079617170CB397F6CD0626BA17452755A4920592C258482E06C4BE7BFAB4735A6B7EE5A191A3F8214C673F9E2391C3BFA6AB315485231C2BF86F24AE255CB0424A51324C010660605919429C83F2301930CE4';
wwv_flow_api.g_varchar2_table(399) := '98EE8E7472375AE8821A4B5411CB8DCE6420EB141E061B4FBBD58D1529D2D132C8C1997B70B6F754C48368AF8504341E58DE5EA743CDFAFF1680CBF04B80C5A4193E2902704444834D1B266F3EFCE0AE4BF38B4BB3CEB9A160426BD04A7163C7B47035B3';
wwv_flow_api.g_varchar2_table(400) := '13C4A0CB5B4F567B3ED5758D4D5B77A0D3E9DE062C3FECE40301FFF60F7E1B354352BE644A72CE019C2C95E52DC94050CA67D6A1143FCD514E06DA82DA80CBC1DE463A5639DF5EA6699997415939D6174558D242E600CF4801324F4E5CDA70B5ADE54B40';
wwv_flow_api.g_varchar2_table(401) := '55E453202E3D663EA76DE71BC2BFDD6E05F8F5FF2C804BF0A700450010C88380A86B1A5695BBF9F0837B2F75AAEA1A1196D01C07905608AA13B9354A139226555B0BCB1D23D6865E2371C101C06834C48E3D07E0AA6C28AB28F9BE9E79FF3DBCF0CD3F42';
wwv_flow_api.g_varchar2_table(402) := '7F6C02A3D1282991B67A515AA9F472DB4B1C11B95B1DDAE1CA4D42D68A8A4595DCCAC7BA741F39C98B71A93E43F655BADEBA5CDE1EEB221B434EA6B0C667928005384972D6CE87D46BC3488536381ED412B58807451E027305FC69B9F7BA5D825FFF5F43';
wwv_flow_api.g_varchar2_table(403) := '2280A1D6CCCC03685CFE5B87F6EFBAB477E7B6CB8B4B8339C08DCC89E25D321525FEA3CA3158503BC0330B99313BA1D79FC0F4B6D5BB0C68648B7A34C21FFFDE6FE0DC0727D1EB8F61542712C82CA3509EDCF58F32A576394A17515BEB7CDEA49EE6563E';
wwv_flow_api.g_varchar2_table(404) := '072A2330DEAF98C79A47DB8DB7D6D6820C0899CEE5ED41B427AC2C34C02D6BCD8D8F2AC3752F2EE324A932A989BC5CFE361E8CB9E6E35B067FDC7BEB763AA8FCFEFF1CBCFB7F09460010303C00E75C4DC0FC03BBB75FD9BB6BEB85C5A5C1AC7318F9B1EA';
wwv_flow_api.g_varchar2_table(405) := '8962EF3346E779F444F1726C26E217165B4BF2E013E39CC381C34F45A0ADC64444A8AA0A572F5FC0FFFDEBBF8AC5857974AA0EEABA1672C848AE007021852C4FAA437B1541A01C1F452BCFAC8F9E1B99477A1525EF45345AB0BAC2BD36DACBC86D99F64C';
wwv_flow_api.g_varchar2_table(406) := '39A24042DCEA3600935EAF4572361EB8D024C931CFC09263EA78CC9FE3C1682FF49008DD6E87AACA8DE0DDFF0BF001C079B0138021590440A351BD3439DEBFF6D0FE5D17005C27D0207257105461D0E664424F2619E5F8DAAA6DD0B9C2C339EC3FFC940F';
wwv_flow_api.g_varchar2_table(407) := 'B061F5A6BAAEE19CC3DBAF7F1FBFFFDBFF3B0087AAB28382516E0AE0B0E4C8E12D3C08CBA36200836AAFE88EEB35B56DE5330BC92B13E456B0BACACA0BEFC22CD7D21EB5B787D4E5D8B7DCEA067932196472CB011EC8C3221D217BB289248D8BF23E2AFC';
wwv_flow_api.g_varchar2_table(408) := '710F27B4D1EB75087EBD7F1D9E00AE419D000CC92400E7300470E3D187F69DDF3835716538AC178204387BCA4E486B549C2835A962A20CCF20D4A5AD53322484BA1E61CB8EDDD8B1F741A0F108566B22F25ECAB7BFF63BF837BFF5CF51D7B0770618B16B';
wwv_flow_api.g_varchar2_table(409) := 'B9B691A920DD24C822998AB988BF59D6A96C7543037AAE49F5390B2836936E03552E2D6484A2D49ED21703A4A94F9AF0E46FBC8FD9769F5A32E54B9930F6DC58497297F398E121CA235F1EF07146B2AFBD97D9ED7408FECCFF1500E7E18F000FB5FB0F18';
wwv_flow_api.g_varchar2_table(410) := '04000095DF3E987DF4A1BDE7376D98383F1C0E67018C84AE28668F932094D59828AE33067B97AC8356051E701A0D47989CDA8467BEF0679A9CAB9700C098FDEB7FF05BF8DDDFF8FF8100743A5D3FA1E1B420039C4032971B6093805A400BF0144840CC9B';
wwv_flow_api.g_varchar2_table(411) := '282581A301177F879CDFCCD25A4B0BAEE49A841471E9BE5B24C03A6F1325C0DA616360563EBAFEBCFE28F83C2652C2431A9F3284AC9C207A263F2B2623E59FB747684EC556159AF3FFB3F0E03FDFBC17FBFF219904E09CA3BAAE17F6ECD87AE5A103BBCF';
wwv_flow_api.g_varchar2_table(412) := '12E13A1106D107C884AC5954B178E6AEF0354F0B9B72DDE76C272C887F1D8D46D87BF051ECDA7708045AE5BB0209CEDFFADAEFE09FFC83FF0E1F9C3A866EB787AAD3415D8FD28DD90D0B27AC43AC4BCBDA70AB753905381133E0C48C944F03CEDAA7D696';
wwv_flow_api.g_varchar2_table(413) := '5BB423F4265FFB7202D16E7502AAB4F252AEE51885F062587BB15513A805AF4259F9527B7289A66516F21464C4DA079399D55E1855BFDFA5AA72C1FD3F0BEF052C64826A520925E49C1B00B8F6E35F7AF65CB75B5D1E51BD48A05A4E72E8841C909ECA7C';
wwv_flow_api.g_varchar2_table(414) := '32910DDAB4F28AAD4361B16E8277F98783456CDCBC1D871EFF1440B4AA7D80D0F9B01C78EFE8ABF867FFDBDFC777BFF107989BBB855E7F0C70403D1AE59E40812863B528E7C9BC333D4B869517CB2E73660D22C9BC0AEE4D70BD898D95DD6AD646EE8EE7';
wwv_flow_api.g_varchar2_table(415) := 'ED2CA79F5468CFF42A84B556C485D477A01D0FDC5B8A1A6E90709104B8C40BEDD535A1535518EBF7C2EDBF2E033807BFFECFF6FF432A7A00CEB921801B9F7FE691B3DBB66C3A578FEA6619A03B033140EE567177459280B604791D600A290519265EB5E7';
wwv_flow_api.g_varchar2_table(416) := '2A0C068B38F2F417B063EFC118705BDDC98FC339876B3397F11BFFEC7FC33FFF47FF03DE7CF9058C46238C8D4FF8C9658ACE8CA1B4F68C1C0370DA48407B0CA4E64A7B1E7CBEF412C4B2F269FE15E0A44FD16A7505C095DC846E9548809760FD5A960478';
wwv_flow_api.g_varchar2_table(417) := '59935092FCB8C7231DDD5C97333C6464A0C9234D4C4E6E6AF940845EB78B7EAF1BDCFF73F01E4071FD0F943D00C06F19CCF7FBDD0B3FF2B927CF0C86A36B40B30CC80425019E804BC6A09195D496404E145B9321D5412AAF83C36838C0C6E9EDF8D24FFD';
wwv_flow_api.g_varchar2_table(418) := '22C627A69ADF573B09209280730EC78EBE8A7FF1ABFF00FFC7AFFC03BCF1CA0B001CBABD1EAA664953D73588EA4C69233946602BCB8BB212B5ED0CA4B94D7DE52C645AF938AF2A4F660890B527773020006E2F33791E2CD39E5EB72F63E52DC2147990CB';
wwv_flow_api.g_varchar2_table(419) := '33F487B55BC40331B9327ACC0DA0224A0B77CE617CAC47F0D6FE1A8033F03B00E6F65F48C50BE9FFEEDFFDBBA1E2B1E94D53DBFFF5D75E38D0EB76B61330E62271387F9F3BD73C7F20585CE79ACB605DCCE5FF67BF373FFB6B9611AF9B75E9569A4D9EF4';
wwv_flow_api.g_varchar2_table(420) := '4D2AE7627BA21D57613858C2F4B6DD188D06387BF2ED35E005C854551596961671F1DC69BCF9CAF338F1EE9B00398C4F4E626AC32674BB3D3FA6184B49961F40FCDEBF651E827FA39499CC3CA450A2AD72F41A8C3CA576D33ADEC843BA5DCAFB4879DFEC';
wwv_flow_api.g_varchar2_table(421) := '712A4FC7F23AB17C7B61791674174C4F830E0210BAAC75D63955D6C243A886E571091C427F333C34F823009DAAC2D6CD1B6AE7DC2C80E3009E07F0067C0C60F8F7FEDEDF33F5AD7880DE070269E880EBFB766DFDE0334F1F3EF3BDD7DF7B7862ACB79108';
wwv_flow_api.g_varchar2_table(422) := '1D4700F97B80C781044B1674C139825F8D131C39906B5EE119CB110047206A86D1DC30C321DC38C3C111819ABCB25C985427DAF14B81253CF5B9AFE0E2072771EADD7401CE5A487CE9B2B8308F77DE7819C7DF7E033BF73C80C79FF90C9EFAD417B16DC7';
wwv_flow_api.g_varchar2_table(423) := '2E4C4C4CA1DBEBA3AA2AA93851F9C277FA7350AAF05E2A9DE3CA0B14F35759B954A68A65957108758BDFD26BECBFCB0191943FE463655B0C836E4BF737966306CA550E541386C381D769B846D71BCD745E2FD30D5E1AFD8C79927E8AB2253C38783D0FBA';
wwv_flow_api.g_varchar2_table(424) := 'DCE4055CC454D05E8107E6D58F8FF5D01CFEB9096FFD3F800F0416DD7FA085001AB9D44434373ED63FFF239F7DE2F4B75F3C3A33353EB66344A31E35B71225077816F5420C400B37C00C03824BC076D480B561AF980714C11A41EB180920140B42E224C0';
wwv_flow_api.g_varchar2_table(425) := '488708BDFE387EE4677E097FF2AF8738FDDE9BCD65B835D642E2320480E17080B3A74FE0ECE913F8A3DFF9573874F8311C3CF2040E3EFC18B6EDD809E7AA989F5B270BFCBCDE985703901041D6941484004D12E15FA7DB945E61780A8DF4F824594195E5';
wwv_flow_api.g_varchar2_table(426) := '000D7D01FBCEA93AD3ADD89525258B74008B188808636363D8B57B2FC6FAFDA8B39C0410F4B4A99C52CF1AEF23D5250C9AC243C04E8E23FFD9C44330930CD6531363C1FD9F01701A7EFB6F0E2DEE3FB00C01785DA425E7DC95671E3BF8FEFEBDDB2F5CBD';
wwv_flow_api.g_varchar2_table(427) := '36FB40B7DB1907A81386D650180325EFBC0765334204144726040AE5F24183149B164907180D8798DCB8093FFAB3FF21FEF0FFFCC73877EADD35E50934C2679F12084E1C7B0B278EBD85F189494C4C6E602E687823CB79D9F08A03FDF272798A65C8E9EA';
wwv_flow_api.g_varchar2_table(428) := 'F2BCA96A5F8EF28A789E65AA633F7287779992A213FCA363659D993F1247A7C26838C481070FE1EFFCB7FF1DF61F78104B4B8BA8AA4E23D9A4CBC200059D768A2CA261921E2BB827CC00EDED60C28EC4111A90348CD67808FD5E2F44FFE7E0D7FDEFC3BB';
wwv_flow_api.g_varchar2_table(429) := 'FEE6E93F9E96F1001C11D1B0AEE9FABE5DDBDEFFFC338FBCFFEBBFF7AD87B76DD9B87134A20A8E1C1F6CE8541446B4E069604172C1AA2308874F132BD730442E5CD64EAABA598234E586830126A636E2CB7FEEAFE16BBFF92BB878F66418D79A22029FD2';
wwv_flow_api.g_varchar2_table(430) := '3ADF55151C8085F9392CCCCF7DD41DFB58A67E7F2CDEC835C50612096B2B9F2C58BB9EC6FA1AB844CF802D2DC805E318F080F499918073405D13364C8DC56D7B78F0BF8F15B8FFC0F21E00008C8868AED3A92E7CFAC9874E7EF55B2F5F1A0E473B9D73FD';
wwv_flow_api.g_varchar2_table(431) := 'E0CD87F54870EDF940F257BE960F2490D64ABE4234DE905C23012EF24C26B8C8A2A91D38CFE69BB6ECC0CFFCD27F8917BFFE7FE3CD17BF8ED168E897043100B4B612D5756369999F7E2FD23DAE2A7A196B28555585BAAEFDEBA8B9502B042A9D5EBB071D';
wwv_flow_api.g_varchar2_table(432) := 'E4F1AFE4A9CA78175B36B8E04BE4B103A9EB0C606CF99C620640D571181FEB13FCDEFF250027E1BD80ECEE3F565A96009A53810322BAF2DC130F9D3AB86FE79937DF3B7D606A627CB226AAB2A0045BCB830D5AB83A5EAAAC1C220980054164ECA0E98FD1';
wwv_flow_api.g_varchar2_table(433) := '5EF414197B06728073188D86E88D4DE04B3FF917B179CB4EBCF4EDDFC7AD1B33CD9A70EDC406748A4768EF5985F7BEAAB546AF612FFEE28573B87CE5221E79FC0910CDB3B57CA36A1AE0B13C72A2B096B52C781D97164004F87278807318D535364E4CA2';
wwv_flow_api.g_varchar2_table(434) := 'D7EDF0E0DF2978F77FB09CF507DACF01C4E49C1BD535DDDCBC71F2F4173FF5E8C96EA7BA3AAAEB25477113CADC5F0D024D82F53FCAC32AF9DEA8DC92C9B770F4DE6D2AC7F64CA371F7C21E8D86A847233CF5B91FC58FFDDCDFC0E1273FDBF4A98E11EAF5';
wwv_flow_api.g_varchar2_table(435) := 'B49E422072CBD6ED989EDE82E170C0DC18B65DC8B61ACDCB74D9BE7EFC8DCA78489929162A1E2DA674806CC3D43839E796E0EFFB77123E0078132BB0FEC00A0900405D55D53C115DFCF99FF8E2F1DD3BB69E1D0E86B708AEE603E343665BB0E6292A04E3';
wwv_flow_api.g_varchar2_table(436) := '45AA0CCA83E6424E65C82847AC9CCF15FC8FD168887D071FC1577EEE3FC44FFCF9FF083BF6EC07A58C410DEEA14AADA7B598C6C7C7D1EF8FA1AE938192860BCB93004903679FFC637570C3D7F483549D41EF47A31A13E363981CEFD7F037FB380BBFFF7F';
wwv_flow_api.g_varchar2_table(437) := '11CB1CFEE169A51E0039870180AB1B374C9CF8991FFDEC899A6806A025DFBF9601410DA83468754ACB3E4F1D2BC9EA9002E4E5741E60381AC2550E8F3CFB03F8B37FE93FC5977EF22F60EF8347D87D051B17ADAAD6DC41A2F5746FD2AD5BB3989B9B63CF';
wwv_flow_api.g_varchar2_table(438) := '7334C0CBF2136C12D0BA272FE082A19F1A0FEAD87053A6AA2A6CDA3041CEB925F25B7F279ABFAB58A1FB0FACDC030080DA3937474467FFDD3FF3B9F7766D9F3E371AD5F3D4308DB8045531231F4814175F2E2C336898E59867B01CE9A8F6001F3D5D5A98';
wwv_flow_api.g_varchar2_table(439) := 'C3864D5BF1EC177F1C3FFE0B7F0B5FFE73BF84071F790663E393BE545D47578BFFADA78F7FF2D76084BB35D95EA8792975E1A4A3CC13FE89AD45EF42E2A1A0EB44181FEB61C3E4780D60DEF973FFEFC17B01CBEEFDF3B4620268186509CE5DD930397EFC';
wwv_flow_api.g_varchar2_table(440) := '177FFA074FCE2D2CCE54CE0D820B90BCFA3209841701D2C2A0C38F3276C01894C504966F8F849711863F1A0E50D735A6364EE3B14FFD207EE217FE267EE697FE0B7CFA87FF2CF63E7804BDFE785C73A58B351C9CABA287B04E0A1FBF3439B901131393F1';
wwv_flow_api.g_varchar2_table(441) := 'E6AD41F3CC7B2EB458F9F8CEB0F2E61581AC351D1F4BED3A6CD9344548077F4EC2BBFF57002CADD4FA032BDB06E46904A29B70EEF48F7EFEA963BFF507DF3972E6C2D5ADFD5EB747844E3A21852C121ADC6A1E115D4924949F9ECA4E0C421E7BD1DB9110';
wwv_flow_api.g_varchar2_table(442) := '9157348743F89E6CEA6F3DAA81BA46B7378EBD070EE3C0E127B030770B674FBC8D4BE74FE3D2D99398B97C1EB766AF63616ECEEF1C2831AF13C1DA4F91D01DBF4EA2D15E423CB1E79076B7F43676543F8507503A9508ADCBD90E41D3AEA8D3F76772BC8F';
wwv_flow_api.g_varchar2_table(443) := 'A9C6FAC39FF83B86DB0CFE8574BB0440CEB9C5BAAE2F6ED9BCE1D8CFFE992F9CFC9F7EE5B7F78DF57B934475056AE0CC079D0E3C861189414B8023493A42D497893F1504978E5B01E10C5259B8BECE74EA0AF1A831518DC1A0C66069099D4E070F3DF169';
wwv_flow_api.g_varchar2_table(444) := '1C7AF459CCDDBA8185F95BB876F91CAE5E3A87D91BD7307FEB3A6EDDB88E1BD7AE60FED64D1F315E4F6B3A058BBFB4B804AA99D5E560F4DFA6EB5EC267927BF7524F1BDD05900E30A70373969E0A231AF04084AD5B3612FC2DBEAFC35BFF63F0C1BFECC1';
wwv_flow_api.g_varchar2_table(445) := '1FCBA5DB228070321070D79D73277FE8B34FBCFB7B5FFFDEC3EF9D3A3F3D313ED625AA3B72DF53ED99320B1CC4908332918438451859372781B8FF1F0408767680F804C0102E225B0712F0E76B2A101116E66EC1550E63135398D8B0095BB7EFC6A1479F';
wwv_flow_api.g_varchar2_table(446) := '05518DE160094B8B0B58989BC5606911C3C112A81EE1C6F5AB180D97E05C274D373B9A2AAF868C5FB29D48F63B3B0E1BFA966835D4E1F2FA13878A0B5D60E50DB236FB92AE1910D7192018347E359CEEAF6A0BE93CBEC8E5626EFE83AC5B8C415F8790FA';
wwv_flow_api.g_varchar2_table(447) := '25AF5FE0EDCA727C5CBCF5AA72188D4698DEB2159BA7B760381C2670AAC36AFAA86E50D634470609C0974987DAD489586ED0203DE81111366D98C4E4F818B7FEEFC293C08A4EFEE974278FD3A1AA720BC3D1E8C2EE1DD3EFFCD8179F79F4BD53E7771368';
wwv_flow_api.g_varchar2_table(448) := '024015CFE5715653EE910B6B7A975C7162EE91758A4A023C9EFBC98F5096DC317EC18675B4985DE91527C3C1AFF5D1DC9DA71EB1606085FED804C6C627B169CB7654F17B06A2A0842E29A4BCE0455D9566E41117E984720C8C15070FBF48C721BEB7AED8';
wwv_flow_api.g_varchar2_table(449) := '2B5F4917DEEB3A649F60F68D13978BFD72FC73C07F90577C2F419BDA2B5CD1A72F488AFDD2570F1A658B753424D0B8A2A3D108A3D128029A5B79584B5266E533834786B162275BE50545F95583813AB66C9E0A37EBB9061FF57F07FEE45FF1B65FF79400';
wwv_flow_api.g_varchar2_table(450) := '8217E09F1A4427FEEC8F7CFA9D3FF8E64B874E9DB9343D3ED6EF12A893AE5C086B74E6FAC3BAAA8A596776CA2FBA5BE17864BA62289AD5146E692301D51E183B33D2B1AEF48A24C4DBA330C97E9A5C5DA356CAAF0166834C29BAA99CC93A718209F5D6D9';
wwv_flow_api.g_varchar2_table(451) := '156E791EEB2A387E79AE050E0DB4948759756B0C2689D8C466B6CB09D23954C28B0879C27B29979CD42205A972B2BD6C7C4AD6216F8C6D45AD96D7BD14BDDE7842B5A9CDD0531B0FA1BD0AC3D108D31BA7B4F57FA721816BB803EB0FDCDE36204FB5736E';
wwv_flow_api.g_varchar2_table(452) := '9E08E7B76DD9F8F64FFFE8678F3BE7666AAA8729684F220A1FA3A8C54828DB5A691A092578749544D56CE7409463F5B3FD3F33F22A361BE57983B6ED9E58C2B10B985235A95DB1EFCB7730C4CF424EAA837243534D315979E4AF461EB98B524A561ED202';
wwv_flow_api.g_varchar2_table(453) := '40F6B101449E835F8025A3DD5C06861C4372210F5F54306132418AE69D9C735994544DB9ACB3FB0AEAAD6DBE1B05A62FC4F4C5D085B84B90E181A4ACC85F9BB079D31455553524C20C7CD4FF6D782258F1C11F9DEE88001AA6195695BB4644C77FE127BF';
wwv_flow_api.g_varchar2_table(454) := 'F8D6538F1E38BBB4349C8343CD95DB3CD0C3C55D220186667ED10E3F4D254840B52750A6DBE7ED65C0A63819BC4F6DE71BE2FC424EB8B5DDC3498AAB5CBB8221294BD425238F3C05956FB78A720CE0428E85EDD69671F12D2A52635259CC7983FA9CCD7F';
wwv_flow_api.g_varchar2_table(455) := '769644CA8C1B083D2E4D7EFCB49D20613D3E2D373108D647DE9ED450D127DB0091305CA98C94C3685463D386096C9A9AA88968CE399C05F0163C095CC31D5A7FE0CE3D00A0B96720E0CEF57ADDB77EF9AFFCD963FD7EF72A110D88696569D01270360968';
wwv_flow_api.g_varchar2_table(456) := '70CA727232A547A0CE1728FB4B563B8AAD33CF00BC2FAC0CE4F8C41126B2DBD30A182D08989C02E771A2616DC7BAA0C65B24538B5497210161B172B9325EB6DB435EA72D030370948F4B030E50ED408F4B131E37C7723E2D39CAEF541F5B4847E8BAA1A7';
wwv_flow_api.g_varchar2_table(457) := 'D6FE7FC99BA86B42BFD7C5AE6DD3E49C1B38E7AEC247FDDF823F0074C7D61FB80B02681867E01CAE11D1F1278F1C38FA977EE6874FDF9A5B9CED743A75B258B9854B83B601604D90646B0D7025F44C790C853714BB7C13CB54FF8A48402859AA8078478D';
wwv_flow_api.g_varchar2_table(458) := '3E714B95942757B60C4C2AFF725657032194CE94578D4FD18151AE44729A0C529E22E0D00E38D90ECCF189651813A62437353E93040C390A99F33EE5062FFE66E041786B86C74720ECDCBE39DCF063167EBFFF2892F55FF1B15F2BDDEDD333083EFA780E';
wwv_flow_api.g_varchar2_table(459) := 'C0D13FFF533FF0F61347F65FBA393BB7D8A95C9D26381F74CE9E8893D5369951E1F8E4509CDDA4946232EF6C4D26F264563E09A074A557E6BD709022EF132F67033607B3FE6E39C0A1458E3951CB98482E4755175A6490013B346A59F99C4834E0E4B88C';
wwv_flow_api.g_varchar2_table(460) := '3E67444A99852EC79F581F854EDAA42349D95EF649C263E3107A1AFAE0CBD6A31A1B27C7B175F3A670AFFF4BF0EBFEA30DE6EE28F2CFD35D1140880538E7AED7757D7C7AD3D41BBFF4B35F3E3931DEBF311CD523278C4D029BC59E11108690AD15995414';
wwv_flow_api.g_varchar2_table(461) := '2465D696D15A3716262A952BE5D16CCDC00B99071A00A21C84626BB7955B13AED05CA54DB75E5B54011E59974D024A31B3722C8F4502A92B7CF25A002EEBE4632B792F198131B97299490B2E3D3E3D8F7CFEB9016A275369104CA2D2C46218BC12E9F80B';
wwv_flow_api.g_varchar2_table(462) := '7E1CF6ECDC4ACE61047F7FFF93F077FA3D8E3BDCF7D7E95E3C3F8B002C3A575D1C8DEAA33FFCB927DEFCCA179E3E37BFB0381F45CF8DA9068066EBC2A4EA804F9B9073F7982906D4849500DE3299B13ED3CA27A15880935E05CF934A5A0A9DBB88053754';
wwv_flow_api.g_varchar2_table(463) := 'E731DA13A0B448C0B068B25CFB9249923D997D32AD2E53E5DCCAF33E902D03E5CD9824A05DFFF89D1A9F459490FA247592984E30790A6A93322B929CF3D67FE7B6CD98F437FB9C87B7F86FC25BFF3B3AF567A5BB2680868146CEE16655B9539DAA7AFDAF';
wwv_flow_api.g_varchar2_table(464) := 'FDFC57DEDDBB6BDBCC60341C4451F0014697597E974F4D3BE0326637D93A2964065896D706B8ED1EF3BE95AC7CAC43584FABBDA40419B941D693015CD4CBC6AF0007D59EB638A95C92ABB0D88AA8B914CAE4D6DE9E1E7B3BC099AC291F17C9CA647B1971';
wwv_flow_api.g_varchar2_table(465) := 'E6C495FA6991406A4FEB69EC975937AB437963191E840C80E1A8C6D4E438B66FDD444817FCBC0BE075F83BFEDCF498BB3BEB0FDC1B0F205E29E89CBB4C446FEFDFB3FDF5BFFE0B5F797F3018F9C789257214CA94B9FA065B6BEB6B4F9461F50C2B2F4141';
wwv_flow_api.g_varchar2_table(466) := '99B294027ADACA333E11E3B12D5CC843B28CD95EC10A21B5A7812A154C5954A198B91C85D5E54C62C8A04494B243AC9D65DA4BFBDD107934A198E73BC43CDA72CC2D3665F32841582039D3A342DE1E9FD764DD8A56DE3256807FC26FC739ECD9B9857ADD';
wwv_flow_api.g_varchar2_table(467) := 'EE888866E16FF2F93AFCFAFF326EF38ABFB6742F1FA15B039873CE7D4084D77EFACB9F39FAF9678F5C985F585AF4C7F32957CE90845523A98B4C436DC059E57277329F4C0E7036A94C93ADF610CB298083E7598195174B2156C7721644909CA8DCB6A842';
wwv_flow_api.g_varchar2_table(468) := '72864292AC53032EA8AA45A6E26096506929F3AC4FC2599014B7122B9FB9FAAA1DDD5EA60B055096484EEED5E7849B74428FCF2639E871B1B9A79AB065F3066CDE3845042C3AE72EC0BBFDAFC13FECE3B6AEF75F2EDD330208DB820066003AE69C7BE53F';
wwv_flow_api.g_varchar2_table(469) := 'FBAB3FFDDEF4A6A999E170E4B72A5AACBCB0584AC95BB77B201545E6B1264ABBC94A093408C4A4961425666CFA232715ACBDD279038B48043159CA1ADB63B2D416558349032E0CA000384D98D978299F370900E65718569EBBD5C9A9C8AD7C9BD5CDDA6B';
wwv_flow_api.g_varchar2_table(470) := '011C2CD959BAA53D1DEE9964E502D08D2521547B7A69C188B8267FA38F07F66C270003E75DFFF700BC02BFF73F83BBDCF6D3E95E7A0061AE179C73E7EBBA7EE3A1FDBB5FFDAFFFE6CF9D26C2ADBAAEEB9C04F289926E9156680D7036DB99C5D175179467';
wwv_flow_api.g_varchar2_table(471) := '85ED192BD88C0484FBDB7CA96DB004784216A97151D637C313D0CB1A28800B90B510A5D1278B28051261E7C949204D86905BD6BF65AC2E089665866E4FC8BB40B8C4FB6C919574F5B9275622D3DCCB2BC8518C28B55193BF08E9A103BBA8D7ED84FBFC9D';
wwv_flow_api.g_varchar2_table(472) := '06F02A7CE4FF3CEEC1B69F4EF79400424010C0ACABAA5344F4CA57BEF8F49BFFFECFFEC88585C5C102714D3001C7BFB32C9D65E5C1269829B398544D1EC8AD5E463E3000AE5DCF9558F9829B695841E9C64BA2CA2D96ADC8DC9466A450240149729A9820';
wwv_flow_api.g_varchar2_table(473) := '6460CC1B9B1F4BAE26E928F2121E8072E325C0972101527261FD2A93805EC241C841E431C8D49A23413AAC4F99AEC7FC84037B7760C3E404C103FD027CD4FF15F8C0DF2CEE51E08FA77BED01A480A0BF3DD1DB754D2FFFD2CF7EF9D80F7EF6F19985C5C1';
wwv_flow_api.g_varchar2_table(474) := '00E11E8B26E0F8DAB665A292AF58041C772793A7910AC972A5C934DA33AC7C52183DA9098F6D4B985426290CD87BADC0D0E594D25B2EAC152329053D43CDC2265ACA6B11A592399F47FBCC056225B95B1D2AE773A4DB32C8C6F02A4C22653AC4DD126B8E';
wwv_flow_api.g_varchar2_table(475) := '2401CBF6D4E4A6AA0CE2B6747D38AAB16BFB34766E9B26A218F53F06E065F8C0DF6DDFEA6BA5E99E13409A76CC3BE7CE3987D72627C65EFEAFFFE6CF9DDCB363CBCDA5A5E128DCF4C48CD6F20913932901270824280C67DD6065D4A4F2D6CC7294934E98';
wwv_flow_api.g_varchar2_table(476) := 'D58C84C4646A0BC7816003C002B858CF97F26484C2159A83D9B096510A6CFCEAD5243C21B78257238839A390729FF4BC313532893A0C532FD1583D567BB6F7220D429CFB36A2046FA78570557B91AE188CFD65BE93D8BF673BC1F9ED74F8033F2FC307FE';
wwv_flow_api.g_varchar2_table(477) := 'C279FF7B0E7EE03E11005B0ADC70CE9D20A297766EDBFCDADFF9E53F7FAED7EBCE8F4675EDF8841B802BEDAF0252215AD7B1B89DC9B44947F445934EC90AB28E5B4495B597B9F1D2C26B79C4CF86428B5E2A8BA36527640B5E790EAAE25A5A8D578E4BCD';
wwv_flow_api.g_varchar2_table(478) := '0507B49A6B69E5D592C0985B8B544DD2819401F7E0C0C682F851AFEB6DBDC9FDD87612E0C4154A8DEA1AE3633D3C74600FBADD4E0D8A077E5E03F012FCB5FE37701F5CFF90EE9707C07705AE3AE7DEA989BEFFA9271E7AEB97FFCA4F5D5E5C1AA4486601';
wwv_flow_api.g_varchar2_table(479) := '70693AD8446A65D75E84984C35A9CBB1352FC318DB72D932EBC7F2A67EE50A8DE2ABCC2FDB2B2C8B0A790498D4D8733017889265B6AC2E27814CCE7A7C5C26FCB758B240DED6F284B7C5899F13AF352E45A4B06460191C35D779ACA74094B19C25EB244C';
wwv_flow_api.g_varchar2_table(480) := 'E71C1EDEBF1B93E37D22C2C0395C86BFCAEFFBF037FBB8AD7BFCDF49BA6F04C0E67801C03907BC56D7F4BD9FFD339F3FF6EFFED8E7AFCDCE2D0C5CE5B867CE94D0526E6D5161E6B501974F4E6B50101C38ED563E294128C514955BCC9287A309A4857484';
wwv_flow_api.g_varchar2_table(481) := 'F58B02D604985B6B642D19802BB507D5AE32CD669FD9E4EB2513974726478B04B4952712E310F5331DD24B02B9ABA0622E05BD09DB7B42A12D12B788D298A33815CEAFFB0FECD98EADD31B09CD55B5F0EBFEEF21B9FEF73CEAAFD37D2500B12BE0DC2900';
wwv_flow_api.g_varchar2_table(482) := 'DFEF763BDFFF8FFFF24F9E7CEA910337E7E617479573C299B20090312DF1DC6952DB2693AFB1C33C44855200E08A98597924C54CEDF1095EDED56F2539F0CF39E9E44B26D94FCB5A8B711A75B52D6588C92D930193457E068181B44024F941190D1BD647';
wwv_flow_api.g_varchar2_table(483) := 'D127CBCAC72991F52BAB0B28F9331926429379B37EC2D02D4B6F329223C00183C1083BB76DC6FE3D3B8808E1C19E27E12DFFF7711FA3FE3ADD6F0F802F05AE57953B468417B76EDEF0F2DFF9E53F7F66CF8E2D73F38B4B75B81F600E3CA640027085892A';
wwv_flow_api.g_varchar2_table(484) := 'B13E5714F905542B0ACC5201457BB0EA669A0CCBCAC7464C2B2F8164034E2B181F06B757040DD4D46E16AB806A4FE7118497DACD630E3691484F43792C611C06E9C4F620655FB2F219E090F2E4E3D273C4FC02CA6527889A74B9D4D9B61885730E83E108';
wwv_flow_api.g_varchar2_table(485) := 'D39BA770E4E05E3887DA39CCC13FD5F765002FC27B01D7719F5DFF90EE3B0100696B10C0E5AA7247EB9A5E3CF4C0AE37FEDBFFFC2F5E98DE34B5B0B834A8ABAACA59944DBA045CB23A723295C2C40956D642595D3151A2DC72ED298067E0CAADBCB6A429';
wwv_flow_api.g_varchar2_table(486) := '8F61D115E04CAB6FAC69C5FA93B564AF6739992A8B2D00CCDB487D113242AA1F4C66991C35B901797B052BCF7A675A5D7B696178067A1E39092BBDB3E631EA9B417296AC1D1C06C321364E4DE0F1871F40AFDBA989E27EFF1BF0E03F8A7B7CD67FB9F4A1';
wwv_flow_api.g_varchar2_table(487) := '104093C2DD4CCF56957B95885E78FAD1836FFFDDFFF22F5FDDB46172B0B838A08E26011370DC5A33A5A4F244496B9F5BAA92622837A4DC27617198ED3148405879B12E659FA342136BDB208EF0C7014F5AA11950E4503252E4006F0BC496BD2CB994A16C';
wwv_flow_api.g_varchar2_table(488) := 'BC563965DD19F16B1228019C0F28CF130A221F879EEBAC3D5E4E8E4F7892CA6391B226EFF68F46989A18C39347F663622C06FDAEC2EFF3BF007FE2EF2CEEF2165FB79B3E3402E0F10000A79C73DF23A2E73FFDE4C3EFFE37BFFC1766FAFDDE60616989AA';
wwv_flow_api.g_varchar2_table(489) := 'CA6560E113C5DDB1F0AF9E4CD3EA2AC0116C65D2EBC37C0F5C014EB517AD17F152ECB7F856F6C9F426905B7422DE8754A1B6A23CAF0653EA8B010C463A45A254E5E552447B54E955025E93474EA6BA3D1BE079BC81B41CD8B832C2E3650CB990353E2499';
wwv_flow_api.g_varchar2_table(490) := '14E3014C8EA3618D89F13E9E3C72005313E3041FF49B81BFC4F779F8C0DF87B6EEE7E9C3F400E21D84E0D738EFC1B9E74775FDC2973EFDD8F1FFC77FFA8BD727C6FAC3A5A5812781383565AB9BB135A2CCA1D0969300B14967E532EB09AE3CAC2E550E56';
wwv_flow_api.g_varchar2_table(491) := '1E01702845E17974DBAC76615999421253400E2608155556579287F00C58BBBABD62C49EB716BD0FAB9C04239F250E6C2D7F4EF41929A8655F7179C2CAE6BB23797B3909146222BC76C39B09BF8EEA1AFD5E0F4F1E3E804D1B268928EAFF7178CBFF3CFC';
wwv_flow_api.g_varchar2_table(492) := '053FF7E40E3FB79B3E540200D4F900E0ED4E557D7734AA5FFCF2E79F3CF9B7FFFD7FE766557586C3E188D203456C1228B988108A6107F432B6D65A21CA154820BE579E48A1BDD077691791BED70A998D4F978D2E02EB534E2EA214CB632F7D58BD2D8083';
wwv_flow_api.g_varchar2_table(493) := '90019311D238E31C08305BE46DADAD49D5A13D3869E5F3394A8D8BFA61B56BB497CD52921D1F57366F29371C3CF87BDD0E9E78643FB66C9E22221AB2937E2F02F82EFC12E0BEEFF797D2874E0000E09C0B3739BC0CE0CD4EA7FA2E11BDF4B33FFEF9D3FF';
wwv_flow_api.g_varchar2_table(494) := 'C57FF0D3B76AA2D1A8268A4F6055241084CC2D6491ADC1C123ADAEB45CC6FA2EFE8B4C79A4B593D62859453BAF6981856BA9AC6A067066A9B37608BCE3963B0E056652E5B891B301A741C6FA64B9FE82588C712990EA7E6B6F495AD9728C22E62FC85C92';
wwv_flow_api.g_varchar2_table(495) := '8E06B81A2BAF5FC8C2AEA32642A77278FCE1FDD8B1651311D1C83917AEF07B091EFC6F3618586C30F1A1A78F8400804802E11147AF3AE7BE43C0CBFFDE4F7CF1CCDFFAC51F9F1B0E47754D757A5A2A9BD4FCF8278A4030F7A9C13549E6B52DA354C4AC1D';
wwv_flow_api.g_varchar2_table(496) := '2AD481D49EB596875197241C7B5C117CC8CBC0E8B71E8B042A938801E66CE9024D42ECB782B7245AE1644E727CDACA43D46D95CB49DB8A1958735B2410E1EADBEDC97995ED73B93F71F80076EFD802F24FD2E2DB7DDF810FFA9D87BF66E623013F70670F';
wwv_flow_api.g_varchar2_table(497) := '07BD97295CF77C06400F44FD9AA8F7577FEE473BA351BDEF57FFD51F4D76BBE874AA0A8496C72E83E2B302813095FC796DF9B3D7FDDBE63392DBE695473EF83116E0CF2D64CF79455326F529B4E3BF0F0F8024D69E571AF6FC44E381A8E11985FEF985F2';
wwv_flow_api.g_varchar2_table(498) := 'C1AA30C7E55F83B2CAB123F60F4485075422FEE6D86B7C381F11C2939D111E7C49E937F134E7A66E3E5FE1418CF1C9CD006B07EC197961FA9A3AFDECA7E7F0413FA13725F19469F0B2C8E79FC99A98CC435F851E3139A539627D0E8F2DAB7DA9278FECC7';
wwv_flow_api.g_varchar2_table(499) := 'DE5D5B418451B3D77F16FED2DE3F852781338DEE7F64E0073E6202681E341A7606DE77FE79DABD515DF7FEDACF7FA5EA75BB7BFFC9AF7F7562301C767ABD6E9A40E424E0139F285AD16397295302644F7F759C1E421E286006A551A014CF7867EDA59766';
wwv_flow_api.g_varchar2_table(500) := '4C24492003AF4B0F55B701AEDB6379C0082B658B79027944304382070238C400C464D48C25515A0EB8FC69BA895C5D7AA6B62A57A843CF51003E9064A0E736AA899EC7F4387552F2084F950EA493EB0D227BFA357F174F1ED98F07766F47E3F6F30B7CFE';
wwv_flow_api.g_varchar2_table(501) := '143EE2FF3E3E8288BF89C18FB2F190C86B4517C066000F13D10F00F821E7DCB35FFDD62BBBFFA75FF9ED89B9F985CEE4F8184635998F7F2E3D0E1A2E3CEE593E1D963F9DD67AEC742A973F6D973F9E5BD6E5BF5B497B298FF184DBA6AC6BCB633CE5B7D4';
wwv_flow_api.g_varchar2_table(502) := 'A7D2E3B1F34780A7DFC4537D0B4FF235FB94C9483F7537946FA9A3F8A4E3D0465B7BCEAF6BB3A735E77284210FD927631E2391B0CFCE6134AA31393186671E3B889DDB3673F09F87B7FCDF8427808F2CE26FA58F7A0900207A0243F84B1F4F38E7AAC6A9';
wwv_flow_api.g_varchar2_table(503) := 'AF7EE2079FC5F4C6C9DDFFEF7FF47F4E5CBC7CAD3335398E511DAC6FE30A877A82D537D83A3DBF1DCCA2BA6C69E184954F16473EBE9CB9C9CAEA06AB229E17AF1E431E1E7BCE3D1361C15BACBC7CEC39BC27018A8F9F4E6EB9CE83E8320BABC6974DC2EB';
wwv_flow_api.g_varchar2_table(504) := '41F33D44DFB55B1D963FED1E15625BA17D3FBC0670991CD963DDA3FB8EF83B8096F6F42B5B1232996B2B0FAE03310FB279F4CB3508192C0D86D8BA79039E7BE210366F284B729000001485494441549CD2E07F0DC0B7E0837E271A1D5F15E04794CA2A49';
wwv_flow_api.g_varchar2_table(505) := '8D27D003300DE030802F12D10F39E79E3E76EADCEEFFE73FFC9713C73FB8D0999C18030512604C0C280BD38C30E549BF85BCF9B3ED6DAB8B16EBB0FCB3EEB5054763A1649D324FC1CAB7584A218350BF2ED366D52C0B677846B9C715EACF656E794B252F';
wwv_flow_api.g_varchar2_table(506) := '042E9F376DC1E56F2BB7F26DDE4B79AC469DACBDCA392C0D87D8BD632B3EFDC4214C8C8F01FEB01B07FF37E1837EC7700F9EE577AFD3AA2200C024812FD475FD4355553D75FEF2B53DFFAFFFF5D7275F7AF3443539DE8F66AA9504F472C10082702FB112';
wwv_flow_api.g_varchar2_table(507) := '122801C70617AFAB52CB134BC15C214F89746C1250DF7319A87ADA815A70EB9775AB99EB5F5A669488522D43ECF67212A89699B732092C435C5A064DBEE16884037B77E0D9C70FA1DFEB1251BCB8E71CFC7DFCBF096FF95725F89B21AFBEA448E061009F';
wwv_flow_api.g_varchar2_table(508) := '1FD5F50F76AAEAE99BB7E6F7FC7FFEF16F4EFDC9775FEF8C8FF55CA7AA5037AEB165D16D8BA5F3B45B5DD3BA676BD05CE14BED6500E765717B56BEE216B42083529F245021957E19122801B81560669E166F0972BCCB1173CADF1E5F68077822968A7B67';
wwv_flow_api.g_varchar2_table(509) := 'CDF755B3E424221C7E700F9E7AE400AAAAE2FBFC21E0F72DA4537ED7B00AC1DF0C777526450287007CAEAEE907AACA3D5BD7F5BE7FF86BBFBBE137FECDB73BBD6ED7F57B5DD4756DB375334ACBCA47E509795B15050DD824708A046301CECCE30AD6CBB0';
wwv_flow_api.g_varchar2_table(510) := '880609E871594B0BB34F6DA4D6E4A9585E309995963CD0722DC85193DDF2C4B53C0914E70DC1EB2A5B79D32088B1F8F755E5301C35A7FB0E1FC02387F636AA8A91739885DFDA7B053ED8F702FC9AFF1A5629F81B71ACDEC44860133C097C9A887EC039F7';
wwv_flow_api.g_varchar2_table(511) := '1C80FDFFF277BFB9F157FFD51F75E71796DCD4E41846A33209E491F0DCADCE960999FBE9459645B0593BA5F64CAB5700D2F2005F89576158EA8C006D100A6B1DDA5CA9CB0C6B99D34294A5F697F19632ABDF4202A65768CC631A9FCFC43D80AA72581A8C';
wwv_flow_api.g_varchar2_table(512) := 'B0716A024F3FFA200EECDD01F818E910FE861EA7E1F7F7FF14FEA61E21E0B76AC1DF88627527B645B809C00100CF11E10700FA9473EEC1EFBFF1DEE6FFE5D77EAFF7F6F1336EC3D4781C9454DCD25A7005403094289533EA8054C8924B1CDACB94B3E056';
wwv_flow_api.g_varchar2_table(513) := '9748807B3139E918E3C20AF22CB3F4B12C7A91280B798A44095E7781048CF64A4B26B31D738E6C99873A86C311F6EDDA8A671E3B84E94D53E128C1007E4BEF14FCF1DE70C8E77DACB2687F29AD7A020004096C00B00FC03300BE301AD59FED74AA872E5D';
wwv_flow_api.g_varchar2_table(514) := 'BD31FD6BBFF5C7FDDFFAEA77AB7EBF876EA78370462F7349B5C5B6AC6E70515BACAE5577729B57E226AFCCCA73225B91052F025CB7678DAB454E7A4D2CFA57684F03AC31E1C27217E4287E57F595082CD6DFD2A7760F4C7A54CE01A39AD0E95478F28877';
wwv_flow_api.g_varchar2_table(515) := 'F97BDD2E88A876CE2DC1BBF7C7912EEC79157E19308B3500FE20DB35911A12E8009804B007C013F024F0B94EA73A52D7B4ED0FBEF9D2D8FFF75F7CB5BA72EDA69B18EB032EEDB3B70120075C8104B4A581AD54CE412A6B8B3711DB3348A062D6DD6ADFB6';
wwv_flow_api.g_varchar2_table(516) := 'E0CC921648A072F6D8A37C5AFA6D5A4B21B315784B68CB5372DFCBA4DA1614E432913270C539AA9C03C83FAB6FD3C6497CF6A9C3D8BD634BA386543BE716E11FD6F12EFC5A3F5CD8730EFEE19D1FF909BF95A63543004024810AC00480ED001E05F0F99A';
wwv_flow_api.g_varchar2_table(517) := 'E8F395738F02D875F2CCC5C9FFF5D77EB7F3DD57DE7113E363E85415EABACE03410A706650103048A045E1557D797BB2DE8C846EC3CADB00F0DFB5037C993E59DE8A99A7054CAA3DB072D95ABE0DD81938D9BC699928CF43EC8EF0796363B2E2269573A8';
wwv_flow_api.g_varchar2_table(518) := '9B43400FEDDF854F3DF110C6C7FA80772947F000BF007F19EFF3CD5F786CF73CFC853F6B02FC8D48D75E22A20AC01880ADF0DB849F01F039227AD239B76F6930DCF86BBFFD27BD5FFFBD6FB9C5A52126C7FBA86B5A667D6901C0D98A9AAD750B0A2FDA93';
wwv_flow_api.g_varchar2_table(519) := 'A42323EC6EC5005FC9F2C426AEA6AC6857B9BC569F58B9652DFA0ADC6A93280C52CD3DAA32519648F5F602A34D947F38F2477A1F3F84470EEE6DF42DAEF76FC2BBF86FC05BFEEFC16FF35DC5477849EFDDA43549004024811EFCF5030FC2C7053E4744CF';
wwv_flow_api.g_varchar2_table(520) := '3AE70E02D8FC9D97DF1EFB47FFC71FB8774F9E751BA7261A054E1797802976697DCE5D527EC69C2B55C86B910020B7F84C0B7B9B56BE8D04E4E7F05EB727DB3101AB5CE9E21A3C03F3CA0127DA358832F667A524A0DB6BED534E6683C1080FECD986CF3C';
wwv_flow_api.g_varchar2_table(521) := '7518DBA63702E98AEC45F860DF49F86DBE700FBF534877F05D73E06FC4BD76130B0E6E848F0B3C0EE0B344F4E99AE870A7AAB65F9EB931F1CF7FFBEB9D7FF3F5EFB9C160887EBF8770DFC17600D86E66C9EA86BC2B3E88D2D29EA9F028B46F59F902008A';
wwv_flow_api.g_varchar2_table(522) := 'E353E4C6FB7D3724B092B5BC9DB720472899587DC9E6ADBC64F377A226D4758DB1B11E9E3AF2201E7BF801F4FD95A7E49C0BC77A2FC39FE6FB3ED2DD7BCFC17B046B22D8574A6B9A0000111C0C7181C3003E0DE033755D3F5A55D55E001B5F397AB2F72B';
wwv_flow_api.g_varchar2_table(523) := 'FFEA0FABB7DEFB00C3D1085313E3CD5A8FA0AD430E38B4E689BFC3064E495913E034C1DC8E95D775B6B8D16D5E85B564417BBF570270BD96E7EDA1341E438EE9BBDBF196645D41D655E5EB190C87E8F77AD8BB6B2B3EFBD4614C6F9A0A3A553BE782CB7F';
wwv_flow_api.g_varchar2_table(524) := '167E8DFF3D78023886B4DE5F33C1BE525AF30400441270F07181CD000E02780AFEE0D0D3CD92600B80F1DFFCEA77AADFF9DA8BEEBDF7CF6362AC8F5EAF83515D9B56575E56DA1E3C5B996534D6BA05609748C08A1D94BD0AFF9D15143449CEFA8D791376';
wwv_flow_api.g_varchar2_table(525) := '9EB22724C8AD4002998CD4ABB3C66B2D87806548C0BFEF541586A31A755D63F7F62D78FAB18338F4C0CEA84AF037E858807F44F749F863BDDF873FDB7F12DEE55F04406B1DFCCD947E7C123B39B8017E49F008804F01788E880E03D8E59CDB70E9CAF5EE';
wwv_flow_api.g_varchar2_table(526) := '6FFDE177ABDFF9E3177163761E5313634877AC512E2F5AAC9152DE762B6B033C6B2F2835CB5BB686B21D0EB894A70CDE9CE40AC4648EBDDDA25B013F4D3AC53C567F34D9ADD05BE2B272CE61696988CD9BA6F0E491FD78FCE1FDC1DD47B3861FC2EFE15F';
wwv_flow_api.g_varchar2_table(527) := '80B7F42FC31FF07907DEE59FC52A3FD977BBE96345008058128CC3EF121C02F03480E7003C311AD5073A9D6A1AC0D8DB27CE74FEE5EF7ED3FDDBEFBE816EB7836EA7838A2916B03297340871252400B45DB566B8F42BB0F2A5E54919E06522E14B97D6FD';
wwv_flow_api.g_varchar2_table(528) := '756359E3C726DB373D21B34E45066DA4B4EC722C7CE79A788FBFEB6F55393CFEF0013C79643FB66CDE10F425ACF517E10FF6BC0FBFA7FF32BCF53F011FE55FC0C7C0E5D7E963470021B15D824DF0DEC0A3009E05F04C4DF430805D95731B9606C3DE8BAF';
wwv_flow_api.g_varchar2_table(529) := '1D73FFF437FFD81D3F7D1E0E0E63FD2EC2558640BBD216AD11CA2EA9051C6B6B0DCB011C289C6F80008574E3F5F7EDC45522B7120968C0F33C2B59CB5B2490F228A2842193264FA709F08DEA1A95ABB07BC7343EFFCC23D8B3732B9C036A227270617B2F';
wwv_flow_api.g_varchar2_table(530) := '58FDF7E0A3FBAFC0AFFBCF219DE75F9351FEE5D2C79600802C40B80D7EBBF049F82DC327EA9A0E5495DB0260626E61B1FB5B5FFDAEFBB7DF7D0DA7CF5DC1E2D20061EBB00EB7212B28AB8E1D3801EC506619EB6981C4CA5B5CC3DF9E95AFC4E71C946D96';
wwv_flow_api.g_varchar2_table(531) := '78252E7B3A1C058304F2B57CF65D314F99049C6B2C3E80C1C007F8B66DD988278F1CC0630F3F103DAFC6EA0FE10379334856FF55F83DFE53F027FD3E1681BEB6F4B126004004087BF0DB85BBE1770A9E860F141E2660AFF39E427F6E61B1F3D56FBEECBE';
wwv_flow_api.g_varchar2_table(532) := 'F9E251BCF6F6498C4635364C4D84BA1800CA2EEA8A2D632CD706F036F7D8B6F279F0ACC5E5D675B5F689910BEC3C2580E7318A96809E9051BE84B2964C95AB5039607E7180B17E0FFBF76CC7E107F7E091437B9B6B43FC14C29FE65B82B7EC67E1D7FAAF';
wwv_flow_api.g_varchar2_table(533) := 'C3BBFBC7E0EFE47313FEE1351F8B405F5BFAD81340482A36300D603FFCB2E029F8EB0A0ED635EDA82AB701406F7E61A9FACECB6FBB3FF9EEEBF8CECBEFA002616CAC6FBACACD3BA1BC6D6B7970C56F015C6E9173577FD9E5C932563E232E60198097972C';
wwv_flow_api.g_varchar2_table(534) := '2B3E3B6100BC354F8BB7143E0F872374BB1D3C72701F8E1CDA8B07F7EE40A75385B9A7C6850FEEFE25F888FE9BF0E07F1BFE72DE6BF898AEF54BE91343002135B1812E8029F8730307E00F103D05E051227A6054D3B66EA79A04D09B5B5872EF1CFFC0FD';
wwv_flow_api.g_varchar2_table(535) := 'CE1FBF88EFBCFC0EEA2698D4EB7651B9F490082028F20A027A9645F33F1BAE6F09E0E1B796A0E00A019E11976E0F58A64F56DB72BCF78A049C035C55F98B756A2FFD5EAF8B470EEDC3338F3E889DDBA65135972DD6355155C547D1CDC1BBF51FC003FE75';
wwv_flow_api.g_varchar2_table(536) := 'F8033DEFC3EFEBDF823FD4F3B15CEB97D2278E00007151511F7ECB7017FC6EC113F064709888F6D6445B3A553501A0371AD5EED4D94BEED77FF75B78E5AD13B87EE31646356162BC876EB70BFE149A3C78D6B2D66D5EC5053568075C1E55CFAD7C697972';
wwv_flow_api.g_varchar2_table(537) := '6F48C7EA138AD63ABB3007C0B2DE92FA3E1CDEA9EB1AC3D108DD4E071B26C7F1D081DDF8F45387B165D354EC535D13B9CA91F3C00FEBFCE0EE1F85B7FC27E0037FB3F04B82357511CFBD4A9F480208892D0BC201A23D001E02F058F3F71011ED01B0D939';
wwv_flow_api.g_varchar2_table(538) := '3701EF395427CF5C74BFFFF59770F4BDD3387B710633D76E627CAC8F89F1BE5752AA11A17C5BEE71786F5BE4F0DA66E5CB002F04CF560CF0B01428BBE136C00B4141D1BE4D9455E5D7F600B0341861548FB079C324B66DD98407766FC3734F3C848D4D7C';
wwv_flow_api.g_varchar2_table(539) := 'A699CFE0EA8700DF75F848FE71006F357FC79BEFAEC36FFD7D62DC7D2B7DA20920A4665910760BA69188E051F8C34487E08387D34434EE9CEB01A8161697DC4B6F9EC01BEF9CC2EBEFBE8FB78F9F0108989CF497217BF15254783809340E060B3801700D';
wwv_flow_api.g_varchar2_table(540) := '8C1A20D9EBE16C9D1EC0070BF02B2014DD47CBF3304940E6690FF8A5DF042936AF754D581A0CD1EF75B16FD7561CD8BB030FECD98E830FEC62117DC0B978826F00BF86BF061FCC3B017F88E76D24E05F438AEE7FA2DC7D2BAD134093D86E41179E08B6C0';
wwv_flow_api.g_varchar2_table(541) := '83FE103C091C813F62BC9B88B6D4354D743A550F9E38DCA5ABD771FCF405BCF4C6717CFBA5B77075E626BADD0E3A9D0EAACAA1AAAA64E501A004341824600008C1AAFBB7CBBAF125809B79E2FB969D080BD4DAFB8041029CAC22693544D9BCD6B53FB8B3';
wwv_flow_api.g_varchar2_table(542) := '63EB261C39B40F0FEDDF8DED5B3761C3A4BFE51BC13F83AF71F34790AEFE79F800DFBBF0E03FD17C37D3E419E21310DD5F695A270095D4B661F00876C19F213802BF857810C01E22DA5AD734E91CFA55557500B8BA2637737D16478F7F806FBCF006DE78';
wwv_flow_api.g_varchar2_table(543) := 'E734161697301C8DE0E0D0ED56E8763BA8AAFCC1CCDC4D5E510051037A1957BFCDCAAF8474EE8804D418AA0A70AE8A37DEA8EBDA07569D43B7DBC158BF87470FEDC3630F3F803D3BB660AA013D8010F40B81BDB09D37077F52EF1C3CF08FC183FF14FC1A';
wwv_flow_api.g_varchar2_table(544) := 'FF1A3CF03F11DB7AB79BD609A09014118CC3C70876027800FE26240FC37B077B016C25A28D44345655550FE9B1EBEEDA8D5BF8E6F78EE2F5B74FE1ECC5ABB8796B1E3767E7B1B83440AFD741BFD743AFD78183138FFA96D611AD249007D95600702336B1';
wwv_flow_api.g_varchar2_table(545) := '3CC0F3988119E370F2A2A5CA5531323F1AD5188D463E803AD6C7D4E438A626FAD8B16D1A871FDC832307F76262BC2FE6A20E9391B6F216E1F7EAAFC207F74EC09FE27B0F3ECA7F117E8DBF8075E0B7A675025826A9A5C118FC61A26DF0C03F041F2B3808';
wwv_flow_api.g_varchar2_table(546) := '7FB3D21DF0718209E75C1F7E79108201585C1AE0DD93E7F0EEC9B33875E612CE5F9EC1F9CB33B8327313CE55181FEBA1DFEB36F1834805F1C5065C3BC0639EE56206E016DC70FD5B762264502F80DEBF27220C86230C472354CE61DBF4466C9DDE886D5B';
wwv_flow_api.g_varchar2_table(547) := '3662CFCEAD7860D736ECDBBDCD96BD7F0C5F8D64EDE7E12DFA25F83BF39C845FDB9F8027822BF0C4B08875577F45699D005698181174E0B70F27E1E304BBE00F153D084F04079AEFB6C093C53811F588A853553132080098B93E8B0F2E5CC199F35770F2';
wwv_flow_api.g_varchar2_table(548) := '838B3879E6224E7E7011F30B8BE875BBE874AAF857B9AAB1AEC9D58FC1B682E5C63256DE8E1930CF8307FC9047EA753B84B0374FA86BA0A61A5313E37860F736ECDDB9157B766EC58EAD9BB063EBA6F01CBD98FCD39D8006B001F421A877137E0D7F017E';
wwv_flow_api.g_varchar2_table(549) := 'DFFE24BC8B7FBAF96E067E29B0D4945B07FE0AD33A01DC4162E708429C6023FC9587BBE109E0003C29EC833F6C340D60035122033854DED2FB392022CCDC98C5D56BB33873E12ACE5DBC8AF397AFE1CAB59B3877710673F30BC6FADADFC432EC9187BF70';
wwv_flow_api.g_varchar2_table(550) := '455EC52CB2B6E4E693889249079A271C233EB5388CDD8EE23B076C9C9CC0CEEDD3D8BC71123BB66EC6F62D1BB163DB666CDA3019037821D5751DDAA7A60F1AF4B3F0D6FE32BCB53F0D0FFEF7E1837A57E18921ACEF3F91FBF8779BD609E02E122382E015';
wwv_flow_api.g_varchar2_table(551) := '4CC0C70AB6C393C13EF898C103CDE76D68C800CC332042A7D30977DD4F73321AF9432FC3E10837E716F0C1B9CBB83C731317AE5CC3A52BD771FED20C169706188EEAE6A948680ECAF8BB208F4675BC9049BBFCE588BF43B753A1D33C5BA1DFEBFA1D0CE7';
wwv_flow_api.g_varchar2_table(552) := '0398BD6E17E3633DECDBB9159B374D61D7B6694C6F9CC29E9D5BD0EFF7FCCE47B3EBA153F3F83662967E041BF457E041FE41F377A6F97C197E6D3F8F64EDD7817F17699D00EE416A8800485E411FFEA8F12678D0EF848F19EC695E03196C8627834902FA';
wwv_flow_api.g_varchar2_table(553) := '20EA12D0F14B68C711549CA71BB373B8D0780A9DAAE3BD88EBB3E8762B5CBD368B9BB7E69B7B1CF060A2EDFA8737D31B27B179E31446C31A3BB76FC6F8581F9D4E852D9BA6B073DB34C6C77A2B954B046613C00B567E8814C19F85077500FD59F888FE59';
wwv_flow_api.g_varchar2_table(554) := 'F860DE15F80B776E3565064D3D5807FEDDA77502B8C789C50AC2350763F09EC12678EB1FBC835DCDEB4EB06542F337014F245D78EFA203A00A278DD90508CE7D0433185605482F1C88E17D007B007CD8AB9F8574EF2FC203FF029295BF060FFA79A4805E';
wwv_flow_api.g_varchar2_table(555) := '8DF5B5FD3D4FEB04701F934106614B71031221040F61073C116C6FBEDB04EF454CC213C2785347B7A9AF8227850A448EC25C920FC685F7B8933976BC9023FE99314EB86576ADFE86CDDF023C80E7E0ADF70D786B7EB9F9BB8464E1AF35BFCF226DDDAD83';
wwv_flow_api.g_varchar2_table(556) := 'FE4348EB04F02125B54CE8C00339C40DA69048610B3C016C6BDE4FB3D74008E3F09EC5785347387B10FE38F184F730DE8B2EB257FDBE860DF801BC5BBE006FA91790007F0D3E3A1F5EAF347F334860BF85B49E1FA259D303EBEEFD7A5A4FEB693DADA7F5';
wwv_flow_api.g_varchar2_table(557) := 'B49ED6D37A5A4FEB693DADA7F5B49ED6D37A5A4FEB693DDD93F4FF078391A045EA37DEE70000000049454E44AE426082';
null;
end;
/
begin
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(33441757226560671)
,p_file_name=>'cronology.ico'
,p_mime_type=>'image/x-icon'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
null;
end;
/
prompt --application/shared_components/files/cronology_jpg
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := 'FFD8FFE000104A46494600010101006000600000FFDB0043000503040404030504040405050506070C08070707070F0B0B090C110F1212110F111113161C1713141A1511111821181A1D1D1F1F1F13172224221E241C1E1F1EFFDB004301050505070607';
wwv_flow_api.g_varchar2_table(2) := '0E08080E1E1411141E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1E1EFFC000110800C2015A03012200021101031101FFC4001D00010003000301010100000000000000000005';
wwv_flow_api.g_varchar2_table(3) := '0607030408090201FFC4004C10000104010204020505090E05050000000100020304050611071221314161131451718108223242911537526272A1B1D1D2232473748285929394A2B2B3B4C116173353653443455763FFC4001901010003010100000000';
wwv_flow_api.g_varchar2_table(4) := '00000000000000000203040105FFC40023110101010002020202020300000000000000010203110421316112411323325181FFDA000C03010002110311003F00F22222202222022220222202222022220222202222022220222202222022220222202222';
wwv_flow_api.g_varchar2_table(5) := '022220222202222022220222202222022220222202222022220222202222022220222202222022220222B9F0E386BA9B5CD8071B5C57A0D76D25EB1BB626FB40F171F21F1D9764B7E1CB7A531773158ACA65A6F438BC6DCBF2FE05681D23BEC682BD79C3';
wwv_flow_api.g_varchar2_table(6) := 'FE03E86C03239B2759D9FBA3A992E0FDC81F28874DBF2B996C98982A51ACCAD4AB415606746C70C618D1EE03A2B3F8AFED1FCE7E9E0AA7C23E26DB607C3A1F3601FF00B958C67EC76CBF977849C4DA6C2F9B4267CB47731537C9FE1057D0EAF2A90AF2F9';
wwv_flow_api.g_varchar2_table(7) := 'AE5C134F96991C7DFC6D835B234ACD39C778E789D1B87C08057597D58C9633119BA469667194B2559DDE1B5036561F83810B15E257C95342EA38A5B7A525974CE44824319BCB55E7CD84EEDFE49007E0950B3A4BB784515CF8A7C31D61C36CA8A5A9F18E';
wwv_flow_api.g_varchar2_table(8) := '8A291C457B911E7AF636FC07FB7F14ECE1E2153171D111101111011110111101111011110111101111011110111101111011110111101111011110111101115CB84BA40EACD48D6590E18DABB4969C3A730F0603ED76DF602BB9CDD5EA396C93BAB3F04B';
wwv_flow_api.g_varchar2_table(9) := '858752BE3CEEA063E3C3B5DBC50EFCAEB4479F833CFB9F0F6AF5262E3AD4EA4556A411D7AF1343638A3686B58D1D8003B281C7FA2AF047040C6C7146D0D631A360D03A0007B14AD797CD6ECF1CC4EA326B77553F5E5F35255E5ECAA16B3F86C60DF2597A';
wwv_flow_api.g_varchar2_table(10) := '14BF8C59647FE22171C1C44D083BEB6D363DF9483F69475D251A25797B291AF2ACE60E246801B6FAE74C8FE7683F6977E0E25F0F477D79A587F3BC1FB6ABBD2C9DB47AF2F9A92AF2F6EAB358389FC391B6FAFF004A0FE78AFF00B6BBF5F8A7C361B6FC42';
wwv_flow_api.g_varchar2_table(11) := 'D243F9E6BFEDAAEA7177D4783C36A8C1D8C267F1D5F238FB2DE596099BB83EC23C411DC11B107B2F017CA6381991E16E506531866BDA5ADC9CB5EC386EFACF3D4452EDE3EC7763B7815EEDD2BAB34DEA46CCED3BA8713986D72D131A17639C465DBEDCDC';
wwv_flow_api.g_varchar2_table(12) := '84EDBEC76DFD85496A3C2E2B5369FBB81CD5465BC7DD88C53C4FEC41F11EC20EC411D4100850B128F9308AEFC6FE1EDFE19F10AF69AB65F2D71FBB51B246DE9EBB89E577BC6C5A7CDA552145D11110111101111011110111101111011110111101111011';
wwv_flow_api.g_varchar2_table(13) := '110111101111011110111101111017A6B84B85669FD1F56073036CD81EB160EDD799C3A0F80D87C0AF3D68FA2DC96A8C6D278E664961BCE3DAD07777E6057A82BCAB678B8EFBD33791AEBA89FAF2F658C71D78A792C7E465D33A7AC1ACF886D6AC33E96E';
wwv_flow_api.g_varchar2_table(14) := '47D169F0F32B59AF2F6EABC8BC447BA4D7FA85CE3B9FBA7607C048E014BC8D5CE7D23C125BED0D6ACD8B533A6B33CB348E3BB9F23CB893EF2B5BE0A70667D675199BCC587D2C4B9C446183F749B63B123D83CD63EBDD5C2A0C83879A7628C06B5B8D83B7';
wwv_flow_api.g_varchar2_table(15) := 'E40DD66E2C4D5F6BF935F8CF48EA7C08E1A362631F87964206C5CEB0EDCF9A9087809C2E777C13FF00B43FF5ABA5797B755235E5F357DC4FF4AA6AA8F0FC9F7854EEF8093FB4BFF5AEE43F276E133BBE9F93FB4BFF005ABF5797B755235E5F355DCC4E6A';
wwv_flow_api.g_varchar2_table(16) := 'A3F85FC3DD25C3D65E6696C7BA98BC63363794BF9B939B97BFE5157FAF2A80AF2A91AF2F9A8589CAC63E5C3A163D4FC2A3A9AAC21D92D3AFF4FCC0757D6710256FC3E6BFCB94FB578197D66C953AB97C3DCC4DD67A4AB76BC95E66FE131ED2D70FB095F2';
wwv_flow_api.g_varchar2_table(17) := '97398F9B139ABD8AB3FF005E95992BC9F94C7169FCE157528E9A222E3A2222022220222202222022220222202222022220222202222022220222202222022220B67095A0EB8A8F3F5192387F408FF75BDD79579FB861308759D3DCEC1ED7B7FB87F52DCE';
wwv_flow_api.g_varchar2_table(18) := 'BCBE6BD2F127F5FF00D61F27FCD3F5E5EDD579435E9DF5D67CFF00E4ECFF009AE5EA1AF2F65E5CD7277D6D9D3FF92B1FE63957E5CF513F1BE6A197B8786D2EDA130237ED8E83FCB0BC3CBDA9C3A936D11821BFFF001F07F802ABC6F9AB39FE22F75E5F35';
wwv_flow_api.g_varchar2_table(19) := '235E5F35015E5F35235E5F35A2C532A7EBCBDBAA91AF2F6EAA02BCBD948D797B755558B254FD79548D797B755015E5F35235E5EDD5576272A7EBCBDBAAF9ABF281AECABC6ED651463669CBD893FA6F2E3FE25F472BCBD97CDCE395D6E438C7ABED30F331';
wwv_flow_api.g_varchar2_table(20) := 'D98B2D691E21B21683F9955A59953511141211110111101111011110111101111011110111101111011110111101111011110111107730970D0CBD4BBD768666BCF9807AFE6DD6FD5670E6B5CD70208DC11E2BCEAB5AE1C6605FC232BBDFBCF5768DC3C4';
wwv_flow_api.g_varchar2_table(21) := 'B7EA9FB3A7C16EF0B7EEE6B27959F534D0ABCBDBAAF39F12294D475BE55B2B48F4D65F3B0FB5AF7170FD2B7EAF2F6EAA2F57E93C6EA9ACD164986CC6368E760EA3C8FB42BFC9E1BBCFA53C3C9317DBCE6BD5FC17D474F33A231D1432B7D629C0CAF3C7BF';
wwv_flow_api.g_varchar2_table(22) := 'CE6968DB7DBD840DD62590E126A68652293AADC8F7E8448187EC77EB5CB83E1F71271171B6F175FD5A61F5997231BFBFE77558F8E6F8F5EF2D5BB8DCF97AAEBCBDBAA92AF2F6EABCFF005AC71CD91B5ADA945E40DB77490EE7FBCBB915BE3DFD4A38EFEB';
wwv_flow_api.g_varchar2_table(23) := '21FDA57DDFD55531F71E85AF2F6EAA46BCBDBAAF39C573E509F528637FAD83F6976A2B9F28DFAB8FC67F5B07ED2AEEFEAA533F6F49D79548D797B755937076CF11DF1E47FE6157AB0BC3A3F53F42F8CEE3E773EFC84FE2F75A5D797B755CB3B49DCD479D';
wwv_flow_api.g_varchar2_table(24) := 'AFA7F4CE4B3B68810D0AB2587827B86B49DBDE76DBE2BE685DB135CB935BB0F2F9A791D248E3E2E71DC9FB4AF58FCB235CB71FA52B68BA737EFBC9B84D6C34F565761DC03F94F03E0C3ED5E4959F77DAEC7C0888A0908888088880888808888088880888';
wwv_flow_api.g_varchar2_table(25) := '808888088880888808888088880888808888088880A4B4DE5A6C36523B71EEE67D1959F84DF1F8A8D45DCEAE6F71CB259D56F58ABD05CAB1D9AD20922906ED214BD797B75585E93D4767076394832D479DE48B7EDE6DF3FD2B5CC2656A64AAB6CD39DB2C';
wwv_flow_api.g_varchar2_table(26) := '67BEDDDA7D847815EBF0F367967DBCDE4E2BC77E969AF2F9A91AF2F6EAA02BCBDBAA91AF2F6EAA76212A7EBCBDBAA91AF2F9A80AF2F6EAA46BCBE6ABB164A9FAF2A92AF2F9AAFD797CD48D697CD576272AC15E5F35D2D69ABF17A374D58CE6565DA2886D';
wwv_flow_api.g_varchar2_table(27) := '1C40FCF9A43F458DF33F986E7B055DD63ADB07A3B146F662D06B883E86BB3ACB31F635BFEE7A05E51E26EBCCC6BBCD7AEE41DE86AC5BB6AD463B7642DFF771F1778F90D82CFCBB99F5FB5FC79B517AD351E4B566A6BB9FCAC9CD66D49CDCA3E8C6D1D1AC';
wwv_flow_api.g_varchar2_table(28) := '6F901B01EE50E88B234088880888808888088880888808888088880888808888088880888808888088880888808888088880BB58CC8DDC6D91628D87C3278F29E847B08EC57551765B2F70B3BF969180E24460363CBD5730FF00DD83A8F8B4F6F86EAF38';
wwv_flow_api.g_varchar2_table(29) := '8D5382BA07ABE56A927EABDFC8EFB1DB15E7E45A73E5EE7CFB67D78D9BF1E9EA6A9618F68731ED703E20EEA4196E185BCD34AC8DA3B973800BC94D739BF45C47B8A39CE71DDCE27DE54EF97F48CF1BEDEA5C8EBFD27896136B3755EF1F52077A576FECD9';
wwv_flow_api.g_varchar2_table(30) := 'BBEDF1542D55C73B0E8DF5F4C50F41BF4F5AB40170F36B0741F127DCB16454EBC8D6BE3D2CCF0E63B797C9E432F7E4BD93B935BB327D29257731F7790F25D444542E11110111101111011110111101111011110111101111011110111101111011110111';
wwv_flow_api.g_varchar2_table(31) := '1011110111101111011110111101111011110111735DAB6A959756B95A6AD3B402E8E5616386E011B83D7A820FC5070A2220222202222022220222202222022220222202222022220222202FEB18E7BC318D739C4EC001B92BBBA7F156F399DA386A0D0E';
wwv_flow_api.g_varchar2_table(32) := 'B5767641102761CCE3B6E7D80772B43D47ACE3D09767D2FC3A1053150982E66BD135F6EECA3A3C879079230EDC3437D9BEFD5067ECC1671ED0F661B22E6B86E08ACF208FB1756ED2B94A46C776A4F59EE1B86CD196123DBB156777137884E7171D659ADC';
wwv_flow_api.g_varchar2_table(33) := '9DFA5A701FA541EA0CFE6F50D98ECE73296F23346CF46C92C4A5EE6B77DF604F86E4A08D5CE695D173D4CD4B1EB3BEDE87D19E7DFD9CBDD702DCB8FBAEF2380E2466313A49FF00721E5D1BF217600058B5298DA40F49F49AC68E501A361B8713BEE830D4';
wwv_flow_api.g_varchar2_table(34) := '453DA034E49AAB55D3C2B676D68A42E92C58776861634BA479F7341F8EC82120866B12B6282292591DD98C69713F00BF56AB58AB2986D412C120EEC9185A7EC2B41CBF136DE244B86E1DC4CD3B858CF236586306DDB03FF725948E6E63DF61B01BEDE0B8';
wwv_flow_api.g_varchar2_table(35) := '717C57D46E6B68EAAF41AAB0EF3B4D5325187BB63DCB25DB9D8EDBB107A1EBB20CFD15AF899A6E96032D52CE1AC49670996A8CBD8E924FA6D8DDB831BFC39D8E05A7E07C7655441C93C1340E6B6786489CE68700F69692D3D8F5F02B99B8CC8BAA7ADB71';
wwv_flow_api.g_varchar2_table(36) := 'F6DD580DFD2885C59B7E56DB2DCF89991C1E8EABA7F3EDA35B2BA9F2183A6DA8CB7187C14216441BE9790F4748E76E1BBF41CA4F875CDDFC58E233AE7AD9D5F92126FBF2B5E1B1FF00400E5F86C82948B4E7CF4B89BA7F273CD8FA94757E2AA9B9E9AA44';
wwv_flow_api.g_varchar2_table(37) := '23664E067FD50F60E8256821C08FA4371B74598A02E4AD5E7B32886B4324D21ECC8DA5C4FC02B0F0DB4E43A9F53B69DEB26A632B4325CC8D91DE1AF18E67B8799E8079B829FCC71532D579F19A1628F4B612325B14551804F281D03E59482E73C8F3FB76';
wwv_flow_api.g_varchar2_table(38) := 'DD067F6209ABCAE86C43243237A163DA5A47C0AE35A1E238A996B2E663F5CC316AAC2BCF2CB15B8DA6789BE2F8A5E8E6BC799EBE5BEEA07893A6E1D31A97D568DA75BC65BAF1DDC75870D8CB5E41BB09F31D41F30505695FFE50DF7DCCB7F034FF00D242';
wwv_flow_api.g_varchar2_table(39) := 'A80AFF00F286FBEE65BF81A7FE921414040092000493D805C95609AD598AB578DD24D2BC32360EEE713B003E2B52D41A82BF0BEC9D31A321ABF772B304796CE49136594CFB7CF8A1E604318D3BB77DB724796E4330B54AED46B1D6AA5881AF1BB0C91968';
wwv_flow_api.g_varchar2_table(40) := '70F68DFBAE0579A3C5AD7D04AE36B3B2652BC87F75AB908DB6219478B4B5C3A0F76DE4BF7AF71786CA697A7AF74DD46E3EBD8B269E4F1CC3BB2A5AE5E6063FFF0037B41207D5236F7050D115E787988C255C16475C6A8AC6EE371F2B6B53A1CE5A2EDB70';
wwv_flow_api.g_varchar2_table(41) := 'E60C711D98D68E677B771DFB10A753A376E071A94EC580C1BBBD1445DB7BF60B80B1E243196B83C1D8B48EBBFB36579BDC5BD7733DADA399388A919DE1A78E89B5E1887834068DC8FCA2558747EAEA9C40CC55D3BC408ABCB7ECC8D663B39140D8EC4336';
wwv_flow_api.g_varchar2_table(42) := 'FF003192F280248C9D8751B8DFBF5DC064F3C335799D0CF13E295876731ED2D734F982904335899B0C113E595E766B18D2E738F900AE7C77FBEFEA6FE3A7F40556C164ED61B354B2D49DCB669CEC9E23F8CD208DFCBA20E91041208208EE0AFDC10CD626';
wwv_flow_api.g_varchar2_table(43) := '6C3044F96579D9AC634B9CE3E402B8F19F1B529EB693258C696E333704795A5E4C986EE6F972BF9DBB792EEF07C8C2C19FD7720D8E12918E9123BDC9F78E3DBDBCA0BDC7D9B02833F735CD716B816B81D8823A82BF884924924927B92880888808888088';
wwv_flow_api.g_varchar2_table(44) := '88088882F3C03B75A971874DCD6F6F466D1886E7EBBD8E633FBCE6AA7E5AA59A194B74AEB5CDB55E67C5307770F6920EFF0010B86096482664D0BDD1C91B8398F69D8B483B820FB56957F2DA2788423BFA97252E96D4A1AD65ABB1D433D4BDB0D848E633';
wwv_flow_api.g_varchar2_table(45) := 'E74721E9B91F37EDE819922BFF00FC11A3FF00FB5309FD8ACFECAAD6ADC4E330F7628317A8AA67627C7CEE9ABC4F8C31DB91CA43C03BF8FC5042ABFF00CA27EFCFA8FF00868FFCA62A02B8F1AF2F8ECEF1473796C4DA6DAA562563A295AD203808DA0F42';
wwv_flow_api.g_varchar2_table(46) := '01EE0A0A72D07818D7D8CCEA3C6D7D8DDBFA6AFD7A6DFACE94B03B95BE65AD70FCFE0B3E5DDC1E52F61331572D8CB0EAF72A4A258646F8387E91E0478841D245A4E4470E75ACEECA3B2D2E8CCC4EE325BAF2D5758A52484EE5D1399F3A304EE7670206FB';
wwv_flow_api.g_varchar2_table(47) := '05C75B0FC31D3EEF5ECB6A99F5548C3BC78DC6557C0C908EA3D24D201B34F621A3741C7C436BAB70BB87742CEE2D8AD76D721EED8659C18BE0795C47BD67CA6759EA3BDAA7504D97BCD8E273C363860886D1C11346CC8D83C1A028641A0F1D9EE76A2C23';
wwv_flow_api.g_varchar2_table(48) := '5CE24334EE3C37C87A107F492B3E571E2D65B1D98CE6327C6DA6D88A1C353AF239A08E5919106B9BD478154E417FF93DFCEE2BE36277564B5AE31EDF070F5497A1FB15015C782F97C760B8918ECA65AD36AD38A2B2D7CAE69201756958DE8013D5CE03E2';
wwv_flow_api.g_varchar2_table(49) := 'A9C8340E1135D630DAE71F587EFD9F4FC8F876EAE7363918E91807892D07CFA2CFD4A694CF6474CEA1A79CC54A23B7524E76EE376B876735C3C5A41208F61574BD4B867AAE5764A96764D1B7653CD3E3EDD57CF5438FD23148CEAD6FE2B8790D820CDD68';
wwv_flow_api.g_varchar2_table(50) := '1C5806BE9DD098FB1BFAE43816CB2EFDDAC9257BE369FE49EDE6BB1468F0CB4AC8CC95ECF4BACAEC4EE6871F4EB3EBD62E1D47A59241B96F9347BF754BD599EC86A6D437339947B5D6AD3F99C18366B000035AD1E0D00003C8208B57FF009437DF732DFC';
wwv_flow_api.g_varchar2_table(51) := '0D3FF490AA02B8F1A32F8ECEF1232394C4DA6DAA72C559AC95AD2012DAD131DD0807A39A47C1047F0D2CD6A7C45D376ADF28AF1656B3E42E3B06B44ADDDC7DDDFE0BF9C49A96E971075056BC1DEB0DC94E5E5C36E6DE4243BDC4107E2ABEB4976A0D23AE';
wwv_flow_api.g_varchar2_table(52) := '68568F5B5AB986CFD685B037370406C476A368D9BEB118F9C5E074E76F53E3D820CD9681A741ABC0AD5962D6E21BD94A35EA6FE32C7E91EFDBF9042FD45A4F879464F58CAF1263B9599D4D7C663A533CBF8AD2F018D3E67A288D7DAB20CEC5430F86A071';
wwv_flow_api.g_varchar2_table(53) := '7A7F16D7368D42FE6792E3BBE591DF59EE3D7D83B0F30AA2D0AE6D67E4F78F35A3FF00D16A299B6F63BEC6485A58E23C010D237F259EABB70F72991C061B2390BB86396D217A4651CAD73272873F62E61041DD8F6F52D76DB771BEE5052549E93A966FEA';
wwv_flow_api.g_varchar2_table(54) := '9C552A61C6CCF7228E2E5EFCC5E0056F974AF0EB20EF59C47115B8F81FD7D572B8F944D17917460B5FEF1B297D2D92D25A3B2F5AB68A9AC6A7D4F76465583253563057ABE908693146EF9CE7F52399DB01BFBC10AE71DFEFBFA9BF8E9FD015255C38D966';
wwv_flow_api.g_varchar2_table(55) := '2B5C59D4D2C2EE660C848CDFCDA794FE70553D05F9E7FE23E0BB1DD5D774A5CE53E74EC9E9EFE5941F707AFD6B82301C34D31A519F36CDE0739901E720E4AED3EE8C13B7E3A7008B2C6BF185B7019F1796A562A645BBEDCB07A32F2FDFC394B1AEDFC957';
wwv_flow_api.g_varchar2_table(56) := 'B8899F3A9F5AE5336D6F24362722BB36DB921680D8DBF0635A10402222022220222202222022220222202222022220222202222022220222202222022220222202222022220222202B5F0EF5643A764BD8ECB50392C065A210E4698772B880776C8C3E0F';
wwv_flow_api.g_varchar2_table(57) := '693B83FA3B8AA220D027D19A36FF00EF9C0711F1715771DC4197825AF3C5B9FA2EE56B9AE2078B7A13EC5D9A37F4870F49BF83CA9D4DA9C31CDAD6595CC74E838820BC078E69641BF4E81A37DFB80B36441FA9647CB23A595EE7C8F25CE738EE5C4F724F';
wwv_flow_api.g_varchar2_table(58) := '895F9444174D1194C7603456A8C87AD47F766FC0DC5D284757B6290EF3C9E4395A1A0FB5CA968880888808888088880888808888088880888808888088880888808888088880888808888088880888808888088880888808888088880888808888088880';
wwv_flow_api.g_varchar2_table(59) := '88883FFFD9';
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(33452538977521178)
,p_file_name=>'cronology.jpg'
,p_mime_type=>'image/jpeg'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/shared_components/files/cronology_js
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '2F2F2020202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D0D0A2F2F2020202D2D202863292043726F6E6F6C6F677920536F667477617265204C696D697465642020323030322D32';
wwv_flow_api.g_varchar2_table(2) := '303233202D2D0D0A2F2F2020202D2D2020202020202020202020207777772E63726F6E6F6C6F67792E636F2E756B2020202020202020202020202D2D0D0A2F2F2020202D2D202020202020536565206C6963656E73652061677265656D656E7420666F72';
wwv_flow_api.g_varchar2_table(3) := '207465726D732020202020202D2D0D0A2F2F2020202D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D2D0D0A0D0A76617220676C6F62616C5F696E646578203D206E756C6C3B0D0A7661';
wwv_flow_api.g_varchar2_table(4) := '7220676C6F62616C5F63757272656E745F69675F636F6C203D206E756C6C3B0D0A0D0A76617220775F6F72616E67655F72676220202020202020203D2022726762283136302C2038332C20313729223B0D0A76617220695F626C75655F72676220202020';
wwv_flow_api.g_varchar2_table(5) := '2020202020203D202272676228382C2035392C2031303329223B0D0A76617220655F7265645F72676220202020202020202020203D2022726762283134382C2031352C20313529223B0D0A0D0A766172206461726B626C75655F7267622020202020203D';
wwv_flow_api.g_varchar2_table(6) := '2022726762283020202C3020202C31323829223B0D0A766172206C696768745F6F72616E67655F72676220203D2022726762283235352C3139312C3029223B0D0A766172206272696768745F79656C6C6F775F726762203D2022726762283235352C3232';
wwv_flow_api.g_varchar2_table(7) := '342C3029223B0D0A766172206C696768745F79656C6C6F775F72676220203D2022726762283232342C3139322C3029223B0D0A766172206C696768745F7265645F72676220202020203D2022726762283131332C33392C333929223B0D0A76617220626C';
wwv_flow_api.g_varchar2_table(8) := '75655F726762202020202020202020203D2022726762283132382C3139322C32353529223B0D0A76617220677265656E5F7267622020202020202020203D20227267622838372C3136302C353129223B0D0A766172206C696768745F677265656E5F7267';
wwv_flow_api.g_varchar2_table(9) := '622020203D2022726762283134342C3139312C393629223B0D0A766172207265645F72676220202020202020202020203D2022726762283139322C302C3029223B0D0A0D0A7661722077686974655F7267622020202020202020203D2022726762283235';
wwv_flow_api.g_varchar2_table(10) := '352C3235352C32353529223B0D0A76617220626C61636B5F7267622020202020202020203D202272676228302C302C3029223B0D0A0D0A766172207370696E6E65723B0D0A76617220637573746F6D5F64696167202020202020203D2066616C73653B0D';
wwv_flow_api.g_varchar2_table(11) := '0A0D0A2F2F2072656D656D62657220616C6C2074686573652061726520616C736F206475706C69636174656420696E20746865204D41494E206772696420484947484C494748542073657474696E67730D0A0D0A766172206B657972657065617420203D';
wwv_flow_api.g_varchar2_table(12) := '2066616C73653B0D0A0D0A7661722064656661756C745F6E6F746966795F6469736D697373203D20333030303B0D0A0D0A2F2F746865206974656D206C6F6F6B7320757070657263617365206275742074686520696E7465726E616C2076616C75652069';
wwv_flow_api.g_varchar2_table(13) := '73207374696C6C206C6F77657263617365202D2072656C696573206F6E2075707065726361736520616E64206C6F7765726361736520636C617373657320696E206373732066696C650D0A2428646F63756D656E74292E6F6E28276368616E6765272C27';
wwv_flow_api.g_varchar2_table(14) := '2E757070657263617365272C66756E6374696F6E28297B0D0A20207661722069203D20222322202B20242874686973292E617474722822696422293B0D0A2020242869292E76616C2820242869292E76616C28292E746F55707065724361736528292029';
wwv_flow_api.g_varchar2_table(15) := '3B0D0A7D293B0D0A0D0A2428646F63756D656E74292E6F6E28276368616E6765272C272E6C6F77657263617365272C66756E6374696F6E28297B0D0A20207661722069203D20222322202B20242874686973292E617474722822696422293B0D0A202024';
wwv_flow_api.g_varchar2_table(16) := '2869292E76616C2820242869292E76616C28292E746F4C6F77657243617365282920293B0D0A7D293B0D0A0D0A2F2F2075706461746520676C6F62616C207661726961626C65206B657972657065617420736F20636F64652063616E20656173696C7920';
wwv_flow_api.g_varchar2_table(17) := '7365652069662061206B6579206973206265696E672068656C6420646F776E0D0A77696E646F772E6164644576656E744C697374656E657228276B6579646F776E272C2066756E6374696F6E286529207B0D0A202069662028652E72657065617429207B';
wwv_flow_api.g_varchar2_table(18) := '0D0A202020206B6579726570656174203D20747275650D0A20207D0D0A2020656C7365207B0D0A202020206B6579726570656174203D2066616C73653B0D0A20207D0D0A202077696E646F772E6164644576656E744C697374656E657228276B65797570';
wwv_flow_api.g_varchar2_table(19) := '272C2066756E6374696F6E2829207B0D0A202020206B6579726570656174203D2066616C73653B0D0A20207D293B0D0A7D293B0D0A0D0A2F2F207061676520776974682053494E474C452074657874206974656D2077696C6C207375626D697420696620';
wwv_flow_api.g_varchar2_table(20) := '796F752068697420656E746572212120746869732070726576656E747320746869730D0A242822696E7075742C73656C65637422292E6B657970726573732866756E6374696F6E2865297B0D0A2072657475726E20652E6B6579436F6465213D3D31333B';
wwv_flow_api.g_varchar2_table(21) := '0D0A7D293B0D0A0D0A66756E6374696F6E207365745F6974656D5F636F6C6F75722028206974656D2C20636F6C2029207B0D0A6966202820636F6C203D3D20274F272029207B0D0A202024286974656D292E6373732822636F6C6F72222C202020202062';
wwv_flow_api.g_varchar2_table(22) := '6C61636B5F726762293B20202020202020202F2F746578740D0A202024286974656D292E63737328226261636B67726F756E64222C6C696768745F6F72616E67655F726762293B202020202F2F6261636B67726F756E640D0A7D0D0A656C736520696620';
wwv_flow_api.g_varchar2_table(23) := '2820636F6C203D3D2027522729207B0D0A202024286974656D292E6373732822636F6C6F72222C20202020206C696768745F79656C6C6F775F726762293B0D0A202024286974656D292E63737328226261636B67726F756E64222C7265645F726762293B';
wwv_flow_api.g_varchar2_table(24) := '0D0A7D0D0A656C7365206966202820636F6C203D3D2027472729207B0D0A202024286974656D292E6373732822636F6C6F72222C2020202020626C61636B5F726762293B0D0A202024286974656D292E63737328226261636B67726F756E64222C677265';
wwv_flow_api.g_varchar2_table(25) := '656E5F726762293B0D0A7D0D0A656C7365206966202820636F6C203D3D2027672729207B0D0A202024286974656D292E6373732822636F6C6F72222C2020202020626C61636B5F726762293B0D0A202024286974656D292E63737328226261636B67726F';
wwv_flow_api.g_varchar2_table(26) := '756E64222C6C696768745F677265656E5F726762293B0D0A7D0D0A656C7365206966202820636F6C203D3D2027422729207B0D0A202024286974656D292E6373732822636F6C6F72222C2020202020626C61636B5F726762293B0D0A202024286974656D';
wwv_flow_api.g_varchar2_table(27) := '292E63737328226261636B67726F756E64222C626C75655F726762293B0D0A7D0D0A656C7365206966202820636F6C203D3D2027722729207B0D0A202024286974656D292E6373732822636F6C6F72222C202020202077686974655F726762293B0D0A20';
wwv_flow_api.g_varchar2_table(28) := '2024286974656D292E63737328226261636B67726F756E64222C6C696768745F7265645F726762293B0D0A7D0D0A656C7365206966202820636F6C203D3D2027592729207B0D0A202024286974656D292E6373732822636F6C6F72222C2020202020626C';
wwv_flow_api.g_varchar2_table(29) := '61636B5F726762293B0D0A202024286974656D292E63737328226261636B67726F756E64222C6C696768745F79656C6C6F775F726762293B0D0A7D0D0A656C7365206966202820636F6C203D3D2027572729207B2020202F2F205741524E494E470D0A20';
wwv_flow_api.g_varchar2_table(30) := '2024286974656D292E6373732822636F6C6F72222C202020202077686974655F726762293B0D0A202024286974656D292E63737328226261636B67726F756E64222C775F6F72616E67655F726762293B0D0A7D0D0A656C7365207B0D0A2F2F2072656D6F';
wwv_flow_api.g_varchar2_table(31) := '766520616E7920636F6C6F757220636F64696E670D0A24286974656D292E63737328226261636B67726F756E64222C2222293B0D0A24286974656D292E6373732822636F6C6F72222C222229203B0D0A7D3B0D0A7D0D0A0D0A66756E6374696F6E207368';
wwv_flow_api.g_varchar2_table(32) := '6F775F7370696E6E65722829207B0D0A2020207370696E6E6572203D20617065782E7574696C2E73686F775370696E6E657228293B0D0A7D0D0A0D0A66756E6374696F6E2064697361626C655F6638202869675F73656C6563746F725F696E29207B0D0A';
wwv_flow_api.g_varchar2_table(33) := '2F2F2069662074686579206861766520746F67676C65642073656C656374206D6F6465206F6E2028463829207475726E206974206F66660D0A69662028202428202223222B69675F73656C6563746F725F696E20292E677269642820226F7074696F6E22';
wwv_flow_api.g_varchar2_table(34) := '2C202273656C65637443656C6C732220292029207B0D0A2020202428202223222B69675F73656C6563746F725F696E20292E677269642820226F7074696F6E222C202273656C65637443656C6C73222C2066616C736520293B0D0A7D0D0A7D0D0A0D0A66';
wwv_flow_api.g_varchar2_table(35) := '756E6374696F6E20686964655F7370696E6E65722829207B0D0A2F2F2062656C7420616E6420627261636573202D2072656D6F76657320414C4C207370696E6E6572732C207370696E6E65722E72656D6F76652829206A7573742072656D6F766573206C';
wwv_flow_api.g_varchar2_table(36) := '617374206F6363757272656E63650D0A2020202428222E752D50726F63657373696E6722292E72656D6F766528293B0D0A7D0D0A0D0A66756E6374696F6E2073686F775F696E6C696E655F6572726F7220286974656D5F696E2C206D73675F696E29207B';
wwv_flow_api.g_varchar2_table(37) := '0D0A20202069662028206D73675F696E20213D2027272029207B0D0A202020202020617065782E6D6573736167652E636C6561724572726F727328293B0D0A2020202020202F2F20746869732063616E20626520616E20617272617920746F2064697370';
wwv_flow_api.g_varchar2_table(38) := '6C6179206D756C7469706C650D0A20202020202020617065782E6D6573736167652E73686F774572726F7273285B0D0A20202020202020202020202020202020202020202020202020202020202020207B0D0A2020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(39) := '20202020202020202020202020202020747970653A20226572726F72222C0D0A2020202020202020202020202020202020202020202020202020202020202020206C6F636174696F6E3A205B2022696E6C696E6522205D2C0D0A20202020202020202020';
wwv_flow_api.g_varchar2_table(40) := '2020202020202020202020202020202020202020202020706167654974656D3A206974656D5F696E2C0D0A2020202020202020202020202020202020202020202020202020202020202020206D6573736167653A206D73675F696E2C0D0A202020202020';
wwv_flow_api.g_varchar2_table(41) := '202020202020202020202020202020202020202020202020202020756E736166653A2066616C73650D0A20202020202020202020202020202020202020202020202020202020202020207D0D0A2020202020202020202020202020202020202020202020';
wwv_flow_api.g_varchar2_table(42) := '20202020202020205D293B0D0A2020207D0D0A7D0D0A0D0A66756E6374696F6E206469616C6F675F6163746976652028746869735F6469616C6F675F726567696F6E29207B0D0A0D0A20202076617220746869735F6469616C6F675F696E646578203D20';
wwv_flow_api.g_varchar2_table(43) := '303B0D0A20202076617220246163746976654469616C6F6773203D20617065782E7574696C2E676574546F704170657828292E6A517565727928272E75692D6469616C6F673A76697369626C6527292E66696E6428272E75692D6469616C6F672D636F6E';
wwv_flow_api.g_varchar2_table(44) := '74656E7427293B0D0A0D0A202F2F207468697320444F4553204E4F5420636174657220666F72206D756C7469706C65206469616C6F67205041474553206265696E67206F70656E6564206F6E20746F70206F66206F6E6520616E6F74686572202D20776F';
wwv_flow_api.g_varchar2_table(45) := '756C64206E65656420746F2062652061626C6520746F2061737369676E20616E20696420736F6D65686F7720746F207468652050414745207768696368207365656D7320747269636B790D0A202F2F20616C776179732075736520617065782E7574696C';
wwv_flow_api.g_varchar2_table(46) := '2E676574546F704170657828292E6A517565727920666F7220746869732066756E6320726174686572207468616E206A757374202428290D0A0D0A202F2F2066696E642074686973206469616C6F6720696E6465782066697273740D0A20202020666F72';
wwv_flow_api.g_varchar2_table(47) := '20286C65742069203D20303B2069203C20246163746976654469616C6F67732E6C656E6774683B20692B2B29207B0D0A20202020206966202820246163746976654469616C6F67735B695D2E636C6173734E616D652E737461727473576974682827742D';
wwv_flow_api.g_varchar2_table(48) := '4469616C6F67526567696F6E27292029202F2F20706F707570206469616C6F6720524547494F4E0D0A20202020207B0D0A2020202020202020206966202820746869735F6469616C6F675F726567696F6E203D3D20246163746976654469616C6F67735B';
wwv_flow_api.g_varchar2_table(49) := '695D2E696420290D0A2020202020202020207B0D0A202020202020202020202020746869735F6469616C6F675F696E646578203D20693B0D0A202020202020202020202020627265616B3B0D0A2020202020202020207D0D0A20202020207D0D0A202020';
wwv_flow_api.g_varchar2_table(50) := '7D0D0A0D0A202020666F7220286C65742069203D20303B2069203C20246163746976654469616C6F67732E6C656E6774683B20692B2B29207B0D0A20202020206966202820246163746976654469616C6F67735B695D2E69642E73746172747357697468';
wwv_flow_api.g_varchar2_table(51) := '2827506F7075704C6F762729207C7C0D0A202020202020202020202820246163746976654469616C6F67735B695D2E636C6173734E616D652E73746172747357697468282775692D6469616C6F672D636F6E74656E742729202626202120246163746976';
wwv_flow_api.g_varchar2_table(52) := '654469616C6F67735B695D2E69642E737461727473576974682827617065785F6469616C6F67272920292020202F2F20637573746F6D436F6E6669726D2F416C65727420616E64204E4F542061206469616C6F6720504147450D0A202020202020202029';
wwv_flow_api.g_varchar2_table(53) := '0D0A20202020207B0D0A2020202020202072657475726E202754273B0D0A20202020207D0D0A2020202020656C7365206966202820246163746976654469616C6F67735B695D2E636C6173734E616D652E737461727473576974682827742D4469616C6F';
wwv_flow_api.g_varchar2_table(54) := '67526567696F6E27292029202F2F20706F707570206469616C6F6720524547494F4E0D0A20202020207B0D0A2020202020202020696620282069203E20746869735F6469616C6F675F696E6465782029207B0D0A20202020202020202F2F20616E6F7468';
wwv_flow_api.g_varchar2_table(55) := '6572206469616C6F6720697320696E2066726F6E74206F662074686520746869735F6469616C6F675F726567696F6E0D0A202020202020202020202072657475726E202754273B0D0A20202020202020207D0D0A20202020207D0D0A2020207D0D0A2020';
wwv_flow_api.g_varchar2_table(56) := '2072657475726E202746273B0D0A7D3B0D0A0D0A66756E6374696F6E20646174655F746F5F737472696E67202864745F696E2C20696E635F7365636F6E64735F696E29207B0D0A0D0A2F2F2072657475726E732061206461746520696E20595959594D4D';
wwv_flow_api.g_varchar2_table(57) := '4444484832344D49535320666F726D6174202D2075736566756C20666F72203E203C203D20636F6D70617269736F6E730D0A0D0A20202066756E6374696F6E206164645A65726F286929207B0D0A20202020206966202869203C20313029207B0D0A2020';
wwv_flow_api.g_varchar2_table(58) := '202020202069203D20223022202B20693B0D0A20202020207D0D0A202020202072657475726E20692E746F537472696E6728293B0D0A2020207D0D0A0D0A2020207661722064203D206E657720446174652864745F696E293B202F2F2061206E756C6C20';
wwv_flow_api.g_varchar2_table(59) := '64745F696E2077696C6C20726573756C7420696E2030312D30312D31393730210D0A20202076617220726574203D20642E67657446756C6C596561722829202B206164645A65726F28642E6765744D6F6E74682829202B203129202B206164645A65726F';
wwv_flow_api.g_varchar2_table(60) := '28642E67657444617465282929202B206164645A65726F28642E676574486F757273282929202B206164645A65726F28642E6765744D696E757465732829293B0D0A0D0A2020206966202820696E635F7365636F6E64735F696E203D3D20275427202920';
wwv_flow_api.g_varchar2_table(61) := '7B0D0A202020202020726574203D20726574202B206164645A65726F28642E6765745365636F6E64732829293B0D0A2020207D0D0A0D0A202020696620282064745F696E203D3D206E756C6C207C7C2069734E614E2872657429202029207B0D0A202020';
wwv_flow_api.g_varchar2_table(62) := '2020207468726F772027496E76616C696420646174653A2027202B2064745F696E3B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A20202020202072657475726E207265743B0D0A2020207D0D0A0D0A7D3B0D0A0D0A2F2F204947206F707469';
wwv_flow_api.g_varchar2_table(63) := '6F6E2066756E6374696F6E730D0A2F2F204947206C6576656C0D0A66756E6374696F6E2069675F6174742028636F6E66696729207B0D0A0D0A20202020636F6E6669672E64656661756C7447726964566965774F7074696F6E732020203D207B666F6F74';
wwv_flow_api.g_varchar2_table(64) := '65723A2066616C73652C0D0A2020202020202020746F6F6C7469703A207B0D0A2020202020202020202020202F2F207768656E2074686520746F6F6C74697020697320696E74656772617465642077697468207468652067726964207669657720746865';
wwv_flow_api.g_varchar2_table(65) := '20636F6E74656E742063616C6C6261636B0D0A2020202020202020202020202F2F206765747320736F6D652065787472612068656C7066756C20706172616D65746572730D0A202020202020202020202020636F6E74656E743A2066756E6374696F6E28';
wwv_flow_api.g_varchar2_table(66) := '63616C6C6261636B2C206D6F64656C2C207265636F72644D6574612C20636F6C4D6574612C20636F6C756D6E4465662029207B0D0A2020202020202020202020202020206966202820636F6C756D6E44656620213D206E756C6C2029207B0D0A20202020';
wwv_flow_api.g_varchar2_table(67) := '2020202020202020202020202020676C6F62616C5F63757272656E745F69675F636F6C203D20636F6C756D6E4465662E70726F70657274793B0D0A2020202020202020202020202020207D0D0A2020202020202020202020207D0D0A2020202020202020';
wwv_flow_api.g_varchar2_table(68) := '7D0D0A202020207D3B0D0A0D0A2F2F20202020636F6E6669672E64656661756C7447726964566965774F7074696F6E732020203D207B666F6F7465723A2066616C73657D3B0D0A20202020636F6E6669672E66656174757265732E616767726567617465';
wwv_flow_api.g_varchar2_table(69) := '202020202020203D2066616C73653B0D0A20202020636F6E6669672E7265706F727453657474696E677341726561202020202020203D2066616C73653B2020202F2F206869646520686967686C69676874696E67206F7074696F6E730D0A202020207265';
wwv_flow_api.g_varchar2_table(70) := '7475726E20636F6E6669673B0D0A7D3B0D0A0D0A2F2F20494720636F6C756D6E206C6576656C0D0A66756E6374696F6E2069675F636F6C756D6E5F6864722028636F6E66696729207B0D0A20202020636F6E6669672E64656661756C7447726964436F6C';
wwv_flow_api.g_varchar2_table(71) := '756D6E4F7074696F6E73203D207B6E6F48656164657241637469766174653A20747275657D3B0D0A2020202072657475726E20636F6E6669673B0D0A7D3B0D0A0D0A0D0A66756E6374696F6E20676F746F5F69675F636F6C756D6E2028726567696F6E5F';
wwv_flow_api.g_varchar2_table(72) := '696E2C20636F6C756D6E5F696E29207B0D0A0D0A20202076617220696720202020203D20617065782E726567696F6E28726567696F6E5F696E292E77696467657428293B0D0A202020766172206D6F64656C20203D2069672E696E746572616374697665';
wwv_flow_api.g_varchar2_table(73) := '477269642822676574566965777322292E677269642E6D6F64656C3B20202F2F6571756976616C656E743A20766172206D6F64656C203D20617065782E726567696F6E2822525F504152414D22292E77696467657428292E696E74657261637469766547';
wwv_flow_api.g_varchar2_table(74) := '72696428226765745669657773222C20226772696422292E6D6F64656C3B0D0A20202076617220676724202020203D2069672E696E74657261637469766547726964282267657443757272656E745669657722292E76696577243B0D0A0D0A2020207472';
wwv_flow_api.g_varchar2_table(75) := '79207B0D0A2020202020206767242E677269642827676F746F43656C6C272C206D6F64656C2E6765745265636F7264496428206767242E67726964282267657453656C65637465645265636F72647322295B305D2029202C20636F6C756D6E5F696E293B';
wwv_flow_api.g_varchar2_table(76) := '0D0A2020207D0D0A2020206361746368202865727229207B0D0A202020202020202F2F206E6F7468696E6720696E20746865206D6F64656C0D0A2020202020202072657475726E3B0D0A2020207D3B0D0A0D0A7D3B0D0A0D0A66756E6374696F6E206765';
wwv_flow_api.g_varchar2_table(77) := '745F63757272656E745F636F6C20286772696449442C20636F6C29207B0D0A20202076617220696720202020203D20617065782E726567696F6E28677269644944292E77696467657428293B0D0A202020766172206D6F64656C20203D2069672E696E74';
wwv_flow_api.g_varchar2_table(78) := '6572616374697665477269642822676574566965777322292E677269642E6D6F64656C3B20202F2F6571756976616C656E743A20766172206D6F64656C203D20617065782E726567696F6E2822525F504152414D22292E77696467657428292E696E7465';
wwv_flow_api.g_varchar2_table(79) := '726163746976654772696428226765745669657773222C20226772696422292E6D6F64656C3B0D0A20202076617220676724202020203D2069672E696E74657261637469766547726964282267657443757272656E745669657722292E76696577243B0D';
wwv_flow_api.g_varchar2_table(80) := '0A202020766172207265745F76616C203D206E756C6C3B0D0A0D0A202020747279207B0D0A202020202020207265745F76616C203D206D6F64656C2E67657456616C7565286767242E67726964282267657453656C65637465645265636F72647322295B';
wwv_flow_api.g_varchar2_table(81) := '305D2C636F6C293B0D0A2020207D0D0A2020206361746368202865727229207B0D0A202020202020202F2F206E6F7468696E6720696E20746865206D6F64656C0D0A202020202020207265745F76616C203D206E756C6C3B0D0A2020207D3B0D0A202020';
wwv_flow_api.g_varchar2_table(82) := '72657475726E207265745F76616C3B0D0A7D3B0D0A0D0A66756E6374696F6E20637573746F6D41747472696273282070547970652C20705469746C652C20704F4B6F7269672C207043616E63656C4F7269672029207B0D0A202020202F2F746865207469';
wwv_flow_api.g_varchar2_table(83) := '6D656F75742069732072657175697265642073696E636520415045582031392E322064756520746F2061206368616E676520696E2074686520617065782E6D6573736167652E636F6E6669726D2F616C6572740D0A2020202073657454696D656F757428';
wwv_flow_api.g_varchar2_table(84) := '66756E6374696F6E202829207B0D0A202020202020202F2F206D616B6520737572652065736361706520616E6420636C6F7365206E6F7420617661696C61626C650D0A2020202020202076617220636F6E74656E7420203D20617065782E7574696C2E67';
wwv_flow_api.g_varchar2_table(85) := '6574546F704170657828292E6A517565727928272E75692D6469616C6F672D2D6E6F74696669636174696F6E202E75692D6469616C6F672D636F6E74656E7427293B0D0A20202020202020766172207469746C65626172203D20617065782E7574696C2E';
wwv_flow_api.g_varchar2_table(86) := '676574546F704170657828292E6A517565727928272E75692D6469616C6F672D2D6E6F74696669636174696F6E202E75692D6469616C6F672D7469746C6562617227293B0D0A20202020202020636F6E74656E742E6469616C6F6728276F7074696F6E27';
wwv_flow_api.g_varchar2_table(87) := '2C2027636C6F73654F6E457363617065272C2066616C7365293B0D0A20202020202020636F6E74656E742E6469616C6F67287B6469616C6F67436C6173733A20226E6F2D636C6F7365227D293B0D0A20202020202020636F6E74656E742E6469616C6F67';
wwv_flow_api.g_varchar2_table(88) := '28226F7074696F6E222C20227469746C65222C20705469746C65293B0D0A202020202020202F2F2054686573652074776F204841564520746F20626520696E206865726520666F7220736F6D6520726561736F6E0D0A20202020202020617065782E6C61';
wwv_flow_api.g_varchar2_table(89) := '6E672E6164644D65737361676573287B22415045582E4449414C4F472E4F4B223A2020202020704F4B6F7269677D293B0D0A20202020202020617065782E6C616E672E6164644D65737361676573287B22415045582E4449414C4F472E43414E43454C22';
wwv_flow_api.g_varchar2_table(90) := '3A207043616E63656C4F7269677D293B0D0A202020202020202F2F20536574207469746C6562617220636F6C6F75720D0A20202020202020696620287054797065203D3D2027492729207B0D0A202020202020202020207469746C656261722E63737328';
wwv_flow_api.g_varchar2_table(91) := '226261636B67726F756E642D636F6C6F72222C695F626C75655F726762293B0D0A202020202020207D0D0A20202020202020656C736520696620287054797065203D3D2027572729207B0D0A202020202020202020207469746C656261722E6373732822';
wwv_flow_api.g_varchar2_table(92) := '6261636B67726F756E642D636F6C6F72222C775F6F72616E67655F726762293B0D0A202020202020207D0D0A20202020202020656C736520696620287054797065203D3D2027452729207B0D0A202020202020202020207469746C656261722E63737328';
wwv_flow_api.g_varchar2_table(93) := '226261636B67726F756E642D636F6C6F72222C655F7265645F726762293B0D0A202020202020207D3B0D0A202020207D2C2030293B0D0A207D0D0A0D0A66756E6374696F6E20637573746F6D436F6E6669726D282070547970652C20705469746C652C20';
wwv_flow_api.g_varchar2_table(94) := '704D6573736167652C20704F6B4C6162656C2C207043616E63656C4C6162656C2C207043616C6C6261636B20297B0D0A20202020766172206C5F6F726967696E616C5F6D65737361676573203D207B22415045582E4449414C4F472E4F4B223A20202020';
wwv_flow_api.g_varchar2_table(95) := '20617065782E6C616E672E6765744D6573736167652822415045582E4449414C4F472E4F4B22292C0D0A2020202020202020202020202020202020202020202020202020202020202022415045582E4449414C4F472E43414E43454C223A20617065782E';
wwv_flow_api.g_varchar2_table(96) := '6C616E672E6765744D6573736167652822415045582E4449414C4F472E43414E43454C22297D3B0D0A0D0A202020637573746F6D5F64696167203D20747275653B0D0A2F2F206368616E67652074686520627574746F6E206C6162656C73206D65737361';
wwv_flow_api.g_varchar2_table(97) := '6765730D0A202020617065782E6C616E672E6164644D65737361676573287B22415045582E4449414C4F472E4F4B223A2020202020704F6B4C6162656C7D293B0D0A202020617065782E6C616E672E6164644D65737361676573287B22415045582E4449';
wwv_flow_api.g_varchar2_table(98) := '414C4F472E43414E43454C223A207043616E63656C4C6162656C7D293B0D0A2F2F2073686F772074686520636F6E6669726D206469616C6F670D0A202020617065782E6D6573736167652E636F6E6669726D28275C6E272B704D6573736167652C207043';
wwv_flow_api.g_varchar2_table(99) := '616C6C6261636B293B0D0A2F2F20736574206469616C6F67206174747269627320616E6420636F6C6F7572730D0A202020637573746F6D41747472696273282070547970652C20705469746C652C206C5F6F726967696E616C5F6D657373616765735B22';
wwv_flow_api.g_varchar2_table(100) := '415045582E4449414C4F472E4F4B225D2C206C5F6F726967696E616C5F6D657373616765735B22415045582E4449414C4F472E43414E43454C225D20293B0D0A0D0A2020206966202820704D6573736167652E746F4C6F7765724361736528292E696E63';
wwv_flow_api.g_varchar2_table(101) := '6C7564657328273C6120687265663D2729207C7C0D0A2020202020202020704D6573736167652E746F4C6F7765724361736528292E696E636C7564657328273C62723E27292029207B0D0A2020202F2F2053776974636820746F2048544D4C0D0A202020';
wwv_flow_api.g_varchar2_table(102) := '20202073657454696D656F75742866756E6374696F6E202829207B0D0A20202020202020202076617220636F6E74656E7420203D20617065782E7574696C2E676574546F704170657828292E6A517565727928272E75692D6469616C6F672D2D6E6F7469';
wwv_flow_api.g_varchar2_table(103) := '6669636174696F6E202E75692D6469616C6F672D636F6E74656E7427293B0D0A2020202020202020202428636F6E74656E74295B305D2E696E6E657248544D4C203D20273C62723E27202B20704D6573736167652E7265706C616365416C6C28275C6E27';
wwv_flow_api.g_varchar2_table(104) := '2C273C62723E27290D0A2020202020207D2C2030293B0D0A2020207D3B0D0A7D3B0D0A0D0A66756E6374696F6E20637573746F6D416C657274282070547970652C20705469746C652C20704D6573736167652C20704F6B4C6162656C2C207043616C6C62';
wwv_flow_api.g_varchar2_table(105) := '61636B20297B0D0A20202020766172206C5F6F726967696E616C5F6D65737361676573203D207B22415045582E4449414C4F472E4F4B223A2020202020617065782E6C616E672E6765744D6573736167652822415045582E4449414C4F472E4F4B22292C';
wwv_flow_api.g_varchar2_table(106) := '0D0A2020202020202020202020202020202020202020202020202020202020202022415045582E4449414C4F472E43414E43454C223A20617065782E6C616E672E6765744D6573736167652822415045582E4449414C4F472E43414E43454C22297D3B0D';
wwv_flow_api.g_varchar2_table(107) := '0A0D0A202020637573746F6D5F64696167203D20747275653B0D0A2F2F206368616E67652074686520627574746F6E206C6162656C73206D657373616765730D0A202020617065782E6C616E672E6164644D65737361676573287B22415045582E444941';
wwv_flow_api.g_varchar2_table(108) := '4C4F472E4F4B223A2020202020704F6B4C6162656C7D293B0D0A2F2F2073686F772074686520616C657274206469616C6F670D0A202020617065782E6D6573736167652E616C65727428275C6E272B704D6573736167652C207043616C6C6261636B293B';
wwv_flow_api.g_varchar2_table(109) := '0D0A2F2F20736574206469616C6F67206174747269627320616E6420636F6C6F7572730D0A202020637573746F6D41747472696273282070547970652C20705469746C652C206C5F6F726967696E616C5F6D657373616765735B22415045582E4449414C';
wwv_flow_api.g_varchar2_table(110) := '4F472E4F4B225D2C206C5F6F726967696E616C5F6D657373616765735B22415045582E4449414C4F472E43414E43454C225D20293B0D0A0D0A2020206966202820704D6573736167652E746F4C6F7765724361736528292E696E636C7564657328273C61';
wwv_flow_api.g_varchar2_table(111) := '20687265663D2729207C7C0D0A2020202020202020704D6573736167652E746F4C6F7765724361736528292E696E636C7564657328273C62723E27292029207B0D0A2020202F2F2053776974636820746F2048544D4C0D0A20202020202073657454696D';
wwv_flow_api.g_varchar2_table(112) := '656F75742866756E6374696F6E202829207B0D0A20202020202020202076617220636F6E74656E7420203D20617065782E7574696C2E676574546F704170657828292E6A517565727928272E75692D6469616C6F672D2D6E6F74696669636174696F6E20';
wwv_flow_api.g_varchar2_table(113) := '2E75692D6469616C6F672D636F6E74656E7427293B0D0A2020202020202020202428636F6E74656E74295B305D2E696E6E657248544D4C203D20273C62723E27202B20704D6573736167652E7265706C616365416C6C28275C6E272C273C62723E27290D';
wwv_flow_api.g_varchar2_table(114) := '0A2020202020207D2C2030293B0D0A2020207D3B0D0A7D3B0D0A0D0A0D0A66756E6374696F6E206E766C2876616C7565312C76616C756532290D0A7B0D0A6966202876616C756531203D3D206E756C6C207C7C2076616C756531203D3D202727207C7C20';
wwv_flow_api.g_varchar2_table(115) := '76616C756531203D3D20756E646566696E6564290D0A7B72657475726E2076616C7565327D0D0A656C73650D0A7B72657475726E2076616C7565317D3B0D0A7D3B0D0A0D0A66756E6374696F6E2073686F77286929207B0D0A6966202820692E73756273';
wwv_flow_api.g_varchar2_table(116) := '7472696E6728302C3129203D3D202723272029207B0D0A2F2F207573696E67207374617469632069640D0A202020242869292E73686F7728293B0D0A7D0D0A656C73650D0A7B0D0A202020617065782E6974656D2869292E73686F7728293B0D0A7D0D0A';
wwv_flow_api.g_varchar2_table(117) := '7D3B0D0A0D0A66756E6374696F6E20686964652869290D0A7B0D0A2020206966202820692E737562737472696E6728302C3129203D3D202723272029207B0D0A2F2F207573696E67207374617469632069640D0A202020202020242869292E6869646528';
wwv_flow_api.g_varchar2_table(118) := '293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A202020202020617065782E6974656D2869292E6869646528293B0D0A2020207D0D0A7D3B0D0A0D0A66756E6374696F6E20656E61626C652869290D0A7B0D0A2020206966202820692E7375';
wwv_flow_api.g_varchar2_table(119) := '62737472696E6728302C3129203D3D202723272029207B0D0A2020202F2F207573696E67207374617469632069640D0A202020202020242869292E72656D6F7665436C6173732822617065785F64697361626C656422293B0D0A20202020202024286929';
wwv_flow_api.g_varchar2_table(120) := '2E63737328226F706163697479222C20223122293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A202020202020617065782E6974656D2869292E656E61626C6528293B0D0A2020207D0D0A7D0D0A0D0A66756E6374696F6E2064697361626C';
wwv_flow_api.g_varchar2_table(121) := '652869290D0A7B0D0A202020206966202820692E737562737472696E6728302C3129203D3D202723272029207B0D0A202020202F2F207573696E67207374617469632069640D0A202020202020242869292E616464436C6173732822617065785F646973';
wwv_flow_api.g_varchar2_table(122) := '61626C656422293B0D0A2020202020206966202820692E737562737472696E6728312C3229203D3D202742272029207B0D0A2020202020202F2F20697473206120627574746F6E2C2067726579206974206F75740D0A202020202020202020242869292E';
wwv_flow_api.g_varchar2_table(123) := '63737328226F706163697479222C20222E3322293B0D0A2020202020207D0D0A202020207D0D0A20202020656C73650D0A20202020202020207B0D0A202020202020202020617065782E6974656D2869292E64697361626C6528293B0D0A202020202020';
wwv_flow_api.g_varchar2_table(124) := '20207D0D0A7D3B0D0A0D0A66756E6374696F6E207365744E6F746966794469736D6973732820647572203D2064656661756C745F6E6F746966795F6469736D6973732029207B0D0A2020206966202820647572203D3D20302029207B0D0A202020202020';
wwv_flow_api.g_varchar2_table(125) := '617065782E7468656D6534322E7574696C2E636F6E666967415045584D736773287B6175746F4469736D6973733A2066616C73657D293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A202020202020617065782E7468656D6534322E757469';
wwv_flow_api.g_varchar2_table(126) := '6C2E636F6E666967415045584D736773287B6175746F4469736D6973733A20747275652C206475726174696F6E3A20647572207D293B0D0A2020207D0D0A7D0D0A0D0A66756E6374696F6E20637573746F6D4E6F74696679284D73675F696E2C20646973';
wwv_flow_api.g_varchar2_table(127) := '6D6973735F696E203D2064656661756C745F6E6F746966795F6469736D697373290D0A7B0D0A2020207365744E6F746966794469736D697373286469736D6973735F696E293B0D0A202020617065782E6D6573736167652E636C6561724572726F727328';
wwv_flow_api.g_varchar2_table(128) := '293B0D0A202020617065782E6D6573736167652E73686F775061676553756363657373284D73675F696E293B0D0A7D0D0A0D0A6173796E632066756E6374696F6E20676F746F5F49475F726F772869675F7374617469635F69645F696E2C20636F6C756D';
wwv_flow_api.g_varchar2_table(129) := '6E5F696E2C2076616C75655F696E2C2065786163745F696E2C20636173655F73656E7369746976655F696E2C2073746172745F696E6465785F696E203D202D312C20676F746F5F636F6C756D6E5F696E29207B0D0A20202076617220696720202020203D';
wwv_flow_api.g_varchar2_table(130) := '20617065782E726567696F6E2869675F7374617469635F69645F696E292E77696467657428293B0D0A202020766172206D6F64656C20203D2069672E696E746572616374697665477269642822676574566965777322292E677269642E6D6F64656C3B20';
wwv_flow_api.g_varchar2_table(131) := '202F2F6571756976616C656E743A20766172206D6F64656C203D20617065782E726567696F6E2822525F504152414D22292E77696467657428292E696E7465726163746976654772696428226765745669657773222C20226772696422292E6D6F64656C';
wwv_flow_api.g_varchar2_table(132) := '3B0D0A20202076617220676724202020203D2069672E696E74657261637469766547726964282267657443757272656E745669657722292E76696577243B0D0A202020766172206C696E655F6D6F72655F646174615F66657463686564203D2074727565';
wwv_flow_api.g_varchar2_table(133) := '3B0D0A202020766172206C696E655F666F756E645F726F77203D2066616C73653B0D0A2020207661722073746172745F696E6465783B0D0A202020766172207265745F696E6465783B0D0A202020766172206E756D726F77733B0D0A0D0A202020737461';
wwv_flow_api.g_varchar2_table(134) := '72745F696E646578203D2073746172745F696E6465785F696E203B0D0A0D0A2020207768696C652028216C696E655F666F756E645F726F77202626206C696E655F6D6F72655F646174615F6665746368656429207B0D0A2020202020206E756D726F7773';
wwv_flow_api.g_varchar2_table(135) := '203D206D6F64656C2E5F646174612E6C656E6774683B0D0A202020202020747279207B0D0A2020202020202020206D6F64656C2E666F7245616368282066756E6374696F6E28207265636F72642C20696E6465782C2069642029207B0D0A202020202020';
wwv_flow_api.g_varchar2_table(136) := '2020206966202820696E646578203E2073746172745F696E646578202626207265636F72642029207B0D0A202020202020202020202020696620282020282065786163745F696E203D3D2020275427202626206D6F64656C2E67657456616C7565282072';
wwv_flow_api.g_varchar2_table(137) := '65636F72642C20636F6C756D6E5F696E2029203D3D2076616C75655F696E20290D0A20202020202020202020202020207C7C0D0A2020202020202020202020202020282065786163745F696E203D3D2027462720262620636173655F73656E7369746976';
wwv_flow_api.g_varchar2_table(138) := '655F696E203D3D20275427202626206D6F64656C2E67657456616C756528207265636F72642C20636F6C756D6E5F696E20292E696E636C756465732876616C75655F696E2920290D0A20202020202020202020202020207C7C0D0A202020202020202020';
wwv_flow_api.g_varchar2_table(139) := '2020202020282065786163745F696E203D3D2027462720262620636173655F73656E7369746976655F696E203D3D20274627202626206D6F64656C2E67657456616C756528207265636F72642C20636F6C756D6E5F696E20292E746F4C6F776572436173';
wwv_flow_api.g_varchar2_table(140) := '6528292E696E636C756465732876616C75655F696E2E746F4C6F7765724361736528292920290D0A20202020202020202020202029207B0D0A20202020202020202020202020206C696E655F666F756E645F726F77203D20747275653B0D0A2020202020';
wwv_flow_api.g_varchar2_table(141) := '2020202020202020206966202820676F746F5F636F6C756D6E5F696E203D3D20756E646566696E65642029207B0D0A202020202020202020202020202020206767242E677269642827676F746F43656C6C272C6964293B0D0A2020202020202020202020';
wwv_flow_api.g_varchar2_table(142) := '2020207D0D0A2020202020202020202020202020656C73650D0A20202020202020202020202020207B0D0A202020202020202020202020202020206767242E677269642827676F746F43656C6C272C69642C676F746F5F636F6C756D6E5F696E293B0D0A';
wwv_flow_api.g_varchar2_table(143) := '20202020202020202020202020207D0D0A20202020202020202020202020207265745F696E646578203D2020696E6465783B0D0A20202020202020202020202020207468726F7722223B0D0A2020202020202020202020207D0D0A202020202020202020';
wwv_flow_api.g_varchar2_table(144) := '7D0D0A202020202020207D0D0A202020202020293B0D0A2020202020207D206361746368202865727229207B2072657475726E207265745F696E6465783B207D3B0D0A0D0A20202020202069662028216C696E655F666F756E645F726F7729207B0D0A20';
wwv_flow_api.g_varchar2_table(145) := '202020202020202073746172745F696E646578203D204D6174682E6D6178286E756D726F7773202D20312C2073746172745F696E6465785F696E293B0D0A2020202020202020206C696E655F6D6F72655F646174615F66657463686564203D2066616C73';
wwv_flow_api.g_varchar2_table(146) := '653B0D0A2020202020202020206177616974206D6F64656C2E6665746368286D6F64656C2E5F646174612E6C656E677468293B202F2F2063616E206F6E6C79206177616974206F6E20736F6D657468696E6720746861742072657475726E732061207072';
wwv_flow_api.g_varchar2_table(147) := '6F6D6973650D0A202020202020202020696620286E756D726F777320213D206D6F64656C2E5F646174612E6C656E67746829207B0D0A202020202020202020202020206C696E655F6D6F72655F646174615F66657463686564203D20747275653B0D0A20';
wwv_flow_api.g_varchar2_table(148) := '20202020202020207D0D0A2020202020207D0D0A2020207D3B0D0A20202072657475726E202D313B0D0A7D3B0D0A0D0A6173796E632066756E6374696F6E20676F746F5F49475F726F77322869675F7374617469635F69645F696E2C20636F6C756D6E5F';
wwv_flow_api.g_varchar2_table(149) := '696E2C2076616C75655F696E2C2065786163745F696E2C20636173655F73656E7369746976655F696E2C2073746172745F696E6465785F696E203D20302C20676F746F5F636F6C756D6E5F696E29207B0D0A2F2F2076657273696F6E2073706563696669';
wwv_flow_api.g_varchar2_table(150) := '63616C6C7920666F7220766965775F736F757263652020200D0A20202076617220696720202020203D20617065782E726567696F6E2869675F7374617469635F69645F696E292E77696467657428293B0D0A202020766172206D6F64656C20203D206967';
wwv_flow_api.g_varchar2_table(151) := '2E696E746572616374697665477269642822676574566965777322292E677269642E6D6F64656C3B20202F2F6571756976616C656E743A20766172206D6F64656C203D20617065782E726567696F6E2822525F504152414D22292E77696467657428292E';
wwv_flow_api.g_varchar2_table(152) := '696E7465726163746976654772696428226765745669657773222C20226772696422292E6D6F64656C3B0D0A20202076617220676724202020203D2069672E696E74657261637469766547726964282267657443757272656E745669657722292E766965';
wwv_flow_api.g_varchar2_table(153) := '77243B0D0A202020766172206C696E655F6D6F72655F646174615F66657463686564203D20747275653B0D0A202020766172206C696E655F666F756E645F726F77203D2066616C73653B0D0A2020207661722073746172745F696E6465783B0D0A202020';
wwv_flow_api.g_varchar2_table(154) := '766172206E756D6F77733B0D0A0D0A20202073746172745F696E646578203D2073746172745F696E6465785F696E203B0D0A0D0A2020207768696C652028216C696E655F666F756E645F726F77202626206C696E655F6D6F72655F646174615F66657463';
wwv_flow_api.g_varchar2_table(155) := '68656429207B0D0A202020202020206E756D726F7773203D206D6F64656C2E5F646174612E6C656E6774683B0D0A20202020202020666F7220286C65742069203D2073746172745F696E6465783B2069203C3D206E756D726F7773202D31203B20692B2B';
wwv_flow_api.g_varchar2_table(156) := '29207B0D0A20202020202020202020207265636F7264203D206D6F64656C2E6765745265636F726428207061727365496E742869292B3120293B0D0A20202020202020202020200D0A2020202020202020696620282020282065786163745F696E203D3D';
wwv_flow_api.g_varchar2_table(157) := '2020275427202626206D6F64656C2E67657456616C756528207265636F72642C20636F6C756D6E5F696E2029203D3D2076616C75655F696E20290D0A20202020202020202020202020207C7C0D0A2020202020202020202020202020282065786163745F';
wwv_flow_api.g_varchar2_table(158) := '696E203D3D2027462720262620636173655F73656E7369746976655F696E203D3D20275427202626206D6F64656C2E67657456616C756528207265636F72642C20636F6C756D6E5F696E20292E696E636C756465732876616C75655F696E2920290D0A20';
wwv_flow_api.g_varchar2_table(159) := '202020202020202020202020207C7C0D0A2020202020202020202020202020282065786163745F696E203D3D2027462720262620636173655F73656E7369746976655F696E203D3D20274627202626206D6F64656C2E67657456616C756528207265636F';
wwv_flow_api.g_varchar2_table(160) := '72642C20636F6C756D6E5F696E20292E746F4C6F7765724361736528292E696E636C756465732876616C75655F696E2E746F4C6F7765724361736528292920290D0A202020202020202020202029207B0D0A2020202020202020202020206C696E655F66';
wwv_flow_api.g_varchar2_table(161) := '6F756E645F726F77203D20747275653B0D0A20202020202020202020202072657475726E20693B0D0A20202020202020202020207D20202020202020202020200D0A202020202020207D0D0A20202020202069662028216C696E655F666F756E645F726F';
wwv_flow_api.g_varchar2_table(162) := '7729207B0D0A20202020202020202073746172745F696E646578203D204D6174682E6D6178286E756D726F7773202D20312C2073746172745F696E6465785F696E293B0D0A2020202020202020206C696E655F6D6F72655F646174615F66657463686564';
wwv_flow_api.g_varchar2_table(163) := '203D2066616C73653B0D0A2020202020202020206177616974206D6F64656C2E6665746368286D6F64656C2E5F646174612E6C656E677468293B202F2F2063616E206F6E6C79206177616974206F6E20736F6D657468696E672074686174207265747572';
wwv_flow_api.g_varchar2_table(164) := '6E7320612070726F6D6973650D0A202020202020202020696620286E756D726F777320213D206D6F64656C2E5F646174612E6C656E67746829207B0D0A202020202020202020202020206C696E655F6D6F72655F646174615F66657463686564203D2074';
wwv_flow_api.g_varchar2_table(165) := '7275653B0D0A2020202020202020207D0D0A20202020207D0D0A2020207D3B0D0A20202072657475726E202D313B0D0A7D3B0D0A0D0A66756E6374696F6E2073686F775F6C6F76286C6F765F6974656D5F696E2C207469746C655F696E2C2073686F775F';
wwv_flow_api.g_varchar2_table(166) := '636C6F73655F696E2C2073686F775F7365617263686261725F696E29207B0D0A20207661722073656C202020203D202723506F7075704C6F765F27202B202476282770466C6F775374657049642729202B20275F27202B206C6F765F6974656D5F696E20';
wwv_flow_api.g_varchar2_table(167) := '2B20275F646C67273B0D0A2F2F20656720506F7075704C6F765F325F50325F4155544F5F544558545F4C4F565F646C670D0A2F2F2068617320746F20626520696E2074686973206F72646572210D0A20202428646F63756D656E742E717565727953656C';
wwv_flow_api.g_varchar2_table(168) := '6563746F72282223222B6C6F765F6974656D5F696E2B225F6C6F765F62746E2229292E747269676765722822636C69636B22293B0D0A0D0A2020696620282073686F775F636C6F73655F696E203D3D202754272029207B0D0A2020202020617065782E75';
wwv_flow_api.g_varchar2_table(169) := '74696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F67287B6469616C6F67436C6173733A20227965732D636C6F7365227D293B0D0A2020202020617065782E7574696C2E676574546F704170657828292E6A5175657279';
wwv_flow_api.g_varchar2_table(170) := '2873656C292E6469616C6F6728226F7074696F6E222C2022636C6F73654F6E457363617065222C2074727565293B0D0A20207D0D0A2020656C73650D0A20207B0D0A20202F2F20746869732072656C696573206F6E20696E6C696E652043535320626569';
wwv_flow_api.g_varchar2_table(171) := '6E6720736574207570204F4E205448452043414C4C494E4720504147453A202E6E6F2D636C6F7365202E75692D6469616C6F672D7469746C656261722D636C6F7365207B2020646973706C61793A206E6F6E653B207D0D0A2020202020617065782E7574';
wwv_flow_api.g_varchar2_table(172) := '696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F67287B6469616C6F67436C6173733A20226E6F2D636C6F7365227D293B0D0A2020202020617065782E7574696C2E676574546F704170657828292E6A51756572792873';
wwv_flow_api.g_varchar2_table(173) := '656C292E6469616C6F6728226F7074696F6E222C2022636C6F73654F6E457363617065222C2066616C7365293B0D0A20207D0D0A2020617065782E7574696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F6728276F7074';
wwv_flow_api.g_varchar2_table(174) := '696F6E272C20277469746C65272C207469746C655F696E293B0D0A2F2F2072656D6F766520616E7920696E68657269746564207469746C652062617220636F6C6F757220286D61792068617665206265656E2063616C6C65642066726F6D206120646961';
wwv_flow_api.g_varchar2_table(175) := '6C6F67756520776865726520636F6C6F757220686173206265656E206F76657272696464656E290D0A20202428646F63756D656E742E717565727953656C6563746F7228226469762E75692D6469616C6F672E75692D6469616C6F672D706F7075706C6F';
wwv_flow_api.g_varchar2_table(176) := '76203E206469762E75692D6469616C6F672D7469746C656261722229292E63737328226261636B67726F756E642D636F6C6F72222C2222293B0D0A0D0A2020696620282073686F775F7365617263686261725F696E203D3D202754272029207B0D0A2020';
wwv_flow_api.g_varchar2_table(177) := '2020202428646F63756D656E742E717565727953656C6563746F722873656C202B2022203E206469762E612D506F7075704C4F562D7365617263684261722229292E6373732822646973706C6179222C2222293B0D0A20207D0D0A2020656C73650D0A20';
wwv_flow_api.g_varchar2_table(178) := '207B0D0A20202020202428646F63756D656E742E717565727953656C6563746F722873656C202B2022203E206469762E612D506F7075704C4F562D7365617263684261722229292E6373732822646973706C6179222C226E6F6E6522293B0D0A20207D0D';
wwv_flow_api.g_varchar2_table(179) := '0A7D0D0A0D0A6173796E632066756E6374696F6E206F70656E5F696E6C696E655F69675F6469616C6F67286469616C6F675F696E2C2069675F726567696F6E5F696E2C207469746C655F696E2C2073686F775F636C6F73655F696E2C20636C6F73655F6F';
wwv_flow_api.g_varchar2_table(180) := '6E5F6573636170655F696E2C20666F6375735F69665F7A65726F5F696E2C20766572746963616C5F6F66667365745F696E2C20686F72697A6F6E616C5F6F66667365745F696E29207B0D0A20202076617220696720202020203D20617065782E72656769';
wwv_flow_api.g_varchar2_table(181) := '6F6E2869675F726567696F6E5F696E292E77696467657428293B0D0A202020766172206D6F64656C20203D2069672E696E746572616374697665477269642822676574566965777322292E677269642E6D6F64656C3B20202F2F6571756976616C656E74';
wwv_flow_api.g_varchar2_table(182) := '3A20766172206D6F64656C203D20617065782E726567696F6E2822525F504152414D22292E77696467657428292E696E7465726163746976654772696428226765745669657773222C20226772696422292E6D6F64656C3B0D0A20202076617220676724';
wwv_flow_api.g_varchar2_table(183) := '202020203D2069672E696E74657261637469766547726964282267657443757272656E745669657722292E76696577243B0D0A2020207661722073656C202020203D202723272B6469616C6F675F696E2B272E75692D6469616C6F672D636F6E74656E74';
wwv_flow_api.g_varchar2_table(184) := '273B0D0A0D0A2F2F207769706520746865206D6F64656C0D0A20202069672E696E74657261637469766547726964282022676574416374696F6E732220292E73657428202265646974222C2066616C736520293B0D0A2F2F20636C656172206461746120';
wwv_flow_api.g_varchar2_table(185) := '2D204D55535420626520646F6E65206265666F726520636C6561724368616E6765730D0A202020747279207B0D0A2F2F207468697320736F6D6574696D6573206661696C73202E2E2E2069676E6F72650D0A2020202020206D6F64656C2E636C65617244';
wwv_flow_api.g_varchar2_table(186) := '61746128293B0D0A2020207D0D0A2020206361746368202865727229207B0D0A2020202020206E756C6C3B0D0A2020207D3B0D0A2F2F20636C65617220616E79206368616E676573202D2077696C6C207375707072657373207468657265206172652070';
wwv_flow_api.g_varchar2_table(187) := '656E64696E67206368616E676573206D6573736167650D0A2020206D6F64656C2E636C6561724368616E67657328293B0D0A0D0A2020206177616974206D6F64656C2E666574636828293B0D0A0D0A202020676C6F62616C5F696E646578203D202D313B';
wwv_flow_api.g_varchar2_table(188) := '0D0A202020617065782E7574696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F6728276F7074696F6E272C20277469746C65272C207469746C655F696E293B0D0A2F2F204F7074696F6E7320666F7220636C6F73696E67';
wwv_flow_api.g_varchar2_table(189) := '20746865206D6F64616C202E2E2E0D0A2F2F2048696465206F722073686F7720746865205820696E2074686520746F70207269676874202E2E2E20746869732072656C696573206F6E20696E6C696E6520435353206265696E6720736574207570204F4E';
wwv_flow_api.g_varchar2_table(190) := '205448452043414C4C494E4720504147453A202E6E6F2D636C6F7365202E75692D6469616C6F672D7469746C656261722D636C6F7365207B2020646973706C61793A206E6F6E653B207D20202E7965732D636C6F7365202E75692D6469616C6F672D7469';
wwv_flow_api.g_varchar2_table(191) := '746C656261722D636C6F7365207B2020646973706C61793A20696E6C696E653B207D0D0A202020696620282073686F775F636C6F73655F696E203D3D202754272029207B0D0A202020202020617065782E7574696C2E676574546F704170657828292E6A';
wwv_flow_api.g_varchar2_table(192) := '51756572792873656C292E6469616C6F67287B6469616C6F67436C6173733A20227965732D636C6F7365227D293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A202020202020617065782E7574696C2E676574546F704170657828292E6A51';
wwv_flow_api.g_varchar2_table(193) := '756572792873656C292E6469616C6F67287B6469616C6F67436C6173733A20226E6F2D636C6F7365227D293B0D0A2020207D3B0D0A2F2F20416C6C6F77206F7220646973616C6C6F772074686520455343206B657920746F20636C6F73650D0A20202069';
wwv_flow_api.g_varchar2_table(194) := '66202820636C6F73655F6F6E5F6573636170655F696E203D3D202754272029207B0D0A202020202020617065782E7574696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F6728226F7074696F6E222C2022636C6F73654F';
wwv_flow_api.g_varchar2_table(195) := '6E457363617065222C2074727565293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A202020202020617065782E7574696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F6728226F7074696F6E222C2022636C';
wwv_flow_api.g_varchar2_table(196) := '6F73654F6E457363617065222C2066616C7365293B0D0A2020207D3B0D0A0D0A202020617065782E7574696C2E676574546F704170657828292E6A51756572792873656C292E6469616C6F6728276F7074696F6E272C2027706F736974696F6E272C207B';
wwv_flow_api.g_varchar2_table(197) := '206D793A202263656E7465722063656E746572222C2061743A202263656E746572222B6E766C28686F72697A6F6E616C5F6F66667365745F696E2C2727292B222063656E746572222B6E766C28766572746963616C5F6F66667365745F696E2C2727292C';
wwv_flow_api.g_varchar2_table(198) := '206F663A2077696E646F777D293B0D0A0D0A20202069662028206D6F64656C2E5F646174612E6C656E677468203D3D20302020262620666F6375735F69665F7A65726F5F696E203D3D206E756C6C2029207B202F2F203D3D206E756C6C20636F76657273';
wwv_flow_api.g_varchar2_table(199) := '20626F746820276E756C6C272070617373656420696E20616E64206E6F2076616C756520617420616C6C20692E652E20756E646566696E65640D0A202020202020637573746F6D416C65727428202749272C20274E6F204461746120466F756E64272C20';
wwv_flow_api.g_varchar2_table(200) := '274E6F20646174612072657475726E656420666F72202E2E2E5C6E5C6E27202B207469746C655F696E2C20274F4B2720293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A2020202020206F70656E4D6F64616C286469616C6F675F696E293B';
wwv_flow_api.g_varchar2_table(201) := '0D0A0D0A20202020202069662028206D6F64656C2E5F646174612E6C656E677468203D3D20302029207B0D0A2020202020202F2F20676F20746F20746865206974656D2073706563696669656420696E7374656164206F662074686520677269640D0A20';
wwv_flow_api.g_varchar2_table(202) := '20202020202020206966202820666F6375735F69665F7A65726F5F696E2E737562737472696E6728302C3129203D3D202723272029207B0D0A2020202020202020202F2F207573696E67207374617469632069640D0A202020202020202020202020646F';
wwv_flow_api.g_varchar2_table(203) := '63756D656E742E717565727953656C6563746F7228666F6375735F69665F7A65726F5F696E292E666F63757328293B0D0A2020202020202020207D0D0A202020202020202020656C73650D0A2020202020202020207B0D0A202020202020202020202020';
wwv_flow_api.g_varchar2_table(204) := '617065782E6974656D2820666F6375735F69665F7A65726F5F696E20292E736574466F63757328293B0D0A2020202020202020207D0D0A2020202020207D0D0A202020202020656C73650D0A2020202020207B0D0A2020202020202F2F20736574207365';
wwv_flow_api.g_varchar2_table(205) := '6C656374696F6E20746F2031737420726F7720616E6420616C736F206769766520666F63757320287472756520706172616D290D0A2020202020202020206767242E6772696428202273657453656C656374696F6E222C205B6767242E66696E64282022';
wwv_flow_api.g_varchar2_table(206) := '2E612D47562D772D7363726F6C6C202E612D47562D726F772220292E65712831295D202C207472756520293B0D0A2020202020207D0D0A2020207D3B0D0A7D3B0D0A0D0A6173796E632066756E6374696F6E206F70656E5F696E6C696E655F6469616C6F';
wwv_flow_api.g_varchar2_table(207) := '6728726567696F6E5F696E2C207469746C655F696E2C2073686F775F636C6F73655F696E2C20636C6F73655F6F6E5F6573636170655F696E2C20766572746963616C5F6F66667365745F696E2C20686F72697A6F6E616C5F6F66667365745F696E29207B';
wwv_flow_api.g_varchar2_table(208) := '0D0A0D0A2F2F207573696E6720242829206865726520696E7374656164206F6620617065782E7574696C2E676574546F704170657828292E6A51756572792873656C29206173207468617420646F6573206E6F74207365656D20746F20776F726B207768';
wwv_flow_api.g_varchar2_table(209) := '656E2063616C6C696E6720696E6C696E65206D6F64616C7320726F6D2041504558206469616C6F672050414745530D0A2020207661722073656C203D2024282723272B726567696F6E5F696E2B272E75692D6469616C6F672D636F6E74656E7427293B0D';
wwv_flow_api.g_varchar2_table(210) := '0A0D0A202020617065782E726567696F6E28726567696F6E5F696E292E7265667265736828293B0D0A0D0A20202073656C2E6469616C6F6728276F7074696F6E272C20277469746C65272C207469746C655F696E293B0D0A2F2F204D616B652073757265';
wwv_flow_api.g_varchar2_table(211) := '20746865792063616E6E6F74206869742065736361706520746F20636C6F736520746865206D6F64616C0D0A202020696620282073686F775F636C6F73655F696E203D3D202754272029207B0D0A20202020202073656C2E6469616C6F67287B6469616C';
wwv_flow_api.g_varchar2_table(212) := '6F67436C6173733A20227965732D636C6F7365227D293B0D0A2020207D0D0A202020656C73650D0A2020207B0D0A2020202F2F20746869732072656C696573206F6E20696E6C696E6520435353206265696E67207365742075703A202E6E6F2D636C6F73';
wwv_flow_api.g_varchar2_table(213) := '65202E75692D6469616C6F672D7469746C656261722D636C6F7365207B2020646973706C61793A206E6F6E653B207D0D0A20202020202073656C2E6469616C6F67287B6469616C6F67436C6173733A20226E6F2D636C6F7365227D293B0D0A2020207D3B';
wwv_flow_api.g_varchar2_table(214) := '0D0A2020206966202820636C6F73655F6F6E5F6573636170655F696E203D3D202754272029207B0D0A20202020202073656C2E6469616C6F6728276F7074696F6E272C2027636C6F73654F6E457363617065272C2074727565293B0D0A2020207D0D0A20';
wwv_flow_api.g_varchar2_table(215) := '2020656C73650D0A2020207B0D0A20202020202073656C2E6469616C6F6728276F7074696F6E272C2027636C6F73654F6E457363617065272C2066616C7365293B0D0A2020207D3B0D0A0D0A20202073656C2E6469616C6F6728276F7074696F6E272C20';
wwv_flow_api.g_varchar2_table(216) := '27706F736974696F6E272C207B206D793A202263656E7465722063656E746572222C2061743A202263656E746572222B6E766C28686F72697A6F6E616C5F6F66667365745F696E2C2727292B222063656E746572222B6E766C28766572746963616C5F6F';
wwv_flow_api.g_varchar2_table(217) := '66667365745F696E2C2727292C206F663A2077696E646F777D293B0D0A0D0A2F2F20646F6E6520696E20612074696D6572206173207365656E20697373756573207769746820317374206974656D206E6F742067657474696E6720666F6375730D0A2020';
wwv_flow_api.g_varchar2_table(218) := '2073657454696D656F75742866756E6374696F6E202829207B0D0A2020202020206F70656E4D6F64616C28726567696F6E5F696E293B0D0A2020207D2C31293B0D0A0D0A7D3B0D0A0D0A';
null;
end;
/
begin
wwv_flow_api.create_app_static_file(
 p_id=>wwv_flow_api.id(38352710844167358)
,p_file_name=>'cronology.js'
,p_mime_type=>'text/javascript'
,p_file_charset=>'utf-8'
,p_file_content => wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
null;
end;
/
prompt --application/plugin_settings
begin
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24179361840741717)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24179635486741719)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24179927947741720)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24180262632741722)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24180617162741724)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'modern'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24180834759741724)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_api.create_plugin_setting(
 p_id=>wwv_flow_api.id(24181195685741726)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
end;
/
prompt --application/shared_components/security/authorizations/cronology_a
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(24344349155760999)
,p_name=>'CRONOLOGY_A'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from dba_role_privs',
'where grantee = :app_user',
'and granted_role in (''CRONOLOGY_ADMINISTRATOR'')'))
,p_error_message=>'You must be a CRONOLOGY Adinistrator to perform this action'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/cronology_ao
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(24344557412768325)
,p_name=>'CRONOLOGY_AO'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from dba_role_privs',
'where grantee = :app_user',
'and granted_role in (''CRONOLOGY_ADMINISTRATOR'',''CRONOLOGY_OPERATOR'')'))
,p_error_message=>'You must be a CRONOLOGY adinistrator or operator to perform this action'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/cronology_aor
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(24344738422782061)
,p_name=>'CRONOLOGY_AOR'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select count(*) from dba_role_privs',
'where grantee = :app_user',
'and granted_role in (''CRONOLOGY_ADMINISTRATOR'',',
'''CRONOLOGY_READONLY'',''CRONOLOGY_OPERATOR'')',
'having count(*) = 1'))
,p_error_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'You must be granted one (and only one) of the following database roles to perform this action:',
'CRONOLOGY_ADMINISTATOR | CRONOLOGY_OPERATOR | CRONOLOGY_READONLY'))
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/administration_rights
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(35437810033199452)
,p_name=>'Administration Rights'
,p_scheme_type=>'NATIVE_IS_IN_GROUP'
,p_attribute_01=>'Administrator'
,p_attribute_02=>'A'
,p_error_message=>'Insufficient privileges, user is not an Administrator'
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/contribution_rights
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(35438102670199456)
,p_name=>'Contribution Rights'
,p_scheme_type=>'NATIVE_IS_IN_GROUP'
,p_attribute_01=>'Administrator,Contributor'
,p_attribute_02=>'A'
,p_error_message=>'Insufficient privileges, user is not a Contributor'
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/reader_rights
begin
wwv_flow_api.create_security_scheme(
 p_id=>wwv_flow_api.id(35438390336199456)
,p_name=>'Reader Rights'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(apex_app_setting.get_value(',
'   p_name => ''ACCESS_CONTROL_SCOPE''),''x'') = ''ALL_USERS'' then',
'    -- allow user not in the ACL to access the application',
'    return true;',
'else',
'    -- require user to have at least one role',
'    return apex_acl.has_user_any_roles (',
'        p_application_id => :APP_ID, ',
'        p_user_name      => :APP_USER);',
'end if;'))
,p_error_message=>'You are not authorized to view this application, either because you have not been granted access, or your account has been locked. Please contact the application administrator.'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/app_access_control/administrator
begin
wwv_flow_api.create_acl_role(
 p_id=>wwv_flow_api.id(35437349995199450)
,p_static_id=>'ADMINISTRATOR'
,p_name=>'Administrator'
,p_description=>'Role assigned to application administrators.'
);
end;
/
prompt --application/shared_components/security/app_access_control/contributor
begin
wwv_flow_api.create_acl_role(
 p_id=>wwv_flow_api.id(35437524471199452)
,p_static_id=>'CONTRIBUTOR'
,p_name=>'Contributor'
,p_description=>'Role assigned to application contributors.'
);
end;
/
prompt --application/shared_components/security/app_access_control/reader
begin
wwv_flow_api.create_acl_role(
 p_id=>wwv_flow_api.id(35437703285199452)
,p_static_id=>'READER'
,p_name=>'Reader'
,p_description=>'Role assigned to application readers.'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_items
begin
wwv_flow_api.create_flow_item(
 p_id=>wwv_flow_api.id(26277796361390129)
,p_name=>'DB_DETAILS'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_computations
begin
wwv_flow_api.create_flow_computation(
 p_id=>wwv_flow_api.id(26278146814413437)
,p_computation_sequence=>10
,p_computation_item=>'DB_DETAILS'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'   if UPPER(SYS_CONTEXT(''USERENV'',''DB_NAME'')) = UPPER(SYS_CONTEXT(''USERENV'',''INSTANCE_NAME'')) then',
'   return UPPER(SYS_CONTEXT(''USERENV'',''DB_NAME''));',
'else',
'   return UPPER(SYS_CONTEXT(''USERENV'',''INSTANCE_NAME''))|| -- container instance if a cdb',
'   '' (''||UPPER(SYS_CONTEXT(''USERENV'',''DB_NAME''))||'')'';    -- plug db name if a pdb',
'end if;',
'end;'))
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
wwv_flow_api.create_app_setting(
 p_id=>wwv_flow_api.id(35437148777199447)
,p_name=>'ACCESS_CONTROL_SCOPE'
,p_value=>'ACL_ONLY'
,p_is_required=>'N'
,p_valid_values=>'ACL_ONLY, ALL_USERS'
,p_on_upgrade_keep_value=>true
,p_required_patch=>wwv_flow_api.id(35436897437199438)
,p_comments=>'The default access level given to authenticated users who are not in the access control list'
);
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/access_roles
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(35452375787199521)
,p_lov_name=>'ACCESS_ROLES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select role_name d, role_id r',
'from APEX_APPL_ACL_ROLES where application_id = :APP_ID ',
'order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auto_text
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(25775311821328359)
,p_lov_name=>'AUTO_TEXT'
,p_lov_query=>'select auto_text d, auto_text r from console_auto_text order by 1'
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_username_credentials
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(36980353888046000)
,p_lov_name=>'DB_USERNAME_CREDENTIALS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct username, db_conn_string, nvl(db_conn_string,'' '') db_conn_string_disp, username||''|''||nvl(db_conn_string,''<NULL>'') pk',
'from   job',
'where  username is not null',
'order by 1, 2 nulls first'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'PK'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(36980774701048442)
,p_query_column_name=>'USERNAME'
,p_heading=>'Username'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37042474253450719)
,p_query_column_name=>'DB_CONN_STRING_DISP'
,p_heading=>'DB Connect String'
,p_display_sequence=>15
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(36981216963048443)
,p_query_column_name=>'DB_CONN_STRING'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(38345146136463766)
,p_query_column_name=>'PK'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/email_addresses
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(36956843371292430)
,p_lov_name=>'EMAIL_ADDRESSES'
,p_source_type=>'TABLE'
,p_location=>'LOCAL'
,p_query_table=>'JOB_EMAIL_ADDRESSES_V'
,p_return_column_name=>'EMAIL_ADDRESS'
,p_display_column_name=>'EMAIL_ADDRESS'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'EMAIL_ADDRESS'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(36957398966296084)
,p_query_column_name=>'EMAIL_ADDRESS'
,p_heading=>'E-mail Address'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(36957772425296085)
,p_query_column_name=>'REFERENCED'
,p_heading=>'Referenced'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
,p_is_searchable=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/email_username_format
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(35460100379199539)
,p_lov_name=>'EMAIL_USERNAME_FORMAT'
,p_lov_query=>'.'||wwv_flow_api.id(35460100379199539)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(35460372420199539)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Email Addresses'
,p_lov_return_value=>'EMAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/install_info
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(31786688506946876)
,p_lov_name=>'INSTALL_INFO'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select install_status, object_type, object_name, status, granted, grantor',
'from   installation_info',
'where  install_status not in (''VALID'',''CURRENT'')',
'order  by 1,2,3,4,5,6',
''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'INSTALL_STATUS'
,p_display_column_name=>'INSTALL_STATUS'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31787169751952929)
,p_query_column_name=>'INSTALL_STATUS'
,p_heading=>'Invalid Reason'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31787540180952930)
,p_query_column_name=>'OBJECT_TYPE'
,p_heading=>'Object Type'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31787971774952930)
,p_query_column_name=>'OBJECT_NAME'
,p_heading=>'Object Name'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31788362204952930)
,p_query_column_name=>'STATUS'
,p_heading=>'Info 1'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31788737178952930)
,p_query_column_name=>'GRANTED'
,p_heading=>'Info 2'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(31789124826952931)
,p_query_column_name=>'GRANTOR'
,p_heading=>'Info 3'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jobs_dep_on_this_job
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(29827166504595431)
,p_lov_name=>'JOBS_DEP_ON_THIS_JOB'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select j.job_name,',
'       decode(j.job_online,''Y'',''Online'',''N'',''Offline'') status,',
'       case (select count(*) from job_param_dependencies jpd',
'             where jpd.job_id = j.job_id',
'             and   jpd.dependent_job_id = jd.dependent_job_id) when 0 then ''Parallel''',
'          else',
'             ''Parameter''   ',
'       end  dependency_type',
'from   job j,',
'       job_dependencies_v jd',
'where  j.job_id = jd.job_id',
'and    jd.dependent_job_id = :P2_JOB_ID',
'order by j.job_name',
''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_NAME'
,p_display_column_name=>'JOB_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'JOB_NAME'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(29828606687650170)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(29838850407795691)
,p_query_column_name=>'STATUS'
,p_heading=>'Status'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(36439947746328479)
,p_query_column_name=>'DEPENDENCY_TYPE'
,p_heading=>'Dependency Type'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/job_params
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(30826112814237366)
,p_lov_name=>'JOB_PARAMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select job_id||''-''||param_id||''-''||param_order pk, job_id, param_id, param_order, name, type, initcap(data_type) data_type',
'from   cronology.job_parameters_v',
'where  job_id = :P2_JOB_PARAMS_JOB_ID',
'order  by param_order'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'PK'
,p_display_column_name=>'NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30842087295724053)
,p_query_column_name=>'JOB_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30855182168107678)
,p_query_column_name=>'PK'
,p_heading=>'Pk'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30842464804724054)
,p_query_column_name=>'PARAM_ID'
,p_heading=>'Param Id'
,p_display_sequence=>20
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30842891609724055)
,p_query_column_name=>'PARAM_ORDER'
,p_heading=>'Param Order'
,p_display_sequence=>30
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30843319833724055)
,p_query_column_name=>'NAME'
,p_heading=>'Name'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30843628965724055)
,p_query_column_name=>'TYPE'
,p_heading=>'Type'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30844037644724056)
,p_query_column_name=>'DATA_TYPE'
,p_heading=>'Data Type'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_remember_username
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(24324199150742727)
,p_lov_name=>'LOGIN_REMEMBER_USERNAME'
,p_lov_query=>'.'||wwv_flow_api.id(24324199150742727)||'.'
,p_location=>'STATIC'
);
wwv_flow_api.create_static_lov_data(
 p_id=>wwv_flow_api.id(24324520623742732)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Remember username'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/message_history
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33913989696387590)
,p_lov_name=>'MESSAGE_HISTORY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select sub_dttm, ',
'       send_dttm,',
'       decode(send_status,null,''Success'',',
'                          ''S'' ,''Sending'',',
'                          ''F'' ,''Error'' ,',
'                          ''P'' ,decode(msg_failure_info,null,''Pending'',',
'                                      ''Pending Retry'')) send_status,',
'send_attempts ,',
'SENT_BY_USER     ,',
'SENT_BY_MODULE  , ',
'MESSAGE_TYPE     ,',
'substr(SENT_TO,1,2000) sent_to          ,',
'substr(SUBJECT,1,2000) subject          ,',
'substr(decode(job_id,null,MESSAGE, decode  (job_sub_dttm,null,''** JOB COMPLETION MESSAGE **'', ''** JOB LOG **'')),1,2000) MESSAGE ,',
'substr(MSG_FAILURE_INFO,1,2000) msg_failure_info ,',
'decode(msg_failure_info,null,null,substr(to_char(CALL_ERROR_ID),1,6)) CALL_ERROR_ID,',
'rowid rid',
'from message_history',
'order by send_dttm desc'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RID'
,p_display_column_name=>'RID'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34006734149621997)
,p_query_column_name=>'RID'
,p_display_sequence=>10
,p_data_type=>'ROWID'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33914847867391598)
,p_query_column_name=>'SEND_DTTM'
,p_heading=>'Send / Retry Time'
,p_display_sequence=>20
,p_data_type=>'DATE'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33915243168391598)
,p_query_column_name=>'SEND_STATUS'
,p_heading=>'Send Status'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33915666227391599)
,p_query_column_name=>'SEND_ATTEMPTS'
,p_heading=>'Send Attempts'
,p_display_sequence=>40
,p_data_type=>'NUMBER'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33914495982391597)
,p_query_column_name=>'SUB_DTTM'
,p_heading=>'Submit Time'
,p_display_sequence=>45
,p_data_type=>'DATE'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33916835981391600)
,p_query_column_name=>'MESSAGE_TYPE'
,p_heading=>'Message Type'
,p_display_sequence=>47
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33917646951391601)
,p_query_column_name=>'SUBJECT'
,p_heading=>'Subject / Content'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33917271920391601)
,p_query_column_name=>'SENT_TO'
,p_heading=>'Sent To'
,p_display_sequence=>55
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33918071360391601)
,p_query_column_name=>'MESSAGE'
,p_heading=>'Message / Additional Info'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33916096235391599)
,p_query_column_name=>'SENT_BY_USER'
,p_heading=>'Sent By User'
,p_display_sequence=>70
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33916501820391600)
,p_query_column_name=>'SENT_BY_MODULE'
,p_heading=>'Sent By Module'
,p_display_sequence=>80
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33918446322391602)
,p_query_column_name=>'MSG_FAILURE_INFO'
,p_heading=>'Error Information'
,p_display_sequence=>110
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33918909628391603)
,p_query_column_name=>'CALL_ERROR_ID'
,p_heading=>'Internal Error ID'
,p_display_sequence=>120
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/offline_jobs_3
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(34830224769999080)
,p_lov_name=>'OFFLINE_JOBS_3'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /*+ RULE */',
' job_id,',
' job_name,',
' job_description,',
' source_type, ',
' source_name,',
' parent_offline,',
' parent_job_name',
'  from (select j.JOB_ID,',
'               j.SOURCE_NAME,',
'               (select description',
'                  from job_source_types jst',
'                 where jst.source_type = j.source_type) source_type,',
'               substr(lpad(''   '', 2 * (level - 1)) || j.job_name, 1, 2000) job_name,',
'               j.JOB_DESCRIPTION,',
'               (select nvl(max(''Y''),''N'')',
'                from   job pj',
'                where  pj.job_id = j.parent_job_id',
'                and    pj.job_online = ''N'') parent_offline,',
'               (select job_name from job pjn where pjn.job_id = j.parent_job_id) parent_job_name',
'          from job j',
'         where j.job_online = ''N''',
'         start with j.schedule_type = ''TIMED''',
'        connect by prior j.job_id = j.parent_job_id)'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_ID'
,p_display_column_name=>'JOB_ID'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'JOB_ID'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34830661056001108)
,p_query_column_name=>'JOB_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34831120085001109)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34831484984001109)
,p_query_column_name=>'JOB_DESCRIPTION'
,p_heading=>'Job Description'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34831854551001110)
,p_query_column_name=>'SOURCE_TYPE'
,p_heading=>'Source Type'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34832248670001110)
,p_query_column_name=>'SOURCE_NAME'
,p_heading=>'Source Name'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34832650744001111)
,p_query_column_name=>'PARENT_OFFLINE'
,p_heading=>'Parent Offline'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(34833091481001112)
,p_query_column_name=>'PARENT_JOB_NAME'
,p_heading=>'Parent Job Name'
,p_display_sequence=>70
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/online_jobs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(30626419070165143)
,p_lov_name=>'ONLINE_JOBS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select job_id, ',
'       lpad(external.get_child_ind,4*(j_level-1))||'' ''||job_name        job_name,',
'       job_name                                           job_name_trimmed',
'from   job_v',
''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_ID'
,p_display_column_name=>'JOB_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30663469797808236)
,p_query_column_name=>'JOB_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30663900143808237)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(30664268534808238)
,p_query_column_name=>'JOB_NAME_TRIMMED'
,p_heading=>'Job Name Trimmed'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ordered_source_2
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(37803338947155824)
,p_lov_name=>'ORDERED_SOURCE_2'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select j.job_id,',
'       j.source_name,',
'       st.description source_type,',
'       j.job_name, ',
'       decode(j.job_online,''Y'',''Online'',''N'',''Offline'') status',
'from   job j',
'join   job_source_types st',
'on     j.source_type = st.source_type',
'order  by 2,3,4'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_ID'
,p_display_column_name=>'JOB_ID'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37805363922159000)
,p_query_column_name=>'JOB_ID'
,p_heading=>'Job Id'
,p_display_sequence=>5
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37803751648158998)
,p_query_column_name=>'SOURCE_NAME'
,p_heading=>'Source Name'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37804195520158998)
,p_query_column_name=>'SOURCE_TYPE'
,p_heading=>'Source Type'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37804556219158999)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37805010007158999)
,p_query_column_name=>'STATUS'
,p_heading=>'Status'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/overdue_jobs
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33774640582320974)
,p_lov_name=>'OVERDUE_JOBS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select a.job_name,',
'       to_char(a.next_sub_dttm,''DD-MON-YYYY HH24:MI:SS'') next_sub_dttm',
'from   job_v a, job b',
'where  a.next_sub_dttm < sysdate',
'and    nvl(a.ok_to_continue,''Y'') = ''Y''',
'and    b.job_id = a.job_id',
'and    b.overdue_behaviour = ''C''',
'order  by a.next_sub_dttm'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_NAME'
,p_display_column_name=>'JOB_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33775161945323958)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33775549496323959)
,p_query_column_name=>'NEXT_SUB_DTTM'
,p_heading=>'Next Submit Date Time'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameters
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33137602085837363)
,p_lov_name=>'PARAMETERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select param_id,',
'type,',
'case type when ''FIXED'' then ''Fixed'' when ''ENVVAR'' then ''Environment Variable'' when ''SQL'' then ''SQL'' end disp_type,',
'name, ',
'source, ',
'description, ',
'data_type,',
'initcap(data_type) disp_data_type, ',
'value, ',
'override_value, ',
'conceal_values,',
'coalesce(source,value) source_value',
'from     parameters',
'where    param_id > 0',
'order by name'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'PARAM_ID'
,p_display_column_name=>'PARAM_ID'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33138288116838569)
,p_query_column_name=>'PARAM_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33139053111838570)
,p_query_column_name=>'NAME'
,p_heading=>'Name'
,p_display_sequence=>15
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(43259771179976791)
,p_query_column_name=>'DISP_DATA_TYPE'
,p_heading=>'Data Type'
,p_display_sequence=>16
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(43259378506976790)
,p_query_column_name=>'DISP_TYPE'
,p_heading=>'Type'
,p_display_sequence=>17
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33138646199838569)
,p_query_column_name=>'TYPE'
,p_heading=>'Type'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33140230503838571)
,p_query_column_name=>'DATA_TYPE'
,p_heading=>'Data Type'
,p_display_sequence=>25
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33165444789090265)
,p_query_column_name=>'SOURCE_VALUE'
,p_heading=>'Value / Source'
,p_display_sequence=>27
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33139431992838570)
,p_query_column_name=>'SOURCE'
,p_heading=>'Source'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33139825516838571)
,p_query_column_name=>'DESCRIPTION'
,p_heading=>'Description'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33140715435838572)
,p_query_column_name=>'VALUE'
,p_heading=>'Value'
,p_display_sequence=>70
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33141072536838572)
,p_query_column_name=>'OVERRIDE_VALUE'
,p_heading=>'Override Value'
,p_display_sequence=>80
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33141443769838573)
,p_query_column_name=>'CONCEAL_VALUES'
,p_heading=>'Conceal Values'
,p_display_sequence=>90
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/parameter_uses
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(33544174007158904)
,p_lov_name=>'PARAMETER_USES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select job_name, ',
'       decode(job_online,''Y'',''Online'',''N'',''Offline'') status',
'from   job',
'where  job_id in (select job_id from job_parameters',
'where param_id = :P7_PARAM_ID)',
'order by job_name',
''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'JOB_NAME'
,p_display_column_name=>'JOB_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33544526667163297)
,p_query_column_name=>'JOB_NAME'
,p_heading=>'Job Name'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
,p_is_searchable=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(33544989961163298)
,p_query_column_name=>'STATUS'
,p_heading=>'Status'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/status_summary
begin
wwv_flow_api.create_list_of_values(
 p_id=>wwv_flow_api.id(37534491015971400)
,p_lov_name=>'STATUS_SUMMARY'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select nvl(status,''NULL'') status, case when status is null then '' '' else status end disp_status, count(*) stat_count',
'from    job_v',
'group by status',
'order by status'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'STATUS'
,p_display_column_name=>'STATUS'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37535135194978730)
,p_query_column_name=>'STATUS'
,p_heading=>'Status'
,p_display_sequence=>10
,p_data_type=>'VARCHAR2'
,p_is_visible=>'N'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37535536571978730)
,p_query_column_name=>'DISP_STATUS'
,p_heading=>'Status'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_api.create_list_of_values_cols(
 p_id=>wwv_flow_api.id(37535931769978731)
,p_query_column_name=>'STAT_COUNT'
,p_heading=>'No. of Jobs'
,p_display_sequence=>30
,p_data_type=>'NUMBER'
,p_is_searchable=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
wwv_flow_api.create_page_group(
 p_id=>wwv_flow_api.id(24322287369742645)
,p_group_name=>'Administration'
);
end;
/
prompt --application/comments
begin
null;
end;
/
prompt --application/shared_components/navigation/breadcrumbs/breadcrumb
begin
wwv_flow_api.create_menu(
 p_id=>wwv_flow_api.id(24181785561741737)
,p_name=>'Breadcrumb'
);
end;
/
prompt --application/shared_components/user_interface/templates/page/left_side_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24182559413741766)
,p_theme_id=>42
,p_name=>'Left Side Column'
,p_internal_name=>'LEFT_SIDE_COLUMN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.leftSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--showLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-side" id="t_Body_side">#REGION_POSITION_02#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2525196570560608698
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32581562696330453)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32582074591330453)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32582545827330454)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Left Column'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32583032143330454)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32583542584330455)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32584107455330455)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32584574756330456)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32585115857330456)
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/left_and_right_side_columns
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24185340265741816)
,p_theme_id=>42
,p_name=>'Left and Right Side Columns'
,p_internal_name=>'LEFT_AND_RIGHT_SIDE_COLUMNS'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.bothSideCols();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">  ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>',
'</head>',
'<body class="t-PageBody t-PageBody--showLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-side" id="t_Body_side">#REGION_POSITION_02#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2525203692562657055
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32589811487330465)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>6
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32590269314330465)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32590760633330466)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Left Column'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>3
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32591294359330466)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Right Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>3
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32591746876330467)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32592250830330467)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>6
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32592818974330467)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32593319692330468)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32593812577330468)
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>6
);
end;
/
prompt --application/shared_components/user_interface/templates/page/login
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24188478770741827)
,p_theme_id=>42
,p_name=>'Login'
,p_internal_name=>'LOGIN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.appLogin();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody--login no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Login-container">',
'  <header class="t-Login-containerHeader">#REGION_POSITION_01#</header>',
'  <main class="t-Login-containerBody" id="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</main>',
'  <footer class="t-Login-containerFooter">#REGION_POSITION_02#</footer>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>6
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2099711150063350616
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32596052117330471)
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32596600878330472)
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_name=>'Body Header'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32597063717330472)
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_name=>'Body Footer'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/master_detail
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24190767808741843)
,p_theme_id=>42
,p_name=>'Marquee'
,p_internal_name=>'MASTER_DETAIL'
,p_is_popup=>false
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.stickyTableHeader#MIN#.js?v=#APEX_VERSION#',
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'))
,p_javascript_code_onload=>'apex.theme42.initializePage.masterDetail();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--masterDetail t-PageBody--hideLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-info" id="t_Body_info">#REGION_POSITION_02#</div>',
'        <div class="t-Body-contentInner" role="main">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>1996914646461572319
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32603835943330481)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32604382437330481)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32604888428330482)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Master Detail'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32605338803330482)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Right Side Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32605820727330483)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32606397720330483)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32606884567330483)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32607355986330484)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32607831698330484)
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/minimal_no_navigation
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24193871274741859)
,p_theme_id=>42
,p_name=>'Minimal (No Navigation)'
,p_internal_name=>'MINIMAL_NO_NAVIGATION'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.noSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#  ',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES# t-PageBody--noNav" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Icon fa fa-bars" aria-hidden="true"'
||'></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'</header>',
'    '))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>',
''))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar t-NavigationBar--classic" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2977628563533209425
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32611750189330489)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32612255963330489)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32612773326330489)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32613313187330490)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32613807608330490)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32614285171330490)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32614747357330491)
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/page/modal_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24196406975741866)
,p_theme_id=>42
,p_name=>'Modal Dialog'
,p_internal_name=>'MODAL_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.theme42.initializePage.modalDialog();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-Dialog-page t-Dialog-page--standard #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="t-Dialog-header">#REGION_POSITION_01#</div>',
'  <div class="t-Dialog-bodyWrapperOut">',
'    <div class="t-Dialog-bodyWrapperIn">',
'      <div class="t-Dialog-body" role="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</div>',
'    </div>',
'  </div>',
'  <div class="t-Dialog-footer">#REGION_POSITION_03#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>3
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},''t-Dialog-page--standard ''+#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'720'
,p_dialog_max_width=>'960'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2098960803539086924
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32617035362330496)
,p_page_template_id=>wwv_flow_api.id(24196406975741866)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32617584300330496)
,p_page_template_id=>wwv_flow_api.id(24196406975741866)
,p_name=>'Dialog Header'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32618026723330497)
,p_page_template_id=>wwv_flow_api.id(24196406975741866)
,p_name=>'Dialog Footer'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/right_side_column
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24197843513741871)
,p_theme_id=>42
,p_name=>'Right Side Column'
,p_internal_name=>'RIGHT_SIDE_COLUMN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.rightSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8"> ',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'  <div class="t-Body-actions" id="t_Body_actions">',
'    <button class="t-Body-actionsToggle" aria-label="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" title="#EXPAND_COLLAPSE_SIDE_COL_LABEL#" id="t_Button_rightControlButton" type="button"><span class="t-Body-actionsControlsIcon" aria-hidden="true"></span></button'
||'>',
'    <div class="t-Body-actionsContent" role="complementary">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>17
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2525200116240651575
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32622689840330503)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32623144357330503)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32623701717330504)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Right Column'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>false
,p_max_fixed_grid_columns=>4
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32624126708330505)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32624655196330505)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32625137743330506)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32625672803330506)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32626211375330507)
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>8
);
end;
/
prompt --application/shared_components/user_interface/templates/page/standard
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24200712199741878)
,p_theme_id=>42
,p_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.theme42.initializePage.noSideCol();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-PageBody t-PageBody--hideLeft t-PageBody--hideActions no-anim #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD# id="t_PageBody">',
'<a href="#main" id="t_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#FORM_OPEN#',
'<header class="t-Header" id="t_Header">',
'  #REGION_POSITION_07#',
'  <div class="t-Header-branding" role="banner">',
'    <div class="t-Header-controls">',
'      <button class="t-Button t-Button--icon t-Button--header t-Button--headerTree" aria-label="#EXPAND_COLLAPSE_NAV_LABEL#" title="#EXPAND_COLLAPSE_NAV_LABEL#" id="t_Button_navControl" type="button"><span class="t-Header-controlsIcon" aria-hidden="t'
||'rue"></span></button>',
'    </div>',
'    <div class="t-Header-logo">',
'      <a href="#HOME_LINK#" class="t-Header-logo-link">#LOGO#</a>',
'    </div>',
'    <div class="t-Header-navBar">#NAVIGATION_BAR#</div>',
'  </div>',
'  <div class="t-Header-nav">#TOP_GLOBAL_NAVIGATION_LIST##REGION_POSITION_06#</div>',
'</header>',
''))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body">',
'  #SIDE_GLOBAL_NAVIGATION_LIST#',
'  <div class="t-Body-main">',
'    <div class="t-Body-title" id="t_Body_title">#REGION_POSITION_01#</div>',
'    <div class="t-Body-content" id="t_Body_content">',
'      <main id="main" class="t-Body-mainContent">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        <div class="t-Body-fullContent">#REGION_POSITION_08#</div>',
'        <div class="t-Body-contentInner">#BODY#</div>',
'      </main>',
'      <footer class="t-Footer" role="contentinfo">',
'        <div class="t-Footer-body">',
'          <div class="t-Footer-content">#REGION_POSITION_05#</div>',
'          <div class="t-Footer-apex">',
'            <div class="t-Footer-version">#APP_VERSION#</div>',
'            <div class="t-Footer-customize">#CUSTOMIZE#</div>',
'            #BUILT_WITH_LOVE_USING_APEX#',
'          </div>',
'        </div>',
'        <div class="t-Footer-top">',
'          <a href="#top" class="t-Footer-topButton" id="t_Footer_topButton"><span class="a-Icon icon-up-chevron"></span></a>',
'        </div>',
'      </footer>',
'    </div>',
'  </div>',
'</div>',
'<div class="t-Body-inlineDialogs">#REGION_POSITION_04#</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>',
''))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-NavigationBar t-NavigationBar--classic" data-mode="classic">',
'  <li class="t-NavigationBar-item">',
'    <span class="t-Button t-Button--icon t-Button--noUI t-Button--header t-Button--navBar t-Button--headerUser">',
'      <span class="t-Icon a-Icon icon-user"></span>',
'      <span class="t-Button-label">&APP_USER.</span>',
'    </span>',
'  </li>#BAR_BODY#',
'</ul>'))
,p_navbar_entry=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item">',
'  <a class="t-Button t-Button--icon t-Button--header" href="#LINK#">',
'    <span class="t-Icon #IMAGE#"></span>',
'    <span class="t-Button-label">#TEXT#</span>',
'  </a>',
'</li>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_01'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>4070909157481059304
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32630078389330511)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32630589002330511)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Breadcrumb Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32631103243330512)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Inline Dialogs'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32631548449330512)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Footer'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32632119206330513)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Page Navigation'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32632534643330513)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Page Header'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32633058712330513)
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_name=>'Before Content Body'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/page/wizard_modal_dialog
begin
wwv_flow_api.create_template(
 p_id=>wwv_flow_api.id(24203207540741885)
,p_theme_id=>42
,p_name=>'Wizard Modal Dialog'
,p_internal_name=>'WIZARD_MODAL_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.theme42.initializePage.wizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js #RTL_CLASS# page-&APP_PAGE_ID. app-&APP_ALIAS." lang="&BROWSER_LANGUAGE." #TEXT_DIRECTION#>',
'<head>',
'  <meta http-equiv="x-ua-compatible" content="IE=edge" />',
'  <meta charset="utf-8">',
'  <title>#TITLE#</title>',
'  #APEX_CSS#',
'  #THEME_CSS#',
'  #TEMPLATE_CSS#',
'  #THEME_STYLE_CSS#',
'  #APPLICATION_CSS#',
'  #PAGE_CSS#',
'  #FAVICONS#',
'  #HEAD#',
'  <meta name="viewport" content="width=device-width, initial-scale=1.0" />',
'</head>',
'<body class="t-Dialog-page t-Dialog-page--wizard #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #TEXT_DIRECTION# #ONLOAD#>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="t-Dialog-header">#REGION_POSITION_01#</div>',
'  <div class="t-Dialog-bodyWrapperOut">',
'    <div class="t-Dialog-bodyWrapperIn">',
'      <div class="t-Dialog-body" role="main">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION##BODY#</div>',
'    </div>',
'  </div>',
'  <div class="t-Dialog-footer">#REGION_POSITION_03#</div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#  ',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--success t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Success" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-header">',
'          <h2 class="t-Alert-title">#SUCCESS_MESSAGE#</h2>',
'        </div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Success'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-alert">',
'  <div class="t-Alert t-Alert--defaultIcons t-Alert--warning t-Alert--horizontal t-Alert--page t-Alert--colorBG" id="t_Alert_Notification" role="alert">',
'    <div class="t-Alert-wrap">',
'      <div class="t-Alert-icon">',
'        <span class="t-Icon"></span>',
'      </div>',
'      <div class="t-Alert-content">',
'        <div class="t-Alert-body">#MESSAGE#</div>',
'      </div>',
'      <div class="t-Alert-buttons">',
'        <button class="t-Button t-Button--noUI t-Button--icon t-Button--closeAlert" onclick="apex.jQuery(''#t_Alert_Notification'').remove();" type="button" title="#CLOSE_NOTIFICATION#"><span class="t-Icon icon-close"></span></button>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"'
,p_theme_class_id=>3
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--danger t-Alert--wizard t-Alert--defaultIcons">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-body">',
'        <h3>#MESSAGE#</h3>',
'        <p>#ADDITIONAL_INFO#</p>',
'        <div class="t-Alert-inset">#TECHNICAL_INFO#</div>',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      <button onclick="#BACK_LINK#" class="t-Button t-Button--hot w50p t-Button--large" type="button">#OK#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_default_label_col_span=>2
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>'<div class="col col-#COLUMN_SPAN_NUMBER# #CSS_CLASSES#" #ATTRIBUTES#>#CONTENT#</div>'
,p_grid_first_column_attributes=>'alpha'
,p_grid_last_column_attributes=>'omega'
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},''t-Dialog-page--wizard ''+#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'auto'
,p_dialog_width=>'720'
,p_dialog_max_width=>'960'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>2120348229686426515
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32635331291330517)
,p_page_template_id=>wwv_flow_api.id(24203207540741885)
,p_name=>'Wizard Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32635850805330517)
,p_page_template_id=>wwv_flow_api.id(24203207540741885)
,p_name=>'Wizard Progress Bar'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_page_tmpl_display_point(
 p_id=>wwv_flow_api.id(32636405110330517)
,p_page_template_id=>wwv_flow_api.id(24203207540741885)
,p_name=>'Wizard Buttons'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/button/icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(24295778150742260)
,p_template_name=>'Icon'
,p_internal_name=>'ICON'
,p_template=>'<button class="t-Button t-Button--noLabel t-Button--icon #BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL#" aria-label="#LABEL#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"><'
||'/span></button>'
,p_hot_template=>'<button class="t-Button t-Button--noLabel t-Button--icon #BUTTON_CSS_CLASSES# t-Button--hot" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL#" aria-label="#LABEL#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_reference_id=>2347660919680321258
,p_translate_this_template=>'N'
,p_theme_class_id=>5
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/button/text
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(24296457568742267)
,p_template_name=>'Text'
,p_internal_name=>'TEXT'
,p_template=>'<button onclick="#JAVASCRIPT#" class="t-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><span class="t-Button-label">#LABEL#</span></button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="t-Button t-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#"><span class="t-Button-label">#LABEL#</span></button>'
,p_reference_id=>4070916158035059322
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/button/text_with_icon
begin
wwv_flow_api.create_button_templates(
 p_id=>wwv_flow_api.id(24296606035742268)
,p_template_name=>'Text with Icon'
,p_internal_name=>'TEXT_WITH_ICON'
,p_template=>'<button class="t-Button t-Button--icon #BUTTON_CSS_CLASSES#" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#"><span class="t-Icon t-Icon--left #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-Button-label">#LABEL#'
||'</span><span class="t-Icon t-Icon--right #ICON_CSS_CLASSES#" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="t-Button t-Button--icon #BUTTON_CSS_CLASSES# t-Button--hot" #BUTTON_ATTRIBUTES# onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#"><span class="t-Icon t-Icon--left #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-Button-'
||'label">#LABEL#</span><span class="t-Icon t-Icon--right #ICON_CSS_CLASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>2081382742158699622
,p_translate_this_template=>'N'
,p_theme_class_id=>4
,p_preset_template_options=>'t-Button--iconRight'
,p_theme_id=>42
);
end;
/
prompt --application/shared_components/user_interface/templates/region/alert
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24204662079741892)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-header">',
'        <h2 class="t-Alert-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'      </div>',
'      <div class="t-Alert-body">#BODY#</div>',
'    </div>',
'    <div class="t-Alert-buttons">#PREVIOUS##CLOSE##CREATE##NEXT#</div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Alert'
,p_internal_name=>'ALERT'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>21
,p_preset_template_options=>'t-Alert--horizontal:t-Alert--defaultIcons:t-Alert--warning'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2039236646100190748
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32638212187330525)
,p_plug_template_id=>wwv_flow_api.id(24204662079741892)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_with_attributes
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24208351153741927)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="#REGION_CSS_CLASSES#">#PREVIOUS##BODY##SUB_REGIONS##NEXT#</div>'
,p_page_plug_template_name=>'Blank with Attributes'
,p_internal_name=>'BLANK_WITH_ATTRIBUTES'
,p_theme_id=>42
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>4499993862448380551
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/blank_with_attributes_no_grid
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24208596467741927)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="#REGION_CSS_CLASSES#">#PREVIOUS##BODY##SUB_REGIONS##NEXT#</div>'
,p_page_plug_template_name=>'Blank with Attributes (No Grid)'
,p_internal_name=>'BLANK_WITH_ATTRIBUTES_NO_GRID'
,p_theme_id=>42
,p_theme_class_id=>7
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>3369790999010910123
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32646953020330538)
,p_plug_template_id=>wwv_flow_api.id(24208596467741927)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32647516158330538)
,p_plug_template_id=>wwv_flow_api.id(24208596467741927)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/buttons_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24209351005741929)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ButtonRegion t-Form--floatLeft #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-ButtonRegion-wrap">',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##CLOSE##DELETE#</div></div>',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--content">',
'      <h2 class="t-ButtonRegion-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'      #BODY#',
'      <div class="t-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Buttons Container'
,p_internal_name=>'BUTTONS_CONTAINER'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>17
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2124982336649579661
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32649093368330540)
,p_plug_template_id=>wwv_flow_api.id(24209351005741929)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32649593333330541)
,p_plug_template_id=>wwv_flow_api.id(24209351005741929)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/carousel_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24211577744741938)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region t-Region--carousel #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <span class="t-Region-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'    <h2 class="t-Region-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#COPY##EDIT#<span class="js-maximizeButtonContainer"></span></div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #BODY#',
'   <div class="t-Region-carouselRegions">',
'     #SUB_REGIONS#',
'   </div>',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#CLOSE##HELP#</div>',
'    <div class="t-Region-buttons-right">#DELETE##CHANGE##CREATE#</div>',
'   </div>',
' </div>',
'</div>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div data-label="#SUB_REGION_TITLE#" id="SR_#SUB_REGION_ID#">',
'  #SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'Carousel Container'
,p_internal_name=>'CAROUSEL_CONTAINER'
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#',
'#IMAGE_PREFIX#plugins/com.oracle.apex.carousel/1.1/com.oracle.apex.carousel#MIN#.js?v=#APEX_VERSION#'))
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>5
,p_default_template_options=>'t-Region--showCarouselControls'
,p_preset_template_options=>'t-Region--hiddenOverflow'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2865840475322558786
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32653902498330549)
,p_plug_template_id=>wwv_flow_api.id(24211577744741938)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32654347148330550)
,p_plug_template_id=>wwv_flow_api.id(24211577744741938)
,p_name=>'Slides'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/collapsible
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24218751700741965)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region t-Region--hideShow #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems  t-Region-headerItems--controls"><button class="t-Button t-Button--icon t-Button--hideShow" type="button"></button></div>',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <h2 class="t-Region-title">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#EDIT#</div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#CLOSE#</div>',
'    <div class="t-Region-buttons-right">#CREATE#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #COPY#',
'     #BODY#',
'     #SUB_REGIONS#',
'     #CHANGE#',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
' </div>',
'</div>'))
,p_page_plug_template_name=>'Collapsible'
,p_internal_name=>'COLLAPSIBLE'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>1
,p_preset_template_options=>'is-expanded:t-Region--scrollBody'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2662888092628347716
,p_translate_this_template=>'N'
,p_template_comment=>'Red Theme'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32670085080330571)
,p_plug_template_id=>wwv_flow_api.id(24218751700741965)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32670575384330571)
,p_plug_template_id=>wwv_flow_api.id(24218751700741965)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/content_block
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24224131411741986)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ContentBlock #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-ContentBlock-header">',
'    <div class="t-ContentBlock-headerItems t-ContentBlock-headerItems--title">',
'      <span class="t-ContentBlock-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'      <h1 class="t-ContentBlock-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h1>',
'      #EDIT#',
'    </div>',
'    <div class="t-ContentBlock-headerItems t-ContentBlock-headerItems--buttons">#CHANGE#</div>',
'  </div>',
'  <div class="t-ContentBlock-body">#BODY#</div>',
'  <div class="t-ContentBlock-buttons">#PREVIOUS##NEXT#</div>',
'</div>',
''))
,p_page_plug_template_name=>'Content Block'
,p_internal_name=>'CONTENT_BLOCK'
,p_theme_id=>42
,p_theme_class_id=>21
,p_preset_template_options=>'t-ContentBlock--h1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2320668864738842174
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/hero
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24226159227741993)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-HeroRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-HeroRegion-wrap">',
'    <div class="t-HeroRegion-col t-HeroRegion-col--left"><span class="t-HeroRegion-icon t-Icon #ICON_CSS_CLASSES#"></span></div>',
'    <div class="t-HeroRegion-col t-HeroRegion-col--content">',
'      <h1 class="t-HeroRegion-title">#TITLE#</h1>',
'      #BODY#',
'    </div>',
'    <div class="t-HeroRegion-col t-HeroRegion-col--right"><div class="t-HeroRegion-form">#SUB_REGIONS#</div><div class="t-HeroRegion-buttons">#NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Hero'
,p_internal_name=>'HERO'
,p_theme_id=>42
,p_theme_class_id=>22
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2672571031438297268
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32687098043330595)
,p_plug_template_id=>wwv_flow_api.id(24226159227741993)
,p_name=>'Region Body'
,p_placeholder=>'#BODY#'
,p_has_grid_support=>false
,p_glv_new_row=>false
);
end;
/
prompt --application/shared_components/user_interface/templates/region/inline_dialog
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24228268014742000)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#_parent">',
'<div id="#REGION_STATIC_ID#"  class="t-DialogRegion #REGION_CSS_CLASSES# js-regionDialog" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="t-DialogRegion-wrap">',
'    <div class="t-DialogRegion-bodyWrapperOut"><div class="t-DialogRegion-bodyWrapperIn"><div class="t-DialogRegion-body">#BODY#</div></div></div>',
'    <div class="t-DialogRegion-buttons">',
'       <div class="t-ButtonRegion t-ButtonRegion--dialogRegion">',
'         <div class="t-ButtonRegion-wrap">',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'         </div>',
'       </div>',
'    </div>',
'  </div>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'Inline Dialog'
,p_internal_name=>'INLINE_DIALOG'
,p_theme_id=>42
,p_theme_class_id=>24
,p_default_template_options=>'js-modal:js-draggable:js-resizable'
,p_preset_template_options=>'js-dialog-size600x400'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2671226943886536762
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32691421592330602)
,p_plug_template_id=>wwv_flow_api.id(24228268014742000)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/inline_popup
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24230598242742016)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#_parent">',
'<div id="#REGION_STATIC_ID#"  class="t-DialogRegion #REGION_CSS_CLASSES# js-regionPopup" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="t-DialogRegion-wrap">',
'    <div class="t-DialogRegion-bodyWrapperOut"><div class="t-DialogRegion-bodyWrapperIn"><div class="t-DialogRegion-body">#BODY#</div></div></div>',
'    <div class="t-DialogRegion-buttons">',
'       <div class="t-ButtonRegion t-ButtonRegion--dialogRegion">',
'         <div class="t-ButtonRegion-wrap">',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--left"><div class="t-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'           <div class="t-ButtonRegion-col t-ButtonRegion-col--right"><div class="t-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'         </div>',
'       </div>',
'    </div>',
'  </div>',
'</div>',
'</div>'))
,p_page_plug_template_name=>'Inline Popup'
,p_internal_name=>'INLINE_POPUP'
,p_theme_id=>42
,p_theme_class_id=>24
,p_preset_template_options=>'js-dialog-size600x400'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1483922538999385230
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32695953299330609)
,p_plug_template_id=>wwv_flow_api.id(24230598242742016)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/interactive_report
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24233880401742026)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="t-IRR-region #REGION_CSS_CLASSES#">',
'  <h2 class="u-VisuallyHidden" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'#PREVIOUS##BODY##SUB_REGIONS##NEXT#',
'</div>'))
,p_page_plug_template_name=>'Interactive Report'
,p_internal_name=>'INTERACTIVE_REPORT'
,p_theme_id=>42
,p_theme_class_id=>9
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2099079838218790610
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/login
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24234455365742029)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Login-region t-Form--stretchInputs t-Form--labelsAbove #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Login-header">',
'    <span class="t-Login-logo #ICON_CSS_CLASSES#"></span>',
'    <h1 class="t-Login-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h1>',
'  </div>',
'  <div class="t-Login-body">#BODY#</div>',
'  <div class="t-Login-buttons">#NEXT#</div>',
'  <div class="t-Login-links">#EDIT##CREATE#</div>',
'  <div class="t-Login-subRegions">#SUB_REGIONS#</div>',
'</div>'))
,p_page_plug_template_name=>'Login'
,p_internal_name=>'LOGIN'
,p_theme_id=>42
,p_theme_class_id=>23
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2672711194551076376
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32704635708330621)
,p_plug_template_id=>wwv_flow_api.id(24234455365742029)
,p_name=>'Content Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/standard
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24235771973742035)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Region #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
' <div class="t-Region-header">',
'  <div class="t-Region-headerItems t-Region-headerItems--title">',
'    <span class="t-Region-headerIcon"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span></span>',
'    <h2 class="t-Region-title" id="#REGION_STATIC_ID#_heading">#TITLE#</h2>',
'  </div>',
'  <div class="t-Region-headerItems t-Region-headerItems--buttons">#COPY##EDIT#<span class="js-maximizeButtonContainer"></span></div>',
' </div>',
' <div class="t-Region-bodyWrap">',
'   <div class="t-Region-buttons t-Region-buttons--top">',
'    <div class="t-Region-buttons-left">#PREVIOUS#</div>',
'    <div class="t-Region-buttons-right">#NEXT#</div>',
'   </div>',
'   <div class="t-Region-body">',
'     #BODY#',
'     #SUB_REGIONS#',
'   </div>',
'   <div class="t-Region-buttons t-Region-buttons--bottom">',
'    <div class="t-Region-buttons-left">#CLOSE##HELP#</div>',
'    <div class="t-Region-buttons-right">#DELETE##CHANGE##CREATE#</div>',
'   </div>',
' </div>',
'</div>',
''))
,p_page_plug_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_plug_table_bgcolor=>'#ffffff'
,p_theme_id=>42
,p_theme_class_id=>8
,p_preset_template_options=>'t-Region--scrollBody'
,p_plug_heading_bgcolor=>'#ffffff'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>4070912133526059312
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32708056733330625)
,p_plug_template_id=>wwv_flow_api.id(24235771973742035)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32708535309330625)
,p_plug_template_id=>wwv_flow_api.id(24235771973742035)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>12
);
end;
/
prompt --application/shared_components/user_interface/templates/region/tabs_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24242606244742055)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-TabsRegion #REGION_CSS_CLASSES# apex-tabs-region" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'  <div class="t-TabsRegion-items">',
'    #SUB_REGIONS#',
'  </div>',
'</div>'))
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div data-label="#SUB_REGION_TITLE#" id="SR_#SUB_REGION_ID#">',
'  #SUB_REGION#',
'</div>'))
,p_page_plug_template_name=>'Tabs Container'
,p_internal_name=>'TABS_CONTAINER'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'
,p_theme_id=>42
,p_theme_class_id=>5
,p_preset_template_options=>'t-TabsRegion-mod--simple'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>3221725015618492759
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32727223943330653)
,p_plug_template_id=>wwv_flow_api.id(24242606244742055)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_glv_new_row=>true
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32727773572330653)
,p_plug_template_id=>wwv_flow_api.id(24242606244742055)
,p_name=>'Tabs'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/title_bar
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24245177604742064)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="t-BreadcrumbRegion #REGION_CSS_CLASSES#"> ',
'  <div class="t-BreadcrumbRegion-body">',
'    <div class="t-BreadcrumbRegion-breadcrumb">',
'      #BODY#',
'    </div>',
'    <div class="t-BreadcrumbRegion-title">',
'      <h1 class="t-BreadcrumbRegion-titleText">#TITLE#</h1>',
'    </div>',
'  </div>',
'  <div class="t-BreadcrumbRegion-buttons">#PREVIOUS##CLOSE##DELETE##HELP##CHANGE##EDIT##COPY##CREATE##NEXT#</div>',
'</div>'))
,p_page_plug_template_name=>'Title Bar'
,p_internal_name=>'TITLE_BAR'
,p_theme_id=>42
,p_theme_class_id=>6
,p_default_template_options=>'t-BreadcrumbRegion--showBreadcrumb'
,p_preset_template_options=>'t-BreadcrumbRegion--useBreadcrumbTitle'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2530016523834132090
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/region/wizard_container
begin
wwv_flow_api.create_plug_template(
 p_id=>wwv_flow_api.id(24246181062742070)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Wizard #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="t-Wizard-header">',
'    <h1 class="t-Wizard-title">#TITLE#</h1>',
'    <div class="u-Table t-Wizard-controls">',
'      <div class="u-Table-fit t-Wizard-buttons">#PREVIOUS##CLOSE#</div>',
'      <div class="u-Table-fill t-Wizard-steps">',
'        #BODY#',
'      </div>',
'      <div class="u-Table-fit t-Wizard-buttons">#NEXT#</div>',
'    </div>',
'  </div>',
'  <div class="t-Wizard-body">',
'    #SUB_REGIONS#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'Wizard Container'
,p_internal_name=>'WIZARD_CONTAINER'
,p_theme_id=>42
,p_theme_class_id=>8
,p_preset_template_options=>'t-Wizard--hideStepsXSmall'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2117602213152591491
,p_translate_this_template=>'N'
);
wwv_flow_api.create_plug_tmpl_display_point(
 p_id=>wwv_flow_api.id(32734404571330662)
,p_plug_template_id=>wwv_flow_api.id(24246181062742070)
,p_name=>'Wizard Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_glv_new_row=>false
);
end;
/
prompt --application/shared_components/user_interface/templates/list/top_navigation_tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24271460186742155)
,p_list_template_current=>'<li class="t-NavTabs-item #A03# is-active" id="#A01#"><a href="#LINK#" class="t-NavTabs-link #A04# " title="#TEXT_ESC_SC#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-NavTabs-label">#TEXT_ESC_SC#</span><span class'
||'="t-NavTabs-badge #A05#">#A02#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-NavTabs-item #A03#" id="#A01#"><a href="#LINK#" class="t-NavTabs-link #A04# " title="#TEXT_ESC_SC#"><span class="t-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="t-NavTabs-label">#TEXT_ESC_SC#</span><span class="t-NavTab'
||'s-badge #A05#">#A02#</span></a></li>'
,p_list_template_name=>'Top Navigation Tabs'
,p_internal_name=>'TOP_NAVIGATION_TABS'
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-NavTabs--inlineLabels-lg:t-NavTabs--displayLabels-sm'
,p_list_template_before_rows=>'<ul class="t-NavTabs #COMPONENT_CSS_CLASSES#" id="#PARENT_STATIC_ID#_navtabs">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'List Item ID'
,p_a02_label=>'Badge Value'
,p_a03_label=>'List Item Class'
,p_a04_label=>'Link Class'
,p_a05_label=>'Badge Class'
,p_reference_id=>1453011561172885578
);
end;
/
prompt --application/shared_components/user_interface/templates/list/wizard_progress
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24273061338742170)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-WizardSteps-step is-active" id="#LIST_ITEM_ID#"><div class="t-WizardSteps-wrap" data-link="#LINK#"><span class="t-WizardSteps-marker"></span><span class="t-WizardSteps-label">#TEXT# <span class="t-WizardSteps-labelState"></span></span></'
||'div></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-WizardSteps-step" id="#LIST_ITEM_ID#"><div class="t-WizardSteps-wrap" data-link="#LINK#"><span class="t-WizardSteps-marker"></span><span class="t-WizardSteps-label">#TEXT# <span class="t-WizardSteps-labelState"></span></span></div></li>',
''))
,p_list_template_name=>'Wizard Progress'
,p_internal_name=>'WIZARD_PROGRESS'
,p_javascript_code_onload=>'apex.theme.initWizardProgressBar();'
,p_theme_id=>42
,p_theme_class_id=>17
,p_preset_template_options=>'t-WizardSteps--displayLabels'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<h2 class="u-VisuallyHidden">#CURRENT_PROGRESS#</h2>',
'<ul class="t-WizardSteps #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>2008702338707394488
);
end;
/
prompt --application/shared_components/user_interface/templates/list/menu_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24274497226742179)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Menu Bar'
,p_internal_name=>'MENU_BAR'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menubar", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup( e );',
'}',
'e.menu({',
'  behaveLikeTabs: e.hasClass("js-tabLike"),',
'  menubarShowSubMenuIcon: e.hasClass("js-showSubMenuIcons") || null,',
'  iconType: ''fa'',',
'  slide: e.hasClass("js-slide"),',
'  menubar: true,',
'  menubarOverflow: true,',
'  callout: e.hasClass("js-menu-callout")',
'});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_default_template_options=>'js-showSubMenuIcons'
,p_list_template_before_rows=>'<div class="t-MenuBar #COMPONENT_CSS_CLASSES#" id="#PARENT_STATIC_ID#_menubar"><ul style="display:none">'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>2008709236185638887
);
end;
/
prompt --application/shared_components/user_interface/templates/list/badge_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24275631851742183)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item #A02#">',
'  <a class="t-BadgeList-wrap u-color #A04#" href="#LINK#" #A03#>',
'  <span class="t-BadgeList-label">#TEXT#</span>',
'  <span class="t-BadgeList-value">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item #A02#">',
'  <a class="t-BadgeList-wrap u-color #A04#" href="#LINK#" #A03#>',
'  <span class="t-BadgeList-label">#TEXT#</span>',
'  <span class="t-BadgeList-value">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_name=>'Badge List'
,p_internal_name=>'BADGE_LIST'
,p_theme_id=>42
,p_theme_class_id=>3
,p_preset_template_options=>'t-BadgeList--large:t-BadgeList--cols t-BadgeList--3cols:t-BadgeList--circular'
,p_list_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Value'
,p_a02_label=>'List item CSS Classes'
,p_a03_label=>'Link Attributes'
,p_a04_label=>'Link Classes'
,p_reference_id=>2062482847268086664
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'A01: Large Number',
'A02: List Item Classes',
'A03: Link Attributes'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/media_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24279704003742196)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item is-active #A04#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #A05#" #A03#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#TEXT#</h3>',
'            <p class="t-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item  #A04#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #A05#" #A03#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#TEXT#</h3>',
'            <p class="t-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'Media List'
,p_internal_name=>'MEDIA_LIST'
,p_theme_id=>42
,p_theme_class_id=>5
,p_default_template_options=>'t-MediaList--showIcons:t-MediaList--showDesc'
,p_list_template_before_rows=>'<ul class="t-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Description'
,p_a02_label=>'Badge Value'
,p_a03_label=>'Link Attributes'
,p_a04_label=>'List Item CSS Classes'
,p_a05_label=>'Link Class'
,p_a06_label=>'Icon Color Class'
,p_reference_id=>2066548068783481421
);
end;
/
prompt --application/shared_components/user_interface/templates/list/side_navigation_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24282651135742212)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Side Navigation Menu'
,p_internal_name=>'SIDE_NAVIGATION_MENU'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.treeView#MIN#.js?v=#APEX_VERSION#'
,p_javascript_code_onload=>'apex.jQuery(''body'').addClass(''t-PageBody--leftNav'');'
,p_theme_id=>42
,p_theme_class_id=>19
,p_preset_template_options=>'js-navCollapsed--default:t-TreeNav--styleA'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Body-nav" id="t_Body_nav" role="navigation" aria-label="&APP_TITLE!ATTR.">',
'<div class="t-TreeNav #COMPONENT_CSS_CLASSES#" id="t_TreeNav" data-id="#PARENT_STATIC_ID#_tree" aria-label="&APP_TITLE!ATTR."><ul style="display:none">'))
,p_list_template_after_rows=>'</ul></div></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'ID Attribute'
,p_a02_label=>'Disabled True/False'
,p_a04_label=>'Title'
,p_reference_id=>2466292414354694776
);
end;
/
prompt --application/shared_components/user_interface/templates/list/top_navigation_menu
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24284310417742218)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_name=>'Top Navigation Menu'
,p_internal_name=>'TOP_NAVIGATION_MENU'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("#t_MenuNav", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  if ( apex.actions ) {',
'    apex.actions.addFromMarkup( e );',
'  } else {',
'    apex.debug.warn("Include actions.js to support menu shortcuts");',
'  }',
'}',
'e.menu({',
'  behaveLikeTabs: e.hasClass("js-tabLike"),',
'  menubarShowSubMenuIcon: e.hasClass("js-showSubMenuIcons") || null,',
'  slide: e.hasClass("js-slide"),',
'  menubar: true,',
'  menubarOverflow: true,',
'  callout: e.hasClass("js-menu-callout")',
'});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_default_template_options=>'js-tabLike'
,p_list_template_before_rows=>'<div class="t-Header-nav-list #COMPONENT_CSS_CLASSES#" id="t_MenuNav"><ul style="display:none">'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'ID Attribute'
,p_a02_label=>'Disabled True / False'
,p_a03_label=>'Hide'
,p_a04_label=>'Title Attribute'
,p_a05_label=>'Shortcut Key'
,p_reference_id=>2525307901300239072
);
end;
/
prompt --application/shared_components/user_interface/templates/list/navigation_bar
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24285515375742222)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item is-active #A02#">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item #A02#">',
'  <a class="t-Button t-Button--icon t-Button--header t-Button--navBar" href="#LINK#">',
'    <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span>',
'  </a>',
'</li>'))
,p_list_template_name=>'Navigation Bar'
,p_internal_name=>'NAVIGATION_BAR'
,p_theme_id=>42
,p_theme_class_id=>20
,p_list_template_before_rows=>'<ul class="t-NavigationBar #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<div class="t-NavigationBar-menu" style="display: none" id="menu_#PARENT_LIST_ITEM_ID#"><ul>'
,p_after_sub_list=>'</ul></div></li>'
,p_sub_list_item_current=>'<li data-current="true" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-current="false" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item is-active #A02#">',
'  <button class="t-Button t-Button--icon t-Button t-Button--header t-Button--navBar js-menuButton" type="button" id="#LIST_ITEM_ID#" data-menu="menu_#LIST_ITEM_ID#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span><span class="a-Icon icon-down-arrow"></span>',
'  </button>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-NavigationBar-item #A02#">',
'  <button class="t-Button t-Button--icon t-Button t-Button--header t-Button--navBar js-menuButton" type="button" id="#LIST_ITEM_ID#" data-menu="menu_#LIST_ITEM_ID#">',
'      <span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Button-label">#TEXT_ESC_SC#</span><span class="t-Button-badge">#A01#</span><span class="a-Icon icon-down-arrow"></span>',
'  </button>'))
,p_sub_templ_curr_w_child=>'<li data-current="true" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_sub_templ_noncurr_w_child=>'<li data-current="false" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#">#TEXT_ESC_SC#</a></li>'
,p_a01_label=>'Badge Value'
,p_a02_label=>'List  Item CSS Classes'
,p_reference_id=>2846096252961119197
);
end;
/
prompt --application/shared_components/user_interface/templates/list/cards
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24285849093742225)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item is-active #A04#">',
'  <div class="t-Card">',
'    <a href="#LINK#" class="t-Card-wrap" #A05#>',
'      <div class="t-Card-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#"><span class="t-Card-initials" role="presentation">#A03#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#TEXT#</h3><h4 class="t-Card-subtitle">#A07#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#A01#</div>',
'        <div class="t-Card-info">#A02#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #A06#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #A04#">',
'  <div class="t-Card">',
'    <a href="#LINK#" class="t-Card-wrap" #A05#>',
'      <div class="t-Card-icon u-color #A06#"><span class="t-Icon #ICON_CSS_CLASSES#"><span class="t-Card-initials" role="presentation">#A03#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#TEXT#</h3><h4 class="t-Card-subtitle">#A07#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#A01#</div>',
'        <div class="t-Card-info">#A02#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #A06#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_list_template_name=>'Cards'
,p_internal_name=>'CARDS'
,p_theme_id=>42
,p_theme_class_id=>4
,p_preset_template_options=>'t-Cards--animColorFill:t-Cards--3cols:t-Cards--basic'
,p_list_template_before_rows=>'<ul class="t-Cards #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_a01_label=>'Description'
,p_a02_label=>'Secondary Information'
,p_a03_label=>'Initials'
,p_a04_label=>'List Item CSS Classes'
,p_a05_label=>'Link Attributes'
,p_a06_label=>'Card Color Class'
,p_a07_label=>'Subtitle'
,p_reference_id=>2885322685880632508
);
end;
/
prompt --application/shared_components/user_interface/templates/list/tabs
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24291267411742239)
,p_list_template_current=>'<li class="t-Tabs-item is-active"><a href="#LINK#" class="t-Tabs-link"><span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Tabs-label">#TEXT#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-Tabs-item"><a href="#LINK#" class="t-Tabs-link"><span class="t-Icon #ICON_CSS_CLASSES#"></span><span class="t-Tabs-label">#TEXT#</span></a></li>'
,p_list_template_name=>'Tabs'
,p_internal_name=>'TABS'
,p_javascript_file_urls=>'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.apexTabs#MIN#.js?v=#APEX_VERSION#'
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Tabs--simple'
,p_list_template_before_rows=>'<ul class="t-Tabs #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>3288206686691809997
);
end;
/
prompt --application/shared_components/user_interface/templates/list/menu_popup
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24292897218742246)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'Menu Popup'
,p_internal_name=>'MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup( e );',
'}',
'e.menu({ slide: e.hasClass("js-slide"), iconType: ''fa'', callout: e.hasClass("js-menu-callout")});'))
,p_theme_id=>42
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#ICON_CSS_CLASSES#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_a01_label=>'Data ID'
,p_a02_label=>'Disabled (True/False)'
,p_a03_label=>'Hidden (True/False)'
,p_a04_label=>'Title Attribute'
,p_a05_label=>'Shortcut'
,p_reference_id=>3492264004432431646
);
end;
/
prompt --application/shared_components/user_interface/templates/list/links_list
begin
wwv_flow_api.create_list_template(
 p_id=>wwv_flow_api.id(24293462578742249)
,p_list_template_current=>'<li class="t-LinksList-item is-current #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-b'
||'adge">#A01#</span></a></li>'
,p_list_template_noncurrent=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_list_template_name=>'Links List'
,p_internal_name=>'LINKS_LIST'
,p_theme_id=>42
,p_theme_class_id=>18
,p_list_template_before_rows=>'<ul class="t-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul class="t-LinksList-list">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="t-LinksList-item is-current #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-b'
||'adge">#A01#</span></a></li>'
,p_sub_list_item_noncurrent=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_item_templ_curr_w_child=>'<li class="t-LinksList-item is-current is-expanded #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t'
||'-LinksList-badge">#A01#</span></a>#SUB_LISTS#</li>'
,p_item_templ_noncurr_w_child=>'<li class="t-LinksList-item #A03#"><a href="#LINK#" class="t-LinksList-link" #A02#><span class="t-LinksList-icon"><span class="t-Icon #ICON_CSS_CLASSES#"></span></span><span class="t-LinksList-label">#TEXT#</span><span class="t-LinksList-badge">#A01#'
||'</span></a></li>'
,p_a01_label=>'Badge Value'
,p_a02_label=>'Link Attributes'
,p_a03_label=>'List Item CSS Classes'
,p_reference_id=>4070914341144059318
);
end;
/
prompt --application/shared_components/user_interface/templates/report/timeline
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24247467027742077)
,p_row_template_name=>'Timeline'
,p_internal_name=>'TIMELINE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Timeline-item #EVENT_MODIFIERS#" #EVENT_ATTRIBUTES#>',
'  <div class="t-Timeline-wrap">',
'    <div class="t-Timeline-user">',
'      <div class="t-Timeline-avatar #USER_COLOR#">',
'        #USER_AVATAR#',
'      </div>',
'      <div class="t-Timeline-userinfo">',
'        <span class="t-Timeline-username">#USER_NAME#</span>',
'        <span class="t-Timeline-date">#EVENT_DATE#</span>',
'      </div>',
'    </div>',
'    <div class="t-Timeline-content">',
'      <div class="t-Timeline-typeWrap">',
'        <div class="t-Timeline-type #EVENT_STATUS#">',
'          <span class="t-Icon #EVENT_ICON#"></span>',
'          <span class="t-Timeline-typename">#EVENT_TYPE#</span>',
'        </div>',
'      </div>',
'      <div class="t-Timeline-body">',
'        <h3 class="t-Timeline-title">#EVENT_TITLE#</h3>',
'        <p class="t-Timeline-desc">#EVENT_DESC#</p>',
'      </div>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_condition1=>':EVENT_LINK is null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Timeline-item #EVENT_MODIFIERS#" #EVENT_ATTRIBUTES#>',
'  <a href="#EVENT_LINK#" class="t-Timeline-wrap">',
'    <div class="t-Timeline-user">',
'      <div class="t-Timeline-avatar #USER_COLOR#">',
'        #USER_AVATAR#',
'      </div>',
'      <div class="t-Timeline-userinfo">',
'        <span class="t-Timeline-username">#USER_NAME#</span>',
'        <span class="t-Timeline-date">#EVENT_DATE#</span>',
'      </div>',
'    </div>',
'    <div class="t-Timeline-content">',
'      <div class="t-Timeline-typeWrap">',
'        <div class="t-Timeline-type #EVENT_STATUS#">',
'          <span class="t-Icon #EVENT_ICON#"></span>',
'          <span class="t-Timeline-typename">#EVENT_TYPE#</span>',
'        </div>',
'      </div>',
'      <div class="t-Timeline-body">',
'        <h3 class="t-Timeline-title">#EVENT_TITLE#</h3>',
'        <p class="t-Timeline-desc">#EVENT_DESC#</p>',
'      </div>',
'    </div>',
'  </a>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="t-Timeline #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_timeline" data-region-id="#REGION_STATIC_ID#">',
''))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_reference_id=>1513373588340069864
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24248071060742085)
,p_row_template_name=>'Content Row'
,p_internal_name=>'CONTENT_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-ContentRow-item #ITEM_CLASSES#">',
'  <div class="t-ContentRow-wrap">',
'    <div class="t-ContentRow-selection">#SELECTION#</div>',
'    <div class="t-ContentRow-iconWrap">',
'      <span class="t-ContentRow-icon #ICON_CLASS#">#ICON_HTML#</span>',
'    </div>',
'    <div class="t-ContentRow-body">',
'      <div class="t-ContentRow-content">',
'        <h3 class="t-ContentRow-title">#TITLE#</h3>',
'        <div class="t-ContentRow-description">#DESCRIPTION#</div>',
'      </div>',
'      <div class="t-ContentRow-misc">#MISC#</div>',
'      <div class="t-ContentRow-actions">#ACTIONS#</div>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-ContentRow #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>4
,p_reference_id=>1797843454948280151
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/media_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24251273221742090)
,p_row_template_name=>'Media List'
,p_internal_name=>'MEDIA_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item #LIST_CLASS#">',
'    <a href="#LINK#" class="t-MediaList-itemWrap #LINK_CLASS#" #LINK_ATTR#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #ICON_COLOR_CLASS#"><span class="t-Icon #ICON_CLASS#"></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#LIST_TITLE#</h3>',
'            <p class="t-MediaList-desc">#LIST_TEXT#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#LIST_BADGE#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_row_template_condition1=>':LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-MediaList-item #LIST_CLASS#">',
'    <div class="t-MediaList-itemWrap #LINK_CLASS#" #LINK_ATTR#>',
'        <div class="t-MediaList-iconWrap">',
'            <span class="t-MediaList-icon u-color #ICON_COLOR_CLASS#"><span class="t-Icon #ICON_CLASS#"></span></span>',
'        </div>',
'        <div class="t-MediaList-body">',
'            <h3 class="t-MediaList-title">#LIST_TITLE#</h3>',
'            <p class="t-MediaList-desc">#LIST_TEXT#</p>',
'        </div>',
'        <div class="t-MediaList-badgeWrap">',
'            <span class="t-MediaList-badge">#LIST_BADGE#</span>',
'        </div>',
'    </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-MediaList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>1
,p_default_template_options=>'t-MediaList--showDesc:t-MediaList--showIcons'
,p_preset_template_options=>'t-MediaList--stack'
,p_reference_id=>2092157460408299055
,p_translate_this_template=>'N'
,p_row_template_comment=>' (SELECT link_text, link_target, detail1, detail2, last_modified)'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/value_attribute_pairs_row
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24254658582742102)
,p_row_template_name=>'Value Attribute Pairs - Row'
,p_internal_name=>'VALUE_ATTRIBUTE_PAIRS_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<dt class="t-AVPList-label">',
'  #1#',
'</dt>',
'<dd class="t-AVPList-value">',
'  #2#',
'</dd>'))
,p_row_template_before_rows=>'<dl class="t-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="report_#REGION_STATIC_ID#" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</dl>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-AVPList--leftAligned'
,p_reference_id=>2099068321678681753
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/value_attribute_pairs_column
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24256706012742109)
,p_row_template_name=>'Value Attribute Pairs - Column'
,p_internal_name=>'VALUE_ATTRIBUTE_PAIRS_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<dt class="t-AVPList-label">',
'  #COLUMN_HEADER#',
'</dt>',
'<dd class="t-AVPList-value">',
'  #COLUMN_VALUE#',
'</dd>'))
,p_row_template_before_rows=>'<dl class="t-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</dl>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>6
,p_preset_template_options=>'t-AVPList--leftAligned'
,p_reference_id=>2099068636272681754
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/badge_list
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24258496462742115)
,p_row_template_name=>'Badge List'
,p_internal_name=>'BADGE_LIST'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
' <span class="t-BadgeList-wrap u-color">',
'  <span class="t-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="t-BadgeList-value">#COLUMN_VALUE#</span>',
' </span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>6
,p_preset_template_options=>'t-BadgeList--large:t-BadgeList--fixed:t-BadgeList--circular'
,p_reference_id=>2103197159775914759
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24262063313742124)
,p_row_template_name=>'Standard'
,p_internal_name=>'STANDARD'
,p_row_template1=>'<td class="t-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES# data-region-id="#REGION_STATIC_ID#">',
'  <div class="t-Report-wrap">',
'    <table class="t-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="t-Report-tableWrap">',
'    <table class="t-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="t-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="t-Report-pagination t-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="t-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</thead>',
'<tbody>'))
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>4
,p_preset_template_options=>'t-Report--altRowsDefault:t-Report--rowHighlight'
,p_reference_id=>2537207537838287671
,p_translate_this_template=>'N'
);
begin
wwv_flow_api.create_row_template_patch(
 p_id=>wwv_flow_api.id(24262063313742124)
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
);
exception when others then null;
end;
end;
/
prompt --application/shared_components/user_interface/templates/report/comments
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24264627396742133)
,p_row_template_name=>'Comments'
,p_internal_name=>'COMMENTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Comments-item #COMMENT_MODIFIERS#">',
'    <div class="t-Comments-icon">',
'        <div class="t-Comments-userIcon #ICON_MODIFIER#" aria-hidden="true">#USER_ICON#</div>',
'    </div>',
'    <div class="t-Comments-body">',
'        <div class="t-Comments-info">',
'            #USER_NAME# <span class="t-Comments-date">#COMMENT_DATE#</span> <span class="t-Comments-actions">#ACTIONS#</span>',
'        </div>',
'        <div class="t-Comments-comment">',
'            #COMMENT_TEXT##ATTRIBUTE_1##ATTRIBUTE_2##ATTRIBUTE_3##ATTRIBUTE_4#',
'        </div>',
'    </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-Comments #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>',
''))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Comments--chat'
,p_reference_id=>2611722012730764232
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/alerts
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24265859221742137)
,p_row_template_name=>'Alerts'
,p_internal_name=>'ALERTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Alert t-Alert--horizontal t-Alert--colorBG t-Alert--defaultIcons t-Alert--#ALERT_TYPE#" role="alert">',
'  <div class="t-Alert-wrap">',
'    <div class="t-Alert-icon">',
'      <span class="t-Icon"></span>',
'    </div>',
'    <div class="t-Alert-content">',
'      <div class="t-Alert-header">',
'        <h2 class="t-Alert-title">#ALERT_TITLE#</h2>',
'      </div>',
'      <div class="t-Alert-body">',
'        #ALERT_DESC#',
'      </div>',
'    </div>',
'    <div class="t-Alert-buttons">',
'      #ALERT_ACTION#',
'    </div>',
'  </div>',
'</div>'))
,p_row_template_before_rows=>'<div class="t-Alerts #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_alerts" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>14
,p_reference_id=>2881456138952347027
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/cards
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24266091041742137)
,p_row_template_name=>'Cards'
,p_internal_name=>'CARDS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #CARD_MODIFIERS#">',
'  <div class="t-Card">',
'    <a href="#CARD_LINK#" class="t-Card-wrap">',
'      <div class="t-Card-icon u-color #CARD_COLOR#"><span class="t-Icon fa #CARD_ICON#"><span class="t-Card-initials" role="presentation">#CARD_INITIALS#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#CARD_TITLE#</h3><h4 class="t-Card-subtitle">#CARD_SUBTITLE#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#CARD_TEXT#</div>',
'        <div class="t-Card-info">#CARD_SUBTEXT#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #CARD_COLOR#"></span>',
'    </a>',
'  </div>',
'</li>'))
,p_row_template_condition1=>':CARD_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-Cards-item #CARD_MODIFIERS#">',
'  <div class="t-Card">',
'    <div class="t-Card-wrap">',
'      <div class="t-Card-icon u-color #CARD_COLOR#"><span class="t-Icon fa #CARD_ICON#"><span class="t-Card-initials" role="presentation">#CARD_INITIALS#</span></span></div>',
'      <div class="t-Card-titleWrap"><h3 class="t-Card-title">#CARD_TITLE#</h3><h4 class="t-Card-subtitle">#CARD_SUBTITLE#</h4></div>',
'      <div class="t-Card-body">',
'        <div class="t-Card-desc">#CARD_TEXT#</div>',
'        <div class="t-Card-info">#CARD_SUBTEXT#</div>',
'      </div>',
'      <span class="t-Card-colorFill u-color #CARD_COLOR#"></span>',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-Cards #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_cards" data-region-id="#REGION_STATIC_ID#">'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>7
,p_preset_template_options=>'t-Cards--animColorFill:t-Cards--3cols:t-Cards--basic'
,p_reference_id=>2973535649510699732
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/search_results
begin
wwv_flow_api.create_row_template(
 p_id=>wwv_flow_api.id(24271245073742154)
,p_row_template_name=>'Search Results'
,p_internal_name=>'SEARCH_RESULTS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition1=>':LABEL_02 is null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition2=>':LABEL_03 is null'
,p_row_template3=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'      <span class="t-SearchResults-misc">#LABEL_03#: #VALUE_03#</span>',
'    </div>',
'  </li>'))
,p_row_template_condition3=>':LABEL_04 is null'
,p_row_template4=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-SearchResults-item">',
'    <h3 class="t-SearchResults-title"><a href="#SEARCH_LINK#">#SEARCH_TITLE#</a></h3>',
'    <div class="t-SearchResults-info">',
'      <p class="t-SearchResults-desc">#SEARCH_DESC#</p>',
'      <span class="t-SearchResults-misc">#LABEL_01#: #VALUE_01#</span>',
'      <span class="t-SearchResults-misc">#LABEL_02#: #VALUE_02#</span>',
'      <span class="t-SearchResults-misc">#LABEL_03#: #VALUE_03#</span>',
'      <span class="t-SearchResults-misc">#LABEL_04#: #VALUE_04#</span>',
'    </div>',
'  </li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-SearchResults #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_STATIC_ID#_report" data-region-id="#REGION_STATIC_ID#">',
'<ul class="t-SearchResults-list">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</ul>',
'<table class="t-Report-pagination" role="presentation">#PAGINATION#</table>',
'</div>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="t-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--next">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="t-Button t-Button--small t-Button--noUI t-Report-paginationLink t-Report-paginationLink--prev">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>42
,p_theme_class_id=>1
,p_reference_id=>4070913431524059316
,p_translate_this_template=>'N'
,p_row_template_comment=>' (SELECT link_text, link_target, detail1, detail2, last_modified)'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295050301742255)
,p_template_name=>'Hidden'
,p_internal_name=>'HIDDEN'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer t-Form-labelContainer--hiddenLabel col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label u-VisuallyHidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--hiddenLabel rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>13
,p_reference_id=>2039339104148359505
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295197285742257)
,p_template_name=>'Optional'
,p_internal_name=>'OPTIONAL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>',
''))
,p_before_item=>'<div class="t-Form-fieldContainer rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_reference_id=>2317154212072806530
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295304255742259)
,p_template_name=>'Optional - Above'
,p_internal_name=>'OPTIONAL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_reference_id=>3030114864004968404
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/optional_floating
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295347200742259)
,p_template_name=>'Optional - Floating'
,p_internal_name=>'OPTIONAL_FLOATING'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--floatingLabel #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>3
,p_reference_id=>1607675164727151865
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295452312742259)
,p_template_name=>'Required'
,p_internal_name=>'REQUIRED'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer col col-#LABEL_COLUMN_SPAN_NUMBER#">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer is-required rel-col #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer col col-#ITEM_COLUMN_SPAN_NUMBER#"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_reference_id=>2525313812251712801
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required_above
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295612163742260)
,p_template_name=>'Required - Above'
,p_internal_name=>'REQUIRED_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label> #HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--stacked is-required #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_reference_id=>3030115129444970113
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/required_floating
begin
wwv_flow_api.create_field_template(
 p_id=>wwv_flow_api.id(24295651959742260)
,p_template_name=>'Required - Floating'
,p_internal_name=>'REQUIRED_FLOATING'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-Form-labelContainer">',
'  <label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="t-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="t-Form-fieldContainer t-Form-fieldContainer--floatingLabel is-required #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_item_pre_text=>'<span class="t-Form-itemText t-Form-itemText--pre">#CURRENT_ITEM_PRE_TEXT#</span>'
,p_item_post_text=>'<span class="t-Form-itemText t-Form-itemText--post">#CURRENT_ITEM_POST_TEXT#</span>'
,p_before_element=>'<div class="t-Form-inputContainer"><div class="t-Form-itemWrapper">#ITEM_PRE_TEXT#'
,p_after_element=>'#ITEM_POST_TEXT##HELP_TEMPLATE#</div>#INLINE_HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="t-Form-helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#" aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span></button>'
,p_inline_help_text=>'<span class="t-Form-inlineHelp">#CURRENT_ITEM_INLINE_HELP_TEXT#</span>'
,p_error_template=>'<span class="t-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>42
,p_theme_class_id=>4
,p_reference_id=>1607675344320152883
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/breadcrumb
begin
wwv_flow_api.create_menu_template(
 p_id=>wwv_flow_api.id(24297892105742272)
,p_name=>'Breadcrumb'
,p_internal_name=>'BREADCRUMB'
,p_before_first=>'<ul class="t-Breadcrumb #COMPONENT_CSS_CLASSES#">'
,p_current_page_option=>'<li class="t-Breadcrumb-item is-active"><h1 class="t-Breadcrumb-label">#NAME#</h1></li>'
,p_non_current_page_option=>'<li class="t-Breadcrumb-item"><a href="#LINK#" class="t-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>42
,p_theme_class_id=>1
,p_reference_id=>4070916542570059325
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_api.create_popup_lov_template(
 p_id=>wwv_flow_api.id(24298103741742289)
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#THEME_STYLE_CSS#',
'#FAVICONS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="t-Page t-Page--popupLOV"'
,p_before_field_text=>'<div class="t-PopupLOV-actions t-Form--large">'
,p_filter_width=>'20'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="apex-item-text"'
,p_find_button_text=>'Search'
,p_find_button_attr=>'class="t-Button t-Button--hot t-Button--padLeft"'
,p_close_button_text=>'Close'
,p_close_button_attr=>'class="t-Button u-pullRight"'
,p_next_button_text=>'Next &gt;'
,p_next_button_attr=>'class="t-Button t-PopupLOV-button"'
,p_prev_button_text=>'&lt; Previous'
,p_prev_button_attr=>'class="t-Button t-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_result_row_x_of_y=>'<div class="t-PopupLOV-pagination">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>100
,p_before_result_set=>'<div class="t-PopupLOV-links">'
,p_theme_id=>42
,p_theme_class_id=>1
,p_reference_id=>2885398517835871876
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/calendar
begin
wwv_flow_api.create_calendar_template(
 p_id=>wwv_flow_api.id(24297975811742278)
,p_cal_template_name=>'Calendar'
,p_internal_name=>'CALENDAR'
,p_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th id="#DY#" scope="col" class="t-ClassicCalendar-dayColumn">',
'  <span class="visible-md visible-lg">#IDAY#</span>',
'  <span class="hidden-md hidden-lg">#IDY#</span>',
'</th>'))
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #YYYY#</h1>'))
,p_month_open_format=>'<table class="t-ClassicCalendar-calendar" cellpadding="0" cellspacing="0" border="0" aria-label="#IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>',
''))
,p_day_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_weekend_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#">#TITLE_FORMAT#<div class="t-ClassicCalendar-dayEvents">#DATA#</div>'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_nonday_open_format=>'<td class="t-ClassicCalendar-day is-inactive" headers="#DY#">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr> '
,p_daily_title_format=>'<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_weekly_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--weekly">',
'<h1 class="t-ClassicCalendar-title">#WTITLE#</h1>'))
,p_weekly_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th scope="col" class="t-ClassicCalendar-dayColumn" id="#DY#">',
'  <span class="visible-md visible-lg">#DD# #IDAY#</span>',
'  <span class="hidden-md hidden-lg">#DD# #IDY#</span>',
'</th>'))
,p_weekly_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" aria-label="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t-ClassicCalendar-calendar">'
,p_weekly_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_weekly_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_day_close_format=>'</div></td>'
,p_weekly_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_weekly_weekend_close_format=>'</div></td>'
,p_weekly_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol">'
,p_weekly_time_close_format=>'</th>'
,p_weekly_time_title_format=>'#TIME#'
,p_weekly_hour_open_format=>'<tr>'
,p_weekly_hour_close_format=>'</tr>'
,p_daily_day_of_week_format=>'<th scope="col" id="#DY#" class="t-ClassicCalendar-dayColumn">#IDAY#</th>'
,p_daily_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--daily">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #DD#, #YYYY#</h1>'))
,p_daily_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" aria-label="#CALENDAR_TITLE# #START_DL#" class="t-ClassicCalendar-calendar">'
,p_daily_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_daily_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_daily_day_close_format=>'</div></td>'
,p_daily_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_daily_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol" id="#TIME#">'
,p_daily_time_close_format=>'</th>'
,p_daily_time_title_format=>'#TIME#'
,p_daily_hour_open_format=>'<tr>'
,p_daily_hour_close_format=>'</tr>'
,p_cust_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#IMONTH# #YYYY#</h1>'))
,p_cust_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th id="#DY#" scope="col" class="t-ClassicCalendar-dayColumn">',
'  <span class="visible-md visible-lg">#IDAY#</span>',
'  <span class="hidden-md hidden-lg">#IDY#</span>',
'</th>'))
,p_cust_month_open_format=>'<table class="t-ClassicCalendar-calendar" cellpadding="0" cellspacing="0" border="0" aria-label="#IMONTH# #YYYY#">'
,p_cust_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_cust_week_open_format=>'<tr>'
,p_cust_week_close_format=>'</tr> '
,p_cust_day_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">'
,p_cust_day_close_format=>'</td>'
,p_cust_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#">'
,p_cust_nonday_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_nonday_open_format=>'<td class="t-ClassicCalendar-day is-inactive" headers="#DY#">'
,p_cust_nonday_close_format=>'</td>'
,p_cust_weekend_title_format=>'<span class="t-ClassicCalendar-date">#DD#</span>'
,p_cust_weekend_open_format=>'<td class="t-ClassicCalendar-day is-weekend" headers="#DY#">'
,p_cust_weekend_close_format=>'</td>'
,p_cust_hour_open_format=>'<tr>'
,p_cust_hour_close_format=>'</tr>'
,p_cust_time_title_format=>'#TIME#'
,p_cust_time_open_format=>'<th scope="row" class="t-ClassicCalendar-day t-ClassicCalendar-timeCol">'
,p_cust_time_close_format=>'</th>'
,p_cust_wk_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar">',
'<h1 class="t-ClassicCalendar-title">#WTITLE#</h1>'))
,p_cust_wk_day_of_week_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<th scope="col" class="t-ClassicCalendar-dayColumn" id="#DY#">',
'  <span class="visible-md visible-lg">#DD# #IDAY#</span>',
'  <span class="hidden-md hidden-lg">#DD# #IDY#</span>',
'</th>'))
,p_cust_wk_month_open_format=>'<table border="0" cellpadding="0" cellspacing="0" summary="#CALENDAR_TITLE# #START_DL# - #END_DL#" class="t-ClassicCalendar-calendar">'
,p_cust_wk_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table>',
'</div>'))
,p_cust_wk_week_open_format=>'<tr>'
,p_cust_wk_week_close_format=>'</tr> '
,p_cust_wk_day_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_cust_wk_day_close_format=>'</div></td>'
,p_cust_wk_today_open_format=>'<td class="t-ClassicCalendar-day is-today" headers="#DY#"><div class="t-ClassicCalendar-dayEvents">'
,p_cust_wk_weekend_open_format=>'<td class="t-ClassicCalendar-day" headers="#DY#">'
,p_cust_wk_weekend_close_format=>'</td>'
,p_agenda_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="t-ClassicCalendar t-ClassicCalendar--list">',
'  <div class="t-ClassicCalendar-title">#IMONTH# #YYYY#</div>',
'  <ul class="t-ClassicCalendar-list">',
'    #DAYS#',
'  </ul>',
'</div>'))
,p_agenda_past_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-past">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_today_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-today">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_future_day_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  <li class="t-ClassicCalendar-listTitle is-future">',
'    <span class="t-ClassicCalendar-listDayTitle">#IDAY#</span><span class="t-ClassicCalendar-listDayDate">#IMONTH# #DD#</span>',
'  </li>'))
,p_agenda_past_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-past">#DATA#</li>'
,p_agenda_today_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-today">#DATA#</li>'
,p_agenda_future_entry_format=>'  <li class="t-ClassicCalendar-listEvent is-future">#DATA#</li>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'<span class="t-ClassicCalendar-event">#DATA#</span>'
,p_theme_id=>42
,p_theme_class_id=>1
,p_reference_id=>4070916747979059326
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_api.create_theme(
 p_id=>wwv_flow_api.id(24299293972742349)
,p_theme_id=>42
,p_theme_name=>'Universal Theme'
,p_theme_internal_name=>'UNIVERSAL_THEME'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'L'
,p_nav_bar_type=>'LIST'
,p_reference_id=>4070917134413059350
,p_is_locked=>false
,p_default_page_template=>wwv_flow_api.id(24200712199741878)
,p_default_dialog_template=>wwv_flow_api.id(24196406975741866)
,p_error_template=>wwv_flow_api.id(24188478770741827)
,p_printer_friendly_template=>wwv_flow_api.id(24200712199741878)
,p_breadcrumb_display_point=>'REGION_POSITION_01'
,p_sidebar_display_point=>'REGION_POSITION_02'
,p_login_template=>wwv_flow_api.id(24188478770741827)
,p_default_button_template=>wwv_flow_api.id(24296457568742267)
,p_default_region_template=>wwv_flow_api.id(24235771973742035)
,p_default_chart_template=>wwv_flow_api.id(24235771973742035)
,p_default_form_template=>wwv_flow_api.id(24235771973742035)
,p_default_reportr_template=>wwv_flow_api.id(24235771973742035)
,p_default_tabform_template=>wwv_flow_api.id(24235771973742035)
,p_default_wizard_template=>wwv_flow_api.id(24235771973742035)
,p_default_menur_template=>wwv_flow_api.id(24245177604742064)
,p_default_listr_template=>wwv_flow_api.id(24235771973742035)
,p_default_irr_template=>wwv_flow_api.id(24233880401742026)
,p_default_report_template=>wwv_flow_api.id(24262063313742124)
,p_default_label_template=>wwv_flow_api.id(24295347200742259)
,p_default_menu_template=>wwv_flow_api.id(24297892105742272)
,p_default_calendar_template=>wwv_flow_api.id(24297975811742278)
,p_default_list_template=>wwv_flow_api.id(24293462578742249)
,p_default_nav_list_template=>wwv_flow_api.id(24284310417742218)
,p_default_top_nav_list_temp=>wwv_flow_api.id(24284310417742218)
,p_default_side_nav_list_temp=>wwv_flow_api.id(24282651135742212)
,p_default_nav_list_position=>'SIDE'
,p_default_dialogbtnr_template=>wwv_flow_api.id(24209351005741929)
,p_default_dialogr_template=>wwv_flow_api.id(24208351153741927)
,p_default_option_label=>wwv_flow_api.id(24295347200742259)
,p_default_required_label=>wwv_flow_api.id(24295651959742260)
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_default_navbar_list_template=>wwv_flow_api.id(24285515375742222)
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(42),'#IMAGE_PREFIX#themes/theme_42/1.4/')
,p_files_version=>64
,p_icon_library=>'FONTAPEX'
,p_javascript_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#libraries/apex/#MIN_DIRECTORY#widget.stickyWidget#MIN#.js?v=#APEX_VERSION#',
'#THEME_IMAGES#js/theme42#MIN#.js?v=#APEX_VERSION#'))
,p_css_file_urls=>'#THEME_IMAGES#css/Core#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(32341991819330168)
,p_theme_id=>42
,p_name=>'Vista'
,p_css_file_urls=>'#THEME_IMAGES#css/Vista#MIN#.css?v=#APEX_VERSION#'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_read_only=>true
,p_reference_id=>4007676303523989775
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(32342384583330168)
,p_theme_id=>42
,p_name=>'Vita'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>true
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
,p_reference_id=>2719875314571594493
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(32342776526330169)
,p_theme_id=>42
,p_name=>'Vita - Dark'
,p_is_current=>true
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Dark.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Dark#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
,p_reference_id=>3543348412015319650
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(32343202713330169)
,p_theme_id=>42
,p_name=>'Vita - Red'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Red.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Red#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
,p_reference_id=>1938457712423918173
);
wwv_flow_api.create_theme_style(
 p_id=>wwv_flow_api.id(32343549143330170)
,p_theme_id=>42
,p_name=>'Vita - Slate'
,p_is_current=>false
,p_is_public=>true
,p_is_accessible=>false
,p_theme_roller_input_file_urls=>'#THEME_IMAGES#less/theme/Vita-Slate.less'
,p_theme_roller_output_file_url=>'#THEME_IMAGES#css/Vita-Slate#MIN#.css?v=#APEX_VERSION#'
,p_theme_roller_read_only=>true
,p_reference_id=>3291983347983194966
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/theme_display_points
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32472883306330327)
,p_theme_id=>42
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>40
,p_template_types=>'BUTTON'
,p_help_text=>'Enables you to group many buttons together into a pill. You can use this option to specify where the button is within this set. Set the option to Default if this button is not part of a button set.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32473226654330327)
,p_theme_id=>42
,p_name=>'ICON_HOVER_ANIMATION'
,p_display_name=>'Icon Hover Animation'
,p_display_sequence=>55
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32473644079330327)
,p_theme_id=>42
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>50
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the position of the icon relative to the label.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32474045935330328)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>10
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the size of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32474498379330328)
,p_theme_id=>42
,p_name=>'SPACING_BOTTOM'
,p_display_name=>'Spacing Bottom'
,p_display_sequence=>100
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the bottom of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32474907133330328)
,p_theme_id=>42
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing Left'
,p_display_sequence=>70
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the left of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32475224341330329)
,p_theme_id=>42
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>80
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the right of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32475714308330329)
,p_theme_id=>42
,p_name=>'SPACING_TOP'
,p_display_name=>'Spacing Top'
,p_display_sequence=>90
,p_template_types=>'BUTTON'
,p_help_text=>'Controls the spacing to the top of the button.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32476073302330329)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>30
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the style of the button. Use the "Simple" option for secondary actions or sets of buttons. Use the "Remove UI Decoration" option to make the button appear as text.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32476435875330330)
,p_theme_id=>42
,p_name=>'TYPE'
,p_display_name=>'Type'
,p_display_sequence=>20
,p_template_types=>'BUTTON'
,p_null_text=>'Normal'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32476904035330330)
,p_theme_id=>42
,p_name=>'WIDTH'
,p_display_name=>'Width'
,p_display_sequence=>60
,p_template_types=>'BUTTON'
,p_help_text=>'Sets the width of the button.'
,p_null_text=>'Auto - Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32477231193330330)
,p_theme_id=>42
,p_name=>'BOTTOM_MARGIN'
,p_display_name=>'Bottom Margin'
,p_display_sequence=>220
,p_template_types=>'FIELD'
,p_help_text=>'Set the bottom margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32477690930330331)
,p_theme_id=>42
,p_name=>'ITEM_POST_TEXT'
,p_display_name=>'Item Post Text'
,p_display_sequence=>30
,p_template_types=>'FIELD'
,p_help_text=>'Adjust the display of the Item Post Text'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32478092506330331)
,p_theme_id=>42
,p_name=>'ITEM_PRE_TEXT'
,p_display_name=>'Item Pre Text'
,p_display_sequence=>20
,p_template_types=>'FIELD'
,p_help_text=>'Adjust the display of the Item Pre Text'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32478481706330331)
,p_theme_id=>42
,p_name=>'LEFT_MARGIN'
,p_display_name=>'Left Margin'
,p_display_sequence=>220
,p_template_types=>'FIELD'
,p_help_text=>'Set the left margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32478840116330332)
,p_theme_id=>42
,p_name=>'PRESERVE_LABEL_SPACING'
,p_display_name=>'Preserve Label Spacing'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_help_text=>'Preserves the label space and enables use of the Label Column Span property.'
,p_null_text=>'Yes'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32479278815330332)
,p_theme_id=>42
,p_name=>'RADIO_GROUP_DISPLAY'
,p_display_name=>'Item Group Display'
,p_display_sequence=>300
,p_template_types=>'FIELD'
,p_help_text=>'Determines the display style for radio and check box items.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32479705125330332)
,p_theme_id=>42
,p_name=>'RIGHT_MARGIN'
,p_display_name=>'Right Margin'
,p_display_sequence=>230
,p_template_types=>'FIELD'
,p_help_text=>'Set the right margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32480058569330333)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>10
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32480479429330333)
,p_theme_id=>42
,p_name=>'TOP_MARGIN'
,p_display_name=>'Top Margin'
,p_display_sequence=>200
,p_template_types=>'FIELD'
,p_help_text=>'Set the top margin for this field.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32480894372330334)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>80
,p_template_types=>'LIST'
,p_help_text=>'Sets the hover and focus animation.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32481262021330334)
,p_theme_id=>42
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>70
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32481688854330335)
,p_theme_id=>42
,p_name=>'BODY_TEXT'
,p_display_name=>'Body Text'
,p_display_sequence=>40
,p_template_types=>'LIST'
,p_help_text=>'Determines the height of the card body.'
,p_null_text=>'Auto'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32482098587330335)
,p_theme_id=>42
,p_name=>'COLLAPSE_STYLE'
,p_display_name=>'Collapse Mode'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'Icon (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32482500789330336)
,p_theme_id=>42
,p_name=>'COLOR_ACCENTS'
,p_display_name=>'Color Accents'
,p_display_sequence=>50
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32482825694330336)
,p_theme_id=>42
,p_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_sequence=>90
,p_template_types=>'LIST'
,p_help_text=>'Determines the display for a desktop-sized screen'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32483235197330336)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32483622363330337)
,p_theme_id=>42
,p_name=>'ICONS'
,p_display_name=>'Icons'
,p_display_sequence=>20
,p_template_types=>'LIST'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32484029829330337)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'LIST'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Circle'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32484430557330338)
,p_theme_id=>42
,p_name=>'ICON_STYLE'
,p_display_name=>'Icon Style'
,p_display_sequence=>35
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32484836138330338)
,p_theme_id=>42
,p_name=>'LABEL_DISPLAY'
,p_display_name=>'Label Display'
,p_display_sequence=>50
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32485254346330339)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>30
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32485695904330340)
,p_theme_id=>42
,p_name=>'MOBILE'
,p_display_name=>'Mobile'
,p_display_sequence=>100
,p_template_types=>'LIST'
,p_help_text=>'Determines the display for a mobile-sized screen'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32486045184330340)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32486504999330341)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>10
,p_template_types=>'LIST'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32486857874330341)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND'
,p_display_name=>'Page Background'
,p_display_sequence=>20
,p_template_types=>'PAGE'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32487283489330343)
,p_theme_id=>42
,p_name=>'PAGE_LAYOUT'
,p_display_name=>'Page Layout'
,p_display_sequence=>10
,p_template_types=>'PAGE'
,p_null_text=>'Floating (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32487693414330343)
,p_theme_id=>42
,p_name=>'ACCENT'
,p_display_name=>'Accent'
,p_display_sequence=>30
,p_template_types=>'REGION'
,p_help_text=>'Set the Region''s accent. This accent corresponds to a Theme-Rollable color and sets the background of the Region''s Header.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32488066455330345)
,p_theme_id=>42
,p_name=>'ALERT_DISPLAY'
,p_display_name=>'Alert Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the layout of the Alert Region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32488519493330345)
,p_theme_id=>42
,p_name=>'ALERT_ICONS'
,p_display_name=>'Alert Icons'
,p_display_sequence=>2
,p_template_types=>'REGION'
,p_help_text=>'Sets how icons are handled for the Alert Region.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32488884449330346)
,p_theme_id=>42
,p_name=>'ALERT_TITLE'
,p_display_name=>'Alert Title'
,p_display_sequence=>40
,p_template_types=>'REGION'
,p_help_text=>'Determines how the title of the alert is displayed.'
,p_null_text=>'Visible - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32489232504330346)
,p_theme_id=>42
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>3
,p_template_types=>'REGION'
,p_help_text=>'Sets the type of alert which can be used to determine the icon, icon color, and the background color.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32489685368330346)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Sets the animation when navigating within the Carousel Region.'
,p_null_text=>'Fade'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32490058208330347)
,p_theme_id=>42
,p_name=>'BODY_HEIGHT'
,p_display_name=>'Body Height'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Sets the Region Body height. You can also specify a custom height by modifying the Region''s CSS Classes and using the height helper classes "i-hXXX" where XXX is any increment of 10 from 100 to 800.'
,p_null_text=>'Auto - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32490497117330348)
,p_theme_id=>42
,p_name=>'BODY_OVERFLOW'
,p_display_name=>'Body Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines the scroll behavior when the region contents are larger than their container.'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32490884384330348)
,p_theme_id=>42
,p_name=>'BODY_PADDING'
,p_display_name=>'Body Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the Region Body padding for the region.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32491295182330349)
,p_theme_id=>42
,p_name=>'BODY_STYLE'
,p_display_name=>'Body Style'
,p_display_sequence=>20
,p_template_types=>'REGION'
,p_help_text=>'Controls the display of the region''s body container.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32491681640330349)
,p_theme_id=>42
,p_name=>'CALLOUT_POSITION'
,p_display_name=>'Callout Position'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Determines where the callout for the popup will be positioned relative to its parent.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32492077457330350)
,p_theme_id=>42
,p_name=>'COLLAPSIBLE_BUTTON_ICONS'
,p_display_name=>'Collapsible Button Icons'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines which arrows to use to represent the icons for the collapse and expand button.'
,p_null_text=>'Arrows'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32492433292330350)
,p_theme_id=>42
,p_name=>'COLLAPSIBLE_ICON_POSITION'
,p_display_name=>'Collapsible Icon Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Determines the position of the expand and collapse toggle for the region.'
,p_null_text=>'Start'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32492889701330350)
,p_theme_id=>42
,p_name=>'DEFAULT_STATE'
,p_display_name=>'Default State'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the default state of the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32493278475330350)
,p_theme_id=>42
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32493683512330351)
,p_theme_id=>42
,p_name=>'DISPLAY_ICON'
,p_display_name=>'Display Icon'
,p_display_sequence=>50
,p_template_types=>'REGION'
,p_help_text=>'Display the Hero Region icon.'
,p_null_text=>'Yes (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32494060565330351)
,p_theme_id=>42
,p_name=>'HEADER'
,p_display_name=>'Header'
,p_display_sequence=>20
,p_template_types=>'REGION'
,p_help_text=>'Determines the display of the Region Header which also contains the Region Title.'
,p_null_text=>'Visible - Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32494441229330351)
,p_theme_id=>42
,p_name=>'HIDE_STEPS_FOR'
,p_display_name=>'Hide Steps For'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32494875613330352)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'REGION'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Rounded Corners'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32495259159330352)
,p_theme_id=>42
,p_name=>'ITEM_PADDING'
,p_display_name=>'Item Padding'
,p_display_sequence=>100
,p_template_types=>'REGION'
,p_help_text=>'Sets the padding around items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32495654760330353)
,p_theme_id=>42
,p_name=>'ITEM_SIZE'
,p_display_name=>'Item Size'
,p_display_sequence=>110
,p_template_types=>'REGION'
,p_help_text=>'Sets the size of the form items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32496116307330353)
,p_theme_id=>42
,p_name=>'ITEM_WIDTH'
,p_display_name=>'Item Width'
,p_display_sequence=>120
,p_template_types=>'REGION'
,p_help_text=>'Sets the width of the form items within this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32496457543330353)
,p_theme_id=>42
,p_name=>'LABEL_ALIGNMENT'
,p_display_name=>'Label Alignment'
,p_display_sequence=>130
,p_template_types=>'REGION'
,p_help_text=>'Set the label text alignment for items within this region.'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32496823609330354)
,p_theme_id=>42
,p_name=>'LABEL_POSITION'
,p_display_name=>'Label Position'
,p_display_sequence=>140
,p_template_types=>'REGION'
,p_help_text=>'Sets the position of the label relative to the form item.'
,p_null_text=>'Inline - Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32497233983330354)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32497637188330354)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER'
,p_display_name=>'Login Header'
,p_display_sequence=>10
,p_template_types=>'REGION'
,p_help_text=>'Controls the display of the Login region header.'
,p_null_text=>'Icon and Title (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32498093921330354)
,p_theme_id=>42
,p_name=>'REGION_BOTTOM_MARGIN'
,p_display_name=>'Bottom Margin'
,p_display_sequence=>210
,p_template_types=>'REGION'
,p_help_text=>'Set the bottom margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32498475956330355)
,p_theme_id=>42
,p_name=>'REGION_LEFT_MARGIN'
,p_display_name=>'Left Margin'
,p_display_sequence=>220
,p_template_types=>'REGION'
,p_help_text=>'Set the left margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32498900501330355)
,p_theme_id=>42
,p_name=>'REGION_RIGHT_MARGIN'
,p_display_name=>'Right Margin'
,p_display_sequence=>230
,p_template_types=>'REGION'
,p_help_text=>'Set the right margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32499222129330356)
,p_theme_id=>42
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Sets the source of the Title Bar region''s title.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32499650665330356)
,p_theme_id=>42
,p_name=>'REGION_TOP_MARGIN'
,p_display_name=>'Top Margin'
,p_display_sequence=>200
,p_template_types=>'REGION'
,p_help_text=>'Set the top margin for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32500110251330356)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>40
,p_template_types=>'REGION'
,p_help_text=>'Determines how the region is styled. Use the "Remove Borders" template option to remove the region''s borders and shadows.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32500510125330357)
,p_theme_id=>42
,p_name=>'TABS_SIZE'
,p_display_name=>'Tabs Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32500902965330357)
,p_theme_id=>42
,p_name=>'TAB_STYLE'
,p_display_name=>'Tab Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32501225671330357)
,p_theme_id=>42
,p_name=>'TIMER'
,p_display_name=>'Timer'
,p_display_sequence=>2
,p_template_types=>'REGION'
,p_help_text=>'Sets the timer for when to automatically navigate to the next region within the Carousel Region.'
,p_null_text=>'No Timer'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32501686145330358)
,p_theme_id=>42
,p_name=>'ALTERNATING_ROWS'
,p_display_name=>'Alternating Rows'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Shades alternate rows in the report with slightly different background colors.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32502108183330358)
,p_theme_id=>42
,p_name=>'ANIMATION'
,p_display_name=>'Animation'
,p_display_sequence=>70
,p_template_types=>'REPORT'
,p_help_text=>'Sets the hover and focus animation.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32502506558330358)
,p_theme_id=>42
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32502841769330359)
,p_theme_id=>42
,p_name=>'BODY_TEXT'
,p_display_name=>'Body Text'
,p_display_sequence=>40
,p_template_types=>'REPORT'
,p_help_text=>'Determines the height of the card body.'
,p_null_text=>'Auto'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32503272419330359)
,p_theme_id=>42
,p_name=>'COLOR_ACCENTS'
,p_display_name=>'Color Accents'
,p_display_sequence=>50
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32503695230330359)
,p_theme_id=>42
,p_name=>'COL_ACTIONS'
,p_display_name=>'Actions'
,p_display_sequence=>150
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32504076295330360)
,p_theme_id=>42
,p_name=>'COL_CONTENT_DESCRIPTION'
,p_display_name=>'Description'
,p_display_sequence=>130
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32504475954330360)
,p_theme_id=>42
,p_name=>'COL_CONTENT_TITLE'
,p_display_name=>'Title'
,p_display_sequence=>120
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32504920215330360)
,p_theme_id=>42
,p_name=>'COL_ICON'
,p_display_name=>'Icon'
,p_display_sequence=>110
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32505256046330361)
,p_theme_id=>42
,p_name=>'COL_MISC'
,p_display_name=>'Misc'
,p_display_sequence=>140
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32505641780330361)
,p_theme_id=>42
,p_name=>'COL_SELECTION'
,p_display_name=>'Selection'
,p_display_sequence=>100
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32506114243330362)
,p_theme_id=>42
,p_name=>'COMMENTS_STYLE'
,p_display_name=>'Comments Style'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Determines the style in which comments are displayed.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32506433996330362)
,p_theme_id=>42
,p_name=>'CONTENT_ALIGNMENT'
,p_display_name=>'Content Alignment'
,p_display_sequence=>90
,p_template_types=>'REPORT'
,p_null_text=>'Center (Default)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32506875021330362)
,p_theme_id=>42
,p_name=>'ICONS'
,p_display_name=>'Icons'
,p_display_sequence=>20
,p_template_types=>'REPORT'
,p_help_text=>'Controls how to handle icons in the report.'
,p_null_text=>'No Icons'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32507249310330363)
,p_theme_id=>42
,p_name=>'ICON_SHAPE'
,p_display_name=>'Icon Shape'
,p_display_sequence=>60
,p_template_types=>'REPORT'
,p_help_text=>'Determines the shape of the icon.'
,p_null_text=>'Circle'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32507621173330363)
,p_theme_id=>42
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32508113442330363)
,p_theme_id=>42
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>30
,p_template_types=>'REPORT'
,p_help_text=>'Determines the layout of Cards in the report.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32508518186330364)
,p_theme_id=>42
,p_name=>'PAGINATION_DISPLAY'
,p_display_name=>'Pagination Display'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Controls the display of pagination for this region.'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32508905062330364)
,p_theme_id=>42
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>30
,p_template_types=>'REPORT'
,p_help_text=>'Controls the display of the Report''s borders.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32509220565330364)
,p_theme_id=>42
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>20
,p_template_types=>'REPORT'
,p_help_text=>'Determines whether you want the row to be highlighted on hover.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32509670220330365)
,p_theme_id=>42
,p_name=>'SIZE'
,p_display_name=>'Size'
,p_display_sequence=>35
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_opt_group(
 p_id=>wwv_flow_api.id(32510061757330365)
,p_theme_id=>42
,p_name=>'STYLE'
,p_display_name=>'Style'
,p_display_sequence=>10
,p_template_types=>'REPORT'
,p_help_text=>'Determines the overall style for the component.'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24185287070741813)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24182559413741766)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24188387835741826)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24185340265741816)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24189881196741838)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_1'
,p_display_name=>'Background 1'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_css_classes=>'t-LoginPage--bg1'
,p_group_id=>wwv_flow_api.id(32486857874330341)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24190088692741839)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_2'
,p_display_name=>'Background 2'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_css_classes=>'t-LoginPage--bg2'
,p_group_id=>wwv_flow_api.id(32486857874330341)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24190284828741840)
,p_theme_id=>42
,p_name=>'PAGE_BACKGROUND_3'
,p_display_name=>'Background 3'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_css_classes=>'t-LoginPage--bg3'
,p_group_id=>wwv_flow_api.id(32486857874330341)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24190711026741843)
,p_theme_id=>42
,p_name=>'PAGE_LAYOUT_SPLIT'
,p_display_name=>'Split'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(24188478770741827)
,p_css_classes=>'t-LoginPage--split'
,p_group_id=>wwv_flow_api.id(32487283489330343)
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24193789185741858)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24190767808741843)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24196279371741866)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24193871274741859)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24197557746741871)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_page_template_id=>wwv_flow_api.id(24196406975741866)
,p_css_classes=>'t-Dialog--noPadding'
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24197792197741871)
,p_theme_id=>42
,p_name=>'STRETCH_TO_FIT_WINDOW'
,p_display_name=>'Stretch to Fit Window'
,p_display_sequence=>1
,p_page_template_id=>wwv_flow_api.id(24196406975741866)
,p_css_classes=>'ui-dialog--stretch'
,p_template_types=>'PAGE'
,p_help_text=>'Stretch the dialog to fit the browser window.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24200551193741878)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24197843513741871)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24203118270741885)
,p_theme_id=>42
,p_name=>'STICKY_HEADER_ON_MOBILE'
,p_display_name=>'Sticky Header on Mobile'
,p_display_sequence=>100
,p_page_template_id=>wwv_flow_api.id(24200712199741878)
,p_css_classes=>'js-pageStickyMobileHeader'
,p_template_types=>'PAGE'
,p_help_text=>'This will position the contents of the Breadcrumb Bar region position so it sticks to the top of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24204417543741888)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_page_template_id=>wwv_flow_api.id(24203207540741885)
,p_css_classes=>'t-Dialog--noPadding'
,p_template_types=>'PAGE'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24204549798741891)
,p_theme_id=>42
,p_name=>'STRETCH_TO_FIT_WINDOW'
,p_display_name=>'Stretch to Fit Window'
,p_display_sequence=>10
,p_page_template_id=>wwv_flow_api.id(24203207540741885)
,p_css_classes=>'ui-dialog--stretch'
,p_template_types=>'PAGE'
,p_help_text=>'Stretch the dialog to fit the browser window.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24205221494741917)
,p_theme_id=>42
,p_name=>'COLOREDBACKGROUND'
,p_display_name=>'Highlight Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--colorBG'
,p_template_types=>'REGION'
,p_help_text=>'Set alert background color to that of the alert type (warning, success, etc.)'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24205624495741920)
,p_theme_id=>42
,p_name=>'DANGER'
,p_display_name=>'Danger'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--danger'
,p_group_id=>wwv_flow_api.id(32489232504330346)
,p_template_types=>'REGION'
,p_help_text=>'Show an error or danger alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24206104451741922)
,p_theme_id=>42
,p_name=>'HIDDENHEADER'
,p_display_name=>'Hidden but Accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--accessibleHeading'
,p_group_id=>wwv_flow_api.id(32488884449330346)
,p_template_types=>'REGION'
,p_help_text=>'Visually hides the alert title, but assistive technologies can still read it.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24206226455741922)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--removeHeading'
,p_group_id=>wwv_flow_api.id(32488884449330346)
,p_template_types=>'REGION'
,p_help_text=>'Hides the Alert Title from being displayed.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24206674468741922)
,p_theme_id=>42
,p_name=>'HIDE_ICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--noIcon'
,p_group_id=>wwv_flow_api.id(32488519493330345)
,p_template_types=>'REGION'
,p_help_text=>'Hides alert icons'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24207069459741922)
,p_theme_id=>42
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--horizontal'
,p_group_id=>wwv_flow_api.id(32488066455330345)
,p_template_types=>'REGION'
,p_help_text=>'Show horizontal alert with buttons to the right.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24207302370741923)
,p_theme_id=>42
,p_name=>'INFORMATION'
,p_display_name=>'Information'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--info'
,p_group_id=>wwv_flow_api.id(32489232504330346)
,p_template_types=>'REGION'
,p_help_text=>'Show informational alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24207445137741923)
,p_theme_id=>42
,p_name=>'SHOW_CUSTOM_ICONS'
,p_display_name=>'Show Custom Icons'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--customIcons'
,p_group_id=>wwv_flow_api.id(32488519493330345)
,p_template_types=>'REGION'
,p_help_text=>'Set custom icons by modifying the Alert Region''s Icon CSS Classes property.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24207718826741924)
,p_theme_id=>42
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--success'
,p_group_id=>wwv_flow_api.id(32489232504330346)
,p_template_types=>'REGION'
,p_help_text=>'Show success alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24207901729741924)
,p_theme_id=>42
,p_name=>'USEDEFAULTICONS'
,p_display_name=>'Show Default Icons'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--defaultIcons'
,p_group_id=>wwv_flow_api.id(32488519493330345)
,p_template_types=>'REGION'
,p_help_text=>'Uses default icons for alert types.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24208083161741925)
,p_theme_id=>42
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--warning'
,p_group_id=>wwv_flow_api.id(32489232504330346)
,p_template_types=>'REGION'
,p_help_text=>'Show a warning alert.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24208300586741927)
,p_theme_id=>42
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24204662079741892)
,p_css_classes=>'t-Alert--wizard'
,p_group_id=>wwv_flow_api.id(32488066455330345)
,p_template_types=>'REGION'
,p_help_text=>'Show the alert in a wizard style region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24210520045741933)
,p_theme_id=>42
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24209351005741929)
,p_css_classes=>'t-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24210831317741936)
,p_theme_id=>42
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_api.id(24209351005741929)
,p_css_classes=>'t-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_api.id(32490884384330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24211023565741937)
,p_theme_id=>42
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>4
,p_region_template_id=>wwv_flow_api.id(24209351005741929)
,p_css_classes=>'t-ButtonRegion--noUI'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24211232000741937)
,p_theme_id=>42
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>5
,p_region_template_id=>wwv_flow_api.id(24209351005741929)
,p_css_classes=>'t-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_api.id(32490884384330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24211519424741938)
,p_theme_id=>42
,p_name=>'STICK_TO_BOTTOM'
,p_display_name=>'Stick to Bottom for Mobile'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24209351005741929)
,p_css_classes=>'t-ButtonRegion--stickToBottom'
,p_template_types=>'REGION'
,p_help_text=>'This will position the button container region to the bottom of the screen for small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24212715298741945)
,p_theme_id=>42
,p_name=>'10_SECONDS'
,p_display_name=>'10 Seconds'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-cycle10s'
,p_group_id=>wwv_flow_api.id(32501225671330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24212908976741946)
,p_theme_id=>42
,p_name=>'15_SECONDS'
,p_display_name=>'15 Seconds'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-cycle15s'
,p_group_id=>wwv_flow_api.id(32501225671330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24213075024741947)
,p_theme_id=>42
,p_name=>'20_SECONDS'
,p_display_name=>'20 Seconds'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-cycle20s'
,p_group_id=>wwv_flow_api.id(32501225671330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24213503198741947)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24213689239741948)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24213868482741948)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24214031091741949)
,p_theme_id=>42
,p_name=>'5_SECONDS'
,p_display_name=>'5 Seconds'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-cycle5s'
,p_group_id=>wwv_flow_api.id(32501225671330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24214222211741952)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24214691853741954)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24214887928741954)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24215074650741954)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24215315193741954)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24215436256741954)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24215865952741956)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--removeHeader'
,p_group_id=>wwv_flow_api.id(32494060565330351)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24216295920741957)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24216470417741960)
,p_theme_id=>42
,p_name=>'HIDEREGIONHEADER'
,p_display_name=>'Hidden but accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(32494060565330351)
,p_template_types=>'REGION'
,p_help_text=>'This option will hide the region header.  Note that the region title will still be audible for Screen Readers. Buttons placed in the region header will be hidden and inaccessible.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24216678749741961)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24216916736741961)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24217110211741961)
,p_theme_id=>42
,p_name=>'REMEMBER_CAROUSEL_SLIDE'
,p_display_name=>'Remember Carousel Slide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24217288056741961)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24217476719741962)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Region Header to maximize the region. Clicking this button will toggle the maximize state and stretch the region to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24217684645741962)
,p_theme_id=>42
,p_name=>'SHOW_NEXT_AND_PREVIOUS_BUTTONS'
,p_display_name=>'Show Next and Previous Buttons'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--showCarouselControls'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24217875680741962)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24218239988741963)
,p_theme_id=>42
,p_name=>'SLIDE'
,p_display_name=>'Slide'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--carouselSlide'
,p_group_id=>wwv_flow_api.id(32489685368330346)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24218465234741964)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--carouselSpin'
,p_group_id=>wwv_flow_api.id(32489685368330346)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24218623177741965)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24211577744741938)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24219691525741968)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24219870570741968)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24220100910741969)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets body height to 480px.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24220318390741969)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets body height to 640px.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24220500729741969)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24220701319741970)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24220908356741970)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24221117992741971)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24221294580741972)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24221700171741973)
,p_theme_id=>42
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_api.id(32492889701330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24222046460741975)
,p_theme_id=>42
,p_name=>'CONRTOLS_POSITION_END'
,p_display_name=>'End'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--controlsPosEnd'
,p_group_id=>wwv_flow_api.id(32492433292330350)
,p_template_types=>'REGION'
,p_help_text=>'Position the expand / collapse button to the end of the region header.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24222245786741975)
,p_theme_id=>42
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_api.id(32492889701330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24222517660741976)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24222856474741978)
,p_theme_id=>42
,p_name=>'ICONS_PLUS_OR_MINUS'
,p_display_name=>'Plus or Minus'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--hideShowIconsMath'
,p_group_id=>wwv_flow_api.id(32492077457330350)
,p_template_types=>'REGION'
,p_help_text=>'Use the plus and minus icons for the expand and collapse button.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24223089579741979)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24223250786741984)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24223456991741984)
,p_theme_id=>42
,p_name=>'REMEMBER_COLLAPSIBLE_STATE'
,p_display_name=>'Remember Collapsible State'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
,p_help_text=>'This option saves the current state of the collapsible region for the duration of the session.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24223696189741985)
,p_theme_id=>42
,p_name=>'REMOVE_UI_DECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--noUI'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes UI decoration (borders, backgrounds, shadows, etc) from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24223897656741985)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll - Default'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24224119232741986)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24218751700741965)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24224478138741988)
,p_theme_id=>42
,p_name=>'ADD_BODY_PADDING'
,p_display_name=>'Add Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--padded'
,p_template_types=>'REGION'
,p_help_text=>'Adds padding to the region''s body container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24224919098741990)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H1'
,p_display_name=>'Heading Level 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--h1'
,p_group_id=>wwv_flow_api.id(32499222129330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24225064538741990)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H2'
,p_display_name=>'Heading Level 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--h2'
,p_group_id=>wwv_flow_api.id(32499222129330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24225309524741991)
,p_theme_id=>42
,p_name=>'CONTENT_TITLE_H3'
,p_display_name=>'Heading Level 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--h3'
,p_group_id=>wwv_flow_api.id(32499222129330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24225676295741991)
,p_theme_id=>42
,p_name=>'LIGHT_BACKGROUND'
,p_display_name=>'Light Background'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--lightBG'
,p_group_id=>wwv_flow_api.id(32491295182330349)
,p_template_types=>'REGION'
,p_help_text=>'Gives the region body a slightly lighter background.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24225884547741992)
,p_theme_id=>42
,p_name=>'SHADOW_BACKGROUND'
,p_display_name=>'Shadow Background'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--shadowBG'
,p_group_id=>wwv_flow_api.id(32491295182330349)
,p_template_types=>'REGION'
,p_help_text=>'Gives the region body a slightly darker background.'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24226077464741993)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24224131411741986)
,p_css_classes=>'t-ContentBlock--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24226977467741995)
,p_theme_id=>42
,p_name=>'DISPLAY_ICON_NO'
,p_display_name=>'No'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--hideIcon'
,p_group_id=>wwv_flow_api.id(32493683512330351)
,p_template_types=>'REGION'
,p_help_text=>'Hide the Hero Region icon.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24227122337741996)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--featured'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24227550128741997)
,p_theme_id=>42
,p_name=>'ICONS_CIRCULAR'
,p_display_name=>'Circle'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--iconsCircle'
,p_group_id=>wwv_flow_api.id(32494875613330352)
,p_template_types=>'REGION'
,p_help_text=>'The icons are displayed within a circle.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24227732163741997)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--iconsSquare'
,p_group_id=>wwv_flow_api.id(32494875613330352)
,p_template_types=>'REGION'
,p_help_text=>'The icons are displayed within a square.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24227981920741999)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the hero region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24228198318742000)
,p_theme_id=>42
,p_name=>'STACKED_FEATURED'
,p_display_name=>'Stacked Featured'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24226159227741993)
,p_css_classes=>'t-HeroRegion--featured t-HeroRegion--centered'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24228863193742002)
,p_theme_id=>42
,p_name=>'AUTO_HEIGHT_INLINE_DIALOG'
,p_display_name=>'Auto Height'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-dialog-autoheight'
,p_template_types=>'REGION'
,p_help_text=>'This option will set the height of the dialog to fit its contents.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24229085259742004)
,p_theme_id=>42
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24229514928742010)
,p_theme_id=>42
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24229682563742010)
,p_theme_id=>42
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24229831685742011)
,p_theme_id=>42
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24230043273742012)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>5
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'t-DialogRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the region body.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24230232637742014)
,p_theme_id=>42
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24230473704742016)
,p_theme_id=>42
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24228268014742000)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24231361895742017)
,p_theme_id=>42
,p_name=>'ABOVE'
,p_display_name=>'Above'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-pos-above'
,p_group_id=>wwv_flow_api.id(32491681640330349)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout above or typically on top of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24231616933742018)
,p_theme_id=>42
,p_name=>'AFTER'
,p_display_name=>'After'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-pos-after'
,p_group_id=>wwv_flow_api.id(32491681640330349)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout after or typically to the right of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24231801263742018)
,p_theme_id=>42
,p_name=>'AUTO_HEIGHT_INLINE_DIALOG'
,p_display_name=>'Auto Height'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-dialog-autoheight'
,p_template_types=>'REGION'
,p_help_text=>'This option will set the height of the dialog to fit its contents.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24231922844742018)
,p_theme_id=>42
,p_name=>'BEFORE'
,p_display_name=>'Before'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-pos-before'
,p_group_id=>wwv_flow_api.id(32491681640330349)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout before or typically to the left of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24232214497742018)
,p_theme_id=>42
,p_name=>'BELOW'
,p_display_name=>'Below'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-pos-below'
,p_group_id=>wwv_flow_api.id(32491681640330349)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout below or typically to the bottom of the parent.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24232405506742019)
,p_theme_id=>42
,p_name=>'DISPLAY_POPUP_CALLOUT'
,p_display_name=>'Display Popup Callout'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-callout'
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add display a callout for the popup. Note that callout will only be displayed if the data-parent-element custom attribute is defined.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24232593892742019)
,p_theme_id=>42
,p_name=>'INSIDE'
,p_display_name=>'Inside'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-pos-inside'
,p_group_id=>wwv_flow_api.id(32491681640330349)
,p_template_types=>'REGION'
,p_help_text=>'Positions the callout inside of the parent. This is useful when the parent is sufficiently large, such as a report or large region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24232726353742019)
,p_theme_id=>42
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24232938992742019)
,p_theme_id=>42
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24233193219742021)
,p_theme_id=>42
,p_name=>'NONE'
,p_display_name=>'None'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-dialog-nosize'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24233349986742021)
,p_theme_id=>42
,p_name=>'REMOVE_BODY_PADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'t-DialogRegion--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes the padding around the region body.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24233535207742023)
,p_theme_id=>42
,p_name=>'REMOVE_PAGE_OVERLAY'
,p_display_name=>'Remove Page Overlay'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-popup-noOverlay'
,p_template_types=>'REGION'
,p_help_text=>'This option will display the inline dialog without an overlay on the background.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24233814011742026)
,p_theme_id=>42
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24230598242742016)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_api.id(32493278475330350)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24234152131742028)
,p_theme_id=>42
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24233880401742026)
,p_css_classes=>'t-IRR-region--noBorders'
,p_template_types=>'REGION'
,p_help_text=>'Removes borders around the Interactive Report'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24234339232742029)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24233880401742026)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Interactive Reports toolbar to maximize the report. Clicking this button will toggle the maximize state and stretch the report to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24235232870742034)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER_ICON'
,p_display_name=>'Icon'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24234455365742029)
,p_css_classes=>'t-Login-region--headerIcon'
,p_group_id=>wwv_flow_api.id(32497637188330354)
,p_template_types=>'REGION'
,p_help_text=>'Displays only the Region Icon in the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24235447921742034)
,p_theme_id=>42
,p_name=>'LOGIN_HEADER_TITLE'
,p_display_name=>'Title'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24234455365742029)
,p_css_classes=>'t-Login-region--headerTitle'
,p_group_id=>wwv_flow_api.id(32497637188330354)
,p_template_types=>'REGION'
,p_help_text=>'Displays only the Region Title in the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24235686296742035)
,p_theme_id=>42
,p_name=>'LOGO_HEADER_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24234455365742029)
,p_css_classes=>'t-Login-region--headerHidden'
,p_group_id=>wwv_flow_api.id(32497637188330354)
,p_template_types=>'REGION'
,p_help_text=>'Hides both the Region Icon and Title from the Login region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24236714738742037)
,p_theme_id=>42
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'i-h240'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 240px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24236845573742038)
,p_theme_id=>42
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'i-h320'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
,p_help_text=>'Sets region body height to 320px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24237028423742038)
,p_theme_id=>42
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'i-h480'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24237258579742039)
,p_theme_id=>42
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'i-h640'
,p_group_id=>wwv_flow_api.id(32490058208330347)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24237491615742039)
,p_theme_id=>42
,p_name=>'ACCENT_1'
,p_display_name=>'Accent 1'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent1'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24237680871742039)
,p_theme_id=>42
,p_name=>'ACCENT_10'
,p_display_name=>'Accent 10'
,p_display_sequence=>100
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent10'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24237873360742039)
,p_theme_id=>42
,p_name=>'ACCENT_11'
,p_display_name=>'Accent 11'
,p_display_sequence=>110
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent11'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24238111697742040)
,p_theme_id=>42
,p_name=>'ACCENT_12'
,p_display_name=>'Accent 12'
,p_display_sequence=>120
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent12'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24238292650742040)
,p_theme_id=>42
,p_name=>'ACCENT_13'
,p_display_name=>'Accent 13'
,p_display_sequence=>130
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent13'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24238424908742041)
,p_theme_id=>42
,p_name=>'ACCENT_14'
,p_display_name=>'Accent 14'
,p_display_sequence=>140
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent14'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24238653382742041)
,p_theme_id=>42
,p_name=>'ACCENT_15'
,p_display_name=>'Accent 15'
,p_display_sequence=>150
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent15'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24238908128742042)
,p_theme_id=>42
,p_name=>'ACCENT_2'
,p_display_name=>'Accent 2'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent2'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24239072151742042)
,p_theme_id=>42
,p_name=>'ACCENT_3'
,p_display_name=>'Accent 3'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent3'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24239238385742042)
,p_theme_id=>42
,p_name=>'ACCENT_4'
,p_display_name=>'Accent 4'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent4'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24239513858742043)
,p_theme_id=>42
,p_name=>'ACCENT_5'
,p_display_name=>'Accent 5'
,p_display_sequence=>50
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent5'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24239654455742046)
,p_theme_id=>42
,p_name=>'ACCENT_6'
,p_display_name=>'Accent 6'
,p_display_sequence=>60
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent6'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24239886717742047)
,p_theme_id=>42
,p_name=>'ACCENT_7'
,p_display_name=>'Accent 7'
,p_display_sequence=>70
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent7'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24240037359742047)
,p_theme_id=>42
,p_name=>'ACCENT_8'
,p_display_name=>'Accent 8'
,p_display_sequence=>80
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent8'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24240289233742047)
,p_theme_id=>42
,p_name=>'ACCENT_9'
,p_display_name=>'Accent 9'
,p_display_sequence=>90
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--accent9'
,p_group_id=>wwv_flow_api.id(32487693414330343)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24240452558742047)
,p_theme_id=>42
,p_name=>'HIDDENHEADERNOAT'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--removeHeader'
,p_group_id=>wwv_flow_api.id(32494060565330351)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24240688134742049)
,p_theme_id=>42
,p_name=>'HIDEOVERFLOW'
,p_display_name=>'Hide'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--hiddenOverflow'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24240854194742052)
,p_theme_id=>42
,p_name=>'HIDEREGIONHEADER'
,p_display_name=>'Hidden but accessible'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--hideHeader'
,p_group_id=>wwv_flow_api.id(32494060565330351)
,p_template_types=>'REGION'
,p_help_text=>'This option will hide the region header.  Note that the region title will still be audible for Screen Readers. Buttons placed in the region header will be hidden and inaccessible.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24241030891742053)
,p_theme_id=>42
,p_name=>'NOBODYPADDING'
,p_display_name=>'Remove Body Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--noPadding'
,p_template_types=>'REGION'
,p_help_text=>'Removes padding from region body.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24241262676742053)
,p_theme_id=>42
,p_name=>'NOBORDER'
,p_display_name=>'Remove Borders'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--noBorder'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes borders from the region.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24241485468742053)
,p_theme_id=>42
,p_name=>'REMOVE_UI_DECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--noUI'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes UI decoration (borders, backgrounds, shadows, etc) from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24241687736742053)
,p_theme_id=>42
,p_name=>'SCROLLBODY'
,p_display_name=>'Scroll - Default'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--scrollBody'
,p_group_id=>wwv_flow_api.id(32490497117330348)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24241897663742053)
,p_theme_id=>42
,p_name=>'SHOW_MAXIMIZE_BUTTON'
,p_display_name=>'Show Maximize Button'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'js-showMaximizeButton'
,p_template_types=>'REGION'
,p_help_text=>'Displays a button in the Region Header to maximize the region. Clicking this button will toggle the maximize state and stretch the region to fill the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24242033234742053)
,p_theme_id=>42
,p_name=>'SHOW_REGION_ICON'
,p_display_name=>'Show Region Icon'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--showIcon'
,p_template_types=>'REGION'
,p_help_text=>'Displays the region icon in the region header beside the region title'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24242319099742053)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stack Region'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--stacked'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes side borders and shadows, and can be useful for accordions and regions that need to be grouped together vertically.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24242518664742055)
,p_theme_id=>42
,p_name=>'TEXT_CONTENT'
,p_display_name=>'Text Content'
,p_display_sequence=>40
,p_region_template_id=>wwv_flow_api.id(24235771973742035)
,p_css_classes=>'t-Region--textContent'
,p_group_id=>wwv_flow_api.id(32500110251330356)
,p_template_types=>'REGION'
,p_help_text=>'Useful for displaying primarily text-based content, such as FAQs and more.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24243675035742061)
,p_theme_id=>42
,p_name=>'FILL_TAB_LABELS'
,p_display_name=>'Fill Tab Labels'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'t-TabsRegion-mod--fillLabels'
,p_group_id=>wwv_flow_api.id(32497233983330354)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24244033890742062)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Pill'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'t-TabsRegion-mod--pill'
,p_group_id=>wwv_flow_api.id(32500902965330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24244311742742063)
,p_theme_id=>42
,p_name=>'REMEMBER_ACTIVE_TAB'
,p_display_name=>'Remember Active Tab'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'js-useLocalStorage'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24244516866742063)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'t-TabsRegion-mod--simple'
,p_group_id=>wwv_flow_api.id(32500902965330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24244821680742064)
,p_theme_id=>42
,p_name=>'TABSLARGE'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'t-TabsRegion-mod--large'
,p_group_id=>wwv_flow_api.id(32500510125330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24245049332742064)
,p_theme_id=>42
,p_name=>'TABS_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24242606244742055)
,p_css_classes=>'t-TabsRegion-mod--small'
,p_group_id=>wwv_flow_api.id(32500510125330357)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24245421246742068)
,p_theme_id=>42
,p_name=>'GET_TITLE_FROM_BREADCRUMB'
,p_display_name=>'Use Current Breadcrumb Entry'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24245177604742064)
,p_css_classes=>'t-BreadcrumbRegion--useBreadcrumbTitle'
,p_group_id=>wwv_flow_api.id(32499222129330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24245675646742070)
,p_theme_id=>42
,p_name=>'HIDE_BREADCRUMB'
,p_display_name=>'Show Breadcrumbs'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24245177604742064)
,p_css_classes=>'t-BreadcrumbRegion--showBreadcrumb'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24245877243742070)
,p_theme_id=>42
,p_name=>'REGION_HEADER_VISIBLE'
,p_display_name=>'Use Region Title'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_api.id(24245177604742064)
,p_css_classes=>'t-BreadcrumbRegion--useRegionTitle'
,p_group_id=>wwv_flow_api.id(32499222129330356)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24246027241742070)
,p_theme_id=>42
,p_name=>'USE_COMPACT_STYLE'
,p_display_name=>'Use Compact Style'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24245177604742064)
,p_css_classes=>'t-BreadcrumbRegion--compactTitle'
,p_template_types=>'REGION'
,p_help_text=>'Uses a compact style for the breadcrumbs.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24246979833742073)
,p_theme_id=>42
,p_name=>'HIDESMALLSCREENS'
,p_display_name=>'Small Screens (Tablet)'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_api.id(24246181062742070)
,p_css_classes=>'t-Wizard--hideStepsSmall'
,p_group_id=>wwv_flow_api.id(32494441229330351)
,p_template_types=>'REGION'
,p_help_text=>'Hides the wizard progress steps for screens that are smaller than 768px wide.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24247133529742077)
,p_theme_id=>42
,p_name=>'HIDEXSMALLSCREENS'
,p_display_name=>'X Small Screens (Mobile)'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24246181062742070)
,p_css_classes=>'t-Wizard--hideStepsXSmall'
,p_group_id=>wwv_flow_api.id(32494441229330351)
,p_template_types=>'REGION'
,p_help_text=>'Hides the wizard progress steps for screens that are smaller than 768px wide.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24247409916742077)
,p_theme_id=>42
,p_name=>'SHOW_TITLE'
,p_display_name=>'Show Title'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_api.id(24246181062742070)
,p_css_classes=>'t-Wizard--showTitle'
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24247965738742084)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(24247467027742077)
,p_css_classes=>'t-Timeline--compact'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
,p_help_text=>'Displays a compact version of timeline with smaller text and fewer columns.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24248531835742085)
,p_theme_id=>42
,p_name=>'ACTIONS_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideActions'
,p_group_id=>wwv_flow_api.id(32503695230330359)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Actions column from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24249016101742085)
,p_theme_id=>42
,p_name=>'ALIGNMENT_TOP'
,p_display_name=>'Top'
,p_display_sequence=>100
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--alignTop'
,p_group_id=>wwv_flow_api.id(32506433996330362)
,p_template_types=>'REPORT'
,p_help_text=>'Aligns the content to the top of the row. This is useful when you expect that yours rows will vary in height (e.g. some rows will have longer descriptions than others).'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24249382474742086)
,p_theme_id=>42
,p_name=>'DESCRIPTION_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideDescription'
,p_group_id=>wwv_flow_api.id(32504076295330360)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Description from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24249787987742086)
,p_theme_id=>42
,p_name=>'ICON_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideIcon'
,p_group_id=>wwv_flow_api.id(32504920215330360)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Icon from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24250207109742089)
,p_theme_id=>42
,p_name=>'MISC_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideMisc'
,p_group_id=>wwv_flow_api.id(32505256046330361)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Misc column from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24250544557742089)
,p_theme_id=>42
,p_name=>'SELECTION_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideSelection'
,p_group_id=>wwv_flow_api.id(32505641780330361)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Selection column from being rendered on the screen.'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24250759104742089)
,p_theme_id=>42
,p_name=>'STYLE_COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--styleCompact'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
,p_help_text=>'This option reduces the padding and font sizes to present a compact display of the same information.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24251154163742090)
,p_theme_id=>42
,p_name=>'TITLE_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24248071060742085)
,p_css_classes=>'t-ContentRow--hideTitle'
,p_group_id=>wwv_flow_api.id(32504475954330360)
,p_template_types=>'REPORT'
,p_help_text=>'Hides the Title from being rendered on the screen.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24251756222742092)
,p_theme_id=>42
,p_name=>'2_COLUMN_GRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--cols t-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24251949708742092)
,p_theme_id=>42
,p_name=>'3_COLUMN_GRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--cols t-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24252157258742093)
,p_theme_id=>42
,p_name=>'4_COLUMN_GRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--cols t-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24252419170742093)
,p_theme_id=>42
,p_name=>'5_COLUMN_GRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--cols t-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24252587846742095)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24252922330742096)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--iconsRounded'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24253215964742098)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--iconsSquare'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24253572496742100)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--large force-fa-lg'
,p_group_id=>wwv_flow_api.id(32509670220330365)
,p_template_types=>'REPORT'
,p_help_text=>'Increases the size of the text and icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24253757882742100)
,p_theme_id=>42
,p_name=>'SHOW_BADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--showBadges'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24253963935742101)
,p_theme_id=>42
,p_name=>'SHOW_DESCRIPTION'
,p_display_name=>'Show Description'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--showDesc'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24254164575742101)
,p_theme_id=>42
,p_name=>'SHOW_ICONS'
,p_display_name=>'Show Icons'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--showIcons'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24254338758742101)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTAL'
,p_display_name=>'Span Horizontal'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24254611421742102)
,p_theme_id=>42
,p_name=>'STACK'
,p_display_name=>'Stack'
,p_display_sequence=>5
,p_report_template_id=>wwv_flow_api.id(24251273221742090)
,p_css_classes=>'t-MediaList--stack'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24255160221742105)
,p_theme_id=>42
,p_name=>'FIXED_LARGE'
,p_display_name=>'Fixed - Large'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--fixedLabelLarge'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24255350876742105)
,p_theme_id=>42
,p_name=>'FIXED_MEDIUM'
,p_display_name=>'Fixed - Medium'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--fixedLabelMedium'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24255543202742106)
,p_theme_id=>42
,p_name=>'FIXED_SMALL'
,p_display_name=>'Fixed - Small'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--fixedLabelSmall'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24255732842742107)
,p_theme_id=>42
,p_name=>'LEFT_ALIGNED_DETAILS'
,p_display_name=>'Left Aligned Details'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--leftAligned'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24255968219742107)
,p_theme_id=>42
,p_name=>'RIGHT_ALIGNED_DETAILS'
,p_display_name=>'Right Aligned Details'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--rightAligned'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24256134724742108)
,p_theme_id=>42
,p_name=>'VARIABLE_LARGE'
,p_display_name=>'Variable - Large'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--variableLabelLarge'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24256356658742108)
,p_theme_id=>42
,p_name=>'VARIABLE_MEDIUM'
,p_display_name=>'Variable - Medium'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--variableLabelMedium'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24256529820742109)
,p_theme_id=>42
,p_name=>'VARIABLE_SMALL'
,p_display_name=>'Variable - Small'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24254658582742102)
,p_css_classes=>'t-AVPList--variableLabelSmall'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24256957487742110)
,p_theme_id=>42
,p_name=>'FIXED_LARGE'
,p_display_name=>'Fixed - Large'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--fixedLabelLarge'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24257187563742110)
,p_theme_id=>42
,p_name=>'FIXED_MEDIUM'
,p_display_name=>'Fixed - Medium'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--fixedLabelMedium'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24257387021742111)
,p_theme_id=>42
,p_name=>'FIXED_SMALL'
,p_display_name=>'Fixed - Small'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--fixedLabelSmall'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24257562490742113)
,p_theme_id=>42
,p_name=>'LEFT_ALIGNED_DETAILS'
,p_display_name=>'Left Aligned Details'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--leftAligned'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24257730469742114)
,p_theme_id=>42
,p_name=>'RIGHT_ALIGNED_DETAILS'
,p_display_name=>'Right Aligned Details'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--rightAligned'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24257943434742114)
,p_theme_id=>42
,p_name=>'VARIABLE_LARGE'
,p_display_name=>'Variable - Large'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--variableLabelLarge'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24258147241742114)
,p_theme_id=>42
,p_name=>'VARIABLE_MEDIUM'
,p_display_name=>'Variable - Medium'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--variableLabelMedium'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24258344714742115)
,p_theme_id=>42
,p_name=>'VARIABLE_SMALL'
,p_display_name=>'Variable - Small'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24256706012742109)
,p_css_classes=>'t-AVPList--variableLabelSmall'
,p_group_id=>wwv_flow_api.id(32507621173330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24258929470742118)
,p_theme_id=>42
,p_name=>'128PX'
,p_display_name=>'128px'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(32502506558330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24259219998742119)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_help_text=>'Arrange badges in a two column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24259413763742120)
,p_theme_id=>42
,p_name=>'32PX'
,p_display_name=>'32px'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--small'
,p_group_id=>wwv_flow_api.id(32502506558330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24259611336742120)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_help_text=>'Arrange badges in a 3 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24259806616742120)
,p_theme_id=>42
,p_name=>'48PX'
,p_display_name=>'48px'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(32502506558330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260001195742120)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260189613742120)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260414588742120)
,p_theme_id=>42
,p_name=>'64PX'
,p_display_name=>'64px'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--large'
,p_group_id=>wwv_flow_api.id(32502506558330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260535465742121)
,p_theme_id=>42
,p_name=>'96PX'
,p_display_name=>'96px'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(32502506558330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260764353742121)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24260934801742121)
,p_theme_id=>42
,p_name=>'CIRCULAR'
,p_display_name=>'Circular'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--circular'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24261123992742122)
,p_theme_id=>42
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24261406952742122)
,p_theme_id=>42
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>80
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24261527635742123)
,p_theme_id=>42
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>70
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--float'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24261760966742123)
,p_theme_id=>42
,p_name=>'GRID'
,p_display_name=>'Grid'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--dash'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24261987500742123)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24258496462742115)
,p_css_classes=>'t-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24262614483742128)
,p_theme_id=>42
,p_name=>'ALTROWCOLORSDISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--staticRowColors'
,p_group_id=>wwv_flow_api.id(32501686145330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24262791220742130)
,p_theme_id=>42
,p_name=>'ALTROWCOLORSENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--altRowsDefault'
,p_group_id=>wwv_flow_api.id(32501686145330358)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24263200773742130)
,p_theme_id=>42
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--rowHighlight'
,p_group_id=>wwv_flow_api.id(32509220565330364)
,p_template_types=>'REPORT'
,p_help_text=>'Enable row highlighting on mouse over'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24263550203742130)
,p_theme_id=>42
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Only'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--horizontalBorders'
,p_group_id=>wwv_flow_api.id(32508905062330364)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24263812289742130)
,p_theme_id=>42
,p_name=>'REMOVEALLBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--noBorders'
,p_group_id=>wwv_flow_api.id(32508905062330364)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24263959008742131)
,p_theme_id=>42
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'No Outer Borders'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--inline'
,p_group_id=>wwv_flow_api.id(32508905062330364)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24264159360742131)
,p_theme_id=>42
,p_name=>'ROWHIGHLIGHTDISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--rowHighlightOff'
,p_group_id=>wwv_flow_api.id(32509220565330364)
,p_template_types=>'REPORT'
,p_help_text=>'Disable row highlighting on mouse over'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24264404104742132)
,p_theme_id=>42
,p_name=>'STRETCHREPORT'
,p_display_name=>'Stretch Report'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--stretch'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24264574940742133)
,p_theme_id=>42
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Only'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24262063313742124)
,p_css_classes=>'t-Report--verticalBorders'
,p_group_id=>wwv_flow_api.id(32508905062330364)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24265135848742136)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24264627396742133)
,p_css_classes=>'t-Comments--basic'
,p_group_id=>wwv_flow_api.id(32506114243330362)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24265405874742136)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24264627396742133)
,p_css_classes=>'t-Comments--iconsRounded'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24265559469742136)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24264627396742133)
,p_css_classes=>'t-Comments--iconsSquare'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24265794885742136)
,p_theme_id=>42
,p_name=>'SPEECH_BUBBLES'
,p_display_name=>'Speech Bubbles'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24264627396742133)
,p_css_classes=>'t-Comments--chat'
,p_group_id=>wwv_flow_api.id(32506114243330362)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24266324907742137)
,p_theme_id=>42
,p_name=>'2_COLUMNS'
,p_display_name=>'2 Columns'
,p_display_sequence=>15
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24266744228742137)
,p_theme_id=>42
,p_name=>'2_LINES'
,p_display_name=>'2 Lines'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--desc-2ln'
,p_group_id=>wwv_flow_api.id(32502841769330359)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24266921395742137)
,p_theme_id=>42
,p_name=>'3_COLUMNS'
,p_display_name=>'3 Columns'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--3cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24267187580742138)
,p_theme_id=>42
,p_name=>'3_LINES'
,p_display_name=>'3 Lines'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--desc-3ln'
,p_group_id=>wwv_flow_api.id(32502841769330359)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24267384845742139)
,p_theme_id=>42
,p_name=>'4_COLUMNS'
,p_display_name=>'4 Columns'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--4cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24267594602742139)
,p_theme_id=>42
,p_name=>'4_LINES'
,p_display_name=>'4 Lines'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--desc-4ln'
,p_group_id=>wwv_flow_api.id(32502841769330359)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24267747124742141)
,p_theme_id=>42
,p_name=>'5_COLUMNS'
,p_display_name=>'5 Columns'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--5cols'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24268015255742143)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--basic'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24268162301742143)
,p_theme_id=>42
,p_name=>'BLOCK'
,p_display_name=>'Block'
,p_display_sequence=>40
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--featured t-Cards--block force-fa-lg'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24268577897742145)
,p_theme_id=>42
,p_name=>'CARDS_COLOR_FILL'
,p_display_name=>'Color Fill'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--animColorFill'
,p_group_id=>wwv_flow_api.id(32502108183330358)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24268721233742145)
,p_theme_id=>42
,p_name=>'CARD_RAISE_CARD'
,p_display_name=>'Raise Card'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--animRaiseCard'
,p_group_id=>wwv_flow_api.id(32502108183330358)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24268968527742147)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--compact'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
,p_help_text=>'Use this option when you want to show smaller cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24269344402742150)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--displayIcons'
,p_group_id=>wwv_flow_api.id(32506875021330362)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24269530661742151)
,p_theme_id=>42
,p_name=>'DISPLAY_INITIALS'
,p_display_name=>'Display Initials'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--displayInitials'
,p_group_id=>wwv_flow_api.id(32506875021330362)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24269775737742151)
,p_theme_id=>42
,p_name=>'DISPLAY_SUBTITLE'
,p_display_name=>'Display Subtitle'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--displaySubtitle'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24269934292742152)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>30
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--featured force-fa-lg'
,p_group_id=>wwv_flow_api.id(32510061757330365)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24270193977742152)
,p_theme_id=>42
,p_name=>'FLOAT'
,p_display_name=>'Float'
,p_display_sequence=>60
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--float'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24270342694742154)
,p_theme_id=>42
,p_name=>'HIDDEN_BODY_TEXT'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--hideBody'
,p_group_id=>wwv_flow_api.id(32502841769330359)
,p_template_types=>'REPORT'
,p_help_text=>'This option hides the card body which contains description and subtext.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24270554180742154)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--iconsRounded'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24270800043742154)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--iconsSquare'
,p_group_id=>wwv_flow_api.id(32507249310330363)
,p_template_types=>'REPORT'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24270947260742154)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>70
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'t-Cards--spanHorizontally'
,p_group_id=>wwv_flow_api.id(32508113442330363)
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24271146001742154)
,p_theme_id=>42
,p_name=>'USE_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_report_template_id=>wwv_flow_api.id(24266091041742137)
,p_css_classes=>'u-colors'
,p_template_types=>'REPORT'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24271945767742163)
,p_theme_id=>42
,p_name=>'DISPLAY_LABELS_SM'
,p_display_name=>'Display labels'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24271460186742155)
,p_css_classes=>'t-NavTabs--displayLabels-sm'
,p_group_id=>wwv_flow_api.id(32485695904330340)
,p_template_types=>'LIST'
,p_help_text=>'Displays the label for the list items below the icon'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24272200636742164)
,p_theme_id=>42
,p_name=>'HIDE_LABELS_SM'
,p_display_name=>'Do not display labels'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24271460186742155)
,p_css_classes=>'t-NavTabs--hiddenLabels-sm'
,p_group_id=>wwv_flow_api.id(32485695904330340)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24272532378742169)
,p_theme_id=>42
,p_name=>'LABEL_ABOVE_LG'
,p_display_name=>'Display labels above'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24271460186742155)
,p_css_classes=>'t-NavTabs--stacked'
,p_group_id=>wwv_flow_api.id(32482825694330336)
,p_template_types=>'LIST'
,p_help_text=>'Display the label stacked above the icon and badge'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24272767083742170)
,p_theme_id=>42
,p_name=>'LABEL_INLINE_LG'
,p_display_name=>'Display labels inline'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24271460186742155)
,p_css_classes=>'t-NavTabs--inlineLabels-lg'
,p_group_id=>wwv_flow_api.id(32482825694330336)
,p_template_types=>'LIST'
,p_help_text=>'Display the label inline with the icon and badge'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24272996784742170)
,p_theme_id=>42
,p_name=>'NO_LABEL_LG'
,p_display_name=>'Do not display labels'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24271460186742155)
,p_css_classes=>'t-NavTabs--hiddenLabels-lg'
,p_group_id=>wwv_flow_api.id(32482825694330336)
,p_template_types=>'LIST'
,p_help_text=>'Hides the label for the list item'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24273556307742173)
,p_theme_id=>42
,p_name=>'ALLSTEPS'
,p_display_name=>'All Steps'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24273061338742170)
,p_css_classes=>'t-WizardSteps--displayLabels'
,p_group_id=>wwv_flow_api.id(32484836138330338)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24273810945742177)
,p_theme_id=>42
,p_name=>'CURRENTSTEPONLY'
,p_display_name=>'Current Step Only'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24273061338742170)
,p_css_classes=>'t-WizardSteps--displayCurrentLabelOnly'
,p_group_id=>wwv_flow_api.id(32484836138330338)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24273930900742178)
,p_theme_id=>42
,p_name=>'HIDELABELS'
,p_display_name=>'Hide Labels'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24273061338742170)
,p_css_classes=>'t-WizardSteps--hideLabels'
,p_group_id=>wwv_flow_api.id(32484836138330338)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24274193812742178)
,p_theme_id=>42
,p_name=>'VERTICAL_LIST'
,p_display_name=>'Vertical Orientation'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24273061338742170)
,p_css_classes=>'t-WizardSteps--vertical'
,p_template_types=>'LIST'
,p_help_text=>'Displays the wizard progress list in a vertical orientation and is suitable for displaying within a side column of a page.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24274349918742179)
,p_theme_id=>42
,p_name=>'WIZARD_PROGRESS_LINKS'
,p_display_name=>'Make Wizard Steps Clickable'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24273061338742170)
,p_css_classes=>'js-wizardProgressLinks'
,p_template_types=>'LIST'
,p_help_text=>'This option will make the wizard steps clickable links.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24274791686742182)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24274497226742179)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add shortcuts for menu items. Note that actions.js must be included on your page to support this functionality.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24274966411742182)
,p_theme_id=>42
,p_name=>'BEHAVE_LIKE_TABS'
,p_display_name=>'Behave Like Tabs'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24274497226742179)
,p_css_classes=>'js-tabLike'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24275211257742182)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24274497226742179)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24275364385742182)
,p_theme_id=>42
,p_name=>'ENABLE_SLIDE_ANIMATION'
,p_display_name=>'Enable Slide Animation'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24274497226742179)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24275606536742183)
,p_theme_id=>42
,p_name=>'SHOW_SUB_MENU_ICONS'
,p_display_name=>'Show Sub Menu Icons'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24274497226742179)
,p_css_classes=>'js-showSubMenuIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24276153411742188)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a two column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24276408705742189)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--3cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a 3 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24276597980742190)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--4cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in 4 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24276777170742190)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--cols t-BadgeList--5cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Arrange badges in a 5 column grid'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24277018984742190)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24277345361742191)
,p_theme_id=>42
,p_name=>'CIRCULAR'
,p_display_name=>'Circular'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--circular'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24277618400742192)
,p_theme_id=>42
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>60
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--fixed'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Span badges horizontally'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24277805077742192)
,p_theme_id=>42
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>80
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--flex'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Use flexbox to arrange items'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24277953135742193)
,p_theme_id=>42
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>70
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--float'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Float badges to left'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24278176046742193)
,p_theme_id=>42
,p_name=>'GRID'
,p_display_name=>'Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--dash'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24278525845742193)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--large'
,p_group_id=>wwv_flow_api.id(32481262021330334)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24278800142742193)
,p_theme_id=>42
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--medium'
,p_group_id=>wwv_flow_api.id(32481262021330334)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24279012005742194)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--small'
,p_group_id=>wwv_flow_api.id(32481262021330334)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24279156796742194)
,p_theme_id=>42
,p_name=>'STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--stacked'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Stack badges on top of each other'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24279334431742195)
,p_theme_id=>42
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--xlarge'
,p_group_id=>wwv_flow_api.id(32481262021330334)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24279550537742196)
,p_theme_id=>42
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24275631851742183)
,p_css_classes=>'t-BadgeList--xxlarge'
,p_group_id=>wwv_flow_api.id(32481262021330334)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24280012956742197)
,p_theme_id=>42
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--cols t-MediaList--2cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24280139130742199)
,p_theme_id=>42
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--cols t-MediaList--3cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24280397663742200)
,p_theme_id=>42
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--cols t-MediaList--4cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24280556584742202)
,p_theme_id=>42
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--cols t-MediaList--5cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24280752137742203)
,p_theme_id=>42
,p_name=>'APPLY_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
,p_help_text=>'Applies colors from the Theme''s color palette to icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24281187871742206)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--iconsRounded'
,p_group_id=>wwv_flow_api.id(32484029829330337)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24281342417742208)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--iconsSquare'
,p_group_id=>wwv_flow_api.id(32484029829330337)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24281801574742211)
,p_theme_id=>42
,p_name=>'LIST_SIZE_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--large force-fa-lg'
,p_group_id=>wwv_flow_api.id(32486045184330340)
,p_template_types=>'LIST'
,p_help_text=>'Increases the size of the text and icons in the list.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24281998242742211)
,p_theme_id=>42
,p_name=>'SHOW_BADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--showBadges'
,p_template_types=>'LIST'
,p_help_text=>'Show a badge (Attribute 2) to the right of the list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24282163764742211)
,p_theme_id=>42
,p_name=>'SHOW_DESCRIPTION'
,p_display_name=>'Show Description'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--showDesc'
,p_template_types=>'LIST'
,p_help_text=>'Shows the description (Attribute 1) for each list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24282406161742212)
,p_theme_id=>42
,p_name=>'SHOW_ICONS'
,p_display_name=>'Show Icons'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--showIcons'
,p_template_types=>'LIST'
,p_help_text=>'Display an icon next to the list item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24282561768742212)
,p_theme_id=>42
,p_name=>'SPANHORIZONTAL'
,p_display_name=>'Span Horizontal'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24279704003742196)
,p_css_classes=>'t-MediaList--horizontal'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Show all list items in one horizontal row.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24283002721742216)
,p_theme_id=>42
,p_name=>'COLLAPSED_DEFAULT'
,p_display_name=>'Collapsed by Default'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'js-defaultCollapsed'
,p_template_types=>'LIST'
,p_help_text=>'This option will load the side navigation menu in a collapsed state by default.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24283339567742218)
,p_theme_id=>42
,p_name=>'COLLAPSE_STYLE_HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'js-navCollapsed--hidden'
,p_group_id=>wwv_flow_api.id(32482098587330335)
,p_template_types=>'LIST'
,p_help_text=>'Completely hide the navigation menu when it is collapsed.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24283553416742218)
,p_theme_id=>42
,p_name=>'ICON_DEFAULT'
,p_display_name=>'Icon (Default)'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'js-navCollapsed--default'
,p_group_id=>wwv_flow_api.id(32482098587330335)
,p_template_types=>'LIST'
,p_help_text=>'Display icons when the navigation menu is collapsed for large screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24283752949742218)
,p_theme_id=>42
,p_name=>'STYLE_A'
,p_display_name=>'Style A'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'t-TreeNav--styleA'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Style Variation A'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24283932933742218)
,p_theme_id=>42
,p_name=>'STYLE_B'
,p_display_name=>'Style B'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'t-TreeNav--styleB'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Style Variation B'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24284200477742218)
,p_theme_id=>42
,p_name=>'STYLE_C'
,p_display_name=>'Classic'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24282651135742212)
,p_css_classes=>'t-TreeNav--classic'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Classic Style'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24284528025742219)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add shortcuts for menu items. Note that actions.js must be included on your page to support this functionality.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24284815833742219)
,p_theme_id=>42
,p_name=>'BEHAVE_LIKE_TABS'
,p_display_name=>'Behave Like Tabs'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_css_classes=>'js-tabLike'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24285010041742220)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24285199553742221)
,p_theme_id=>42
,p_name=>'ENABLE_SLIDE_ANIMATION'
,p_display_name=>'Enable Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24285398382742222)
,p_theme_id=>42
,p_name=>'SHOW_SUB_MENU_ICONS'
,p_display_name=>'Show Sub Menu Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_css_classes=>'js-showSubMenuIcons'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24285769764742225)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285515375742222)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24286217588742228)
,p_theme_id=>42
,p_name=>'2_COLUMNS'
,p_display_name=>'2 Columns'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24286556254742228)
,p_theme_id=>42
,p_name=>'2_LINES'
,p_display_name=>'2 Lines'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--desc-2ln'
,p_group_id=>wwv_flow_api.id(32481688854330335)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24286751703742229)
,p_theme_id=>42
,p_name=>'3_COLUMNS'
,p_display_name=>'3 Columns'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--3cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24286944516742230)
,p_theme_id=>42
,p_name=>'3_LINES'
,p_display_name=>'3 Lines'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--desc-3ln'
,p_group_id=>wwv_flow_api.id(32481688854330335)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24287174576742230)
,p_theme_id=>42
,p_name=>'4_COLUMNS'
,p_display_name=>'4 Columns'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--4cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24287353780742231)
,p_theme_id=>42
,p_name=>'4_LINES'
,p_display_name=>'4 Lines'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--desc-4ln'
,p_group_id=>wwv_flow_api.id(32481688854330335)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24287523132742231)
,p_theme_id=>42
,p_name=>'5_COLUMNS'
,p_display_name=>'5 Columns'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--5cols'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24287738763742231)
,p_theme_id=>42
,p_name=>'BASIC'
,p_display_name=>'Basic'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--basic'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24287981772742232)
,p_theme_id=>42
,p_name=>'BLOCK'
,p_display_name=>'Block'
,p_display_sequence=>40
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--featured t-Cards--block force-fa-lg'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24288139009742233)
,p_theme_id=>42
,p_name=>'CARDS_STACKED'
,p_display_name=>'Stacked'
,p_display_sequence=>5
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--stacked'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Stacks the cards on top of each other.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24288577564742234)
,p_theme_id=>42
,p_name=>'COLOR_FILL'
,p_display_name=>'Color Fill'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--animColorFill'
,p_group_id=>wwv_flow_api.id(32480894372330334)
,p_template_types=>'LIST'
,p_help_text=>'Fills the card background with the color of the icon or default link style.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24288784492742234)
,p_theme_id=>42
,p_name=>'COMPACT'
,p_display_name=>'Compact'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--compact'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Use this option when you want to show smaller cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24289164433742235)
,p_theme_id=>42
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--displayIcons'
,p_group_id=>wwv_flow_api.id(32483622363330337)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24289382789742235)
,p_theme_id=>42
,p_name=>'DISPLAY_INITIALS'
,p_display_name=>'Display Initials'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--displayInitials'
,p_group_id=>wwv_flow_api.id(32483622363330337)
,p_template_types=>'LIST'
,p_help_text=>'Initials come from List Attribute 3'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24289556856742236)
,p_theme_id=>42
,p_name=>'DISPLAY_SUBTITLE'
,p_display_name=>'Display Subtitle'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--displaySubtitle'
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24289721609742236)
,p_theme_id=>42
,p_name=>'FEATURED'
,p_display_name=>'Featured'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--featured force-fa-lg'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290006468742237)
,p_theme_id=>42
,p_name=>'FLOAT'
,p_display_name=>'Float'
,p_display_sequence=>60
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--float'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290170046742237)
,p_theme_id=>42
,p_name=>'HIDDEN_BODY_TEXT'
,p_display_name=>'Hidden'
,p_display_sequence=>50
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--hideBody'
,p_group_id=>wwv_flow_api.id(32481688854330335)
,p_template_types=>'LIST'
,p_help_text=>'This option hides the card body which contains description and subtext.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290365936742237)
,p_theme_id=>42
,p_name=>'ICONS_ROUNDED'
,p_display_name=>'Rounded Corners'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--iconsRounded'
,p_group_id=>wwv_flow_api.id(32484029829330337)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square with rounded corners.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290608034742238)
,p_theme_id=>42
,p_name=>'ICONS_SQUARE'
,p_display_name=>'Square'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--iconsSquare'
,p_group_id=>wwv_flow_api.id(32484029829330337)
,p_template_types=>'LIST'
,p_help_text=>'The icons are displayed within a square shape.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290732094742238)
,p_theme_id=>42
,p_name=>'RAISE_CARD'
,p_display_name=>'Raise Card'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--animRaiseCard'
,p_group_id=>wwv_flow_api.id(32480894372330334)
,p_template_types=>'LIST'
,p_help_text=>'Raises the card so it pops up.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24290999345742238)
,p_theme_id=>42
,p_name=>'SPAN_HORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>70
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'t-Cards--spanHorizontally'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24291183304742239)
,p_theme_id=>42
,p_name=>'USE_THEME_COLORS'
,p_display_name=>'Apply Theme Colors'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24285849093742225)
,p_css_classes=>'u-colors'
,p_template_types=>'LIST'
,p_help_text=>'Applies the colors from the theme''s color palette to the icons or initials within cards.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24291553434742242)
,p_theme_id=>42
,p_name=>'ABOVE_LABEL'
,p_display_name=>'Above Label'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--iconsAbove'
,p_group_id=>wwv_flow_api.id(32483622363330337)
,p_template_types=>'LIST'
,p_help_text=>'Places icons above tab label.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24291737812742243)
,p_theme_id=>42
,p_name=>'FILL_LABELS'
,p_display_name=>'Fill Labels'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--fillLabels'
,p_group_id=>wwv_flow_api.id(32485254346330339)
,p_template_types=>'LIST'
,p_help_text=>'Stretch tabs to fill to the width of the tabs container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24291965478742244)
,p_theme_id=>42
,p_name=>'INLINE_WITH_LABEL'
,p_display_name=>'Inline with Label'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--inlineIcons'
,p_group_id=>wwv_flow_api.id(32483622363330337)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24292167892742245)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--large'
,p_group_id=>wwv_flow_api.id(32486045184330340)
,p_template_types=>'LIST'
,p_help_text=>'Increases font size and white space around tab items.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24292392338742245)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Pill'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--pill'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Displays tabs in a pill container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24292582444742245)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--simple'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'A very simplistic tab UI.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24292777377742246)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>5
,p_list_template_id=>wwv_flow_api.id(24291267411742239)
,p_css_classes=>'t-Tabs--small'
,p_group_id=>wwv_flow_api.id(32486045184330340)
,p_template_types=>'LIST'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24293169422742248)
,p_theme_id=>42
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24292897218742246)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
,p_help_text=>'Enables you to define a keyboard shortcut to activate the menu item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24293373169742248)
,p_theme_id=>42
,p_name=>'DISPLAY_MENU_CALLOUT'
,p_display_name=>'Display Menu Callout'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24292897218742246)
,p_css_classes=>'js-menu-callout'
,p_template_types=>'LIST'
,p_help_text=>'Use this option to add display a callout for the menu. Note that callout will only be displayed if the data-parent-element custom attribute is defined.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24293764564742251)
,p_theme_id=>42
,p_name=>'ACTIONS'
,p_display_name=>'Actions'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--actions'
,p_group_id=>wwv_flow_api.id(32486504999330341)
,p_template_types=>'LIST'
,p_help_text=>'Render as actions to be placed on the right side column.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24293960786742251)
,p_theme_id=>42
,p_name=>'DISABLETEXTWRAPPING'
,p_display_name=>'Disable Text Wrapping'
,p_display_sequence=>30
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--nowrap'
,p_template_types=>'LIST'
,p_help_text=>'Do not allow link text to wrap to new lines. Truncate with ellipsis.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24294158142742251)
,p_theme_id=>42
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--showBadge'
,p_template_types=>'LIST'
,p_help_text=>'Show badge to right of link (requires Attribute 1 to be populated)'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24294357979742253)
,p_theme_id=>42
,p_name=>'SHOWGOTOARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--showArrow'
,p_template_types=>'LIST'
,p_help_text=>'Show arrow to the right of link'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24294727558742254)
,p_theme_id=>42
,p_name=>'SHOWICONS'
,p_display_name=>'For All Items'
,p_display_sequence=>20
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--showIcons'
,p_group_id=>wwv_flow_api.id(32483235197330336)
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24294971404742254)
,p_theme_id=>42
,p_name=>'SHOWTOPICONS'
,p_display_name=>'For Top Level Items Only'
,p_display_sequence=>10
,p_list_template_id=>wwv_flow_api.id(24293462578742249)
,p_css_classes=>'t-LinksList--showTopIcons'
,p_group_id=>wwv_flow_api.id(32483235197330336)
,p_template_types=>'LIST'
,p_help_text=>'This will show icons for top level items of the list only. It will not show icons for sub lists.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24296191333742267)
,p_theme_id=>42
,p_name=>'PUSH'
,p_display_name=>'Push'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_css_classes=>'t-Button--hoverIconPush'
,p_group_id=>wwv_flow_api.id(32473226654330327)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will animate to the right or left on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24296346917742267)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_css_classes=>'t-Button--hoverIconSpin'
,p_group_id=>wwv_flow_api.id(32473226654330327)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will spin on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24296767127742269)
,p_theme_id=>42
,p_name=>'HIDE_LABEL_ON_MOBILE'
,p_display_name=>'Hide Label on Mobile'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_css_classes=>'t-Button--mobileHideLabel'
,p_template_types=>'BUTTON'
,p_help_text=>'This template options hides the button label on small screens.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24297163379742270)
,p_theme_id=>42
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_css_classes=>'t-Button--iconLeft'
,p_group_id=>wwv_flow_api.id(32473644079330327)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24297374023742271)
,p_theme_id=>42
,p_name=>'PUSH'
,p_display_name=>'Push'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_css_classes=>'t-Button--hoverIconPush'
,p_group_id=>wwv_flow_api.id(32473226654330327)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will animate to the right or left on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24297547445742271)
,p_theme_id=>42
,p_name=>'RIGHTICON'
,p_display_name=>'Right'
,p_display_sequence=>20
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_css_classes=>'t-Button--iconRight'
,p_group_id=>wwv_flow_api.id(32473644079330327)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(24297815129742271)
,p_theme_id=>42
,p_name=>'SPIN'
,p_display_name=>'Spin'
,p_display_sequence=>10
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_css_classes=>'t-Button--hoverIconSpin'
,p_group_id=>wwv_flow_api.id(32473226654330327)
,p_template_types=>'BUTTON'
,p_help_text=>'The icon will spin on button hover or focus.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32531156104330389)
,p_theme_id=>42
,p_name=>'FBM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-bottom-lg'
,p_group_id=>wwv_flow_api.id(32477231193330330)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32531851706330390)
,p_theme_id=>42
,p_name=>'RBM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-bottom-lg'
,p_group_id=>wwv_flow_api.id(32498093921330354)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32532563708330391)
,p_theme_id=>42
,p_name=>'FBM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-bottom-md'
,p_group_id=>wwv_flow_api.id(32477231193330330)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32533294019330391)
,p_theme_id=>42
,p_name=>'RBM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-bottom-md'
,p_group_id=>wwv_flow_api.id(32498093921330354)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32533935375330394)
,p_theme_id=>42
,p_name=>'FBM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-bottom-none'
,p_group_id=>wwv_flow_api.id(32477231193330330)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32534671132330395)
,p_theme_id=>42
,p_name=>'RBM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-bottom-none'
,p_group_id=>wwv_flow_api.id(32498093921330354)
,p_template_types=>'REGION'
,p_help_text=>'Removes the bottom margin for this region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32535382429330396)
,p_theme_id=>42
,p_name=>'FBM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-bottom-sm'
,p_group_id=>wwv_flow_api.id(32477231193330330)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small bottom margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32535935966330396)
,p_theme_id=>42
,p_name=>'RBM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-bottom-sm'
,p_group_id=>wwv_flow_api.id(32498093921330354)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small bottom margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32536636208330397)
,p_theme_id=>42
,p_name=>'FLM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-left-lg'
,p_group_id=>wwv_flow_api.id(32478481706330331)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32537321824330398)
,p_theme_id=>42
,p_name=>'RLM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-left-lg'
,p_group_id=>wwv_flow_api.id(32498475956330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32538049226330399)
,p_theme_id=>42
,p_name=>'FLM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-left-md'
,p_group_id=>wwv_flow_api.id(32478481706330331)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32538794663330400)
,p_theme_id=>42
,p_name=>'RLM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-left-md'
,p_group_id=>wwv_flow_api.id(32498475956330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32539433713330400)
,p_theme_id=>42
,p_name=>'FLM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-left-none'
,p_group_id=>wwv_flow_api.id(32478481706330331)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32540127917330401)
,p_theme_id=>42
,p_name=>'RLM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-left-none'
,p_group_id=>wwv_flow_api.id(32498475956330355)
,p_template_types=>'REGION'
,p_help_text=>'Removes the left margin from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32540886285330402)
,p_theme_id=>42
,p_name=>'FLM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-left-sm'
,p_group_id=>wwv_flow_api.id(32478481706330331)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small left margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32541523252330403)
,p_theme_id=>42
,p_name=>'RLM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-left-sm'
,p_group_id=>wwv_flow_api.id(32498475956330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small left margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32542233081330403)
,p_theme_id=>42
,p_name=>'FRM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-right-lg'
,p_group_id=>wwv_flow_api.id(32479705125330332)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32542935284330404)
,p_theme_id=>42
,p_name=>'RRM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-right-lg'
,p_group_id=>wwv_flow_api.id(32498900501330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32543647312330405)
,p_theme_id=>42
,p_name=>'FRM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-right-md'
,p_group_id=>wwv_flow_api.id(32479705125330332)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32544398236330405)
,p_theme_id=>42
,p_name=>'RRM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-right-md'
,p_group_id=>wwv_flow_api.id(32498900501330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32545085398330406)
,p_theme_id=>42
,p_name=>'FRM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-right-none'
,p_group_id=>wwv_flow_api.id(32479705125330332)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32545738724330408)
,p_theme_id=>42
,p_name=>'RRM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-right-none'
,p_group_id=>wwv_flow_api.id(32498900501330355)
,p_template_types=>'REGION'
,p_help_text=>'Removes the right margin from the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32546436594330408)
,p_theme_id=>42
,p_name=>'FRM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-right-sm'
,p_group_id=>wwv_flow_api.id(32479705125330332)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small right margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32547176609330409)
,p_theme_id=>42
,p_name=>'RRM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-right-sm'
,p_group_id=>wwv_flow_api.id(32498900501330355)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small right margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32547830599330410)
,p_theme_id=>42
,p_name=>'FTM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-top-lg'
,p_group_id=>wwv_flow_api.id(32480479429330333)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a large top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32548565300330410)
,p_theme_id=>42
,p_name=>'RTM_LARGE'
,p_display_name=>'Large'
,p_display_sequence=>40
,p_css_classes=>'margin-top-lg'
,p_group_id=>wwv_flow_api.id(32499650665330356)
,p_template_types=>'REGION'
,p_help_text=>'Adds a large top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32549225927330411)
,p_theme_id=>42
,p_name=>'FTM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-top-md'
,p_group_id=>wwv_flow_api.id(32480479429330333)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a medium top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32549973557330412)
,p_theme_id=>42
,p_name=>'RTM_MEDIUM'
,p_display_name=>'Medium'
,p_display_sequence=>30
,p_css_classes=>'margin-top-md'
,p_group_id=>wwv_flow_api.id(32499650665330356)
,p_template_types=>'REGION'
,p_help_text=>'Adds a medium top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32550668539330412)
,p_theme_id=>42
,p_name=>'FTM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-top-none'
,p_group_id=>wwv_flow_api.id(32480479429330333)
,p_template_types=>'FIELD'
,p_help_text=>'Removes the top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32551376321330413)
,p_theme_id=>42
,p_name=>'RTM_NONE'
,p_display_name=>'None'
,p_display_sequence=>10
,p_css_classes=>'margin-top-none'
,p_group_id=>wwv_flow_api.id(32499650665330356)
,p_template_types=>'REGION'
,p_help_text=>'Removes the top margin for this region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32552116259330414)
,p_theme_id=>42
,p_name=>'FTM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-top-sm'
,p_group_id=>wwv_flow_api.id(32480479429330333)
,p_template_types=>'FIELD'
,p_help_text=>'Adds a small top margin for this field.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32552763543330415)
,p_theme_id=>42
,p_name=>'RTM_SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'margin-top-sm'
,p_group_id=>wwv_flow_api.id(32499650665330356)
,p_template_types=>'REGION'
,p_help_text=>'Adds a small top margin to the region.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32553445054330415)
,p_theme_id=>42
,p_name=>'DANGER'
,p_display_name=>'Danger'
,p_display_sequence=>30
,p_css_classes=>'t-Button--danger'
,p_group_id=>wwv_flow_api.id(32476435875330330)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32554177453330416)
,p_theme_id=>42
,p_name=>'LARGEBOTTOMMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapBottom'
,p_group_id=>wwv_flow_api.id(32474498379330328)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32554919975330417)
,p_theme_id=>42
,p_name=>'LARGELEFTMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapLeft'
,p_group_id=>wwv_flow_api.id(32474907133330328)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32555591448330418)
,p_theme_id=>42
,p_name=>'LARGERIGHTMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapRight'
,p_group_id=>wwv_flow_api.id(32475224341330329)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32556285089330418)
,p_theme_id=>42
,p_name=>'LARGETOPMARGIN'
,p_display_name=>'Large'
,p_display_sequence=>20
,p_css_classes=>'t-Button--gapTop'
,p_group_id=>wwv_flow_api.id(32475714308330329)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32556988301330419)
,p_theme_id=>42
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>30
,p_css_classes=>'t-Button--large'
,p_group_id=>wwv_flow_api.id(32474045935330328)
,p_template_types=>'BUTTON'
,p_help_text=>'A large button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32557662254330420)
,p_theme_id=>42
,p_name=>'DISPLAY_AS_LINK'
,p_display_name=>'Display as Link'
,p_display_sequence=>30
,p_css_classes=>'t-Button--link'
,p_group_id=>wwv_flow_api.id(32476073302330329)
,p_template_types=>'BUTTON'
,p_help_text=>'This option makes the button appear as a text link.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32558410686330421)
,p_theme_id=>42
,p_name=>'NOUI'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>20
,p_css_classes=>'t-Button--noUI'
,p_group_id=>wwv_flow_api.id(32476073302330329)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32559075433330421)
,p_theme_id=>42
,p_name=>'SMALLBOTTOMMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padBottom'
,p_group_id=>wwv_flow_api.id(32474498379330328)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32559738000330422)
,p_theme_id=>42
,p_name=>'SMALLLEFTMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padLeft'
,p_group_id=>wwv_flow_api.id(32474907133330328)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32560483894330423)
,p_theme_id=>42
,p_name=>'SMALLRIGHTMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padRight'
,p_group_id=>wwv_flow_api.id(32475224341330329)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32561192468330424)
,p_theme_id=>42
,p_name=>'SMALLTOPMARGIN'
,p_display_name=>'Small'
,p_display_sequence=>10
,p_css_classes=>'t-Button--padTop'
,p_group_id=>wwv_flow_api.id(32475714308330329)
,p_template_types=>'BUTTON'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32561872373330425)
,p_theme_id=>42
,p_name=>'PILL'
,p_display_name=>'Inner Button'
,p_display_sequence=>20
,p_css_classes=>'t-Button--pill'
,p_group_id=>wwv_flow_api.id(32472883306330327)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32562535219330425)
,p_theme_id=>42
,p_name=>'PILLEND'
,p_display_name=>'Last Button'
,p_display_sequence=>30
,p_css_classes=>'t-Button--pillEnd'
,p_group_id=>wwv_flow_api.id(32472883306330327)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32563287248330426)
,p_theme_id=>42
,p_name=>'PILLSTART'
,p_display_name=>'First Button'
,p_display_sequence=>10
,p_css_classes=>'t-Button--pillStart'
,p_group_id=>wwv_flow_api.id(32472883306330327)
,p_template_types=>'BUTTON'
,p_help_text=>'Use this for the start of a pill button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32563988463330427)
,p_theme_id=>42
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>10
,p_css_classes=>'t-Button--primary'
,p_group_id=>wwv_flow_api.id(32476435875330330)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32564683990330428)
,p_theme_id=>42
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>10
,p_css_classes=>'t-Button--simple'
,p_group_id=>wwv_flow_api.id(32476073302330329)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32565370343330428)
,p_theme_id=>42
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>20
,p_css_classes=>'t-Button--small'
,p_group_id=>wwv_flow_api.id(32474045935330328)
,p_template_types=>'BUTTON'
,p_help_text=>'A small button.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32566031001330429)
,p_theme_id=>42
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>10
,p_css_classes=>'t-Button--stretch'
,p_group_id=>wwv_flow_api.id(32476904035330330)
,p_template_types=>'BUTTON'
,p_help_text=>'Stretches button to fill container'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32566768675330430)
,p_theme_id=>42
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>40
,p_css_classes=>'t-Button--success'
,p_group_id=>wwv_flow_api.id(32476435875330330)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32567477569330430)
,p_theme_id=>42
,p_name=>'TINY'
,p_display_name=>'Tiny'
,p_display_sequence=>10
,p_css_classes=>'t-Button--tiny'
,p_group_id=>wwv_flow_api.id(32474045935330328)
,p_template_types=>'BUTTON'
,p_help_text=>'A very small button.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32568178558330431)
,p_theme_id=>42
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>20
,p_css_classes=>'t-Button--warning'
,p_group_id=>wwv_flow_api.id(32476435875330330)
,p_template_types=>'BUTTON'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32568889769330432)
,p_theme_id=>42
,p_name=>'SHOWFORMLABELSABOVE'
,p_display_name=>'Show Form Labels Above'
,p_display_sequence=>10
,p_css_classes=>'t-Form--labelsAbove'
,p_group_id=>wwv_flow_api.id(32496823609330354)
,p_template_types=>'REGION'
,p_help_text=>'Show form labels above input fields.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32569561580330433)
,p_theme_id=>42
,p_name=>'FORMSIZELARGE'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_css_classes=>'t-Form--large'
,p_group_id=>wwv_flow_api.id(32495654760330353)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32570234194330433)
,p_theme_id=>42
,p_name=>'FORMLEFTLABELS'
,p_display_name=>'Left'
,p_display_sequence=>20
,p_css_classes=>'t-Form--leftLabels'
,p_group_id=>wwv_flow_api.id(32496457543330353)
,p_template_types=>'REGION'
,p_help_text=>'Align form labels to left.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32570978999330434)
,p_theme_id=>42
,p_name=>'FORMREMOVEPADDING'
,p_display_name=>'Remove Padding'
,p_display_sequence=>20
,p_css_classes=>'t-Form--noPadding'
,p_group_id=>wwv_flow_api.id(32495259159330352)
,p_template_types=>'REGION'
,p_help_text=>'Removes padding between items.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32571633158330435)
,p_theme_id=>42
,p_name=>'FORMSLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>10
,p_css_classes=>'t-Form--slimPadding'
,p_group_id=>wwv_flow_api.id(32495259159330352)
,p_template_types=>'REGION'
,p_help_text=>'Reduces form item padding to 4px.'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32572401579330435)
,p_theme_id=>42
,p_name=>'STRETCH_FORM_FIELDS'
,p_display_name=>'Stretch Form Fields'
,p_display_sequence=>10
,p_css_classes=>'t-Form--stretchInputs'
,p_group_id=>wwv_flow_api.id(32496116307330353)
,p_template_types=>'REGION'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32573083566330436)
,p_theme_id=>42
,p_name=>'FORMSIZEXLARGE'
,p_display_name=>'X Large'
,p_display_sequence=>20
,p_css_classes=>'t-Form--xlarge'
,p_group_id=>wwv_flow_api.id(32495654760330353)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32573809247330437)
,p_theme_id=>42
,p_name=>'LARGE_FIELD'
,p_display_name=>'Large'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--large'
,p_group_id=>wwv_flow_api.id(32480058569330333)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32574423271330437)
,p_theme_id=>42
,p_name=>'POST_TEXT_BLOCK'
,p_display_name=>'Display as Block'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--postTextBlock'
,p_group_id=>wwv_flow_api.id(32477690930330331)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the Item Post Text in a block style immediately after the item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32575208068330438)
,p_theme_id=>42
,p_name=>'PRE_TEXT_BLOCK'
,p_display_name=>'Display as Block'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--preTextBlock'
,p_group_id=>wwv_flow_api.id(32478092506330331)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the Item Pre Text in a block style immediately before the item.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32575890079330440)
,p_theme_id=>42
,p_name=>'DISPLAY_AS_PILL_BUTTON'
,p_display_name=>'Display as Pill Button'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--radioButtonGroup'
,p_group_id=>wwv_flow_api.id(32479278815330332)
,p_template_types=>'FIELD'
,p_help_text=>'Displays the radio buttons to look like a button set / pill button.  Note that the the radio buttons must all be in the same row for this option to work.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32576263945330440)
,p_theme_id=>42
,p_name=>'STRETCH_FORM_ITEM'
,p_display_name=>'Stretch Form Item'
,p_display_sequence=>10
,p_css_classes=>'t-Form-fieldContainer--stretchInputs'
,p_template_types=>'FIELD'
,p_help_text=>'Stretches the form item to fill its container.'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32577006637330441)
,p_theme_id=>42
,p_name=>'X_LARGE_SIZE'
,p_display_name=>'X Large'
,p_display_sequence=>20
,p_css_classes=>'t-Form-fieldContainer--xlarge'
,p_group_id=>wwv_flow_api.id(32480058569330333)
,p_template_types=>'FIELD'
);
wwv_flow_api.create_template_option(
 p_id=>wwv_flow_api.id(32577650296330442)
,p_theme_id=>42
,p_name=>'HIDE_WHEN_ALL_ROWS_DISPLAYED'
,p_display_name=>'Hide when all rows displayed'
,p_display_sequence=>10
,p_css_classes=>'t-Report--hideNoPagination'
,p_group_id=>wwv_flow_api.id(32508518186330364)
,p_template_types=>'REPORT'
,p_help_text=>'This option will hide the pagination when all rows are displayed.'
);
end;
/
prompt --application/shared_components/globalization/language
begin
null;
end;
/
prompt --application/shared_components/globalization/translations
begin
null;
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(24321029955742629)
,p_build_option_name=>'Feature: About Page'
,p_build_option_status=>'INCLUDE'
,p_feature_identifier=>'APPLICATION_ABOUT_PAGE'
,p_build_option_comment=>'About this application page.'
);
wwv_flow_api.create_build_option(
 p_id=>wwv_flow_api.id(35436897437199438)
,p_build_option_name=>'Feature: Access Control'
,p_build_option_status=>'INCLUDE'
,p_feature_identifier=>'APPLICATION_ACCESS_CONTROL'
,p_build_option_comment=>'Incorporate role based user authentication within your application and manage username mappings to application roles.'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_api.create_shortcut(
 p_id=>wwv_flow_api.id(24322068295742644)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Would you like to perform this delete action?'
);
end;
/
prompt --application/shared_components/security/authentications/cronology_authentication
begin
wwv_flow_api.create_authentication(
 p_id=>wwv_flow_api.id(31715813513464739)
,p_name=>'CRONOLOGY_AUTHENTICATION'
,p_scheme_type=>'NATIVE_DB_ACCOUNTS'
,p_invalid_session_type=>'LOGIN'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
);
end;
/
prompt --application/shared_components/plugins/item_type/cronology_apex_qr_item
begin
wwv_flow_api.create_plugin(
 p_id=>wwv_flow_api.id(81501773125101948)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'CRONOLOGY.APEX.QR.ITEM'
,p_display_name=>'QR Code'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','CRONOLOGY.APEX.QR.ITEM'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render_qr_item (',
'    p_item                in apex_plugin.t_page_item,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_value               in varchar2,',
'    p_is_readonly         in boolean,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_page_item_render_result',
'is',
'    l_size          apex_application_page_items.attribute_01%type := p_item.attribute_01;',
'    l_color         apex_application_page_items.attribute_01%type := p_item.attribute_02;',
'    l_background    apex_application_page_items.attribute_01%type := p_item.attribute_03;',
'begin',
'',
'  if apex_application.g_debug then',
'    apex_plugin_util.debug_page_item(',
'      p_plugin        => p_plugin,',
'      p_page_item     => p_item',
'    );',
'  end if;',
'   ',
'  apex_javascript.add_library(',
'     p_name      => ''qrcode.min'',',
'     p_directory => p_plugin.file_prefix,',
'     p_version   => NULL',
'  );',
'',
'  sys.htp.p(''<div id="QR-''||p_item.id||''" style="width:''||l_size||''px; height:''||l_size||''px;"></div>'');',
'',
'  apex_javascript.add_inline_code (',
'    p_code => ''function renderQR_''||p_item.name||''(value) ',
'{ $("#QR-''||p_item.id||''").html(" ");',
'  new QRCode(document.getElementById("QR-''||p_item.id||''"), {',
'  text:   value, ',
'  width:  "''||l_size||''" , ',
'  height: "''||l_size||''" ,',
'  colorDark:  "''||l_color||''" , ',
'  colorLight: "''||l_background||''"',
'  } );',
'}'',',
'    p_key  => ''renderQR_''||p_item.name',
'  );',
'',
'  apex_javascript.add_onload_code (',
'    p_code => ''renderQR_''||p_item.name||''("''||p_value||''");'', ',
'    p_key  => ''renderQR_''||p_item.name',
'  );',
'  ',
'  return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render_qr_item'
,p_standard_attributes=>'VISIBLE:SOURCE:ELEMENT:ENCRYPT'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(81505550095287186)
,p_plugin_id=>wwv_flow_api.id(81501773125101948)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Size'
,p_attribute_type=>'INTEGER'
,p_is_required=>true
,p_default_value=>'200'
,p_display_length=>10
,p_max_length=>30
,p_is_translatable=>false
,p_help_text=>'Height and Width of the QR code in pixels'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(81506171840322763)
,p_plugin_id=>wwv_flow_api.id(81501773125101948)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Color'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#000000'
,p_display_length=>10
,p_max_length=>30
,p_is_translatable=>false
,p_help_text=>'QR code color (dark)'
);
wwv_flow_api.create_plugin_attribute(
 p_id=>wwv_flow_api.id(81506564291326205)
,p_plugin_id=>wwv_flow_api.id(81501773125101948)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Background'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'#FFFFFF'
,p_display_length=>10
,p_max_length=>30
,p_is_translatable=>false
,p_help_text=>'QR code background color'
);
end;
/
begin
wwv_flow_api.g_varchar2_table := wwv_flow_api.empty_varchar2_table;
wwv_flow_api.g_varchar2_table(1) := '766172205152436F64653B2166756E6374696F6E28297B66756E6374696F6E20612861297B746869732E6D6F64653D632E4D4F44455F384249545F425954452C746869732E646174613D612C746869732E706172736564446174613D5B5D3B666F722876';
wwv_flow_api.g_varchar2_table(2) := '617220623D5B5D2C643D302C653D746869732E646174612E6C656E6774683B653E643B642B2B297B76617220663D746869732E646174612E63686172436F646541742864293B663E36353533363F28625B305D3D3234307C28313833353030382666293E';
wwv_flow_api.g_varchar2_table(3) := '3E3E31382C625B315D3D3132387C283235383034382666293E3E3E31322C625B325D3D3132387C28343033322666293E3E3E362C625B335D3D3132387C36332666293A663E323034383F28625B305D3D3232347C2836313434302666293E3E3E31322C62';
wwv_flow_api.g_varchar2_table(4) := '5B315D3D3132387C28343033322666293E3E3E362C625B325D3D3132387C36332666293A663E3132383F28625B305D3D3139327C28313938342666293E3E3E362C625B315D3D3132387C36332666293A625B305D3D662C746869732E7061727365644461';
wwv_flow_api.g_varchar2_table(5) := '74613D746869732E706172736564446174612E636F6E6361742862297D746869732E706172736564446174612E6C656E677468213D746869732E646174612E6C656E677468262628746869732E706172736564446174612E756E73686966742831393129';
wwv_flow_api.g_varchar2_table(6) := '2C746869732E706172736564446174612E756E736869667428313837292C746869732E706172736564446174612E756E73686966742832333929297D66756E6374696F6E206228612C62297B746869732E747970654E756D6265723D612C746869732E65';
wwv_flow_api.g_varchar2_table(7) := '72726F72436F72726563744C6576656C3D622C746869732E6D6F64756C65733D6E756C6C2C746869732E6D6F64756C65436F756E743D302C746869732E6461746143616368653D6E756C6C2C746869732E646174614C6973743D5B5D7D66756E6374696F';
wwv_flow_api.g_varchar2_table(8) := '6E206928612C62297B696628766F696420303D3D612E6C656E677468297468726F77206E6577204572726F7228612E6C656E6774682B222F222B62293B666F722876617220633D303B633C612E6C656E6774682626303D3D615B635D3B29632B2B3B7468';
wwv_flow_api.g_varchar2_table(9) := '69732E6E756D3D6E657720417272617928612E6C656E6774682D632B62293B666F722876617220643D303B643C612E6C656E6774682D633B642B2B29746869732E6E756D5B645D3D615B642B635D7D66756E6374696F6E206A28612C62297B746869732E';
wwv_flow_api.g_varchar2_table(10) := '746F74616C436F756E743D612C746869732E64617461436F756E743D627D66756E6374696F6E206B28297B746869732E6275666665723D5B5D2C746869732E6C656E6774683D307D66756E6374696F6E206D28297B72657475726E22756E646566696E65';
wwv_flow_api.g_varchar2_table(11) := '6422213D747970656F662043616E76617352656E646572696E67436F6E7465787432447D66756E6374696F6E206E28297B76617220613D21312C623D6E6176696761746F722E757365724167656E743B72657475726E2F616E64726F69642F692E746573';
wwv_flow_api.g_varchar2_table(12) := '74286229262628613D21302C614D61743D622E746F537472696E6728292E6D61746368282F616E64726F696420285B302D395D5C2E5B302D395D292F69292C614D61742626614D61745B315D262628613D7061727365466C6F617428614D61745B315D29';
wwv_flow_api.g_varchar2_table(13) := '29292C617D66756E6374696F6E207228612C62297B666F722876617220633D312C653D732861292C663D302C673D6C2E6C656E6774683B673E3D663B662B2B297B76617220683D303B7377697463682862297B6361736520642E4C3A683D6C5B665D5B30';
wwv_flow_api.g_varchar2_table(14) := '5D3B627265616B3B6361736520642E4D3A683D6C5B665D5B315D3B627265616B3B6361736520642E513A683D6C5B665D5B325D3B627265616B3B6361736520642E483A683D6C5B665D5B335D7D696628683E3D6529627265616B3B632B2B7D696628633E';
wwv_flow_api.g_varchar2_table(15) := '6C2E6C656E677468297468726F77206E6577204572726F722822546F6F206C6F6E67206461746122293B72657475726E20637D66756E6374696F6E20732861297B76617220623D656E636F64655552492861292E746F537472696E6728292E7265706C61';
wwv_flow_api.g_varchar2_table(16) := '6365282F5C255B302D39612D66412D465D7B327D2F672C226122293B72657475726E20622E6C656E6774682B28622E6C656E677468213D613F333A30297D612E70726F746F747970653D7B6765744C656E6774683A66756E6374696F6E28297B72657475';
wwv_flow_api.g_varchar2_table(17) := '726E20746869732E706172736564446174612E6C656E6774687D2C77726974653A66756E6374696F6E2861297B666F722876617220623D302C633D746869732E706172736564446174612E6C656E6774683B633E623B622B2B29612E7075742874686973';
wwv_flow_api.g_varchar2_table(18) := '2E706172736564446174615B625D2C38297D7D2C622E70726F746F747970653D7B616464446174613A66756E6374696F6E2862297B76617220633D6E657720612862293B746869732E646174614C6973742E707573682863292C746869732E6461746143';
wwv_flow_api.g_varchar2_table(19) := '616368653D6E756C6C7D2C69734461726B3A66756E6374696F6E28612C62297B696628303E617C7C746869732E6D6F64756C65436F756E743C3D617C7C303E627C7C746869732E6D6F64756C65436F756E743C3D62297468726F77206E6577204572726F';
wwv_flow_api.g_varchar2_table(20) := '7228612B222C222B62293B72657475726E20746869732E6D6F64756C65735B615D5B625D7D2C6765744D6F64756C65436F756E743A66756E6374696F6E28297B72657475726E20746869732E6D6F64756C65436F756E747D2C6D616B653A66756E637469';
wwv_flow_api.g_varchar2_table(21) := '6F6E28297B746869732E6D616B65496D706C2821312C746869732E676574426573744D61736B5061747465726E2829297D2C6D616B65496D706C3A66756E6374696F6E28612C63297B746869732E6D6F64756C65436F756E743D342A746869732E747970';
wwv_flow_api.g_varchar2_table(22) := '654E756D6265722B31372C746869732E6D6F64756C65733D6E657720417272617928746869732E6D6F64756C65436F756E74293B666F722876617220643D303B643C746869732E6D6F64756C65436F756E743B642B2B297B746869732E6D6F64756C6573';
wwv_flow_api.g_varchar2_table(23) := '5B645D3D6E657720417272617928746869732E6D6F64756C65436F756E74293B666F722876617220653D303B653C746869732E6D6F64756C65436F756E743B652B2B29746869732E6D6F64756C65735B645D5B655D3D6E756C6C7D746869732E73657475';
wwv_flow_api.g_varchar2_table(24) := '70506F736974696F6E50726F62655061747465726E28302C30292C746869732E7365747570506F736974696F6E50726F62655061747465726E28746869732E6D6F64756C65436F756E742D372C30292C746869732E7365747570506F736974696F6E5072';
wwv_flow_api.g_varchar2_table(25) := '6F62655061747465726E28302C746869732E6D6F64756C65436F756E742D37292C746869732E7365747570506F736974696F6E41646A7573745061747465726E28292C746869732E736574757054696D696E675061747465726E28292C746869732E7365';
wwv_flow_api.g_varchar2_table(26) := '74757054797065496E666F28612C63292C746869732E747970654E756D6265723E3D372626746869732E7365747570547970654E756D6265722861292C6E756C6C3D3D746869732E646174614361636865262628746869732E6461746143616368653D62';
wwv_flow_api.g_varchar2_table(27) := '2E6372656174654461746128746869732E747970654E756D6265722C746869732E6572726F72436F72726563744C6576656C2C746869732E646174614C69737429292C746869732E6D61704461746128746869732E6461746143616368652C63297D2C73';
wwv_flow_api.g_varchar2_table(28) := '65747570506F736974696F6E50726F62655061747465726E3A66756E6374696F6E28612C62297B666F722876617220633D2D313B373E3D633B632B2B2969662821282D313E3D612B637C7C746869732E6D6F64756C65436F756E743C3D612B632929666F';
wwv_flow_api.g_varchar2_table(29) := '722876617220643D2D313B373E3D643B642B2B292D313E3D622B647C7C746869732E6D6F64756C65436F756E743C3D622B647C7C28746869732E6D6F64756C65735B612B635D5B622B645D3D633E3D302626363E3D63262628303D3D647C7C363D3D6429';
wwv_flow_api.g_varchar2_table(30) := '7C7C643E3D302626363E3D64262628303D3D637C7C363D3D63297C7C633E3D322626343E3D632626643E3D322626343E3D643F21303A2131297D2C676574426573744D61736B5061747465726E3A66756E6374696F6E28297B666F722876617220613D30';
wwv_flow_api.g_varchar2_table(31) := '2C623D302C633D303B383E633B632B2B297B746869732E6D616B65496D706C2821302C63293B76617220643D662E6765744C6F7374506F696E742874686973293B28303D3D637C7C613E6429262628613D642C623D63297D72657475726E20627D2C6372';
wwv_flow_api.g_varchar2_table(32) := '656174654D6F766965436C69703A66756E6374696F6E28612C622C63297B76617220643D612E637265617465456D7074794D6F766965436C697028622C63292C653D313B746869732E6D616B6528293B666F722876617220663D303B663C746869732E6D';
wwv_flow_api.g_varchar2_table(33) := '6F64756C65732E6C656E6774683B662B2B29666F722876617220673D662A652C683D303B683C746869732E6D6F64756C65735B665D2E6C656E6774683B682B2B297B76617220693D682A652C6A3D746869732E6D6F64756C65735B665D5B685D3B6A2626';
wwv_flow_api.g_varchar2_table(34) := '28642E626567696E46696C6C28302C313030292C642E6D6F7665546F28692C67292C642E6C696E65546F28692B652C67292C642E6C696E65546F28692B652C672B65292C642E6C696E65546F28692C672B65292C642E656E6446696C6C2829297D726574';
wwv_flow_api.g_varchar2_table(35) := '75726E20647D2C736574757054696D696E675061747465726E3A66756E6374696F6E28297B666F722876617220613D383B613C746869732E6D6F64756C65436F756E742D383B612B2B296E756C6C3D3D746869732E6D6F64756C65735B615D5B365D2626';
wwv_flow_api.g_varchar2_table(36) := '28746869732E6D6F64756C65735B615D5B365D3D303D3D612532293B666F722876617220623D383B623C746869732E6D6F64756C65436F756E742D383B622B2B296E756C6C3D3D746869732E6D6F64756C65735B365D5B625D262628746869732E6D6F64';
wwv_flow_api.g_varchar2_table(37) := '756C65735B365D5B625D3D303D3D622532297D2C7365747570506F736974696F6E41646A7573745061747465726E3A66756E6374696F6E28297B666F722876617220613D662E6765745061747465726E506F736974696F6E28746869732E747970654E75';
wwv_flow_api.g_varchar2_table(38) := '6D626572292C623D303B623C612E6C656E6774683B622B2B29666F722876617220633D303B633C612E6C656E6774683B632B2B297B76617220643D615B625D2C653D615B635D3B6966286E756C6C3D3D746869732E6D6F64756C65735B645D5B655D2966';
wwv_flow_api.g_varchar2_table(39) := '6F722876617220673D2D323B323E3D673B672B2B29666F722876617220683D2D323B323E3D683B682B2B29746869732E6D6F64756C65735B642B675D5B652B685D3D2D323D3D677C7C323D3D677C7C2D323D3D687C7C323D3D687C7C303D3D672626303D';
wwv_flow_api.g_varchar2_table(40) := '3D683F21303A21317D7D2C7365747570547970654E756D6265723A66756E6374696F6E2861297B666F722876617220623D662E676574424348547970654E756D62657228746869732E747970654E756D626572292C633D303B31383E633B632B2B297B76';
wwv_flow_api.g_varchar2_table(41) := '617220643D21612626313D3D283126623E3E63293B746869732E6D6F64756C65735B4D6174682E666C6F6F7228632F33295D5B6325332B746869732E6D6F64756C65436F756E742D382D335D3D647D666F722876617220633D303B31383E633B632B2B29';
wwv_flow_api.g_varchar2_table(42) := '7B76617220643D21612626313D3D283126623E3E63293B746869732E6D6F64756C65735B6325332B746869732E6D6F64756C65436F756E742D382D335D5B4D6174682E666C6F6F7228632F33295D3D647D7D2C736574757054797065496E666F3A66756E';
wwv_flow_api.g_varchar2_table(43) := '6374696F6E28612C62297B666F722876617220633D746869732E6572726F72436F72726563744C6576656C3C3C337C622C643D662E67657442434854797065496E666F2863292C653D303B31353E653B652B2B297B76617220673D21612626313D3D2831';
wwv_flow_api.g_varchar2_table(44) := '26643E3E65293B363E653F746869732E6D6F64756C65735B655D5B385D3D673A383E653F746869732E6D6F64756C65735B652B315D5B385D3D673A746869732E6D6F64756C65735B746869732E6D6F64756C65436F756E742D31352B655D5B385D3D677D';
wwv_flow_api.g_varchar2_table(45) := '666F722876617220653D303B31353E653B652B2B297B76617220673D21612626313D3D283126643E3E65293B383E653F746869732E6D6F64756C65735B385D5B746869732E6D6F64756C65436F756E742D652D315D3D673A393E653F746869732E6D6F64';
wwv_flow_api.g_varchar2_table(46) := '756C65735B385D5B31352D652D312B315D3D673A746869732E6D6F64756C65735B385D5B31352D652D315D3D677D746869732E6D6F64756C65735B746869732E6D6F64756C65436F756E742D385D5B385D3D21617D2C6D6170446174613A66756E637469';
wwv_flow_api.g_varchar2_table(47) := '6F6E28612C62297B666F722876617220633D2D312C643D746869732E6D6F64756C65436F756E742D312C653D372C673D302C683D746869732E6D6F64756C65436F756E742D313B683E303B682D3D3229666F7228363D3D682626682D2D3B3B297B666F72';
wwv_flow_api.g_varchar2_table(48) := '2876617220693D303B323E693B692B2B296966286E756C6C3D3D746869732E6D6F64756C65735B645D5B682D695D297B766172206A3D21313B673C612E6C656E6774682626286A3D313D3D283126615B675D3E3E3E6529293B766172206B3D662E676574';
wwv_flow_api.g_varchar2_table(49) := '4D61736B28622C642C682D69293B6B2626286A3D216A292C746869732E6D6F64756C65735B645D5B682D695D3D6A2C652D2D2C2D313D3D65262628672B2B2C653D37297D696628642B3D632C303E647C7C746869732E6D6F64756C65436F756E743C3D64';
wwv_flow_api.g_varchar2_table(50) := '297B642D3D632C633D2D633B627265616B7D7D7D7D2C622E504144303D3233362C622E504144313D31372C622E637265617465446174613D66756E6374696F6E28612C632C64297B666F722876617220653D6A2E6765745253426C6F636B7328612C6329';
wwv_flow_api.g_varchar2_table(51) := '2C673D6E6577206B2C683D303B683C642E6C656E6774683B682B2B297B76617220693D645B685D3B672E70757428692E6D6F64652C34292C672E70757428692E6765744C656E67746828292C662E6765744C656E677468496E4269747328692E6D6F6465';
wwv_flow_api.g_varchar2_table(52) := '2C6129292C692E77726974652867297D666F7228766172206C3D302C683D303B683C652E6C656E6774683B682B2B296C2B3D655B685D2E64617461436F756E743B696628672E6765744C656E677468496E4269747328293E382A6C297468726F77206E65';
wwv_flow_api.g_varchar2_table(53) := '77204572726F722822636F6465206C656E677468206F766572666C6F772E2028222B672E6765744C656E677468496E4269747328292B223E222B382A6C2B222922293B666F7228672E6765744C656E677468496E4269747328292B343C3D382A6C262667';
wwv_flow_api.g_varchar2_table(54) := '2E70757428302C34293B30213D672E6765744C656E677468496E42697473282925383B29672E707574426974282131293B666F72283B3B297B696628672E6765744C656E677468496E4269747328293E3D382A6C29627265616B3B696628672E70757428';
wwv_flow_api.g_varchar2_table(55) := '622E504144302C38292C672E6765744C656E677468496E4269747328293E3D382A6C29627265616B3B672E70757428622E504144312C38297D72657475726E20622E637265617465427974657328672C65297D2C622E63726561746542797465733D6675';
wwv_flow_api.g_varchar2_table(56) := '6E6374696F6E28612C62297B666F722876617220633D302C643D302C653D302C673D6E657720417272617928622E6C656E677468292C683D6E657720417272617928622E6C656E677468292C6A3D303B6A3C622E6C656E6774683B6A2B2B297B76617220';
wwv_flow_api.g_varchar2_table(57) := '6B3D625B6A5D2E64617461436F756E742C6C3D625B6A5D2E746F74616C436F756E742D6B3B643D4D6174682E6D617828642C6B292C653D4D6174682E6D617828652C6C292C675B6A5D3D6E6577204172726179286B293B666F7228766172206D3D303B6D';
wwv_flow_api.g_varchar2_table(58) := '3C675B6A5D2E6C656E6774683B6D2B2B29675B6A5D5B6D5D3D32353526612E6275666665725B6D2B635D3B632B3D6B3B766172206E3D662E6765744572726F72436F7272656374506F6C796E6F6D69616C286C292C6F3D6E6577206928675B6A5D2C6E2E';
wwv_flow_api.g_varchar2_table(59) := '6765744C656E67746828292D31292C703D6F2E6D6F64286E293B685B6A5D3D6E6577204172726179286E2E6765744C656E67746828292D31293B666F7228766172206D3D303B6D3C685B6A5D2E6C656E6774683B6D2B2B297B76617220713D6D2B702E67';
wwv_flow_api.g_varchar2_table(60) := '65744C656E67746828292D685B6A5D2E6C656E6774683B685B6A5D5B6D5D3D713E3D303F702E6765742871293A307D7D666F722876617220723D302C6D3D303B6D3C622E6C656E6774683B6D2B2B29722B3D625B6D5D2E746F74616C436F756E743B666F';
wwv_flow_api.g_varchar2_table(61) := '722876617220733D6E65772041727261792872292C743D302C6D3D303B643E6D3B6D2B2B29666F7228766172206A3D303B6A3C622E6C656E6774683B6A2B2B296D3C675B6A5D2E6C656E677468262628735B742B2B5D3D675B6A5D5B6D5D293B666F7228';
wwv_flow_api.g_varchar2_table(62) := '766172206D3D303B653E6D3B6D2B2B29666F7228766172206A3D303B6A3C622E6C656E6774683B6A2B2B296D3C685B6A5D2E6C656E677468262628735B742B2B5D3D685B6A5D5B6D5D293B72657475726E20737D3B666F722876617220633D7B4D4F4445';
wwv_flow_api.g_varchar2_table(63) := '5F4E554D4245523A312C4D4F44455F414C5048415F4E554D3A322C4D4F44455F384249545F425954453A342C4D4F44455F4B414E4A493A387D2C643D7B4C3A312C4D3A302C513A332C483A327D2C653D7B5041545445524E3030303A302C504154544552';
wwv_flow_api.g_varchar2_table(64) := '4E3030313A312C5041545445524E3031303A322C5041545445524E3031313A332C5041545445524E3130303A342C5041545445524E3130313A352C5041545445524E3131303A362C5041545445524E3131313A377D2C663D7B5041545445524E5F504F53';
wwv_flow_api.g_varchar2_table(65) := '4954494F4E5F5441424C453A5B5B5D2C5B362C31385D2C5B362C32325D2C5B362C32365D2C5B362C33305D2C5B362C33345D2C5B362C32322C33385D2C5B362C32342C34325D2C5B362C32362C34365D2C5B362C32382C35305D2C5B362C33302C35345D';
wwv_flow_api.g_varchar2_table(66) := '2C5B362C33322C35385D2C5B362C33342C36325D2C5B362C32362C34362C36365D2C5B362C32362C34382C37305D2C5B362C32362C35302C37345D2C5B362C33302C35342C37385D2C5B362C33302C35362C38325D2C5B362C33302C35382C38365D2C5B';
wwv_flow_api.g_varchar2_table(67) := '362C33342C36322C39305D2C5B362C32382C35302C37322C39345D2C5B362C32362C35302C37342C39385D2C5B362C33302C35342C37382C3130325D2C5B362C32382C35342C38302C3130365D2C5B362C33322C35382C38342C3131305D2C5B362C3330';
wwv_flow_api.g_varchar2_table(68) := '2C35382C38362C3131345D2C5B362C33342C36322C39302C3131385D2C5B362C32362C35302C37342C39382C3132325D2C5B362C33302C35342C37382C3130322C3132365D2C5B362C32362C35322C37382C3130342C3133305D2C5B362C33302C35362C';
wwv_flow_api.g_varchar2_table(69) := '38322C3130382C3133345D2C5B362C33342C36302C38362C3131322C3133385D2C5B362C33302C35382C38362C3131342C3134325D2C5B362C33342C36322C39302C3131382C3134365D2C5B362C33302C35342C37382C3130322C3132362C3135305D2C';
wwv_flow_api.g_varchar2_table(70) := '5B362C32342C35302C37362C3130322C3132382C3135345D2C5B362C32382C35342C38302C3130362C3133322C3135385D2C5B362C33322C35382C38342C3131302C3133362C3136325D2C5B362C32362C35342C38322C3131302C3133382C3136365D2C';
wwv_flow_api.g_varchar2_table(71) := '5B362C33302C35382C38362C3131342C3134322C3137305D5D2C4731353A313333352C4731383A373937332C4731355F4D41534B3A32313532322C67657442434854797065496E666F3A66756E6374696F6E2861297B666F722876617220623D613C3C31';
wwv_flow_api.g_varchar2_table(72) := '303B662E67657442434844696769742862292D662E676574424348446967697428662E473135293E3D303B29625E3D662E4731353C3C662E67657442434844696769742862292D662E676574424348446967697428662E473135293B72657475726E2861';
wwv_flow_api.g_varchar2_table(73) := '3C3C31307C62295E662E4731355F4D41534B7D2C676574424348547970654E756D6265723A66756E6374696F6E2861297B666F722876617220623D613C3C31323B662E67657442434844696769742862292D662E676574424348446967697428662E4731';
wwv_flow_api.g_varchar2_table(74) := '38293E3D303B29625E3D662E4731383C3C662E67657442434844696769742862292D662E676574424348446967697428662E473138293B72657475726E20613C3C31327C627D2C67657442434844696769743A66756E6374696F6E2861297B666F722876';
wwv_flow_api.g_varchar2_table(75) := '617220623D303B30213D613B29622B2B2C613E3E3E3D313B72657475726E20627D2C6765745061747465726E506F736974696F6E3A66756E6374696F6E2861297B72657475726E20662E5041545445524E5F504F534954494F4E5F5441424C455B612D31';
wwv_flow_api.g_varchar2_table(76) := '5D7D2C6765744D61736B3A66756E6374696F6E28612C622C63297B7377697463682861297B6361736520652E5041545445524E3030303A72657475726E20303D3D28622B632925323B6361736520652E5041545445524E3030313A72657475726E20303D';
wwv_flow_api.g_varchar2_table(77) := '3D6225323B6361736520652E5041545445524E3031303A72657475726E20303D3D6325333B6361736520652E5041545445524E3031313A72657475726E20303D3D28622B632925333B6361736520652E5041545445524E3130303A72657475726E20303D';
wwv_flow_api.g_varchar2_table(78) := '3D284D6174682E666C6F6F7228622F32292B4D6174682E666C6F6F7228632F33292925323B6361736520652E5041545445524E3130313A72657475726E20303D3D622A6325322B622A6325333B6361736520652E5041545445524E3131303A7265747572';
wwv_flow_api.g_varchar2_table(79) := '6E20303D3D28622A6325322B622A6325332925323B6361736520652E5041545445524E3131313A72657475726E20303D3D28622A6325332B28622B632925322925323B64656661756C743A7468726F77206E6577204572726F722822626164206D61736B';
wwv_flow_api.g_varchar2_table(80) := '5061747465726E3A222B61297D7D2C6765744572726F72436F7272656374506F6C796E6F6D69616C3A66756E6374696F6E2861297B666F722876617220623D6E65772069285B315D2C30292C633D303B613E633B632B2B29623D622E6D756C7469706C79';
wwv_flow_api.g_varchar2_table(81) := '286E65772069285B312C672E676578702863295D2C3029293B72657475726E20627D2C6765744C656E677468496E426974733A66756E6374696F6E28612C62297B696628623E3D31262631303E62297377697463682861297B6361736520632E4D4F4445';
wwv_flow_api.g_varchar2_table(82) := '5F4E554D4245523A72657475726E2031303B6361736520632E4D4F44455F414C5048415F4E554D3A72657475726E20393B6361736520632E4D4F44455F384249545F425954453A72657475726E20383B6361736520632E4D4F44455F4B414E4A493A7265';
wwv_flow_api.g_varchar2_table(83) := '7475726E20383B64656661756C743A7468726F77206E6577204572726F7228226D6F64653A222B61297D656C73652069662832373E62297377697463682861297B6361736520632E4D4F44455F4E554D4245523A72657475726E2031323B636173652063';
wwv_flow_api.g_varchar2_table(84) := '2E4D4F44455F414C5048415F4E554D3A72657475726E2031313B6361736520632E4D4F44455F384249545F425954453A72657475726E2031363B6361736520632E4D4F44455F4B414E4A493A72657475726E2031303B64656661756C743A7468726F7720';
wwv_flow_api.g_varchar2_table(85) := '6E6577204572726F7228226D6F64653A222B61297D656C73657B696628212834313E6229297468726F77206E6577204572726F722822747970653A222B62293B7377697463682861297B6361736520632E4D4F44455F4E554D4245523A72657475726E20';
wwv_flow_api.g_varchar2_table(86) := '31343B6361736520632E4D4F44455F414C5048415F4E554D3A72657475726E2031333B6361736520632E4D4F44455F384249545F425954453A72657475726E2031363B6361736520632E4D4F44455F4B414E4A493A72657475726E2031323B6465666175';
wwv_flow_api.g_varchar2_table(87) := '6C743A7468726F77206E6577204572726F7228226D6F64653A222B61297D7D7D2C6765744C6F7374506F696E743A66756E6374696F6E2861297B666F722876617220623D612E6765744D6F64756C65436F756E7428292C633D302C643D303B623E643B64';
wwv_flow_api.g_varchar2_table(88) := '2B2B29666F722876617220653D303B623E653B652B2B297B666F722876617220663D302C673D612E69734461726B28642C65292C683D2D313B313E3D683B682B2B296966282128303E642B687C7C642B683E3D622929666F722876617220693D2D313B31';
wwv_flow_api.g_varchar2_table(89) := '3E3D693B692B2B29303E652B697C7C652B693E3D627C7C2830213D687C7C30213D69292626673D3D612E69734461726B28642B682C652B69292626662B2B3B663E35262628632B3D332B662D35297D666F722876617220643D303B622D313E643B642B2B';
wwv_flow_api.g_varchar2_table(90) := '29666F722876617220653D303B622D313E653B652B2B297B766172206A3D303B612E69734461726B28642C652926266A2B2B2C612E69734461726B28642B312C652926266A2B2B2C612E69734461726B28642C652B312926266A2B2B2C612E6973446172';
wwv_flow_api.g_varchar2_table(91) := '6B28642B312C652B312926266A2B2B2C28303D3D6A7C7C343D3D6A29262628632B3D33297D666F722876617220643D303B623E643B642B2B29666F722876617220653D303B622D363E653B652B2B29612E69734461726B28642C6529262621612E697344';
wwv_flow_api.g_varchar2_table(92) := '61726B28642C652B31292626612E69734461726B28642C652B32292626612E69734461726B28642C652B33292626612E69734461726B28642C652B3429262621612E69734461726B28642C652B35292626612E69734461726B28642C652B362926262863';
wwv_flow_api.g_varchar2_table(93) := '2B3D3430293B666F722876617220653D303B623E653B652B2B29666F722876617220643D303B622D363E643B642B2B29612E69734461726B28642C6529262621612E69734461726B28642B312C65292626612E69734461726B28642B322C65292626612E';
wwv_flow_api.g_varchar2_table(94) := '69734461726B28642B332C65292626612E69734461726B28642B342C6529262621612E69734461726B28642B352C65292626612E69734461726B28642B362C6529262628632B3D3430293B666F7228766172206B3D302C653D303B623E653B652B2B2966';
wwv_flow_api.g_varchar2_table(95) := '6F722876617220643D303B623E643B642B2B29612E69734461726B28642C652926266B2B2B3B766172206C3D4D6174682E616273283130302A6B2F622F622D3530292F353B72657475726E20632B3D31302A6C7D7D2C673D7B676C6F673A66756E637469';
wwv_flow_api.g_varchar2_table(96) := '6F6E2861297B696628313E61297468726F77206E6577204572726F722822676C6F6728222B612B222922293B72657475726E20672E4C4F475F5441424C455B615D7D2C676578703A66756E6374696F6E2861297B666F72283B303E613B29612B3D323535';
wwv_flow_api.g_varchar2_table(97) := '3B666F72283B613E3D3235363B29612D3D3235353B72657475726E20672E4558505F5441424C455B615D7D2C4558505F5441424C453A6E657720417272617928323536292C4C4F475F5441424C453A6E657720417272617928323536297D2C683D303B38';
wwv_flow_api.g_varchar2_table(98) := '3E683B682B2B29672E4558505F5441424C455B685D3D313C3C683B666F722876617220683D383B3235363E683B682B2B29672E4558505F5441424C455B685D3D672E4558505F5441424C455B682D345D5E672E4558505F5441424C455B682D355D5E672E';
wwv_flow_api.g_varchar2_table(99) := '4558505F5441424C455B682D365D5E672E4558505F5441424C455B682D385D3B666F722876617220683D303B3235353E683B682B2B29672E4C4F475F5441424C455B672E4558505F5441424C455B685D5D3D683B692E70726F746F747970653D7B676574';
wwv_flow_api.g_varchar2_table(100) := '3A66756E6374696F6E2861297B72657475726E20746869732E6E756D5B615D7D2C6765744C656E6774683A66756E6374696F6E28297B72657475726E20746869732E6E756D2E6C656E6774687D2C6D756C7469706C793A66756E6374696F6E2861297B66';
wwv_flow_api.g_varchar2_table(101) := '6F722876617220623D6E657720417272617928746869732E6765744C656E67746828292B612E6765744C656E67746828292D31292C633D303B633C746869732E6765744C656E67746828293B632B2B29666F722876617220643D303B643C612E6765744C';
wwv_flow_api.g_varchar2_table(102) := '656E67746828293B642B2B29625B632B645D5E3D672E6765787028672E676C6F6728746869732E676574286329292B672E676C6F6728612E67657428642929293B72657475726E206E6577206928622C30297D2C6D6F643A66756E6374696F6E2861297B';
wwv_flow_api.g_varchar2_table(103) := '696628746869732E6765744C656E67746828292D612E6765744C656E67746828293C302972657475726E20746869733B666F722876617220623D672E676C6F6728746869732E676574283029292D672E676C6F6728612E676574283029292C633D6E6577';
wwv_flow_api.g_varchar2_table(104) := '20417272617928746869732E6765744C656E6774682829292C643D303B643C746869732E6765744C656E67746828293B642B2B29635B645D3D746869732E6765742864293B666F722876617220643D303B643C612E6765744C656E67746828293B642B2B';
wwv_flow_api.g_varchar2_table(105) := '29635B645D5E3D672E6765787028672E676C6F6728612E676574286429292B62293B72657475726E206E6577206928632C30292E6D6F642861297D7D2C6A2E52535F424C4F434B5F5441424C453D5B5B312C32362C31395D2C5B312C32362C31365D2C5B';
wwv_flow_api.g_varchar2_table(106) := '312C32362C31335D2C5B312C32362C395D2C5B312C34342C33345D2C5B312C34342C32385D2C5B312C34342C32325D2C5B312C34342C31365D2C5B312C37302C35355D2C5B312C37302C34345D2C5B322C33352C31375D2C5B322C33352C31335D2C5B31';
wwv_flow_api.g_varchar2_table(107) := '2C3130302C38305D2C5B322C35302C33325D2C5B322C35302C32345D2C5B342C32352C395D2C5B312C3133342C3130385D2C5B322C36372C34335D2C5B322C33332C31352C322C33342C31365D2C5B322C33332C31312C322C33342C31325D2C5B322C38';
wwv_flow_api.g_varchar2_table(108) := '362C36385D2C5B342C34332C32375D2C5B342C34332C31395D2C5B342C34332C31355D2C5B322C39382C37385D2C5B342C34392C33315D2C5B322C33322C31342C342C33332C31355D2C5B342C33392C31332C312C34302C31345D2C5B322C3132312C39';
wwv_flow_api.g_varchar2_table(109) := '375D2C5B322C36302C33382C322C36312C33395D2C5B342C34302C31382C322C34312C31395D2C5B342C34302C31342C322C34312C31355D2C5B322C3134362C3131365D2C5B332C35382C33362C322C35392C33375D2C5B342C33362C31362C342C3337';
wwv_flow_api.g_varchar2_table(110) := '2C31375D2C5B342C33362C31322C342C33372C31335D2C5B322C38362C36382C322C38372C36395D2C5B342C36392C34332C312C37302C34345D2C5B362C34332C31392C322C34342C32305D2C5B362C34332C31352C322C34342C31365D2C5B342C3130';
wwv_flow_api.g_varchar2_table(111) := '312C38315D2C5B312C38302C35302C342C38312C35315D2C5B342C35302C32322C342C35312C32335D2C5B332C33362C31322C382C33372C31335D2C5B322C3131362C39322C322C3131372C39335D2C5B362C35382C33362C322C35392C33375D2C5B34';
wwv_flow_api.g_varchar2_table(112) := '2C34362C32302C362C34372C32315D2C5B372C34322C31342C342C34332C31355D2C5B342C3133332C3130375D2C5B382C35392C33372C312C36302C33385D2C5B382C34342C32302C342C34352C32315D2C5B31322C33332C31312C342C33342C31325D';
wwv_flow_api.g_varchar2_table(113) := '2C5B332C3134352C3131352C312C3134362C3131365D2C5B342C36342C34302C352C36352C34315D2C5B31312C33362C31362C352C33372C31375D2C5B31312C33362C31322C352C33372C31335D2C5B352C3130392C38372C312C3131302C38385D2C5B';
wwv_flow_api.g_varchar2_table(114) := '352C36352C34312C352C36362C34325D2C5B352C35342C32342C372C35352C32355D2C5B31312C33362C31325D2C5B352C3132322C39382C312C3132332C39395D2C5B372C37332C34352C332C37342C34365D2C5B31352C34332C31392C322C34342C32';
wwv_flow_api.g_varchar2_table(115) := '305D2C5B332C34352C31352C31332C34362C31365D2C5B312C3133352C3130372C352C3133362C3130385D2C5B31302C37342C34362C312C37352C34375D2C5B312C35302C32322C31352C35312C32335D2C5B322C34322C31342C31372C34332C31355D';
wwv_flow_api.g_varchar2_table(116) := '2C5B352C3135302C3132302C312C3135312C3132315D2C5B392C36392C34332C342C37302C34345D2C5B31372C35302C32322C312C35312C32335D2C5B322C34322C31342C31392C34332C31355D2C5B332C3134312C3131332C342C3134322C3131345D';
wwv_flow_api.g_varchar2_table(117) := '2C5B332C37302C34342C31312C37312C34355D2C5B31372C34372C32312C342C34382C32325D2C5B392C33392C31332C31362C34302C31345D2C5B332C3133352C3130372C352C3133362C3130385D2C5B332C36372C34312C31332C36382C34325D2C5B';
wwv_flow_api.g_varchar2_table(118) := '31352C35342C32342C352C35352C32355D2C5B31352C34332C31352C31302C34342C31365D2C5B342C3134342C3131362C342C3134352C3131375D2C5B31372C36382C34325D2C5B31372C35302C32322C362C35312C32335D2C5B31392C34362C31362C';
wwv_flow_api.g_varchar2_table(119) := '362C34372C31375D2C5B322C3133392C3131312C372C3134302C3131325D2C5B31372C37342C34365D2C5B372C35342C32342C31362C35352C32355D2C5B33342C33372C31335D2C5B342C3135312C3132312C352C3135322C3132325D2C5B342C37352C';
wwv_flow_api.g_varchar2_table(120) := '34372C31342C37362C34385D2C5B31312C35342C32342C31342C35352C32355D2C5B31362C34352C31352C31342C34362C31365D2C5B362C3134372C3131372C342C3134382C3131385D2C5B362C37332C34352C31342C37342C34365D2C5B31312C3534';
wwv_flow_api.g_varchar2_table(121) := '2C32342C31362C35352C32355D2C5B33302C34362C31362C322C34372C31375D2C5B382C3133322C3130362C342C3133332C3130375D2C5B382C37352C34372C31332C37362C34385D2C5B372C35342C32342C32322C35352C32355D2C5B32322C34352C';
wwv_flow_api.g_varchar2_table(122) := '31352C31332C34362C31365D2C5B31302C3134322C3131342C322C3134332C3131355D2C5B31392C37342C34362C342C37352C34375D2C5B32382C35302C32322C362C35312C32335D2C5B33332C34362C31362C342C34372C31375D2C5B382C3135322C';
wwv_flow_api.g_varchar2_table(123) := '3132322C342C3135332C3132335D2C5B32322C37332C34352C332C37342C34365D2C5B382C35332C32332C32362C35342C32345D2C5B31322C34352C31352C32382C34362C31365D2C5B332C3134372C3131372C31302C3134382C3131385D2C5B332C37';
wwv_flow_api.g_varchar2_table(124) := '332C34352C32332C37342C34365D2C5B342C35342C32342C33312C35352C32355D2C5B31312C34352C31352C33312C34362C31365D2C5B372C3134362C3131362C372C3134372C3131375D2C5B32312C37332C34352C372C37342C34365D2C5B312C3533';
wwv_flow_api.g_varchar2_table(125) := '2C32332C33372C35342C32345D2C5B31392C34352C31352C32362C34362C31365D2C5B352C3134352C3131352C31302C3134362C3131365D2C5B31392C37352C34372C31302C37362C34385D2C5B31352C35342C32342C32352C35352C32355D2C5B3233';
wwv_flow_api.g_varchar2_table(126) := '2C34352C31352C32352C34362C31365D2C5B31332C3134352C3131352C332C3134362C3131365D2C5B322C37342C34362C32392C37352C34375D2C5B34322C35342C32342C312C35352C32355D2C5B32332C34352C31352C32382C34362C31365D2C5B31';
wwv_flow_api.g_varchar2_table(127) := '372C3134352C3131355D2C5B31302C37342C34362C32332C37352C34375D2C5B31302C35342C32342C33352C35352C32355D2C5B31392C34352C31352C33352C34362C31365D2C5B31372C3134352C3131352C312C3134362C3131365D2C5B31342C3734';
wwv_flow_api.g_varchar2_table(128) := '2C34362C32312C37352C34375D2C5B32392C35342C32342C31392C35352C32355D2C5B31312C34352C31352C34362C34362C31365D2C5B31332C3134352C3131352C362C3134362C3131365D2C5B31342C37342C34362C32332C37352C34375D2C5B3434';
wwv_flow_api.g_varchar2_table(129) := '2C35342C32342C372C35352C32355D2C5B35392C34362C31362C312C34372C31375D2C5B31322C3135312C3132312C372C3135322C3132325D2C5B31322C37352C34372C32362C37362C34385D2C5B33392C35342C32342C31342C35352C32355D2C5B32';
wwv_flow_api.g_varchar2_table(130) := '322C34352C31352C34312C34362C31365D2C5B362C3135312C3132312C31342C3135322C3132325D2C5B362C37352C34372C33342C37362C34385D2C5B34362C35342C32342C31302C35352C32355D2C5B322C34352C31352C36342C34362C31365D2C5B';
wwv_flow_api.g_varchar2_table(131) := '31372C3135322C3132322C342C3135332C3132335D2C5B32392C37342C34362C31342C37352C34375D2C5B34392C35342C32342C31302C35352C32355D2C5B32342C34352C31352C34362C34362C31365D2C5B342C3135322C3132322C31382C3135332C';
wwv_flow_api.g_varchar2_table(132) := '3132335D2C5B31332C37342C34362C33322C37352C34375D2C5B34382C35342C32342C31342C35352C32355D2C5B34322C34352C31352C33322C34362C31365D2C5B32302C3134372C3131372C342C3134382C3131385D2C5B34302C37352C34372C372C';
wwv_flow_api.g_varchar2_table(133) := '37362C34385D2C5B34332C35342C32342C32322C35352C32355D2C5B31302C34352C31352C36372C34362C31365D2C5B31392C3134382C3131382C362C3134392C3131395D2C5B31382C37352C34372C33312C37362C34385D2C5B33342C35342C32342C';
wwv_flow_api.g_varchar2_table(134) := '33342C35352C32355D2C5B32302C34352C31352C36312C34362C31365D5D2C6A2E6765745253426C6F636B733D66756E6374696F6E28612C62297B76617220633D6A2E6765745273426C6F636B5461626C6528612C62293B696628766F696420303D3D63';
wwv_flow_api.g_varchar2_table(135) := '297468726F77206E6577204572726F72282262616420727320626C6F636B204020747970654E756D6265723A222B612B222F6572726F72436F72726563744C6576656C3A222B62293B666F722876617220643D632E6C656E6774682F332C653D5B5D2C66';
wwv_flow_api.g_varchar2_table(136) := '3D303B643E663B662B2B29666F722876617220673D635B332A662B305D2C683D635B332A662B315D2C693D635B332A662B325D2C6B3D303B673E6B3B6B2B2B29652E70757368286E6577206A28682C6929293B72657475726E20657D2C6A2E6765745273';
wwv_flow_api.g_varchar2_table(137) := '426C6F636B5461626C653D66756E6374696F6E28612C62297B7377697463682862297B6361736520642E4C3A72657475726E206A2E52535F424C4F434B5F5441424C455B342A28612D31292B305D3B6361736520642E4D3A72657475726E206A2E52535F';
wwv_flow_api.g_varchar2_table(138) := '424C4F434B5F5441424C455B342A28612D31292B315D3B6361736520642E513A72657475726E206A2E52535F424C4F434B5F5441424C455B342A28612D31292B325D3B6361736520642E483A72657475726E206A2E52535F424C4F434B5F5441424C455B';
wwv_flow_api.g_varchar2_table(139) := '342A28612D31292B335D3B64656661756C743A72657475726E20766F696420307D7D2C6B2E70726F746F747970653D7B6765743A66756E6374696F6E2861297B76617220623D4D6174682E666C6F6F7228612F38293B72657475726E20313D3D28312674';
wwv_flow_api.g_varchar2_table(140) := '6869732E6275666665725B625D3E3E3E372D612538297D2C7075743A66756E6374696F6E28612C62297B666F722876617220633D303B623E633B632B2B29746869732E70757442697428313D3D283126613E3E3E622D632D3129297D2C6765744C656E67';
wwv_flow_api.g_varchar2_table(141) := '7468496E426974733A66756E6374696F6E28297B72657475726E20746869732E6C656E6774687D2C7075744269743A66756E6374696F6E2861297B76617220623D4D6174682E666C6F6F7228746869732E6C656E6774682F38293B746869732E62756666';
wwv_flow_api.g_varchar2_table(142) := '65722E6C656E6774683C3D622626746869732E6275666665722E707573682830292C61262628746869732E6275666665725B625D7C3D3132383E3E3E746869732E6C656E6774682538292C746869732E6C656E6774682B2B7D7D3B766172206C3D5B5B31';
wwv_flow_api.g_varchar2_table(143) := '372C31342C31312C375D2C5B33322C32362C32302C31345D2C5B35332C34322C33322C32345D2C5B37382C36322C34362C33345D2C5B3130362C38342C36302C34345D2C5B3133342C3130362C37342C35385D2C5B3135342C3132322C38362C36345D2C';
wwv_flow_api.g_varchar2_table(144) := '5B3139322C3135322C3130382C38345D2C5B3233302C3138302C3133302C39385D2C5B3237312C3231332C3135312C3131395D2C5B3332312C3235312C3137372C3133375D2C5B3336372C3238372C3230332C3135355D2C5B3432352C3333312C323431';
wwv_flow_api.g_varchar2_table(145) := '2C3137375D2C5B3435382C3336322C3235382C3139345D2C5B3532302C3431322C3239322C3232305D2C5B3538362C3435302C3332322C3235305D2C5B3634342C3530342C3336342C3238305D2C5B3731382C3536302C3339342C3331305D2C5B373932';
wwv_flow_api.g_varchar2_table(146) := '2C3632342C3434322C3333385D2C5B3835382C3636362C3438322C3338325D2C5B3932392C3731312C3530392C3430335D2C5B313030332C3737392C3536352C3433395D2C5B313039312C3835372C3631312C3436315D2C5B313137312C3931312C3636';
wwv_flow_api.g_varchar2_table(147) := '312C3531315D2C5B313237332C3939372C3731352C3533355D2C5B313336372C313035392C3735312C3539335D2C5B313436352C313132352C3830352C3632355D2C5B313532382C313139302C3836382C3635385D2C5B313632382C313236342C393038';
wwv_flow_api.g_varchar2_table(148) := '2C3639385D2C5B313733322C313337302C3938322C3734325D2C5B313834302C313435322C313033302C3739305D2C5B313935322C313533382C313131322C3834325D2C5B323036382C313632382C313136382C3839385D2C5B323138382C313732322C';
wwv_flow_api.g_varchar2_table(149) := '313232382C3935385D2C5B323330332C313830392C313238332C3938335D2C5B323433312C313931312C313335312C313035315D2C5B323536332C313938392C313432332C313039335D2C5B323639392C323039392C313439392C313133395D2C5B3238';
wwv_flow_api.g_varchar2_table(150) := '30392C323231332C313537392C313231395D2C5B323935332C323333312C313636332C313237335D5D2C6F3D66756E6374696F6E28297B76617220613D66756E6374696F6E28612C62297B746869732E5F656C3D612C746869732E5F68744F7074696F6E';
wwv_flow_api.g_varchar2_table(151) := '3D627D3B72657475726E20612E70726F746F747970652E647261773D66756E6374696F6E2861297B66756E6374696F6E206728612C62297B76617220633D646F63756D656E742E637265617465456C656D656E744E532822687474703A2F2F7777772E77';
wwv_flow_api.g_varchar2_table(152) := '332E6F72672F323030302F737667222C61293B666F7228766172206420696E206229622E6861734F776E50726F70657274792864292626632E73657441747472696275746528642C625B645D293B72657475726E20637D76617220623D746869732E5F68';
wwv_flow_api.g_varchar2_table(153) := '744F7074696F6E2C633D746869732E5F656C2C643D612E6765744D6F64756C65436F756E7428293B4D6174682E666C6F6F7228622E77696474682F64292C4D6174682E666C6F6F7228622E6865696768742F64292C746869732E636C65617228293B7661';
wwv_flow_api.g_varchar2_table(154) := '7220683D672822737667222C7B76696577426F783A2230203020222B537472696E672864292B2220222B537472696E672864292C77696474683A2231303025222C6865696768743A2231303025222C66696C6C3A622E636F6C6F724C696768747D293B68';
wwv_flow_api.g_varchar2_table(155) := '2E7365744174747269627574654E532822687474703A2F2F7777772E77332E6F72672F323030302F786D6C6E732F222C22786D6C6E733A786C696E6B222C22687474703A2F2F7777772E77332E6F72672F313939392F786C696E6B22292C632E61707065';
wwv_flow_api.g_varchar2_table(156) := '6E644368696C642868292C682E617070656E644368696C642867282272656374222C7B66696C6C3A622E636F6C6F724461726B2C77696474683A2231222C6865696768743A2231222C69643A2274656D706C617465227D29293B666F722876617220693D';
wwv_flow_api.g_varchar2_table(157) := '303B643E693B692B2B29666F7228766172206A3D303B643E6A3B6A2B2B29696628612E69734461726B28692C6A29297B766172206B3D672822757365222C7B783A537472696E672869292C793A537472696E67286A297D293B6B2E736574417474726962';
wwv_flow_api.g_varchar2_table(158) := '7574654E532822687474703A2F2F7777772E77332E6F72672F313939392F786C696E6B222C2268726566222C222374656D706C61746522292C682E617070656E644368696C64286B297D7D2C612E70726F746F747970652E636C6561723D66756E637469';
wwv_flow_api.g_varchar2_table(159) := '6F6E28297B666F72283B746869732E5F656C2E6861734368696C644E6F64657328293B29746869732E5F656C2E72656D6F76654368696C6428746869732E5F656C2E6C6173744368696C64297D2C617D28292C703D22737667223D3D3D646F63756D656E';
wwv_flow_api.g_varchar2_table(160) := '742E646F63756D656E74456C656D656E742E7461674E616D652E746F4C6F7765724361736528292C713D703F6F3A6D28293F66756E6374696F6E28297B66756E6374696F6E206128297B746869732E5F656C496D6167652E7372633D746869732E5F656C';
wwv_flow_api.g_varchar2_table(161) := '43616E7661732E746F4461746155524C2822696D6167652F706E6722292C746869732E5F656C496D6167652E7374796C652E646973706C61793D22626C6F636B222C746869732E5F656C43616E7661732E7374796C652E646973706C61793D226E6F6E65';
wwv_flow_api.g_varchar2_table(162) := '227D66756E6374696F6E206428612C62297B76617220633D746869733B696628632E5F664661696C3D622C632E5F66537563636573733D612C6E756C6C3D3D3D632E5F62537570706F727444617461555249297B76617220643D646F63756D656E742E63';
wwv_flow_api.g_varchar2_table(163) := '7265617465456C656D656E742822696D6722292C653D66756E6374696F6E28297B632E5F62537570706F7274446174615552493D21312C632E5F664661696C26265F664661696C2E63616C6C2863297D2C663D66756E6374696F6E28297B632E5F625375';
wwv_flow_api.g_varchar2_table(164) := '70706F7274446174615552493D21302C632E5F66537563636573732626632E5F66537563636573732E63616C6C2863297D3B72657475726E20642E6F6E61626F72743D652C642E6F6E6572726F723D652C642E6F6E6C6F61643D662C642E7372633D2264';
wwv_flow_api.g_varchar2_table(165) := '6174613A696D6167652F6769663B6261736536342C6956424F5277304B47676F414141414E53556845556741414141554141414146434159414141434E6279626C4141414148456C4551565149313250342F2F382F773338474941584449424B45304448';
wwv_flow_api.g_varchar2_table(166) := '78676C6A4E4241414F3954584C3059344F487741414141424A52553545726B4A6767673D3D222C766F696420307D632E5F62537570706F7274446174615552493D3D3D21302626632E5F66537563636573733F632E5F66537563636573732E63616C6C28';
wwv_flow_api.g_varchar2_table(167) := '63293A632E5F62537570706F7274446174615552493D3D3D21312626632E5F664661696C2626632E5F664661696C2E63616C6C2863297D696628746869732E5F616E64726F69642626746869732E5F616E64726F69643C3D322E31297B76617220623D31';
wwv_flow_api.g_varchar2_table(168) := '2F77696E646F772E646576696365506978656C526174696F2C633D43616E76617352656E646572696E67436F6E7465787432442E70726F746F747970652E64726177496D6167653B43616E76617352656E646572696E67436F6E7465787432442E70726F';
wwv_flow_api.g_varchar2_table(169) := '746F747970652E64726177496D6167653D66756E6374696F6E28612C642C652C662C672C682C692C6A297B696628226E6F64654E616D6522696E206126262F696D672F692E7465737428612E6E6F64654E616D652929666F7228766172206C3D61726775';
wwv_flow_api.g_varchar2_table(170) := '6D656E74732E6C656E6774682D313B6C3E3D313B6C2D2D29617267756D656E74735B6C5D3D617267756D656E74735B6C5D2A623B656C736522756E646566696E6564223D3D747970656F66206A262628617267756D656E74735B315D2A3D622C61726775';
wwv_flow_api.g_varchar2_table(171) := '6D656E74735B325D2A3D622C617267756D656E74735B335D2A3D622C617267756D656E74735B345D2A3D62293B632E6170706C7928746869732C617267756D656E7473297D7D76617220653D66756E6374696F6E28612C62297B746869732E5F62497350';
wwv_flow_api.g_varchar2_table(172) := '61696E7465643D21312C746869732E5F616E64726F69643D6E28292C746869732E5F68744F7074696F6E3D622C746869732E5F656C43616E7661733D646F63756D656E742E637265617465456C656D656E74282263616E76617322292C746869732E5F65';
wwv_flow_api.g_varchar2_table(173) := '6C43616E7661732E77696474683D622E77696474682C746869732E5F656C43616E7661732E6865696768743D622E6865696768742C612E617070656E644368696C6428746869732E5F656C43616E766173292C746869732E5F656C3D612C746869732E5F';
wwv_flow_api.g_varchar2_table(174) := '6F436F6E746578743D746869732E5F656C43616E7661732E676574436F6E746578742822326422292C746869732E5F6249735061696E7465643D21312C746869732E5F656C496D6167653D646F63756D656E742E637265617465456C656D656E74282269';
wwv_flow_api.g_varchar2_table(175) := '6D6722292C746869732E5F656C496D6167652E7374796C652E646973706C61793D226E6F6E65222C746869732E5F656C2E617070656E644368696C6428746869732E5F656C496D616765292C746869732E5F62537570706F7274446174615552493D6E75';
wwv_flow_api.g_varchar2_table(176) := '6C6C7D3B72657475726E20652E70726F746F747970652E647261773D66756E6374696F6E2861297B76617220623D746869732E5F656C496D6167652C633D746869732E5F6F436F6E746578742C643D746869732E5F68744F7074696F6E2C653D612E6765';
wwv_flow_api.g_varchar2_table(177) := '744D6F64756C65436F756E7428292C663D642E77696474682F652C673D642E6865696768742F652C683D4D6174682E726F756E642866292C693D4D6174682E726F756E642867293B622E7374796C652E646973706C61793D226E6F6E65222C746869732E';
wwv_flow_api.g_varchar2_table(178) := '636C65617228293B666F7228766172206A3D303B653E6A3B6A2B2B29666F7228766172206B3D303B653E6B3B6B2B2B297B766172206C3D612E69734461726B286A2C6B292C6D3D6B2A662C6E3D6A2A673B632E7374726F6B655374796C653D6C3F642E63';
wwv_flow_api.g_varchar2_table(179) := '6F6C6F724461726B3A642E636F6C6F724C696768742C632E6C696E6557696474683D312C632E66696C6C5374796C653D6C3F642E636F6C6F724461726B3A642E636F6C6F724C696768742C632E66696C6C52656374286D2C6E2C662C67292C632E737472';
wwv_flow_api.g_varchar2_table(180) := '6F6B6552656374284D6174682E666C6F6F72286D292B2E352C4D6174682E666C6F6F72286E292B2E352C682C69292C632E7374726F6B6552656374284D6174682E6365696C286D292D2E352C4D6174682E6365696C286E292D2E352C682C69297D746869';
wwv_flow_api.g_varchar2_table(181) := '732E5F6249735061696E7465643D21307D2C652E70726F746F747970652E6D616B65496D6167653D66756E6374696F6E28297B746869732E5F6249735061696E7465642626642E63616C6C28746869732C61297D2C652E70726F746F747970652E697350';
wwv_flow_api.g_varchar2_table(182) := '61696E7465643D66756E6374696F6E28297B72657475726E20746869732E5F6249735061696E7465647D2C652E70726F746F747970652E636C6561723D66756E6374696F6E28297B746869732E5F6F436F6E746578742E636C6561725265637428302C30';
wwv_flow_api.g_varchar2_table(183) := '2C746869732E5F656C43616E7661732E77696474682C746869732E5F656C43616E7661732E686569676874292C746869732E5F6249735061696E7465643D21317D2C652E70726F746F747970652E726F756E643D66756E6374696F6E2861297B72657475';
wwv_flow_api.g_varchar2_table(184) := '726E20613F4D6174682E666C6F6F72283165332A61292F3165333A617D2C657D28293A66756E6374696F6E28297B76617220613D66756E6374696F6E28612C62297B746869732E5F656C3D612C746869732E5F68744F7074696F6E3D627D3B7265747572';
wwv_flow_api.g_varchar2_table(185) := '6E20612E70726F746F747970652E647261773D66756E6374696F6E2861297B666F722876617220623D746869732E5F68744F7074696F6E2C633D746869732E5F656C2C643D612E6765744D6F64756C65436F756E7428292C653D4D6174682E666C6F6F72';
wwv_flow_api.g_varchar2_table(186) := '28622E77696474682F64292C663D4D6174682E666C6F6F7228622E6865696768742F64292C673D5B273C7461626C65207374796C653D22626F726465723A303B626F726465722D636F6C6C617073653A636F6C6C617073653B223E275D2C683D303B643E';
wwv_flow_api.g_varchar2_table(187) := '683B682B2B297B672E7075736828223C74723E22293B666F722876617220693D303B643E693B692B2B29672E7075736828273C7464207374796C653D22626F726465723A303B626F726465722D636F6C6C617073653A636F6C6C617073653B7061646469';
wwv_flow_api.g_varchar2_table(188) := '6E673A303B6D617267696E3A303B77696474683A272B652B2270783B6865696768743A222B662B2270783B6261636B67726F756E642D636F6C6F723A222B28612E69734461726B28682C69293F622E636F6C6F724461726B3A622E636F6C6F724C696768';
wwv_flow_api.g_varchar2_table(189) := '74292B273B223E3C2F74643E27293B672E7075736828223C2F74723E22297D672E7075736828223C2F7461626C653E22292C632E696E6E657248544D4C3D672E6A6F696E282222293B766172206A3D632E6368696C644E6F6465735B305D2C6B3D28622E';
wwv_flow_api.g_varchar2_table(190) := '77696474682D6A2E6F66667365745769647468292F322C6C3D28622E6865696768742D6A2E6F6666736574486569676874292F323B6B3E3026266C3E302626286A2E7374796C652E6D617267696E3D6C2B22707820222B6B2B22707822297D2C612E7072';
wwv_flow_api.g_varchar2_table(191) := '6F746F747970652E636C6561723D66756E6374696F6E28297B746869732E5F656C2E696E6E657248544D4C3D22227D2C617D28293B5152436F64653D66756E6374696F6E28612C62297B696628746869732E5F68744F7074696F6E3D7B77696474683A32';
wwv_flow_api.g_varchar2_table(192) := '35362C6865696768743A3235362C747970654E756D6265723A342C636F6C6F724461726B3A2223303030303030222C636F6C6F724C696768743A2223666666666666222C636F72726563744C6576656C3A642E487D2C22737472696E67223D3D74797065';
wwv_flow_api.g_varchar2_table(193) := '6F662062262628623D7B746578743A627D292C6229666F7228766172206320696E206229746869732E5F68744F7074696F6E5B635D3D625B635D3B22737472696E67223D3D747970656F662061262628613D646F63756D656E742E676574456C656D656E';
wwv_flow_api.g_varchar2_table(194) := '7442794964286129292C746869732E5F616E64726F69643D6E28292C746869732E5F656C3D612C746869732E5F6F5152436F64653D6E756C6C2C746869732E5F6F44726177696E673D6E6577207128746869732E5F656C2C746869732E5F68744F707469';
wwv_flow_api.g_varchar2_table(195) := '6F6E292C746869732E5F68744F7074696F6E2E746578742626746869732E6D616B65436F646528746869732E5F68744F7074696F6E2E74657874297D2C5152436F64652E70726F746F747970652E6D616B65436F64653D66756E6374696F6E2861297B74';
wwv_flow_api.g_varchar2_table(196) := '6869732E5F6F5152436F64653D6E65772062287228612C746869732E5F68744F7074696F6E2E636F72726563744C6576656C292C746869732E5F68744F7074696F6E2E636F72726563744C6576656C292C746869732E5F6F5152436F64652E6164644461';
wwv_flow_api.g_varchar2_table(197) := '74612861292C746869732E5F6F5152436F64652E6D616B6528292C746869732E5F656C2E7469746C653D612C746869732E5F6F44726177696E672E6472617728746869732E5F6F5152436F6465292C746869732E6D616B65496D61676528297D2C515243';
wwv_flow_api.g_varchar2_table(198) := '6F64652E70726F746F747970652E6D616B65496D6167653D66756E6374696F6E28297B2266756E6374696F6E223D3D747970656F6620746869732E5F6F44726177696E672E6D616B65496D61676526262821746869732E5F616E64726F69647C7C746869';
wwv_flow_api.g_varchar2_table(199) := '732E5F616E64726F69643E3D33292626746869732E5F6F44726177696E672E6D616B65496D61676528297D2C5152436F64652E70726F746F747970652E636C6561723D66756E6374696F6E28297B746869732E5F6F44726177696E672E636C6561722829';
wwv_flow_api.g_varchar2_table(200) := '7D2C5152436F64652E436F72726563744C6576656C3D647D28293B';
null;
end;
/
begin
wwv_flow_api.create_plugin_file(
 p_id=>wwv_flow_api.id(81503048489190588)
,p_plugin_id=>wwv_flow_api.id(81501773125101948)
,p_file_name=>'qrcode.min.js'
,p_mime_type=>'application/javascript'
,p_file_content=>wwv_flow_api.varchar2_to_blob(wwv_flow_api.g_varchar2_table)
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_api.create_user_interface(
 p_id=>wwv_flow_api.id(24318965471742462)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>false
,p_is_default=>true
,p_theme_id=>42
,p_home_url=>'f?p=&APP_ID.:2:&SESSION.'
,p_login_url=>'f?p=&APP_ID.:LOGIN_DESKTOP:&SESSION.'
,p_theme_style_by_user_pref=>true
,p_built_with_love=>false
,p_global_page_id=>0
,p_navigation_list_position=>'TOP'
,p_navigation_list_template_id=>wwv_flow_api.id(24284310417742218)
,p_nav_list_template_options=>'#DEFAULT#:js-tabLike'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#APP_IMAGES#app-icon.css?version=#APP_VERSION#',
'#APP_IMAGES#cronology.css'))
,p_javascript_file_urls=>'#APP_IMAGES#cronology.js'
,p_nav_bar_type=>'LIST'
,p_nav_bar_list_id=>wwv_flow_api.id(24318688776742456)
,p_nav_bar_list_template_id=>wwv_flow_api.id(24285515375742222)
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_api.create_page(
 p_id=>0
,p_user_interface_id=>wwv_flow_api.id(24318965471742462)
,p_name=>'Global Page - Desktop'
,p_step_title=>'Global Page - Desktop'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_protection_level=>'D'
,p_last_updated_by=>'CRON_DEV'
,p_last_upd_yyyymmddhh24miss=>'20250502133108'
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(22597135157982727)
,p_name=>'Page Load DA'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(22597278629982728)
,p_event_id=>wwv_flow_api.id(22597135157982727)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var keep_alive;',
'',
'// monitor all dialog notifications, if title not set i.e. APEX generated dialog, most likely an error, set the attributes',
'// custom_diag is a global var declared in the app .js file',
'// this is in here becuase 1) all related and 2) needed to reference the logout URL substitution string',
'',
'$(document).on("dialogopen", ".ui-dialog--notification", function (event, ui) {',
'// belt and braces - should never have a spinner running in front of a dialog',
'   hide_spinner();',
'   if ( ! custom_diag ) {',
'      var content  = apex.util.getTopApex().jQuery(''.ui-dialog--notification .ui-dialog-content'');',
'      var titlebar = apex.util.getTopApex().jQuery(''.ui-dialog--notification .ui-dialog-titlebar'');    ',
'      content.dialog(''option'', ''closeOnEscape'', false);',
'      content.dialog({dialogClass: "no-close"});',
'   // add a line feed to the start of any message, it looks nicer! This relies on the CSS to auto height size the notifications',
'      content.html( "<br>" + content.html().replace(''<br>'','''') );',
'   ',
'   // Special cases',
'      if ( content.html().includes(''Your session has expired'') ) {    ',
'         $(''#t_Alert_Notification'').css("display","none");             ',
'         content.dialog("option", "title", ''Error'');   ',
'         titlebar.css("background-color",e_red_rgb);    ',
'      }',
'      else if ( content.html().includes(''There are unsaved changes. Do you want to continue?'') ) {',
'         content.dialog("option", "title", ''Warning'');   ',
'         titlebar.css("background-color",w_orange_rgb);    ',
'      }',
'      else',
'      {',
'         content.dialog("option", "title", ''Error'');   ',
'         titlebar.css("background-color",e_red_rgb);    ',
'      }',
'   }',
'   custom_diag = false;',
'});',
'',
'$(document).on("dialogclose", ".ui-dialog--notification", function (event, ui) {',
'   var content  = apex.util.getTopApex().jQuery(''.ui-dialog--notification .ui-dialog-content'');',
'   if ( content.dialog("option", "title" ) == ''Error'' && content.html().includes(''Your session has expired'') ) {',
'      apex.navigation.redirect ("&LOGOUT_URL.");',
'   }',
'}',
');',
'',
'// ping the DB at regular interval (milliseconds) - this advances the IDLE_TIMEOUT_ON in wwv_flow_sessions$',
'// KEEP_ALIVE DA only fires on page 2 and 9 (see server side condition on the DA) - DB could be down - you would not expect login page to error.',
'// Only needed on page 2 (and 9) as all other pages open over the top of page 2 - the page 2 interval persists even though new window / page opened on top - if fired for these pages',
'// just end up with 2 intervals/timers running.',
'// If the APEX session job cleanup runs (every hour) and removes the nobody entry then login screen will error - but never mind',
'// Ping DB every 5 minutes',
'',
'clearInterval(keep_alive);',
'keep_alive = setInterval(function() {$.event.trigger("KEEP_ALIVE");}, 300000);',
'',
''))
);
wwv_flow_api.create_page_da_event(
 p_id=>wwv_flow_api.id(24758747290255723)
,p_name=>'KEEP_ALIVE'
,p_event_sequence=>20
,p_triggering_element_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_element=>'document'
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'KEEP_ALIVE'
,p_display_when_type=>'CURRENT_PAGE_IN_CONDITION'
,p_display_when_cond=>'2,9'
);
wwv_flow_api.create_page_da_action(
 p_id=>wwv_flow_api.id(24759140567255730)
,p_event_id=>wwv_flow_api.id(24758747290255723)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'   maxs  number := to_number(crypto.get_param(''CONSOLE_MAX_SESSION_MINS''));',
'   s     number := apex_application.g_instance;',
'   a     number := apex_application.g_flow_id;',
'begin',
'   if maxs <> 0 then',
'      if (sysdate - to_date(APEX_UTIL.GET_SESSION_STATE (''P2_SESSION_START''),''YYYYMMDDHH24MISS'')) * 1440 >= maxs then',
'      APEX_SESSION.DELETE_SESSION (s);',
'      commit;',
'      APEX_AUTHENTICATION.LOGOUT (s, a);',
'      end if;',
'   end if;',
'end;'))
,p_wait_for_result=>'N'
);
end;
/
prompt --application/pages/page_00002
begin
wwv_flow_api.create_page(
 p_id=>2
,p_user_interface_id=>wwv_flow_api.id(24318965471742462)
,p_name=>'MAIN'
,p_alias=>'HOME'
,p_step_title=>'&AP_NAME. Console | &DB_DETAILS.&P2_ENV_LABEL.'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var jsonData;',
'var consoleRefresh;',
'var jrh_ig_actions;',
'var job_log_ig_actions;',
'var pgv_total_rows = 0;',
'var pgv_refresh_on = 1;',
'var pgv_more_data_fetched = true;',
'var pgv_found_row = false;',
'var pgv_dctf  = ''Double click to filter'';',
'var pgv_dctcf = ''Double click header to clear filter'';',
'var pgv_main_grid_col = null;',
'var pgv_main_filter_trg_action = null;',
'var pgv_jrh_grid_col = null;',
'var pgv_jrh_filter_trg_action = null;',
'var db_datetime_interval;',
'var pgv_mouse_down_col;',
'var gv_goto_job = 0;',
'var global_mjf;',
'var pgv_exe_job_or_tooltip;',
'var maingridID = "MAIN";',
'var info_textarea = document.getElementById(''P2_INFO'');',
'var pgv_page_load = true;',
'var pgv_job_status;',
'var pgv_job_sub;',
'var pgv_jl_called_from;',
'var env_dets_changed = false;',
'var pgv_main_over_header = false;',
'var pgv_main_dbl_click = false;',
'var suspend_refresh   = false;',
'var view_source_goto  = true;',
'var aud_obj_name = "Audit History";',
'var pgv_scale = parseInt(window.screen.availWidth) >= 1920;',
'',
'var view_source_goto = true;',
'var next_needs_scroll = true;',
'',
'// here in case someone tries to bypass 2FA and come straight to this page. Gotp Logout page',
'if ( $v(''P2_AUTHENTICATED'') != ''T'') {',
'   apex.navigation.redirect (''f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'');',
'}',
'',
'function reset_refresh_timer() {',
'// MUST clear first or it will create multiple timers!',
'   clearInterval(consoleRefresh);',
'   consoleRefresh = null;',
'// value of 0 = no refresh',
'   if ( $v(''P2_CRONOLOGY_CONSOLE_REFRESH'') != 0 ) {',
'      consoleRefresh = setInterval("myTimer();", $v(''P2_CRONOLOGY_CONSOLE_REFRESH''));    ',
'   }',
'}',
'    ',
'function refresh_on_focus() {',
'// null consoleRefresh means they have turned refresh rate OFF',
'  if ( ! suspend_refresh && consoleRefresh != null ) {',
'     if ( $(".ui-dialog:visible").find(''.ui-dialog-content'').length === 0 ) {',
'     // only refresh if no dialogs active',
'         $.event.trigger("REFRESH_ALL");',
'       //reset refresh to same value - avoids quick double refreshes         ',
'         reset_refresh_timer();',
'     }',
'  }',
'}',
'',
'// removed in 4.2.5 as can clash with logout processing. If session timed out - then focus put on screen - got errors on screen / deadlock messages etc',
' window.addEventListener(''focus'', refresh_on_focus);',
'',
'function show_bg_history( bg_abb ) {',
'$s(''P2_BP_ABB_HISTORY'', bg_abb);',
'switch (bg_abb) {',
'  case ''JPLR'':',
'    bg_long = ''Job Poller'';',
'    break;',
'  case ''LGWR'':',
'    bg_long = ''Log Writer'';',
'    break;',
'  case ''MSVR'':',
'    bg_long = ''Message Server'';',
'    break;',
'}',
'open_inline_ig_dialog(''R_BG_PROCESS_HISTORY'',''R_BG_PROCESS_HISTORY'', bg_long+'' Process History'',''T'',''T'');',
'}',
'',
'function set_bg_process_buttons() {',
'if ( $v(''P2_JPLR_STATUS'') == ''STOPPED'' ) {',
'   enable(''#B_START_JPLR'');',
'   disable(''#B_STOP_JPLR'');',
'   disable(''P2_DELAYED_STOP_DTTM'');',
'}',
'else if ( $v(''P2_JPLR_STATUS'') == ''RUNNING'' ) {',
'   disable(''#B_START_JPLR'');',
'   enable(''#B_STOP_JPLR'');',
'   enable(''P2_DELAYED_STOP_DTTM'');',
'}',
'',
'if ( $v(''P2_JPLR_STATUS_1'').startsWith(''RUNNING ('') ) {',
'   disable(''P2_DELAYED_STOP_DTTM'');',
'   $(''#B_D_STOP_JPLR'').text(''Cancel Delayed Stop'');',
'   enable(''#B_D_STOP_JPLR'');    ',
'}',
'else',
'{',
'   $(''#B_D_STOP_JPLR'').text(''Request Delayed Stop'');',
'   disable(''#B_D_STOP_JPLR'');     ',
'   $s(''P2_DELAYED_STOP_DTTM'',null);    ',
'}',
'',
'if ( $v(''P2_LGWR_STATUS'') == ''RUNNING'' ) {',
'  enable(''#B_STOP_LGWR'');',
'}',
'else {',
'  disable(''#B_STOP_LGWR'');',
'}',
'',
'if ( $v(''P2_MSVR_STATUS'') == ''RUNNING'' ) {',
'  enable(''#B_STOP_MSVR'');',
'}',
'else {',
'  disable(''#B_STOP_MSVR'');',
'}',
'}',
'',
'async function myTimer()',
'{',
'   if (document.hasFocus() && ! suspend_refresh) {',
'      var diags = $(".ui-dialog:visible").find(''.ui-dialog-content''); ',
'       ',
'      if ( diags.length === 0 ) {',
'      // no dialogs open',
'         $.event.trigger("REFRESH_ALL");',
'      }',
'      else',
'      {',
'      // dialog active - refresh JRH and JL is viewing a running job',
'      // pgv_job_status and pgv_job_sub only set when JRH opened',
'         if ( [''RUN_HISTORY'',''JOB_LOG''].includes( diags[diags.length-1].id ) && pgv_job_status == ''RUNNING'' ) {',
'         // full refresh of main screen    ',
'            $.event.trigger("REFRESH_ALL");               ',
'         // can get away with smart refresh of run history - will only show them the latest job at the top RUNNING potnetially change status',
'            ig       = apex.region(''RUN_HISTORY'').widget();',
'            model    = ig.interactiveGrid("getViews").grid.model;  //equivalent: var model = apex.region("R_PARAM").widget().interactiveGrid("getViews", "grid").model;',
'            await model.fetchRecords(model._data); // this does the smart/invisible refresh               ',
'         // only update job log if viewing direct from JRH i.e. not refreshing for job log find results',
'            if ( diags[diags.length-1].id == ''JOB_LOG'' && pgv_jl_called_from == ''RUN_HISTORY'' && pgv_job_sub == get_current_col(''RUN_HISTORY'',''DISPLAY_SUB_DTTM'') ) {',
'            // they are looking at the log of a running job, refresh ...',
'               $s(''P2_JOB_LOG_GOTO_LINE'', get_current_col(''JOB_LOG'',''LINE_NO'') )',
'               if ( get_current_col(''RUN_HISTORY'',''STATUS'') != ''RUNNING'' ) {',
'               // status has changed',
'                  $(''#JOB_LOG.ui-dialog-content'').dialog(''option'', ''title'', ''Job Log - '' + ''Started: '' + get_current_col(''RUN_HISTORY'',''START_DTTM'')  + '' | Status: '' + get_current_col(''RUN_HISTORY'',''STATUS''));',
'               // change global var to stop any more refreshes after this one',
'                  pgv_job_status = get_current_col(''RUN_HISTORY'',''STATUS'');',
'               }',
'               apex.region(''JOB_LOG'').refresh();',
'            }',
'            else',
'            {',
'            // not looking at the running instance or called from job find - see if status has changed',
'               if ( get_current_col(''MAIN'',''STATUS'') != ''RUNNING'' ) {',
'               // change global var to stop any more refreshes after this one                      ',
'                  pgv_job_status = get_current_col(''MAIN'',''STATUS'');',
'               }',
'            }',
'         }',
'      }',
'   }',
'}',
'',
'function focus_grid()',
'{',
' apex.region(maingridID).focus();',
'};',
'',
'',
'function refreshOn () {',
'   pgv_refresh_on = 1;',
'};',
'',
'function refreshOff () {',
'    pgv_refresh_on = 0;',
'};',
'',
'function set_pgv_total_rows (n) {',
'  pgv_total_rows = n;',
'//  console.log("PGV_TOTAL_ROWS: "+pgv_total_rows);',
'};',
'',
'function set(col)',
'{',
'   $s(col,get_current_col(maingridID , col.substring(3)));',
'};',
'',
'function refresh_child_regions() {',
'  apex.region(''JOB_PARAMS'').refresh();',
'  apex.region(''JOB_DEPS'').refresh();',
'};',
'',
'async function smartRefreshNow() {',
'   var ig       = apex.region(maingridID).widget();',
'   var model    = ig.interactiveGrid("getViews").grid.model;  //equivalent: var model = apex.region("R_PARAM").widget().interactiveGrid("getViews", "grid").model;',
'   var gg$      = ig.interactiveGrid("getCurrentView").view$;',
'   var tot_rows = null;',
'',
'   gv_goto_job = nvl(get_current_col(maingridID ,''JOB_ID''),0);',
'',
'   await model.fetchRecords(model._data); // this does the smart/invisible refresh',
'    ',
'   try {',
'      tot_rows = model.getValue( model.recordAt(0) , ''TOTAL_ROWS'');',
'   }',
'   catch (err) {tot_rows = 0}',
'',
'//console.log(''----'');',
'//console.log(''PGV_TOTAL_ROWS: ''+pgv_total_rows);',
'//console.log(''FAST refresh TOT_ROWS: ''+tot_rows);',
'//console.log(''goto JOB ID: ''+gv_goto_job);',
'//console.log(''----'');',
'',
'     if ( parseInt(pgv_total_rows) == 0) {',
'     // no rows before the refresh, MUST do a full refresh as the numer of rows can only increase, WNRI will set pgv_total_rows',
'       apex.region(maingridID).refresh();',
'//       document.querySelector("#B_MAIN_MENU").focus();         ',
'       //gv_goto_job will be 0 so WNRI will refresh children',
'       // best efforts to goto 1st row as the full refresh is async - wait for a bit!',
'       setTimeout(function () {    ',
'       document.querySelector("#B_MAIN_MENU").focus();                    ',
'          gg$.grid(''gotoCell'',1);            // PK (recordid) is RN - which starts at 1    ',
'       },1500);',
'',
'     }',
'     else if ( parseInt(tot_rows) == 0) {',
'     // model has 0 rows ...',
'       set_pgv_total_rows(tot_rows);',
'       gv_goto_job = 0;',
'    // necessary evil to call WNRI - but it clears out all the job fields nicely  ',
'       $.event.trigger("MAIN_WNRI");',
'     }',
'     else if ( parseInt(tot_rows) > parseInt(pgv_total_rows) )  {',
'     // number of rows has increased - full refresh required',
'       set_pgv_total_rows(tot_rows);',
'       apex.region(maingridID).refresh();',
'       focus_grid();',
'     }',
'     else {',
'     // number of rows remained the same or decreased - fast refresh will have done its thing but wont fire WNRI, so have to do it ourselves',
'       set_pgv_total_rows(tot_rows);',
'       $.event.trigger("MAIN_WNRI");',
'     }',
'};',
'',
'function current_job_name() {',
'   try {',
'      return get_current_col(maingridID ,''DISPLAY_JOB_NAME'').replace(/^ +/g,'''').replace(/^>/g,'''').replace(/^ +/g,'''');',
'   }',
'   catch (err) {return null;}',
'}',
'',
'$(function() {',
'    apex.actions.add([',
'        {',
'            name: "create-job", // this matches the A01 Data ID list attribute',
'            action: function(event, element) {',
'                $.event.trigger("CREATE_JOB");',
'                return true; // return true because focus is set to the alert dialog',
'            }',
'        },',
'        {',
'            name: "copy-job",',
'            action: function(event, element) {',
'                $.event.trigger("COPY_JOB");',
'                return true;',
'            }',
'        },',
'        {',
'            name: "bring-online",',
'            action: function(event, element) {',
'                $s(''P2_ONLINE_YN'',''Y'');',
'                show_lov(''P2_OFFLINE_JOBS_LOV'',''Offline Jobs'', ''T'',''T'');',
'                return true;',
'            }',
'        },',
'        {',
'            name: "schedule-settings",',
'            action: function(event, element) {',
'                $.event.trigger("OPEN_SCHEDULE_SETTINGS");',
'                return true;',
'            }',
'        },',
'        {',
'            name: "bg-process",',
'            action: function(event, element) {',
'                $.event.trigger("OPEN_BG_PROCESS");',
'                return true;',
'            }',
'        },',
'        {',
'            name: "status-summary",',
'            action: function(event, element) {',
'                show_lov(''P2_STATUS_SUMMARY_LOV'',''Status Summary and Filter'',''T'',''F'');',
'                return true;',
'            }',
'        },',
'        {',
'            // the thing that makes an action a radio group is set and get methods + a choices array',
'            name: "console-refresh",',
'            get: function() {',
'                return $v("P2_CRONOLOGY_CONSOLE_REFRESH");',
'            },',
'            set: function(value) {',
'                $s("P2_CRONOLOGY_CONSOLE_REFRESH", value);',
'            },',
'            choices: [] // fill this in, in a moment',
'        },',
'        {',
'            // the thing that makes an action a radio group is set and get methods + a choices array',
'            name: "console-zoom", // this matches the A01 Data ID list attribute',
'            get: function() {',
'                return $v("P2_CRONOLOGY_CONSOLE_ZOOM");',
'            },',
'            set: function(value) {',
'                $s("P2_CRONOLOGY_CONSOLE_ZOOM", value);',
'            },',
'            choices: [] // fill this in, in a moment',
'        }',
'    ]);',
'',
'    // When the page first loads',
'    // Use the actions set methods to make sure the UI is in sync with the initial state when the page loads',
'    apex.actions.set("console-refresh", $v("P2_CRONOLOGY_CONSOLE_REFRESH"));',
'    setTimeout(function() {',
'        var action, label;',
'        // initialize the choices',
'        action = apex.actions.lookup("console-refresh");',
'        action.choices = action.label.split("|").map(function(c, i) { return {label: c, value: ["10000", "30000", "60000", "120000", "300000", "0"][i]}; } );',
'        delete action.label;',
'        apex.actions.update("console-refresh"); // not needed if only used from menus but good idea to call after making changes.',
'    }, 1);',
'    apex.actions.set("console-zoom", $v("P2_CRONOLOGY_CONSOLE_ZOOM"));',
'    setTimeout(function() {',
'        var action, label;',
'        // initialize the choices',
'        action = apex.actions.lookup("console-zoom");',
'        action.choices = action.label.split("|").map(function(c, i) { return {label: c, value: ["Y", "N"][i]}; } );',
'        delete action.label;',
'        apex.actions.update("console-zoom");',
'    }, 1);',
'});',
'',
'',
''))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var banner_rgb = "X";',
'var ig     = apex.region(maingridID).widget();',
'var model  = ig.interactiveGrid("getViews").grid.model;  //equivalent: var model = apex.region("R_PARAM").widget().interactiveGrid("getViews", "grid").model; ',
'',
'// this DOES correctly capture if data returned or not in the grid on initial page load',
'if ( model._data.length > 0 ) {',
'   set_pgv_total_rows(model.getValue( model.recordAt(0) , ''TOTAL_ROWS''));',
'}',
'else',
'{  set_pgv_total_rows(0); }',
'',
'apex.item("P2_AUTO_TEXT_LOV").hide();    ',
'apex.item("P2_JOBS_DEP_ON_THIS_JOB_LOV").hide();    ',
'apex.item("P2_JOB_DEP_JOB_LOV").hide();    ',
'apex.item("P2_JOB_DEP_JOB_PARAMS_LOV").hide();    ',
'apex.item("P2_OVERDUE_JOBS_LOV").hide();    ',
'apex.item("P2_MESSAGE_HISTORY_LOV").hide();    ',
'apex.item("P2_OFFLINE_JOBS_LOV").hide();    ',
'apex.item("P2_STATUS_SUMMARY_LOV").hide();    ',
'apex.item("P2_ORDERED_SOURCE_LOV").hide();    ',
'',
'hide(''#B_GOTO_JOB_SCREEN''); // dummy button to redirect to job maint page - calling click programatically via JS',
'hide(''#B_GOTO_SCHED_OPS_SCREEN''); // dummy button to redirect to job maint page - calling click programatically via JS',
'hide(''#B_DOWNLOAD_EXPORT''); // dummy button to redirect to download ajax process',
'',
'gv_goto_job = $v(''P2_GOTO_JOB_ID'');',
'if ( gv_goto_job == 0 ) {',
'// if no P2_GOTO_JOB_ID set, use P2_JOB_ID if it is set    ',
'    gv_goto_job = nvl($v(''P2_JOB_ID''),0);',
'}',
'',
'$.event.trigger("REFRESH_HEADER");   ',
'focus_grid();',
'',
'$("#R_USER_INFO").css("padding-bottom","5px");',
'apex.model.setMaxCachedModels(1);',
'',
'// set the default dismiss for alerts APEX fires (if relying on page processing)',
'setNotifyDismiss();',
'',
'apex.item("DJP_NAME").node.readOnly = true;',
'apex.item("DJP_DATA_TYPE").node.readOnly = true;',
'apex.item("DJP_DEP_NAME").node.readOnly = true;',
'apex.item("DJP_DEP_DATA_TYPE").node.readOnly = true;',
'',
'$.event.trigger("SET_JOB_NAME_HDR");   ',
'',
'switch ( $v(''P2_ENV_COLOUR'') ) {',
'  case "R" : banner_rgb = "148 15 15"; break;',
'  case "G" : banner_rgb = "48 112 16"; break;',
'  case "B" : banner_rgb = "46 89 127"; break;',
'  case "Y" : banner_rgb = "166 128 32"; break;',
'  case "O" : banner_rgb = "160 83 17"; break;',
'};',
'',
'if ( banner_rgb != ''X'' ) {',
'  $(''.t-Header-branding, .t-HeroRegion-icon '').css("background","linear-gradient(90deg, rgb("+banner_rgb+") 0%, rgb(25 28 30) 100%)");',
'}',
'',
'// for lower res / 4:3 display',
'if ( parseInt(window.screen.availWidth) <= 1280 ) {',
'$(document.querySelector("#R_USER_INFO > div.t-Region-bodyWrap > div.t-Region-body > div > div:nth-child(2) > div.col.col-3.apex-col-auto")).css("width","33%");    ',
'$(document.querySelector("#R_USER_INFO > div.t-Region-bodyWrap > div.t-Region-body > div > div:nth-child(2) > div.col.col-9.apex-col-auto")).css("width","67%");',
'}',
'',
'$(document.querySelector("#P2_LATEST_SQL_CONTAINER > div.t-Form-labelContainer")).css("height","9px");',
'$(document.querySelector("#P2_EXPLAIN_PLAN_CONTAINER > div.t-Form-labelContainer")).css("height","9px");',
'$(document.querySelector("#P2_SQL_MONITOR_CONTAINER > div.t-Form-labelContainer")).css("height","9px");',
'',
'$(document.querySelector("#R_LATEST_SQL > div > div.t-DialogRegion-bodyWrapperOut > div > div")).css("padding-bottom","0px");',
'',
'$(document.querySelector("#SQL_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-top","9px");',
'$(document.querySelector("#SQL_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-bottom","11px");',
'$(document.querySelector("#MON_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-top","9px");',
'$(document.querySelector("#MON_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-bottom","11px");',
'$(document.querySelector("#EXP_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-top","9px");',
'$(document.querySelector("#EXP_TAB > div.t-Region-bodyWrap > div.t-Region-body")).css("padding-bottom","11px");',
'',
'',
'if ( pgv_total_rows == 0 ) {',
'// necessary evil to call WNRI - but it clears out all the job fields nicely  ',
'   pgv_page_load = false;',
'   $.event.trigger("MAIN_WNRI");',
'}',
'',
'$(document.querySelector("#P2_EXE_JOB_RSA_CONTAINER")).attr(''title'',''If set, no child jobs will be launched on completion'');',
'',
'// these here to stop page load shimmy',
'hide("P2_SOURCE_TYPE_1");',
'hide("P2_SCHEDULE_TYPE_1");',
'hide("P2_PARENT_JOB_NAME");',
'',
'setTimeout(function(){ ',
'$("#JOB_DEPS_ig.a-IG.a-IG--noToolbar").css("height", "164px");',
'},1);',
''))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#PopupLov_2_DEP_JOB_PARAMS_OPERATOR_dlg .a-PopupLOV-searchBar {',
'    display :none;',
'}',
'',
'#PopupLov_2_DEP_JOB_PARAMS_OPERATOR_dlg .a-PopupLOV-results .a-TMV-w-scroll .a-GV-loadMore {',
'    display :none;',
'}',
'',
'#PopupLov_14_P14_SUB_VAR_dlg .a-PopupLOV-searchBar {display :none;}',
'#PopupLov_14_P14_SUB_VAR_dlg .a-PopupLOV-results .a-TMV-w-scroll .a-GV-loadMore {display :none;}',
'',
'#MAIN td {',
'    white-space: pre;',
'    height: 21px;  /* was 22 */',
'}',
'',
'#JOB_DEPS td {',
'    white-space: pre;',
'    height: 21px;',
'}',
'',
'#JOB_PARAMS td {',
'    white-space: pre;',
'    height: 21px;',
'}',
'',
'/* NOTE THE _IG SO JUST THE GRID GETS THIS EG FONT - YOU MAY HAVE BUTTON ETC THAT WANT BACK IN STANDARD FONT */',
'',
'#R_VIEW_SOURCE_ig td {',
'    white-space: pre;',
'    height: 21px;',
'    font-family: consolas;    ',
'    font-size: 1.1rem;',
'}',
'',
'#R_BG_PROCESS_HISTORY td {',
'    white-space: pre;',
'    height: 21px;',
'}',
'',
'#RUN_HISTORY td {',
'    white-space: pre;',
'    height: 21px;',
'}',
'',
'#PARALLEL_JOBS td {',
'    white-space: pre;',
'    height: 21px;',
'}',
'',
'#JOB_LOG_ig td {',
'    white-space: pre;',
'    height: 21px;',
'    font-family: consolas;    ',
'    font-size: 1.1rem;',
'}',
'',
'#JOB_LOG_FIND_RESULTS_ig td {',
'    white-space: pre;',
'    height: 21px;',
'    font-family: consolas;    ',
'    font-size: 1.1rem;',
'}',
'',
'/* make these fields look neater next to the toggle switches next to them */',
'#P2_SOURCE_FIND_CONTAINER .t-Form-inputContainer { padding-top: 2px; }',
'#P2_ACTION_USERNAME_CONTAINER .t-Form-inputContainer { padding-top: 2px; }',
'#P2_JRH_LOG_FIND_CONTAINER .t-Form-inputContainer { padding-top: 2px; }',
'',
'#P2_EXE_JOB_UOP_CONTAINER {height: 50px;}',
'#P2_EXE_JOB_RSA_CONTAINER {height: 50px;}',
'#P2_EXE_JOB_LATER_SWITCH_CONTAINER {height: 50px;}',
'',
'/* to center item LABEL */',
'',
'#P2_JPLR_STATUS_CONTAINER .t-Form-labelContainer {text-align: center; }',
'#P2_LGWR_STATUS_CONTAINER .t-Form-labelContainer {text-align: center; }',
'#P2_MSVR_STATUS_CONTAINER .t-Form-labelContainer {text-align: center; }',
'',
'#P2_JPLR_STATUS_CONTAINER .t-Form-inputContainer {padding-right: 0px; padding-left: 0px;}',
'#P2_LGWR_STATUS_CONTAINER .t-Form-inputContainer {padding-right: 0px; padding-left: 0px;}',
'#P2_MSVR_STATUS_CONTAINER .t-Form-inputContainer {padding-right: 0px; padding-left: 0px;}',
'',
'#P2_STATUS_SUMMARY_CONTAINER .t-Form-labelContainer {text-align: center;}',
'#P2_AVG_DURATION_CONTAINER .t-Form-labelContainer {text-align: center;}',
'',
'#P2_RUNTIME_WARNING_DISP_CONTAINER .t-Form-labelContainer {text-align: center;}',
'#P2_DISPLAY_NEXT_SUB_DTTM_CONTAINER .t-Form-labelContainer {text-align: center;}',
'#P2_JOB_CRON_STR_CONTAINER .t-Form-labelContainer {text-align: center;}',
'',
'#JOB_REGION .t-Region-body {padding-bottom: 2px;}',
'',
'#JOB_PARAMS_ig_grid_vc .a-GV-bdy .a-GV-w-scroll {overflow-x: hidden;}',
'',
'#P2_EXPORT_PROMPT_FOR_CONN_CONTAINER.t-Form-fieldContainer {margin-top: 0px!important;}',
'#P2_EXPORT_DEPENDENCIES_CONTAINER.t-Form-fieldContainer {margin-top: 1.6rem;}',
'#P2_EXPORT_CHILDREN_1_CONTAINER.t-Form-fieldContainer {margin-top: 11px!important;}',
'',
'/* remove the shaded blue cros that sometimes appears top right of parameter / dependencies tab */',
'#JP_JD_TABS > div > div.apex-rds-slider > div.apex-rds-hover.right > a { display: none;}',
''))
,p_page_template_options=>'#DEFAULT#'
,p_last_updated_by=>'CRON_DEV'
,p_last_upd_yyyymmddhh24miss=>'20250506155115'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(24338916738145573)
,p_plug_name=>'MAIN'
,p_region_name=>'MAIN'
,p_region_template_options=>'#DEFAULT#:margin-top-none:margin-bottom-sm'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select rownum rn',
',count(*) over () total_rows',
',JOB_ID',
',lpad(''>'',4*(j_level-1))||''  ''||job_name display_job_name',
',JOB_CRON_STR',
',SSH_CONN_STRING',
',SOURCE_NAME',
',SOURCE_DIR',
',DB_CONN_STRING',
',USERNAME',
',DISPLAY_EMAIL_LOG',
',EMAIL',
',EMAIL_ON_FAILURE',
unistr(',decode(EMAIL_ON_FAILURE_CC_OPS,''Y'',''\00FE'',''N'',''\00A8'') EMAIL_ON_FAILURE_CC_OPS'),
',SUB_DTTM',
',START_DTTM',
',END_DTTM',
',DURATION',
',STATUS',
unistr(',decode(RUN_STAND_ALONE,''Y'',''\00FE'',''\00A8'') RUN_STAND_ALONE'),
',OK_TO_CONTINUE',
unistr(',decode(USE_OVERRIDE_PARAMS,''Y'',''\00FE'',''\00A8'') USE_OVERRIDE_PARAMS'),
',ACTION_USERNAME',
',INFO',
',JOB_FREQUENCY',
',DOC_LINK',
',decode(schedule_type,''TIMED'',''T'',null) SCHEDULE_TYPE_CC',
',  case when sub_dttm is not null then ''E'' else ''D'' end                                -- RUN HISTORY',
'       ||case ',
'            when nvl(OK_TO_CONTINUE,''Y'') = ''Y'' then ',
'               ''E'' ',
'            else ',
'               ''D'' ',
'            end                                                                        -- EXE JOB',
'       ||case ',
'            when status in (''WAITING'',''SUSPENDED'') then ',
'               ''E'' ',
'         else ',
'            case ',
'               when status = ''PENDING'' and SUB_DTTM <= sysdate - 2/1440 then ',
'                  ''E'' ',
'               else ',
'                  ''D'' ',
'            end ',
'         end                                                                           -- CANCEL                 ',
'       ||case ',
'            when status = ''RUNNING'' then ',
'               ''K''',
'            when status = ''KILLING'' and info like ''%Oracle session marked for kill%'' and source_type_short in (''SPROC'',''SQL'') then',
'               case ',
'                  when sysdate >= to_date(substr(info,1,20),''DD-MON-YYYY HH24:MI:SS'') + 2/1440 then -- use initial time kill requested',
'                     ''F''',
'                  else',
'                     ''f''',
'               end',
'            else',
'               ''k''',
'         end                                                                           -- KILL K = kill enable | k = kill disable | F = force kill enable | f = force kill disable',
'       ||case ',
'            when status in (''RUNNING'',''WAITING'',''PENDING'',''SUSPENDED'',''KILLING'') then ',
'               ''D'' ',
'            else ',
'               ''E'' ',
'         end                                                                           -- OFFLINE',
'       ||''E''                                                                           -- EXPORT - set later by role privs',
'       ||''E''                                                                           -- AMEND  - set later by role privs',
'       ||case ',
'            when status in (''RUNNING'',''WAITING'',''PENDING'',''SUSPENDED'',''KILLING'') then ',
'               ''D'' ',
'            else ',
'               ''E'' ',
'         end                                                                           -- DELETE',
'       ||''E''                                                                           -- DEPENDENCIES - set later by role privs   ',
'       ||case when doc_link is not null then ''E'' else ''D'' end                          -- DOC LINK',
'       ||case when status = ''RUNNING'' then ''E'' else ''D'' end       button_states        -- LATEST_SQL',
' ,     case ',
'          when status = ''WAITING'' then',
'             ''O''',
'          when status = ''RUNNING'' then             ',
'             case',
'                when ssh_conn_string is not null or process < 0 then ',
'                   ''g''',
'                else',
'                   ''G''',
'             end',
'          when status = ''FAILED'' and ok_to_continue = ''N'' then',
'             ''R''',
'          when status in (''KILLING'',''KILLED'') and ok_to_continue = ''N'' then',
'             ''r''',
'          when status like ''%ERROR%'' and ok_to_continue = ''N'' then',
'             ''R''',
'          when status = ''CANCELLED'' and ok_to_continue = ''N'' then',
'             ''Y''',
'          when status = ''SUSPENDED'' then',
'             ''B''',
'          when status = ''PENDING'' then',
'             ''B''',
'          when next_sub_dttm >= to_date(''31-DEC-4712'',''DD-MON-YYYY'') then',
'             ''D''',
'       end               status_duration_cc         ',
'      ,case',
'          when nvl(runtime_warning_disp, ''99:99:99:99'') < duration then',
'             ''r''',
'          when status = ''SUSPENDED'' then',
'             ''B''             ',
'       end duration_cc',
'from   job_v',
'where nvl(status,''NULL'')     = nvl(:P2_MAIN_STATUS_FILTER,nvl(status,''NULL''))',
'and   job_frequency          = nvl(:P2_MAIN_JOB_FREQUENCY_FILTER,job_frequency)',
'and   upper(job_name)        like ''%''||upper(:P2_MAIN_JOB_NAME_FILTER)||''%''',
'and   nvl(today_only,''NULL'') = case when :P2_MAIN_TODAY_ONLY_FILTER = ''Y'' then ''Y'' else nvl(today_only,''NULL'') end',
'and   schedule_type          = case when :P2_MAIN_TIMED_ONLY_FILTER = ''Y'' then ''TIMED'' else schedule_type end',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_MAIN_STATUS_FILTER,P2_MAIN_JOB_FREQUENCY_FILTER,P2_MAIN_JOB_NAME_FILTER,P2_MAIN_TODAY_ONLY_FILTER,P2_MAIN_TIMED_ONLY_FILTER'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24635625411189397)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Job Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_static_id=>'MAIN_JOB_ID'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24636054180189401)
,p_name=>'DISPLAY_JOB_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_JOB_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Job Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'MAIN_DISPLAY_JOB_NAME'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664160669193370)
,p_name=>'SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Sub Dttm'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>330
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664251803193371)
,p_name=>'START_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'START_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Start Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664350580193372)
,p_name=>'END_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'END_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'End Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664442047193373)
,p_name=>'DURATION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DURATION'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Duration'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>70
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>15
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664608263193374)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Status'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>40
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>30
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'MAIN_STATUS'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664661911193375)
,p_name=>'RUN_STAND_ALONE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'RUN_STAND_ALONE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'RSA'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>90
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664747981193376)
,p_name=>'OK_TO_CONTINUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'OK_TO_CONTINUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Ok To Continue'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>340
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664846271193377)
,p_name=>'USE_OVERRIDE_PARAMS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USE_OVERRIDE_PARAMS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'UOP'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>100
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24664989750193378)
,p_name=>'ACTION_USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ACTION_USERNAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Action Username'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>350
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>128
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24665065453193379)
,p_name=>'INFO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'INFO'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Info'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>360
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>2000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24665306056193381)
,p_name=>'JOB_FREQUENCY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_FREQUENCY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Frequency'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>80
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>11
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'MAIN_JOB_FREQUENCY'
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24665926082193388)
,p_name=>'RN'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'RN'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Rn'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>380
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(24666044808193389)
,p_name=>'TOTAL_ROWS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOTAL_ROWS'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Total Rows'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>390
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25309123359080490)
,p_name=>'DOC_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DOC_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Doc Link'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>430
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>500
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25310117593080499)
,p_name=>'BUTTON_STATES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'BUTTON_STATES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Button States'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>440
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>11
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(26443113754205663)
,p_name=>'STATUS_DURATION_CC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS_DURATION_CC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Status Duration Cc'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>450
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38899640750291005)
,p_name=>'JOB_CRON_STR'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_CRON_STR'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Job Cron Str'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>600
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>200
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38899799243291006)
,p_name=>'SSH_CONN_STRING'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SSH_CONN_STRING'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Ssh Conn String'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>610
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38899863155291007)
,p_name=>'SOURCE_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SOURCE_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Source Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>620
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38899979890291008)
,p_name=>'SOURCE_DIR'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SOURCE_DIR'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Source Dir'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>630
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38900099952291009)
,p_name=>'DB_CONN_STRING'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DB_CONN_STRING'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Db Conn String'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>640
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>150
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(38900175689291010)
,p_name=>'USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USERNAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Username'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>650
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>128
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39098467636667861)
,p_name=>'DISPLAY_EMAIL_LOG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_EMAIL_LOG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Display Email Log'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>660
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>7
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39098557526667862)
,p_name=>'EMAIL'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EMAIL'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Email'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>670
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>500
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39098655591667863)
,p_name=>'EMAIL_ON_FAILURE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EMAIL_ON_FAILURE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Email On Failure'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>680
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>500
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39098792520667864)
,p_name=>'EMAIL_ON_FAILURE_CC_OPS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EMAIL_ON_FAILURE_CC_OPS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Email On Failure Cc Ops'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>690
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39099215627667868)
,p_name=>'DURATION_CC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DURATION_CC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Duration Cc'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>710
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39099434033667871)
,p_name=>'SCHEDULE_TYPE_CC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SCHEDULE_TYPE_CC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Schedule Type Cc'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>720
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(24635592142189396)
,p_internal_uid=>2561971649587836
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>393
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(config) {',
'    config.defaultGridViewOptions   = {footer: false,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'                var text = null;',
'                pgv_main_over_header = false;',
'                    if ( columnDef != null ) {',
'                       pgv_main_grid_col = columnDef.property;',
'                       if ( recordMeta == null ) {  // over the header',
'                           pgv_main_over_header = true;',
'                           if ( columnDef.property == "DISPLAY_JOB_NAME" ) {',
'                              if ( $v(''P2_MAIN_JOB_NAME_FILTER'') == '''' && $v(''P2_MAIN_TIMED_ONLY_FILTER'') == ''N'' && $v(''P2_MAIN_TODAY_ONLY_FILTER'') == ''N'' ) {',
'                                 text = ''Ctrl + double click a job name for filter options'';',
'                                 pgv_main_filter_trg_action = null;',
'                              }',
'                              else',
'                              {',
'                                 text = pgv_dctcf;',
'                                 pgv_main_filter_trg_action = ''CF'';',
'                              }',
'                           }',
'                           else if ( [''STATUS'',''JOB_FREQUENCY''].includes( columnDef.property ) ) {',
'                              if ( $v(''P2_MAIN_''+pgv_main_grid_col+''_FILTER'') == '''' ) {',
'                                 text = ''Ctrl + double click a value to filter''; ',
'                                 pgv_main_filter_trg_action = null;                                  ',
'                              }',
'                              else',
'                              {',
'                                 text = pgv_dctcf;',
'                                 pgv_main_filter_trg_action = ''CF'';                                  ',
'                              }',
'                           }',
'                           else if ( columnDef.property == "RUN_STAND_ALONE" ) {',
'                              text = ''Run Stand Alone''; ',
'                           }',
'                           else if ( columnDef.property == "USE_OVERRIDE_PARAMS" ) {',
'                              text = ''Use Override Parameters''; ',
'                           }',
'                       }',
'                       else // over a record',
'                       { ',
'                           if ( columnDef.property == "DISPLAY_JOB_NAME" ) {',
'                              if ( $v(''P2_MAIN_JOB_NAME_FILTER'') == '''' && $v(''P2_MAIN_TIMED_ONLY_FILTER'') == ''N'' && $v(''P2_MAIN_TODAY_ONLY_FILTER'') == ''N'' ) {',
'                                 pgv_main_filter_trg_action = ''F'';',
'                              }',
'                              else',
'                              {',
'                                 //pgv_main_filter_trg_action = null;',
'                                  pgv_main_filter_trg_action = ''F'';',
'                              }',
'                           }',
'                           else if ( [''STATUS'',''JOB_FREQUENCY''].includes( columnDef.property ) ) {',
'                              if ( $v(''P2_MAIN_''+pgv_main_grid_col+''_FILTER'') == '''' ) {',
'                                 pgv_main_filter_trg_action = ''F''',
'                              }',
'                              else',
'                              {',
'                                 pgv_main_filter_trg_action = null; ',
'                              }',
'                           }',
'                       }',
'                    }',
'                return text;',
'            }',
'        }',
'    };',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;',
' //   apex.util.getNestedObject(config, "views.grid.features").highlight = false;    ',
'    return config;',
'}'))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(39381524454723004)
,p_interactive_grid_id=>wwv_flow_api.id(24635592142189396)
,p_name=>'Main View'
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_rows_per_page=>100
,p_show_row_number=>false
,p_settings_area_expanded=>false
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(39381565509723004)
,p_report_id=>wwv_flow_api.id(39381524454723004)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(22076254896639342)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>28
,p_column_id=>wwv_flow_api.id(39099215627667868)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25406652485709413)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>15
,p_column_id=>wwv_flow_api.id(25309123359080490)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25434433994553798)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>16
,p_column_id=>wwv_flow_api.id(25310117593080499)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(26467601715958293)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>17
,p_column_id=>wwv_flow_api.id(26443113754205663)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(31642134049845062)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>13
,p_column_id=>wwv_flow_api.id(24665926082193388)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(31642687340845070)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>14
,p_column_id=>wwv_flow_api.id(24666044808193389)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39105437689669838)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>18
,p_column_id=>wwv_flow_api.id(38899640750291005)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39106012009669843)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>19
,p_column_id=>wwv_flow_api.id(38899799243291006)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39106462901669847)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>20
,p_column_id=>wwv_flow_api.id(38899863155291007)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39106955957669851)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>21
,p_column_id=>wwv_flow_api.id(38899979890291008)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39107442925669855)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>22
,p_column_id=>wwv_flow_api.id(38900099952291009)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39107961491669859)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>23
,p_column_id=>wwv_flow_api.id(38900175689291010)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39108500602669864)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>24
,p_column_id=>wwv_flow_api.id(39098467636667861)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39108999727669868)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>25
,p_column_id=>wwv_flow_api.id(39098557526667862)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39109461502669872)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>26
,p_column_id=>wwv_flow_api.id(39098655591667863)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39110014293669876)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>27
,p_column_id=>wwv_flow_api.id(39098792520667864)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39146180283850733)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>29
,p_column_id=>wwv_flow_api.id(39099434033667871)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39382061321723007)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>8
,p_column_id=>wwv_flow_api.id(24635625411189397)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39384086120723020)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(24636054180189401)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>450
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39393514353723087)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>9
,p_column_id=>wwv_flow_api.id(24664160669193370)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39393972841723091)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(24664251803193371)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>146
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39394545052723095)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(24664350580193372)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>149
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39395006370723098)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(24664442047193373)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>85
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39395535435723102)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>83
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39396003794723105)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(24664661911193375)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>40
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39396490727723109)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>10
,p_column_id=>wwv_flow_api.id(24664747981193376)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39396972668723112)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(24664846271193377)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>51
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39397489216723115)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>11
,p_column_id=>wwv_flow_api.id(24664989750193378)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39397987933723119)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>12
,p_column_id=>wwv_flow_api.id(24665065453193379)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39399012325723125)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(24665306056193381)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>93
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073710140725171)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>7.5
,p_name=>'DEAD_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#000000'
,p_text_color=>'#FFFFFF'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'D'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073733158620221)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>23.896484375
,p_name=>'CHILD'
,p_column_id=>wwv_flow_api.id(24636054180189401)
,p_background_color=>'#222629'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(39099434033667871)
,p_condition_operator=>'N'
,p_condition_is_case_sensitive=>false
,p_is_enabled=>true
);
end;
/
begin
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073753096601563)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>24.84375
,p_name=>'DEFAULT_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_text_color=>'#FFFFFF'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'N'
,p_condition_is_case_sensitive=>true
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073857201664130)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>22.94921875
,p_name=>'PARENT'
,p_column_id=>wwv_flow_api.id(24636054180189401)
,p_background_color=>'#1B1F22'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(39099434033667871)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>false
,p_condition_expression=>'T'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073859207725171)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>8.75
,p_name=>'WAITING_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#FFBF00'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'O'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22073987952837942)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>8.125
,p_name=>'KILLING_KILLED_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#712727'
,p_text_color=>'#FFFFFF'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'r'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22074098725837943)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>8.4375
,p_name=>'PENDING_SUSPENDED_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#80C0FF'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'B'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22074298389837943)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>8.671875
,p_name=>'CANCELLED_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#E0BE00'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'Y'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22074328756837943)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>9.375
,p_name=>'RUNNING_REMOTE_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#8FBF60'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'g'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22074457410837943)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>9.6875
,p_name=>'RUNNING_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#55A033'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'G'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22076872135679330)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>29.84375
,p_name=>'DEFAULT_DURATION'
,p_column_id=>wwv_flow_api.id(24664442047193373)
,p_text_color=>'#FFFFFF'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(39099215627667868)
,p_condition_operator=>'N'
,p_condition_is_case_sensitive=>false
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22076982489691683)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>17.265625
,p_name=>'SUSPENDED_DURATION'
,p_column_id=>wwv_flow_api.id(24664442047193373)
,p_background_color=>'#80C0FF'
,p_text_color=>'#000000'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(39099215627667868)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>false
,p_condition_expression=>'B'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(22077141269707333)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>21.0546875
,p_name=>'RUNTIME_WARNING_DURATION'
,p_column_id=>wwv_flow_api.id(24664442047193373)
,p_background_color=>'#712827'
,p_text_color=>'#FFFFFF'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(39099215627667868)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>false
,p_condition_expression=>'r'
,p_is_enabled=>true
);
wwv_flow_api.create_ig_report_highlight(
 p_id=>wwv_flow_api.id(34140147543955977)
,p_view_id=>wwv_flow_api.id(39381565509723004)
,p_execution_seq=>5
,p_name=>'FAILED_STATUS'
,p_column_id=>wwv_flow_api.id(24664608263193374)
,p_background_color=>'#C00000'
,p_text_color=>'#E0BE00'
,p_condition_type=>'COLUMN'
,p_condition_column_id=>wwv_flow_api.id(26443113754205663)
,p_condition_operator=>'EQ'
,p_condition_is_case_sensitive=>true
,p_condition_expression=>'R'
,p_is_enabled=>true
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25268173704880080)
,p_plug_name=>'JOB'
,p_region_name=>'JOB_REGION'
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25489632318463193)
,p_plug_name=>'Buttons'
,p_parent_plug_id=>wwv_flow_api.id(25268173704880080)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:t-Form--noPadding:margin-top-none:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_grid_column_span=>1
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36288291192693682)
,p_plug_name=>'JOB_SUB'
,p_parent_plug_id=>wwv_flow_api.id(25268173704880080)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>20
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25488163039463178)
,p_plug_name=>'Tabs'
,p_region_name=>'JP_JD_TABS'
,p_parent_plug_id=>wwv_flow_api.id(36288291192693682)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple:t-Form--noPadding:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>70
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25310274810080501)
,p_plug_name=>'Online Job Dependencies'
,p_region_name=>'JOB_DEPS'
,p_parent_plug_id=>wwv_flow_api.id(25488163039463178)
,p_region_template_options=>'#DEFAULT#:t-IRR-region--noBorders:margin-top-none:margin-bottom-none'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from ',
'job_dependencies_v',
'where job_id = :P2_JOB_ID',
'and job_online = ''Y'''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25310482490080503)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Job Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>10
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25310620075080504)
,p_name=>'DEPENDENT_JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPENDENT_JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Dependent Job Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25310665740080505)
,p_name=>'JOB_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Job Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25310797217080506)
,p_name=>'JOB_ONLINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ONLINE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Job Online'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(25310325868080502)
,p_internal_uid=>3236705375478942
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>true
,p_define_chart_view=>true
,p_enable_download=>true
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>1
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function ig_att (config) {',
'    config.defaultGridViewOptions   = {footer: false,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'                var text = null;',
'                    if ( columnDef != null ) {',
'                       if ( recordMeta == null ) {  // over the header',
'                           null;',
'                       }',
'                       else // over a record',
'                       { ',
'                           if ( [''JOB_NAME''].includes( columnDef.property ) ) {',
'                              text = ''Double click to go to dependent job''; ',
'                           }',
'                       }',
'                    }',
'                return text;',
'            }',
'        }',
'    };',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;   // hide highlighting options',
'    return config;',
'}',
''))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(25492419862475644)
,p_interactive_grid_id=>wwv_flow_api.id(25310325868080502)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(25492485864475644)
,p_report_id=>wwv_flow_api.id(25492419862475644)
,p_view_type=>'GRID'
,p_stretch_columns=>false
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25493608001475651)
,p_view_id=>wwv_flow_api.id(25492485864475644)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(25310482490080503)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25494025193475657)
,p_view_id=>wwv_flow_api.id(25492485864475644)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(25310620075080504)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25494612181475660)
,p_view_id=>wwv_flow_api.id(25492485864475644)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(25310665740080505)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>325
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25495025501475663)
,p_view_id=>wwv_flow_api.id(25492485864475644)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(25310797217080506)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25487104064463167)
,p_plug_name=>'Job Run Parameters'
,p_region_name=>'JOB_PARAMS'
,p_parent_plug_id=>wwv_flow_api.id(25488163039463178)
,p_region_template_options=>'#DEFAULT#:t-IRR-region--noBorders:margin-top-none:margin-bottom-none'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /*+ index_asc (job_param_history_v.jph pk_jparamhist) */ job_id, sub_dttm,',
'name, display_param_value,',
unistr('decode(passed_to_job,''Y'',''\00FE'',''N'',''\00A8'') passed_to_job,'),
'param_id,',
'param_order,',
'param_value',
'from ',
'job_param_history_v',
'where job_id = :P2_JOB_ID',
'and sub_dttm = to_date(:P2_SUB_DTTM,''DD-MON-YYYY HH24:MI:SS'')',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_SUB_DTTM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487237871463169)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Job Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487398015463170)
,p_name=>'SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Sub Dttm'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>30
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487498539463171)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Parameter Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487541083463172)
,p_name=>'DISPLAY_PARAM_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_PARAM_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Parameter Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487708438463173)
,p_name=>'PASSED_TO_JOB'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PASSED_TO_JOB'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Passed To Job'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487816547463174)
,p_name=>'PARAM_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>70
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487823259463175)
,p_name=>'PARAM_ORDER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ORDER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Order'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(25487955586463176)
,p_name=>'PARAM_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Param Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(39395769913849792)
,p_name=>'EDIT'
,p_source_type=>'NONE'
,p_item_type=>'NATIVE_LINK'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>10
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.:RP:P7_PARAM_ID:&PARAM_ID.'
,p_link_text=>'<span class="fa fa-edit" aria-hidden="true"></span>'
,p_use_as_row_header=>false
,p_enable_hide=>false
,p_escape_on_http_output=>true
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(25487194401463168)
,p_internal_uid=>3413573908861608
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>true
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>162
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function ig_att (config) {',
'    config.defaultGridViewOptions   = {footer: false,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'                var text = null;',
'                    if ( columnDef != null ) {',
'                       if ( recordMeta == null ) {  // over the header',
'                           null;',
'                       }',
'                       else // over a record',
'                       { ',
'                           if ( [''EDIT''].includes( columnDef.property ) ) {',
'                              text = ''Edit''; ',
'                           }',
'                       }',
'                    }',
'                return text;',
'            }',
'        }',
'    };',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;   // hide highlighting options',
'    return config;',
'}',
''))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(25505674199985059)
,p_interactive_grid_id=>wwv_flow_api.id(25487194401463168)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(25505789050985059)
,p_report_id=>wwv_flow_api.id(25505674199985059)
,p_view_type=>'GRID'
,p_stretch_columns=>false
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25506261899985061)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(25487237871463169)
,p_is_visible=>false
,p_is_frozen=>true
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25506782226985063)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(25487398015463170)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25507271211985066)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(25487498539463171)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>228.95100000000002
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25507723180985070)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(25487541083463172)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>201.978
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25508235452985072)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(25487708438463173)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>90.987
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25508769008985075)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(25487816547463174)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25509244665985077)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(25487823259463175)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(25509780865985080)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>8
,p_column_id=>wwv_flow_api.id(25487955586463176)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(39886428209786979)
,p_view_id=>wwv_flow_api.id(25505789050985059)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(39395769913849792)
,p_is_visible=>true
,p_is_frozen=>true
,p_width=>40
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25488543141463182)
,p_plug_name=>'User Info'
,p_region_name=>'R_USER_INFO'
,p_parent_plug_id=>wwv_flow_api.id(36288291192693682)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:t-Form--noPadding:margin-top-none:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>2
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25488707120463183)
,p_plug_name=>'Job Details'
,p_parent_plug_id=>wwv_flow_api.id(36288291192693682)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:t-Form--noPadding:margin-top-none:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25488925515463186)
,p_plug_name=>'Job Description'
,p_parent_plug_id=>wwv_flow_api.id(36288291192693682)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:t-Form--noPadding:margin-top-none:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>60
,p_plug_grid_column_span=>5
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25490984889463206)
,p_plug_name=>'Operator Save Options'
,p_region_name=>'R_OP_SAVE_OPTIONS'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>129
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(25795412944096086)
,p_plug_name=>'HEADER'
,p_region_name=>'main_menu'
,p_region_template_options=>'#DEFAULT#:margin-top-none'
,p_component_template_options=>'#DEFAULT#:js-addActions'
,p_plug_template=>wwv_flow_api.id(24208351153741927)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'BODY'
,p_list_id=>wwv_flow_api.id(32851726542400017)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_api.id(24292897218742246)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(26444010280205672)
,p_plug_name=>'VIEW_SOURCE'
,p_region_name=>'R_VIEW_SOURCE'
,p_region_css_classes=>'js-dialog-size1260x645'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size720x480'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>119
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select text, rownum line, goto_line',
'from table(internal.view_source(p_job_id     => :P2_VIEW_SOURCE_JOB_ID,',
'                                src_dir      => :P2_VIEW_SOURCE_DIR,',
'                                src_filename => :P2_VIEW_SOURCE_NAME));'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_VIEW_SOURCE_JOB_ID, P2_VIEW_SOURCE_DIR, P2_VIEW_SOURCE_NAME'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(26446339884205696)
,p_name=>'TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TEXT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Text'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_static_id=>'VIEW_SOURCE_TEXT'
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(26805873918463861)
,p_name=>'LINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LINE'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Line'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>50
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30313817203535239)
,p_name=>'GOTO_LINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'GOTO_LINE'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Goto Line'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>70
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(26444022992205673)
,p_internal_uid=>4370402499604113
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>496
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function ig_att2 (config) {',
'',
'    config.defaultGridViewOptions   = {footer: false,',
'        persistSelection: true,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'               if ( columnDef != null ) {',
'                  global_current_ig_col = columnDef.property;',
'               }',
'            }',
'        }',
'    };',
'',
'    config.defaultModelOptions = {',
'        pageSize: 2000',
'    };',
'    ',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;   // hide highlighting options',
'    return config;',
'}',
''))
);
end;
/
begin
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(26502482955668953)
,p_interactive_grid_id=>wwv_flow_api.id(26444022992205673)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(26502552049668955)
,p_report_id=>wwv_flow_api.id(26502482955668953)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(26690710583836794)
,p_view_id=>wwv_flow_api.id(26502552049668955)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(26446339884205696)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(26811858776467981)
,p_view_id=>wwv_flow_api.id(26502552049668955)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(26805873918463861)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(33556832155982402)
,p_view_id=>wwv_flow_api.id(26502552049668955)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(30313817203535239)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27008022424306694)
,p_plug_name=>'Find'
,p_parent_plug_id=>wwv_flow_api.id(26444010280205672)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:margin-top-md:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(26810795834463910)
,p_plug_name=>'MAIN_FILTERS'
,p_region_name=>'R_MAIN_FILTERS'
,p_region_css_classes=>'js-dialog-size450x285'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>59
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27009638849306710)
,p_plug_name=>'BG_PROCESS_HISTORY'
,p_region_name=>'R_BG_PROCESS_HISTORY'
,p_region_css_classes=>'js-dialog-size1250x495'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>49
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char(action_dttm,''YYYYMMDDHH24MISS'')||''.''||to_char(command_order,''FM00'') sorter, action_dttm, status,',
'--       info, ',
'       case when ',
'              process = ''JPLR'' and',
'              status = ''RUNNING'' and',
'              row_number() over (partition by process order by to_char(action_dttm,''YYYYMMDDHH24MISS'')||''.''||to_char(command_order,''FM00'') desc) = 1 then',
'          (select client_info from gv$session where module = ''Cronology Job Poller'' and rownum < 2)',
'       else',
'          info',
'       end info,',
'       username',
'from   bg_process_history',
'where  process = :P2_BP_ABB_HISTORY'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_BP_ABB_HISTORY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27211264740614263)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27211381833614264)
,p_name=>'INFO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'INFO'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Information'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>500
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27211487970614265)
,p_name=>'USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USERNAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'User'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>128
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27212271954614273)
,p_name=>'ACTION_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ACTION_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Timestamp'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'ig_column_hdr',
''))
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27212638449614277)
,p_name=>'SORTER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SORTER'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Sorter'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>10
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>18
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(27211039281614261)
,p_internal_uid=>5137418789012701
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>410
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(27217010411648627)
,p_interactive_grid_id=>wwv_flow_api.id(27211039281614261)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(27217114967648627)
,p_report_id=>wwv_flow_api.id(27217010411648627)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(22074634137698186)
,p_view_id=>wwv_flow_api.id(27217114967648627)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(27212638449614277)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'DESC'
,p_sort_nulls=>'FIRST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(22075172362624004)
,p_view_id=>wwv_flow_api.id(27217114967648627)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(27212271954614273)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>174
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27218023571648632)
,p_view_id=>wwv_flow_api.id(27217114967648627)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(27211264740614263)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>295
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27218602195648635)
,p_view_id=>wwv_flow_api.id(27217114967648627)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(27211381833614264)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>549
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27219053885648638)
,p_view_id=>wwv_flow_api.id(27217114967648627)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(27211487970614265)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27212998660614280)
,p_plug_name=>'&P2_DOWNLOAD_FILENAME.'
,p_region_name=>'RUN_HISTORY'
,p_region_css_classes=>'js-dialog-size1280x643'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400:margin-bottom-none'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>139
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /*+ index_desc (job_run_history pk_jrunhist) */',
'job_id, ',
'sub_dttm display_sub_dttm,',
'sub_dttm, ',
'start_dttm, ',
'end_dttm, ',
'status, ',
'duration, ',
unistr('decode(run_stand_alone,''Y'',''\00FE'',''N'',''\00A8'') run_stand_alone,'),
unistr('decode(use_override_params,''Y'',''\00FE'',''N'',''\00A8'') use_override_params,'),
'action_username, ',
'replace(info ,chr(10),'' | '') info,',
'run_by',
'from job_run_history',
'where job_id = :P2_JOB_ID',
'and nvl(status,''NULL'')     = nvl(:P2_JRH_STATUS_FILTER,nvl(status,''NULL''))',
'--and   (action_username is not null or nvl(action_username,''N'') = :P2_JRH_ACTION_USERNAME_FILTER)'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_JRH_STATUS_FILTER'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213141683614282)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Status'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>40
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>30
,p_enable_filter=>false
,p_static_id=>'RUN_HISTORY_STATUS'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213310785614283)
,p_name=>'INFO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'INFO'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Status Information'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213623246614287)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Job Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213798187614288)
,p_name=>'SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Submit Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>10
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_format_mask=>'YYYYMMDDHH24MISS'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213883525614289)
,p_name=>'START_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'START_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Start Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27213957061614290)
,p_name=>'END_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'END_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'End Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>30
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27214076993614291)
,p_name=>'DURATION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DURATION'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Duration'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>15
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27214219505614292)
,p_name=>'RUN_STAND_ALONE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'RUN_STAND_ALONE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'RSA'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27214264791614293)
,p_name=>'USE_OVERRIDE_PARAMS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USE_OVERRIDE_PARAMS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'UOP'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>80
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27214418116614294)
,p_name=>'ACTION_USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ACTION_USERNAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Actioned By'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>110
,p_value_alignment=>'CENTER'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>128
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'RUN_HISTORY_ACTION_USERNAME'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27214511960614295)
,p_name=>'RUN_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'RUN_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Run By'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>90
,p_value_alignment=>'CENTER'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>128
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27546763713697689)
,p_name=>'DISPLAY_SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Submit Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>130
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(27213101125614281)
,p_internal_uid=>5139480633012721
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>true
,p_download_filename=>'&P2_DOWNLOAD_FILENAME.'
,p_enable_mail_download=>false
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>370
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(config) {',
'    ',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar(),',
'        toolbarGroup = toolbarData[toolbarData.length - 1]; // this is the last group with reset button',
'',
'    toolbarGroup.controls.push( {',
'        type: "BUTTON",',
'        action: "show-download-dialog",',
'        label: "Download",        ',
'        iconBeforeLabel: true',
'    });',
'    config.toolbarData = toolbarData;',
'    ',
'    ',
'    config.initActions = function( actions ) {  ',
'        jrh_ig_actions=actions;  ',
'    };     ',
'    ',
'    config.defaultGridViewOptions   = {footer: false,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'                var text = null;',
'                    if ( columnDef != null ) {',
'                       pgv_jrh_grid_col = columnDef.property;',
'                       if ( recordMeta == null ) {  // over the header',
'                           if ( [''STATUS''].includes( columnDef.property ) ) {',
'                              if ( $v(''P2_JRH_''+pgv_jrh_grid_col+''_FILTER'') == '''' ) {',
'                                 text = ''Ctrl + double click a value to filter''; ',
'                                 pgv_jrh_filter_trg_action = null;                                  ',
'                              }',
'                              else',
'                              {',
'                                 text = pgv_dctcf;',
'                                 pgv_jrh_filter_trg_action = ''CF'';                                  ',
'                              }',
'                           }',
'                           else if ( columnDef.property == "RUN_STAND_ALONE" ) {',
'                              text = ''Run Stand Alone''; ',
'                           }',
'                           else if ( columnDef.property == "USE_OVERRIDE_PARAMS" ) {',
'                              text = ''Use Override Parameters''; ',
'                           }',
'                           else if ( [''INFO''].includes( columnDef.property ) ) {',
'                              text = ''Ctrl + double click a value for full information''; ',
'                           }',
'                       }',
'                       else // over a record',
'                       { ',
'                           if ( [''STATUS''].includes( columnDef.property ) ) {',
'                              if ( $v(''P2_JRH_''+pgv_jrh_grid_col+''_FILTER'') == '''' ) {',
'                                 pgv_jrh_filter_trg_action = ''F''',
'                              }',
'                              else',
'                              {',
'                                 pgv_jrh_filter_trg_action = null; ',
'                              }',
'                           }',
'                       }',
'                    }',
'                return text;',
'            }',
'        }',
'    };',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;',
'    return config;',
'}',
''))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(27278639429267364)
,p_interactive_grid_id=>wwv_flow_api.id(27213101125614281)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(27278745594267364)
,p_report_id=>wwv_flow_api.id(27278639429267364)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27279273961267367)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(27213141683614282)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>86
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27279767433267369)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>9
,p_column_id=>wwv_flow_api.id(27213310785614283)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>207
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27290527958566293)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>10
,p_column_id=>wwv_flow_api.id(27213623246614287)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27291054465566299)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(27213798187614288)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>145
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27291595701566302)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(27213883525614289)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>141
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27292065597566305)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(27213957061614290)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>140
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27292569505566308)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(27214076993614291)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>78
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27293102993566311)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(27214219505614292)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>40
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27293542954566314)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(27214264791614293)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>40
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27294047344566317)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>12
,p_column_id=>wwv_flow_api.id(27214418116614294)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>40
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27294589338566319)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>11
,p_column_id=>wwv_flow_api.id(27214511960614295)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>139
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27794889931672369)
,p_view_id=>wwv_flow_api.id(27278745594267364)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(27546763713697689)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>142
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27215106100614301)
,p_plug_name=>'JRH_ACTIONS'
,p_parent_plug_id=>wwv_flow_api.id(27212998660614280)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:t-Form--noPadding:margin-top-lg:margin-bottom-none:margin-left-none:margin-right-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>30
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36545006126265907)
,p_plug_name=>'JRP'
,p_parent_plug_id=>wwv_flow_api.id(27212998660614280)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28092759999784567)
,p_plug_name=>'Job Run Parameters'
,p_region_name=>'JRH_JOB_PARAMS'
,p_parent_plug_id=>wwv_flow_api.id(36545006126265907)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--hiddenOverflow:margin-bottom-none'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /*+ index_asc (job_param_history_v.jph pk_jparamhist) */ ',
'       JOB_ID,',
'       SUB_DTTM,',
'       PARAM_ID,',
'       NAME,',
'       PARAM_ORDER,',
'       PARAM_VALUE,',
unistr('       decode(passed_to_job,''Y'',''\00FE'',''N'',''\00A8'') passed_to_job,'),
'       DISPLAY_PARAM_VALUE',
'from ',
'job_param_history_v',
'where job_id = :P2_JOB_ID',
'and sub_dttm = to_date(:P2_JRH_SUB_DTTM,''YYYYMMDDHH24MISS'')',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_JRH_SUB_DTTM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28092968356784569)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>10
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28093105931784570)
,p_name=>'SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>20
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_format_mask=>'YYYYMMDDHH24MISS'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28093169122784571)
,p_name=>'PARAM_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>30
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28093228326784572)
,p_name=>'PARAM_ORDER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ORDER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Order'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>40
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28093379928784573)
,p_name=>'PARAM_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Param Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28093428599784574)
,p_name=>'PASSED_TO_JOB'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PASSED_TO_JOB'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Passed To Job'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28183813985451686)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28183831652451687)
,p_name=>'DISPLAY_PARAM_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_PARAM_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(28092838800784568)
,p_internal_uid=>6019218308183008
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>139
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(28156771027317595)
,p_interactive_grid_id=>wwv_flow_api.id(28092838800784568)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(28156898525317597)
,p_report_id=>wwv_flow_api.id(28156771027317595)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(22074726276787691)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(28183813985451686)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>279
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(22075398909787699)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(28183831652451687)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>217
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28157326027317606)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(28092968356784569)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28157869115317614)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(28093105931784570)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28158377580317618)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(28093169122784571)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28158814075317621)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(28093228326784572)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28159276770317623)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(28093379928784573)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28159763308317626)
,p_view_id=>wwv_flow_api.id(28156898525317597)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(28093428599784574)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>89
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(27829790763847900)
,p_plug_name=>'&P2_DOWNLOAD_FILENAME.'
,p_region_name=>'JOB_LOG'
,p_region_css_classes=>'js-dialog-size1260x645'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>159
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select line_no, line, count(*) over () total_lines',
'from   job_logs',
'where  job_id = :P2_JOB_ID',
'and    sub_dttm = to_date(:P2_JRH_SUB_DTTM,''YYYYMMDDHH24MISS'')'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_JRH_SUB_DTTM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27830123380847904)
,p_name=>'LINE_NO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LINE_NO'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Line No'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>30
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>false
,p_enable_hide=>false
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27830312178847905)
,p_name=>'LINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LINE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Line'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1000
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'JOB_LOG_LINE'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(27921955051356463)
,p_name=>'TOTAL_LINES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TOTAL_LINES'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Total Lines'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>50
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(27829838358847901)
,p_internal_uid=>5756217866246341
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>true
,p_download_filename=>'&P2_DOWNLOAD_FILENAME.'
,p_enable_mail_download=>false
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>496
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(config) { ',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar(),',
'        toolbarGroup = toolbarData[toolbarData.length - 1]; // this is the last group with reset button',
'',
'    toolbarGroup.controls.push( {',
'        type: "BUTTON",',
'        action: "show-download-dialog",',
'        label: "Download",        ',
'        iconBeforeLabel: true',
'    });',
'    config.toolbarData = toolbarData;',
'    ',
'    ',
'    config.initActions = function( actions ) {  ',
'        job_log_ig_actions=actions;  ',
'    };     ',
'    ',
'    config.defaultGridViewOptions   = {footer: false};',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;',
'',
'    return config;',
'}',
'',
''))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(27906573560246887)
,p_interactive_grid_id=>wwv_flow_api.id(27829838358847901)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(27906651842246888)
,p_report_id=>wwv_flow_api.id(27906573560246887)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27907146249246893)
,p_view_id=>wwv_flow_api.id(27906651842246888)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(27830123380847904)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27907688932246897)
,p_view_id=>wwv_flow_api.id(27906651842246888)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(27830312178847905)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(27938776089452199)
,p_view_id=>wwv_flow_api.id(27906651842246888)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(27921955051356463)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28355542760232310)
,p_plug_name=>'Find'
,p_parent_plug_id=>wwv_flow_api.id(27829790763847900)
,p_region_template_options=>'#DEFAULT#:t-Region--noPadding:t-Region--removeHeader:t-Region--noBorder:t-Region--scrollBody:margin-top-md:margin-bottom-none'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28185232087451701)
,p_plug_name=>'JOB_LOG_FIND_RESULTS'
,p_region_name=>'JOB_LOG_FIND_RESULTS'
,p_region_css_classes=>'js-dialog-size1260x645'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>149
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select b.start_dttm,',
'       a.line_no,',
'       a.line,',
'       a.sub_dttm,',
'       b.status',
'from   job_logs a,',
'       job_run_history b',
'where  a.job_id = :P2_JOB_ID',
'and    decode(:P2_JRH_LOG_FIND_MATCH_CASE,''T'',a.line,',
'                                                  ''F'',upper(a.line))',
'       like',
'       decode(:P2_JRH_LOG_FIND_MATCH_CASE,''T'',''%''||:P2_JRH_LOG_FIND||''%'',',
'                                                  ''F'',upper(''%''||:P2_JRH_LOG_FIND||''%''))',
'and   a.job_id = b.job_id',
'and   a.sub_dttm = b.sub_dttm',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_JRH_LOG_FIND_MATCH_CASE,P2_JRH_LOG_FIND'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28185506373451703)
,p_name=>'LINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LINE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Log Line'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>10
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>1000
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'JLFR_LINE'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28185622436451705)
,p_name=>'LINE_NO'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LINE_NO'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Line'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>30
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28185801809451706)
,p_name=>'START_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'START_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Start Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>40
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28185894651451707)
,p_name=>'SUB_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUB_DTTM'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER'
,p_heading=>'Sub Dttm'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'CENTER'
,p_attribute_04=>'button'
,p_attribute_05=>'N'
,p_attribute_07=>'NONE'
,p_format_mask=>'YYYYMMDDHH24MISS'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28351392193232268)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>30
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(28185401572451702)
,p_internal_uid=>6111781079850142
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>496
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(28344868812073557)
,p_interactive_grid_id=>wwv_flow_api.id(28185401572451702)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(28344964885073558)
,p_report_id=>wwv_flow_api.id(28344868812073557)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28345500433073561)
,p_view_id=>wwv_flow_api.id(28344964885073558)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(28185506373451703)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28345994877073564)
,p_view_id=>wwv_flow_api.id(28344964885073558)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(28185622436451705)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>62
,p_sort_order=>2
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28346425255073568)
,p_view_id=>wwv_flow_api.id(28344964885073558)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(28185801809451706)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>142
,p_sort_order=>1
,p_sort_direction=>'DESC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28346992196073571)
,p_view_id=>wwv_flow_api.id(28344964885073558)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(28185894651451707)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28364184553744827)
,p_view_id=>wwv_flow_api.id(28344964885073558)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(28351392193232268)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28351883523232273)
,p_plug_name=>'PARALLEL_JOBS'
,p_region_name=>'PARALLEL_JOBS'
,p_region_css_classes=>'js-dialog-size1260x645'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>169
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select j.job_name,',
'       to_char(jrh.start_dttm,''DD-MON-YYYY HH24:MI:SS'') lstart_dttm,',
'       to_char(jrh.end_dttm,''DD-MON-YYYY HH24:MI:SS'')   lend_dttm,',
'       jrh.status,',
'       jrh.duration,',
'       substr(api.date_diff(least(nvl(jrh.end_dttm, sysdate), nvl(this.end_dttm, sysdate)),',
'                                      greatest(jrh.start_dttm,this.start_dttm))',
'       ,1,50) overlap_duration',
'from   job_run_history this',
'join   job_run_history jrh',
'on     this.job_id <> jrh.job_id',
'and    (',
'        (',
'         this.start_dttm >= jrh.start_dttm',
'         and ',
'         this.start_dttm < nvl(jrh.end_dttm,to_date(''31-DEC-4712'',''DD-MON-YYYY''))',
'        )                 ',
'        or',
'        (',
'         jrh.start_dttm >= this.start_dttm',
'         and',
'         jrh.start_dttm < nvl(this.end_dttm,to_date(''31-DEC-4712'',''DD-MON-YYYY''))',
'        )',
'       )',
'and    jrh.status in (''COMPLETE'',''RUNNING'',''FAILED'',''KILLED'',''KILLING'')',
'join   job j',
'on     j.job_id = jrh.job_id',
'where  this.job_id = :P2_JOB_ID',
'and    this.sub_dttm = to_date(:P2_JRH_SUB_DTTM,''YYYYMMDDHH24MISS'')',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID,P2_JRH_SUB_DTTM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352055965232275)
,p_name=>'JOB_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Job Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>10
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352218132232276)
,p_name=>'LSTART_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LSTART_DTTM'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Start Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>20
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>true
,p_enable_control_break=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352231959232277)
,p_name=>'LEND_DTTM'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LEND_DTTM'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'End Date Time'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>30
,p_value_alignment=>'CENTER'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>20
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352409843232278)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Status'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>40
,p_value_alignment=>'CENTER'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>30
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352423882232279)
,p_name=>'DURATION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DURATION'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Job Duration'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'CENTER'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>15
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28352538308232280)
,p_name=>'OVERLAP_DURATION'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'OVERLAP_DURATION'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Overlap Duration'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(28351936635232274)
,p_internal_uid=>6278316142630714
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>496
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(28492970563232314)
,p_interactive_grid_id=>wwv_flow_api.id(28351936635232274)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(28493036075232315)
,p_report_id=>wwv_flow_api.id(28492970563232314)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28493551118232320)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(28352055965232275)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>346
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28494055376232326)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(28352218132232276)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>145
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28494576124232330)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(28352231959232277)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>136
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28495063441232332)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(28352409843232278)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>89
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28495598880232335)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(28352423882232279)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>94
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28496091608232338)
,p_view_id=>wwv_flow_api.id(28493036075232315)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(28352538308232280)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>115
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28743524442119883)
,p_plug_name=>'EXECUTE_JOB'
,p_region_name=>'EXECUTE_JOB'
,p_region_css_classes=>'js-dialog-size1260x550'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>179
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28643156457040006)
,p_plug_name=>'EXE_JOB_PARAMS'
,p_region_name=>'EXE_JOB_PARAMS'
,p_parent_plug_id=>wwv_flow_api.id(28743524442119883)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>140
,p_plug_grid_column_span=>9
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'param_id, ',
'param_order, ',
'name, ',
'type, ',
'data_type, ',
'console_value, ',
'override_value,',
'conceal_values',
'from job_parameters_v',
'where job_id = :P2_JOB_ID'))
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28643506085040009)
,p_name=>'PARAM_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Param Id'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28643579180040010)
,p_name=>'PARAM_ORDER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ORDER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Param Order'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28741441530119862)
,p_name=>'TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Type'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>70
,p_value_alignment=>'CENTER'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28741603958119863)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Parameter Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28741825219119866)
,p_name=>'DATA_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DATA_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Data Type'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>110
,p_value_alignment=>'CENTER'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28742081806119868)
,p_name=>'OVERRIDE_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'OVERRIDE_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Override Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>130
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
end;
/
begin
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(28742177784119869)
,p_name=>'CONSOLE_VALUE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CONSOLE_VALUE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Value'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(37137497536073881)
,p_name=>'CONCEAL_VALUES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CONCEAL_VALUES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>150
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(28643234429040007)
,p_internal_uid=>6569613936438447
,p_is_editable=>true
,p_edit_operations=>'u'
,p_lost_update_check_type=>'VALUES'
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>387
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function (config) {',
'',
'    config.defaultGridViewOptions   = {footer: false,',
'        tooltip: {',
'            // when the tooltip is integrated with the grid view the content callback',
'            // gets some extra helpful parameters',
'            content: function(callback, model, recordMeta, colMeta, columnDef ) {',
'               var text = null;',
'               if ( columnDef != null ) {',
'                  global_current_ig_col = columnDef.property;',
'                  if ( [''OVERRIDE_VALUE''].includes( columnDef.property ) ) {',
'                     if ( recordMeta == null ) {  // over the header',
'                        text = '''';                         ',
'                     }',
'                     else {',
'                        text = pgv_exe_job_or_tooltip;',
'                     }',
'                  }',
'               }',
'               return text;',
'            }',
'        }',
'    };',
'',
'    config.features.aggregate       = false;',
'    config.reportSettingsArea       = false;',
'    return config;',
'}'))
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(28746949134124184)
,p_interactive_grid_id=>wwv_flow_api.id(28643234429040007)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(28747051007124184)
,p_report_id=>wwv_flow_api.id(28746949134124184)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28748069548124189)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(28643506085040009)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28748592717124192)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(28643579180040010)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28749580683124197)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(28741441530119862)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>67
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28750070062124200)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(28741603958119863)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>252
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28751529814124209)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(28741825219119866)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>86
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28752590039124215)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(28742081806119868)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(28753078322124218)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(28742177784119869)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>235
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(37202257054529490)
,p_view_id=>wwv_flow_api.id(28747051007124184)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(37137497536073881)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(28744440369119892)
,p_plug_name=>'Execution Options'
,p_parent_plug_id=>wwv_flow_api.id(28743524442119883)
,p_region_template_options=>'#DEFAULT#:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>150
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29547582198816781)
,p_plug_name=>'EXPORT_SCRIPT'
,p_region_name=>'R_EXPORT_SCRIPT'
,p_region_css_classes=>'js-dialog-size550x530'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>89
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19978954433471119)
,p_plug_name=>'EXPORT_TABS'
,p_parent_plug_id=>wwv_flow_api.id(29547582198816781)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19979003224471120)
,p_plug_name=>'Release Script'
,p_parent_plug_id=>wwv_flow_api.id(19978954433471119)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'Create a release script (SQL) to recreate the job(s) on another database running &AP_NAME..<BR><BR>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(19979121269471121)
,p_plug_name=>'DB Direct'
,p_parent_plug_id=>wwv_flow_api.id(19978954433471119)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Export the job(s) directly to another database running &AP_NAME.. You must provide valid console logon details for the target database.<BR>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(29790346830105361)
,p_plug_name=>'DELETE_JOB'
,p_region_name=>'R_DELETE_JOB'
,p_region_css_classes=>'js-dialog-size530x255'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>109
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30598706461044666)
,p_plug_name=>'JOB_DEPENDENCIES'
,p_region_name=>'JOB_DEPENDENCIES'
,p_region_css_classes=>'js-dialog-size1280x710'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>189
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p style="font-size:1.4rem">Use this screen to create job dependencies that are not simple child relationships.<BR><BR>',
'<b>Parameter based dependencies</b>: This job will only run if all the dependent jobs have completed successfully and their parameter dependency conditions are true.<BR><b>Parallel dependencies</b>: To avoid resource conflicts, this job will not run '
||'if the specified job is already running. Simply add the job as a dependent job with no parameter dependencies.</p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30599399669044673)
,p_plug_name=>'DEP_JOB'
,p_region_name=>'DEP_JOB'
,p_parent_plug_id=>wwv_flow_api.id(30598706461044666)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'JOB_DEPENDENCIES_V'
,p_query_where=>'JOB_ID = :P2_JOB_ID'
,p_query_order_by=>'JOB_NAME'
,p_include_rowid_column=>true
,p_plug_source_type=>'NATIVE_IG'
,p_ajax_items_to_submit=>'P2_JOB_ID'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30599588337044675)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30599695649044676)
,p_name=>'DEPENDENT_JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPENDENT_JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600042191044680)
,p_name=>'JOB_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Dependent Job Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_value_css_classes=>'is-readonly'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600218426044681)
,p_name=>'JOB_ONLINE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ONLINE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_CHECKBOX'
,p_heading=>'Job Online'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>60
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'wing ; is-readonly'
,p_stretch=>'N'
,p_attribute_01=>'1'
,p_is_required=>true
,p_lov_type=>'STATIC'
,p_lov_source=>unistr('STATIC:\00FE;Y,\00A8;N')
,p_lov_display_extra=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(31012834784447773)
,p_name=>'ROWID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ROWID'
,p_data_type=>'ROWID'
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>true
,p_include_in_export=>false
,p_escape_on_http_output=>true
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(30599488302044674)
,p_internal_uid=>8525867809443114
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>195
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(30637340921282170)
,p_interactive_grid_id=>wwv_flow_api.id(30599488302044674)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(30637451763282171)
,p_report_id=>wwv_flow_api.id(30637340921282170)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30638003513282177)
,p_view_id=>wwv_flow_api.id(30637451763282171)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(30599588337044675)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30638440476282183)
,p_view_id=>wwv_flow_api.id(30637451763282171)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(30599695649044676)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30640494435305991)
,p_view_id=>wwv_flow_api.id(30637451763282171)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(30600042191044680)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>550
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30640939396305993)
,p_view_id=>wwv_flow_api.id(30637451763282171)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(30600218426044681)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>80
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(31083173012155476)
,p_view_id=>wwv_flow_api.id(30637451763282171)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(31012834784447773)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30600225817044682)
,p_plug_name=>'DEP_JOB_PARAMS'
,p_region_name=>'DEP_JOB_PARAMS'
,p_parent_plug_id=>wwv_flow_api.id(30598706461044666)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>35
,p_plug_new_grid_row=>false
,p_plug_grid_column_span=>10
,p_plug_display_column=>2
,p_plug_display_point=>'BODY'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select jpd.JOB_ID, jpd.PARAM_ID, jpd.PARAM_ORDER, jpd.DEPENDENT_JOB_ID,             ',
'                         jpd.DEPENDENT_PARAM_ID, jpd.DEPENDENT_PARAM_ORDER, ',
'                         p.NAME, initcap(p.DATA_TYPE) data_type, dp.NAME dep_name,',
'                         initcap(dp.DATA_TYPE) dep_data_type, jpd.operator, jpd.rowid',
'                  from   job_param_dependencies jpd, parameters p, parameters dp',
'                  where  jpd.param_id = p.param_id',
'                  and    jpd.dependent_param_id = dp.param_id',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_master_region_id=>wwv_flow_api.id(30599399669044673)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600489651044684)
,p_name=>'JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_parent_column_id=>wwv_flow_api.id(30599588337044675)
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600586781044685)
,p_name=>'PARAM_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>40
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600644138044686)
,p_name=>'PARAM_ORDER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PARAM_ORDER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Param Order'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>50
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600772699044687)
,p_name=>'DEPENDENT_JOB_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPENDENT_JOB_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_parent_column_id=>wwv_flow_api.id(30599695649044676)
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600906939044688)
,p_name=>'DEPENDENT_PARAM_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPENDENT_PARAM_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Dependent Param Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>70
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30600994363044689)
,p_name=>'DEPENDENT_PARAM_ORDER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEPENDENT_PARAM_ORDER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Dependent Param Order'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30601149276044691)
,p_name=>'NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Job Parameter Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>110
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'DJP_NAME'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30601280733044692)
,p_name=>'DATA_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DATA_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Data Type'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>120
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>10
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'DJP_DATA_TYPE'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30601456843044694)
,p_name=>'DEP_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEP_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Dependent Job Parameter Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_stretch=>'A'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>50
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'DJP_DEP_NAME'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30601611209044695)
,p_name=>'DEP_DATA_TYPE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DEP_DATA_TYPE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Data Type'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>150
,p_value_alignment=>'CENTER'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>10
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'DJP_DEP_DATA_TYPE'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30601647825044696)
,p_name=>'OPERATOR'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'OPERATOR'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_POPUP_LOV'
,p_heading=>'Condition'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_stretch=>'N'
,p_attribute_01=>'POPUP'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'N'
,p_attribute_08=>'80'
,p_attribute_09=>'170'
,p_is_required=>true
,p_max_length=>2
,p_lov_type=>'STATIC'
,p_lov_source=>'STATIC2:=;=,>;>,<;<,>=;>=,<=;<='
,p_lov_display_extra=>false
,p_lov_display_null=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'DEP_JOB_PARAMS_OPERATOR'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_default_type=>'STATIC'
,p_default_expression=>'='
,p_duplicate_value=>false
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(30671221067138963)
,p_name=>'ROWID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ROWID'
,p_data_type=>'ROWID'
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>true
,p_include_in_export=>false
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(30600388552044683)
,p_internal_uid=>8526768059443123
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>' '
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>195
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(30645035228425476)
,p_interactive_grid_id=>wwv_flow_api.id(30600388552044683)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(30645140401425476)
,p_report_id=>wwv_flow_api.id(30645035228425476)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30645700006425478)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>0
,p_column_id=>wwv_flow_api.id(30600489651044684)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>40
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30646134971425480)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(30600586781044685)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30646639145425483)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(30600644138044686)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30647187289425485)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(30600772699044687)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30647657650425488)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(30600906939044688)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30648129076425491)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>5
,p_column_id=>wwv_flow_api.id(30600994363044689)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>2
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30649160507425496)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>6
,p_column_id=>wwv_flow_api.id(30601149276044691)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>307
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30649624303425498)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>7
,p_column_id=>wwv_flow_api.id(30601280733044692)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>74
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30650673844425504)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>9
,p_column_id=>wwv_flow_api.id(30601456843044694)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>269
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30651217575425506)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>10
,p_column_id=>wwv_flow_api.id(30601611209044695)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>79
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30651693675425509)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>8
,p_column_id=>wwv_flow_api.id(30601647825044696)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>68
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(30686769029074481)
,p_view_id=>wwv_flow_api.id(30645140401425476)
,p_display_seq=>11
,p_column_id=>wwv_flow_api.id(30671221067138963)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30674254316138993)
,p_plug_name=>'DJP_BUTTONS'
,p_parent_plug_id=>wwv_flow_api.id(30598706461044666)
,p_region_template_options=>'#DEFAULT#:t-Form--noPadding:margin-top-lg:margin-left-none:margin-right-none'
,p_plug_template=>wwv_flow_api.id(24208351153741927)
,p_plug_display_sequence=>40
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(30674364797138994)
,p_plug_name=>'JP_BUTTONS'
,p_parent_plug_id=>wwv_flow_api.id(30598706461044666)
,p_region_template_options=>'#DEFAULT#:t-Form--noPadding:margin-top-lg:margin-left-none:margin-right-none'
,p_plug_template=>wwv_flow_api.id(24208351153741927)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31015991597447804)
,p_plug_name=>'JOB_FIND'
,p_region_name=>'R_JOB_FIND'
,p_region_css_classes=>'js-dialog-size535x280'
,p_region_template_options=>'js-modal:js-draggable:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>69
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(31198067346604977)
,p_plug_name=>'DB_DATETIME'
,p_region_name=>'R_DB_DATETIME'
,p_region_css_classes=>'js-dialog-size350x220'
,p_region_template_options=>'t-DialogRegion--noPadding:js-modal:js-draggable:js-dialog-size480x320'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>79
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
begin
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33624239981995475)
,p_plug_name=>'BG_PROCESS'
,p_region_name=>'R_BG_PROCESS'
,p_region_css_classes=>'js-dialog-size1250x400'
,p_region_template_options=>'#DEFAULT#:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>39
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33626971039995502)
,p_plug_name=>'New'
,p_parent_plug_id=>wwv_flow_api.id(33624239981995475)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33627035897995503)
,p_plug_name=>'Job Poller'
,p_parent_plug_id=>wwv_flow_api.id(33626971039995502)
,p_icon_css_classes=>'fa-clock-o'
,p_region_template_options=>'#DEFAULT#:t-Region--showIcon:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The Job Poller is responsible for launching TIMED jobs in the schedule. It polls the schedule once a minute looking for jobs whose "Next Submit Date Time" is due.',
'<BR>The Auto Start setting determines if the Job Poller is automatically started when the database is started.<BR><BR>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33627129868995504)
,p_plug_name=>'Log Writer'
,p_parent_plug_id=>wwv_flow_api.id(33626971039995502)
,p_icon_css_classes=>'fa-server-edit'
,p_region_template_options=>'#DEFAULT#:t-Region--showIcon:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The Log Writer collects output from each job and writes it to a database log table. The Log Writer starts automatically whenever jobs are run or O/S source files are viewed, it will also start if a diagnostic test is requested. Under normal circumsta'
||'nces there is no need to manually start the Log Writer. It may be stopped as long as no jobs are currently running.<BR><BR><BR><BR>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(33627289252995505)
,p_plug_name=>'Message Server'
,p_parent_plug_id=>wwv_flow_api.id(33626971039995502)
,p_icon_css_classes=>'fa-envelope-o'
,p_region_template_options=>'#DEFAULT#:t-Region--showIcon:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'The Message Server is responsible for sending all outbound messages created by Cronology. Message types supported are: e-mail, SNMP traps, socket messaging or bespoke PL/SQL procedures.',
'The Message Server starts automatically whenever messages are due to be sent, there is no manual option to start the Message Server. It may be stopped at any time.<BR><BR><BR><BR>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35562935646022984)
,p_plug_name=>'SCHEDULE_SETTINGS'
,p_region_name=>'R_SCHEDULE_SETTINGS'
,p_region_css_classes=>'js-dialog-size1095x565'
,p_region_template_options=>'#DEFAULT#:js-dialog-size600x400'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>29
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_read_only_when_type=>'FUNCTION_BODY'
,p_plug_read_only_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if APEX_UTIL.PUBLIC_CHECK_AUTHORIZATION(''CRONOLOGY_A'') then',
'-- not read only',
'  return false;',
'else',
'-- read only',
'  return true;',
'end if;'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35563589620022990)
,p_plug_name=>'Schedule Settings Tabs'
,p_parent_plug_id=>wwv_flow_api.id(35562935646022984)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35563691151022991)
,p_plug_name=>'Environment Script'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35563732544022992)
,p_plug_name=>'SSH Environment Script'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35563842626022993)
,p_plug_name=>'Job History Retention'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>40
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(35563987536022994)
,p_plug_name=>'Job Run Log Limit'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>50
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36469322624073180)
,p_plug_name=>'Console Auto Text'
,p_region_name=>'AUTO_TEXT'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24233880401742026)
,p_plug_display_sequence=>80
,p_plug_display_point=>'BODY'
,p_query_type=>'TABLE'
,p_query_table=>'CONSOLE_AUTO_TEXT'
,p_query_order_by=>'auto_text'
,p_include_rowid_column=>true
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(36469523116073182)
,p_name=>'AUTO_TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'AUTO_TEXT'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Auto Text'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>100
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'AUTO_TEXT_COL'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(36469669697073183)
,p_name=>'USERNAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'USERNAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Username'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>40
,p_value_alignment=>'LEFT'
,p_value_css_classes=>'is-readonly'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>128
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'AUTO_TEXT_USERNAME'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_default_type=>'STATIC'
,p_default_expression=>'&APP_USER.'
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(36469732765073184)
,p_name=>'TIMESTAMP'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TIMESTAMP'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Timestamp'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>50
,p_value_alignment=>'CENTER'
,p_value_css_classes=>'is-readonly'
,p_stretch=>'N'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_enable_filter=>false
,p_filter_is_required=>false
,p_static_id=>'AUTO_TEXT_TIMESTAMP'
,p_use_as_row_header=>false
,p_javascript_code=>'ig_column_hdr'
,p_enable_sort_group=>false
,p_enable_hide=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_api.create_region_column(
 p_id=>wwv_flow_api.id(36469884079073185)
,p_name=>'ROWID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ROWID'
,p_data_type=>'ROWID'
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>60
,p_attribute_01=>'Y'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>true
,p_include_in_export=>false
);
wwv_flow_api.create_interactive_grid(
 p_id=>wwv_flow_api.id(36469434234073181)
,p_internal_uid=>14395813741471621
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>true
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_show_toolbar=>false
,p_toolbar_buttons=>null
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'REGION'
,p_fixed_header_max_height=>323
,p_show_icon_view=>false
,p_show_detail_view=>false
,p_javascript_code=>'ig_att'
);
wwv_flow_api.create_ig_report(
 p_id=>wwv_flow_api.id(36497548969305476)
,p_interactive_grid_id=>wwv_flow_api.id(36469434234073181)
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_api.create_ig_report_view(
 p_id=>wwv_flow_api.id(36497698019305476)
,p_report_id=>wwv_flow_api.id(36497548969305476)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(36498147007305479)
,p_view_id=>wwv_flow_api.id(36497698019305476)
,p_display_seq=>1
,p_column_id=>wwv_flow_api.id(36469523116073182)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>692
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(36498712355305484)
,p_view_id=>wwv_flow_api.id(36497698019305476)
,p_display_seq=>2
,p_column_id=>wwv_flow_api.id(36469669697073183)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>196
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(36499164344305489)
,p_view_id=>wwv_flow_api.id(36497698019305476)
,p_display_seq=>3
,p_column_id=>wwv_flow_api.id(36469732765073184)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>152
);
wwv_flow_api.create_ig_report_column(
 p_id=>wwv_flow_api.id(36499705814305493)
,p_view_id=>wwv_flow_api.id(36497698019305476)
,p_display_seq=>4
,p_column_id=>wwv_flow_api.id(36469884079073185)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(38351071383790779)
,p_plug_name=>'Console Environment Indicators'
,p_parent_plug_id=>wwv_flow_api.id(35563589620022990)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>60
,p_plug_display_point=>'BODY'
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(38352714777790795)
,p_plug_name=>'New'
,p_parent_plug_id=>wwv_flow_api.id(38351071383790779)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>70
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(38352737970790796)
,p_plug_name=>'New'
,p_parent_plug_id=>wwv_flow_api.id(38351071383790779)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>80
,p_plug_new_grid_row=>false
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(38353040650790799)
,p_plug_name=>'New'
,p_parent_plug_id=>wwv_flow_api.id(38351071383790779)
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_api.id(24208351153741927)
,p_plug_display_sequence=>90
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36224009117030865)
,p_plug_name=>'LATEST_SQL'
,p_region_name=>'R_LATEST_SQL'
,p_region_css_classes=>'js-dialog-size1260x750'
,p_region_template_options=>'#DEFAULT#:js-dialog-size600x400'
,p_region_attributes=>'style="position:  height: 95%; width: 95%; "'
,p_plug_template=>wwv_flow_api.id(24228268014742000)
,p_plug_display_sequence=>9
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36224160065030867)
,p_plug_name=>'Latest SQL Tabs'
,p_parent_plug_id=>wwv_flow_api.id(36224009117030865)
,p_region_template_options=>'#DEFAULT#:t-TabsRegion-mod--simple'
,p_plug_template=>wwv_flow_api.id(24242606244742055)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36224399650030869)
,p_plug_name=>'SQL'
,p_region_name=>'SQL_TAB'
,p_parent_plug_id=>wwv_flow_api.id(36224160065030867)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>10
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(36224471069030870)
,p_plug_name=>'Explain Plan'
,p_region_name=>'EXP_TAB'
,p_parent_plug_id=>wwv_flow_api.id(36224160065030867)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>20
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_plug(
 p_id=>wwv_flow_api.id(41127679707766161)
,p_plug_name=>'SQL Monitor'
,p_region_name=>'MON_TAB'
,p_parent_plug_id=>wwv_flow_api.id(36224160065030867)
,p_region_template_options=>'#DEFAULT#:t-Region--removeHeader:t-Region--scrollBody'
,p_plug_template=>wwv_flow_api.id(24235771973742035)
,p_plug_display_sequence=>30
,p_plug_display_point=>'BODY'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19980829199471138)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(19979121269471121)
,p_button_name=>'EXPORT_INFO'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'More Information ...'
,p_button_position=>'BELOW_BOX'
,p_button_alignment=>'LEFT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_button_cattributes=>'style="width:130px"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30602040590044700)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(30599399669044673)
,p_button_name=>'ADD_DEP_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Add'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_icon_css_classes=>'fa-asl-interpreting'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35565010970023004)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(35563691151022991)
,p_button_name=>'B_SHOW_ENV_SCRIPT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Show Script ...'
,p_button_position=>'BELOW_BOX'
,p_button_alignment=>'LEFT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36542762031265885)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(36469322624073180)
,p_button_name=>'AUTO_TEXT_RESET'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Reset'
,p_button_position=>'BELOW_BOX'
,p_button_alignment=>'LEFT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(38351444077790783)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(38353040650790799)
,p_button_name=>'ENV_LABEL_APPLY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(19980004376471130)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(19979121269471121)
,p_button_name=>'EXPORT_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Export'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30671844143138969)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(30599399669044673)
,p_button_name=>'DELETE_DEP_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Remove'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35632846544542567)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(35563691151022991)
,p_button_name=>'ENV_SCRIPT_APPLY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36470362620073190)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(36469322624073180)
,p_button_name=>'AUTO_TEXT_REMOVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Remove'
,p_button_position=>'BELOW_BOX'
,p_button_alignment=>'LEFT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36470274459073189)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(36469322624073180)
,p_button_name=>'AUTO_TEXT_ADD'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Add'
,p_button_position=>'BELOW_BOX'
,p_button_alignment=>'LEFT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36541462050265872)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(36469322624073180)
,p_button_name=>'AUTO_TEXT_SAVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35633011607542568)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(35563732544022992)
,p_button_name=>'SSH_ENV_SCRIPT_APPLY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35633054887542569)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(35563842626022993)
,p_button_name=>'JOB_HISTORY_RETENTION_APPLY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35633137776542570)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(35563987536022994)
,p_button_name=>'JOB_RUN_LOG_LIMIT_APPLY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_security_scheme=>wwv_flow_api.id(24344349155760999)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29548402688816789)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(19979003224471120)
,p_button_name=>'EXPORT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Download'
,p_button_position=>'BELOW_BOX'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308209051080480)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_RUN_HISTORY'
,p_button_static_id=>'B_RUN_HISTORY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Run History'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'title="(Keyboard: ENTER)" '
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30674619033138996)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(30674364797138994)
,p_button_name=>'JOB_PARAM_ADD'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconRight:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_button_image_alt=>'Add   '
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-arrow-circle-o-right'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30674774205138998)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(30674254316138993)
,p_button_name=>'DEP_JOB_PARAM_ADD'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconLeft:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_button_image_alt=>'   Add'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-arrow-circle-o-left'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(39393527400849770)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(19979003224471120)
,p_button_name=>'EXPORT_HIDDEN'
,p_button_static_id=>'B_DOWNLOAD_EXPORT'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Dummy'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:&APP_PAGE_ID.:&APP_SESSION.:APPLICATION_PROCESS=DOWNLOAD_FILE:::P2_EXPORT_COLLECTION_NAME:EXPORT_SCRIPT'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(41160683207285183)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(36224471069030870)
,p_button_name=>'B_REFRESH_1_1_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Refresh'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-sm fa-refresh'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_attributes=>'style="padding-bottom: 0px; padding-top: 11px;"'
,p_grid_new_row=>'N'
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308270003080481)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_EXECUTE'
,p_button_static_id=>'B_EXECUTE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Execute ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30674696371138997)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(30674364797138994)
,p_button_name=>'JOB_PARAM_REMOVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconRight:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_button_image_alt=>'Remove   '
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-arrow-circle-o-left'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30674892616138999)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(30674254316138993)
,p_button_name=>'DEP_JOB_PARAM_REMOVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--iconLeft:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296606035742268)
,p_button_image_alt=>'   Remove'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_icon_css_classes=>'fa-arrow-circle-o-right'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(37714498575263875)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(31015991597447804)
,p_button_name=>'JOB_SOURCE_LOV'
,p_button_static_id=>'JOB_SOURCE_LOV'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Select'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-list'
,p_button_cattributes=>'style="margin-top: 16px!important;"'
,p_grid_new_row=>'N'
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25307069307080469)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(25488543141463182)
,p_button_name=>'B_OP_SAVE'
,p_button_static_id=>'B_OP_SAVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Save'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308340455080482)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_CANCEL'
,p_button_static_id=>'B_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(26445576588205688)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(27008022424306694)
,p_button_name=>'VIEW_SOURCE_FIND'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Find'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column=>5
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27263040054731801)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(33627035897995503)
,p_button_name=>'STOP_D_JPLR'
,p_button_static_id=>'B_D_STOP_JPLR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Request Delayed Stop'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 15px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33810448246061570)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(33627129868995504)
,p_button_name=>'LGWR_DIAGNOSTIC'
,p_button_static_id=>'B_LGWR_DIAGNOSTIC'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Diagnostic Test'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>1
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
end;
/
begin
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(41160813829285184)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_api.id(41127679707766161)
,p_button_name=>'B_REFRESH_1_1_1_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Refresh'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-sm fa-refresh'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_attributes=>'style="padding-bottom: 0px; padding-top: 11px;"'
,p_grid_new_row=>'N'
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25307181686080470)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(25488543141463182)
,p_button_name=>'B_OP_CANCEL'
,p_button_static_id=>'B_OP_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308426378080483)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_KILL'
,p_button_static_id=>'B_KILL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Kill ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'N'
,p_grid_new_column=>'N'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27008271399306696)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(27008022424306694)
,p_button_name=>'VIEW_SOURCE_FIND_NEXT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Find Next'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column=>6
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27215563666614306)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(27215106100614301)
,p_button_name=>'JRH_LOG_FIND'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Find'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 14px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28550569979651364)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(28355542760232310)
,p_button_name=>'JOB_LOG_FIND'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Find'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>5
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33810561345061571)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(33627129868995504)
,p_button_name=>'LGWR_SHOW_LOST_LOG_LINES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Show Lost Log Lines'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>3
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33811347174061579)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_api.id(33627289252995505)
,p_button_name=>'SHOW_MESSAGE_HISTORY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Message History'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
,p_grid_column=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308586354080484)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_OFFLINE'
,p_button_static_id=>'B_OFFLINE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Offline ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31811037617993873)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(25795412944096086)
,p_button_name=>'B_MAIN_MENU'
,p_button_static_id=>'B_MAIN_MENU'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Main Menu (Keyboard: m)'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-left  js-menuButton'
,p_icon_css_classes=>'fa-navicon'
,p_button_cattributes=>'style="padding: .7rem" data-menu="main_menu_menu"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33734548065854662)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(33627035897995503)
,p_button_name=>'START_JPLR'
,p_button_static_id=>'B_START_JPLR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Start Job Poller'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 15px!important;"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
,p_grid_column=>1
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33737302537854689)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(33627129868995504)
,p_button_name=>'P2_LGWR_PROCESS_HISTORY'
,p_button_static_id=>'P2_LGWR_PROCESS_HISTORY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Process History'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>9
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33737575548854692)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_api.id(33627289252995505)
,p_button_name=>'P2_MSVR_PROCESS_HISTORY'
,p_button_static_id=>'P2_MSVR_PROCESS_HISTORY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Process History'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>9
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308642324080485)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_EXPORT'
,p_button_static_id=>'B_EXPORT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Export ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28550710109651365)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(28355542760232310)
,p_button_name=>'JOB_LOG_FIND_NEXT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Find Next'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>6
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31197754857604974)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(25795412944096086)
,p_button_name=>'B_DB_DATETIME'
,p_button_static_id=>'B_DB_DATETIME'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Database Time (Keyboard: t)'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-clock-o'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>4
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33735989688854676)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(33627129868995504)
,p_button_name=>'STOP_LGWR'
,p_button_static_id=>'B_STOP_LGWR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Stop Log Writer'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33736359035854680)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_api.id(33627289252995505)
,p_button_name=>'STOP_MSVR'
,p_button_static_id=>'B_STOP_MSVR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Stop Message Server'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 20px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308727207080486)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_AMEND'
,p_button_static_id=>'B_AMEND'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Edit'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25796950344096102)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(25795412944096086)
,p_button_name=>'B_REFRESH'
,p_button_static_id=>'B_REFRESH'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Refresh Now (Keyboard: r)'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-sm fa-refresh'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>5
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27007693963306690)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(27008022424306694)
,p_button_name=>'VIEW_SOURCE_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27215495876614305)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(27215106100614301)
,p_button_name=>'JRH_DOWNLOAD'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Download ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 16px!important;"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33737932916854696)
,p_button_sequence=>80
,p_button_plug_id=>wwv_flow_api.id(33627035897995503)
,p_button_name=>'OVERDUE_JOBS'
,p_button_static_id=>'B_OVERDUE_JOBS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Show Overdue Jobs ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 15px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>3
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308837272080487)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_DELETE'
,p_button_static_id=>'B_DELETE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Delete ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28184954857451698)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(27215106100614301)
,p_button_name=>'JRH_PARALLEL_JOBS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Parallel Jobs ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 16px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>3
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28550979008651368)
,p_button_sequence=>90
,p_button_plug_id=>wwv_flow_api.id(28355542760232310)
,p_button_name=>'JOB_LOG_EMAIL'
,p_button_static_id=>'B_JOB_LOG_EMAIL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Mail Log'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>10
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25308923705080488)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_DEPENDENCIES'
,p_button_static_id=>'B_DEPENDENCIES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Dependencies'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27829514718847897)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(27215106100614301)
,p_button_name=>'JRH_SHOW_LOG'
,p_button_static_id=>'B_JOB_LOG'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Show Log'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 16px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>5
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28353576536232290)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(28355542760232310)
,p_button_name=>'JL_DOWNLOAD'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Download ...'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>11
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33736902749854685)
,p_button_sequence=>100
,p_button_plug_id=>wwv_flow_api.id(33627035897995503)
,p_button_name=>'P2_JPLR_PROCESS_HISTORY'
,p_button_static_id=>'P2_JPLR_PROCESS_HISTORY'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Process History'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 15px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>9
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25309066658080489)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_DOCUMENTATION'
,p_button_static_id=>'B_DOCUMENTATION'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Documentation'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25797050106096103)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(25795412944096086)
,p_button_name=>'B_FIND_JOB'
,p_button_static_id=>'B_FIND_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Find Job (Keyboard: f)'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-left'
,p_icon_css_classes=>'fa-search'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27215674708614307)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(27215106100614301)
,p_button_name=>'JRH_CLOSE'
,p_button_static_id=>'B_JRH_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 16px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28550807424651366)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(28355542760232310)
,p_button_name=>'JOB_LOG_CLOSE'
,p_button_static_id=>'B_JOB_LOG_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
,p_grid_new_row=>'N'
,p_grid_column_span=>1
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33735003060854666)
,p_button_sequence=>110
,p_button_plug_id=>wwv_flow_api.id(33627035897995503)
,p_button_name=>'STOP_JPLR'
,p_button_static_id=>'B_STOP_JPLR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Stop Job Poller'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="margin-top: 15px!important;"'
,p_grid_new_row=>'N'
,p_grid_column_span=>2
,p_grid_column=>11
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31014763617447792)
,p_button_sequence=>120
,p_button_plug_id=>wwv_flow_api.id(25795412944096086)
,p_button_name=>'B_FIND_JOB_NEXT'
,p_button_static_id=>'B_FIND_JOB_NEXT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Find Next (Keyboard: n)'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-left'
,p_icon_css_classes=>'fa-search-plus'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_new_column=>'Y'
,p_grid_column_span=>1
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35634995474542588)
,p_button_sequence=>120
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'CURRENT_SQL'
,p_button_static_id=>'B_CURRENT_SQL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--padTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Current SQL'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36286625910693666)
,p_button_sequence=>150
,p_button_plug_id=>wwv_flow_api.id(36224471069030870)
,p_button_name=>'COPY_TO_CB_EP'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Copy to Clipboard'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'data-clipboard-source=''#P2_EXPLAIN_PLAN'' style="width:130px"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(41128952305766174)
,p_button_sequence=>160
,p_button_plug_id=>wwv_flow_api.id(41127679707766161)
,p_button_name=>'COPY_TO_CB_SM'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Copy to Clipboard'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'data-clipboard-source=''#P2_SQL_MONITOR'' style="width:130px"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(41328574463889716)
,p_button_sequence=>170
,p_button_plug_id=>wwv_flow_api.id(36224399650030869)
,p_button_name=>'B_REFRESH_1_1'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24295778150742260)
,p_button_image_alt=>'Refresh'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'float-right'
,p_icon_css_classes=>'fa-sm fa-refresh'
,p_button_cattributes=>'style="padding: .7rem"'
,p_grid_column_attributes=>'style="padding-bottom: 0px; padding-top: 11px;"'
,p_grid_column_css_classes=>'t-Form-inputContainer'
,p_grid_new_row=>'N'
,p_grid_column=>12
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(34516182803272695)
,p_button_sequence=>200
,p_button_plug_id=>wwv_flow_api.id(25489632318463193)
,p_button_name=>'B_GOTO_JOB_SCREEN'
,p_button_static_id=>'B_GOTO_JOB_SCREEN'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'dummy'
,p_button_position=>'BODY'
,p_button_redirect_url=>'f?p=&APP_ID.:12:&SESSION.::&DEBUG.:RP::'
,p_grid_new_row=>'Y'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36287051816693670)
,p_button_sequence=>300
,p_button_plug_id=>wwv_flow_api.id(36224399650030869)
,p_button_name=>'COPY_TO_CB_SQL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--stretch:t-Button--gapTop'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Copy to Clipboard'
,p_button_position=>'BODY'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'data-clipboard-source=''#P2_LATEST_SQL'' style="width:130px"'
,p_grid_new_row=>'Y'
,p_grid_column_span=>2
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25794773358096080)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(25490984889463206)
,p_button_name=>'OP_SAVE_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28745201214119899)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(28744440369119892)
,p_button_name=>'B_EXE_JOB'
,p_button_static_id=>'B_EXE_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Execute'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29791240469105370)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(29790346830105361)
,p_button_name=>'DELETE_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'No'
,p_button_position=>'REGION_TEMPLATE_CREATE'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27005340783306667)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(26810795834463910)
,p_button_name=>'FILTER_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28350761922232262)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(28185232087451701)
,p_button_name=>'JFLR_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28352917647232283)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(28351883523232273)
,p_button_name=>'PJ_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28745706976119904)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(28743524442119883)
,p_button_name=>'EXECUTE_JOB_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29548494966816790)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(29547582198816781)
,p_button_name=>'EXPORT_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31196651263604963)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(31015991597447804)
,p_button_name=>'JOB_FIND_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31198380735604980)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(31198067346604977)
,p_button_name=>'DB_DATETIME_OK'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'OK'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(33624566648995478)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(33624239981995475)
,p_button_name=>'BG_PROCESS_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(35563087949022985)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(35562935646022984)
,p_button_name=>'SCHEDULE_SETTINGS_CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36286225968693662)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_api.id(36224009117030865)
,p_button_name=>'LATEST_SQL_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Close'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(25794622149096079)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(25490984889463206)
,p_button_name=>'OP_SAVE_OK'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(27005281167306666)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(26810795834463910)
,p_button_name=>'FILTER'
,p_button_static_id=>'FILTER'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Filter'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
end;
/
begin
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(28350711604232261)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(28185232087451701)
,p_button_name=>'JLFR_SHOW_LOG'
,p_button_static_id=>'JLFR_SHOW_LOG'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Show Log'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(31196602382604962)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(31015991597447804)
,p_button_name=>'JOB_FIND'
,p_button_static_id=>'MAIN_FIND_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Find'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30598730719044667)
,p_button_sequence=>25
,p_button_plug_id=>wwv_flow_api.id(30598706461044666)
,p_button_name=>'JOB_DEPENDENCIES_CANCEL'
,p_button_static_id=>'JOB_DEPENDENCIES_CLOSE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:t-Button--padRight'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Cancel'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29791200719105369)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(29790346830105361)
,p_button_name=>'DELETE_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Yes'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(30675203986139002)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_api.id(30598706461044666)
,p_button_name=>'JOB_DEPENDENCIES_SAVE'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Save'
,p_button_position=>'REGION_TEMPLATE_NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'button_width'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(29791457497105372)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(29790346830105361)
,p_button_name=>'B_DEP_ON_THIS_JOB'
,p_button_static_id=>'B_DEP_ON_THIS_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Show Jobs Dependent On This Job ...'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="width:220px"'
);
wwv_flow_api.create_page_button(
 p_id=>wwv_flow_api.id(36288379043693683)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_api.id(30598706461044666)
,p_button_name=>'JOBS_DEP_ON_THIS_JOB'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_api.id(24296457568742267)
,p_button_image_alt=>'Show Jobs Dependent On This Job'
,p_button_position=>'REGION_TEMPLATE_PREVIOUS'
,p_warn_on_unsaved_changes=>null
,p_button_cattributes=>'style="width:250px"'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19979633960471126)
,p_name=>'P2_EXPORT_CHILDREN_1'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(19979121269471121)
,p_prompt=>'Export Children'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:margin-top-md:margin-bottom-md'
,p_is_persistent=>'N'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19979747195471127)
,p_name=>'P2_EXPORT_USERNAME'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(19979121269471121)
,p_placeholder=>'Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>128
,p_tag_css_classes=>'uppercase'
,p_tag_attributes=>'style="height: 3rem;"'
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_icon_css_classes=>'fa-user'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19979848213471128)
,p_name=>'P2_EXPORT_PASSWORD'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(19979121269471121)
,p_placeholder=>'Password'
,p_display_as=>'NATIVE_PASSWORD'
,p_cSize=>60
,p_cMaxlength=>30
,p_tag_attributes=>'style="height: 3rem;"'
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_icon_css_classes=>'fa-key'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19979935847471129)
,p_name=>'P2_EXPORT_DB_CONN_STRING'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(19979121269471121)
,p_placeholder=>'DB Connect String'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>150
,p_tag_css_classes=>'uppercase'
,p_tag_attributes=>'style="height: 3rem;" title="Connect string will be resolved on this DB server."'
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_icon_css_classes=>'fa-plug'
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(19980353726471133)
,p_name=>'P2_EXPORT_DIRECT_RETVAL'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(19979121269471121)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(24397694225696224)
,p_name=>'P2_AUDIT_ID'
,p_item_sequence=>380
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(24397734742696225)
,p_name=>'P2_AUDIT_ID_TYPE'
,p_item_sequence=>390
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25268817346880086)
,p_name=>'P2_JOB_NAME'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Job Name'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cMaxlength=>100
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269043795880089)
,p_name=>'P2_AVG_DURATION'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Average Duration'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>15
,p_cattributes_element=>'title="Average of last 10 COMPLETE runs" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269152577880090)
,p_name=>'P2_RUNTIME_WARNING_DISP'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Runtime Warning'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>15
,p_cattributes_element=>'title="Send a message if runtime exceeds this duration" '
,p_tag_attributes=>'style="text-align: center;"'
,p_begin_on_new_line=>'N'
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269343148880092)
,p_name=>'P2_SOURCE_TYPE'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Source Type'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>50
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269433695880093)
,p_name=>'P2_SCHEDULE_TYPE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Schedule Type'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>10
,p_begin_on_new_line=>'N'
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269600294880094)
,p_name=>'P2_JOB_CRON_STR'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Cron Schedule'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cattributes_element=>'title="Double click for Cron schedule information" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269672227880095)
,p_name=>'P2_SSH_CONN_STRING'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'SSH Connection'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>100
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269781507880096)
,p_name=>'P2_SOURCE_NAME'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Source Name'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_attributes=>'title="Double click to view source code"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25269903086880097)
,p_name=>'P2_SOURCE_DIR'
,p_item_sequence=>260
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Source Directory'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>100
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270009787880098)
,p_name=>'P2_DB_CONN_STRING'
,p_item_sequence=>280
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'DB Connect String'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>150
,p_begin_on_new_line=>'N'
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270051279880099)
,p_name=>'P2_USERNAME'
,p_item_sequence=>270
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'DB Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>128
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270128098880100)
,p_name=>'P2_DISPLAY_EMAIL_LOG'
,p_item_sequence=>300
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Content'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>7
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270232725880101)
,p_name=>'P2_EMAIL'
,p_item_sequence=>290
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'On Completion E-mail'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>500
,p_colspan=>3
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270390191880102)
,p_name=>'P2_EMAIL_ON_FAILURE'
,p_item_sequence=>310
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'On Failure E-mail Override'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>500
,p_begin_on_new_line=>'N'
,p_colspan=>3
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270516721880103)
,p_name=>'P2_EMAIL_ON_FAILURE_CC_OPS'
,p_item_sequence=>320
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Cc Ops'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_attributes=>'style="font-family : ''Wingdings''; font-size: large; width: 35px; text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25270603081880104)
,p_name=>'P2_DISPLAY_NEXT_SUB_DTTM'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Next Submit Date Time'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cattributes_element=>'title="Double click for execution window" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25306295431080461)
,p_name=>'P2_OK_TO_CONTINUE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(25488543141463182)
,p_prompt=>'Resolved'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25306425332080463)
,p_name=>'P2_ACTION_USERNAME'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(25488543141463182)
,p_prompt=>'Username'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>128
,p_begin_on_new_line=>'N'
,p_grid_column=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25306561062080464)
,p_name=>'P2_INFO'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(25488543141463182)
,p_prompt=>'Status Information'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cMaxlength=>2000
,p_cHeight=>6
,p_tag_attributes=>'style="resize: none;"'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs:margin-bottom-none'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25306879972080467)
,p_name=>'P2_PARENT_JOB_NAME'
,p_item_sequence=>220
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_prompt=>'Parent Job Name'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>100
,p_begin_on_new_line=>'N'
,p_colspan=>8
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25307253288080471)
,p_name=>'P2_JOB_ID'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25307328599080472)
,p_name=>'P2_JOB_DESCRIPTION'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(25488925515463186)
,p_prompt=>'Job Description'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cMaxlength=>100
,p_cHeight=>11
,p_tag_attributes=>'style="resize: none;"'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25310130095080500)
,p_name=>'P2_SUB_DTTM'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(25488707120463183)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25489740329463194)
,p_name=>'P2_AUTO_TEXT_LOV'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(25488543141463182)
,p_prompt=>'Auto Text Lov'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'AUTO_TEXT'
,p_lov=>'select auto_text d, auto_text r from console_auto_text order by 1'
,p_lov_display_null=>'YES'
,p_lov_cascade_parent_items=>'P2_JOB_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>30
,p_field_template=>wwv_flow_api.id(24295347200742259)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_03=>'N'
,p_attribute_04=>'N'
,p_attribute_05=>'Y'
,p_attribute_06=>'0'
,p_attribute_08=>'600'
,p_attribute_09=>'600'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25491059235463207)
,p_name=>'FORCE_COMPLETE_SWITCH'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(25490984889463206)
,p_prompt=>'Force Complete'
,p_display_as=>'NATIVE_YES_NO'
,p_colspan=>3
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295347200742259)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25491123281463208)
,p_name=>'RUN_WAITING_JOBS_SWITCH'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(25490984889463206)
,p_prompt=>'Run Waiting Jobs'
,p_display_as=>'NATIVE_YES_NO'
,p_colspan=>3
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295347200742259)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25793560092096068)
,p_name=>'FORCE_COMPLETE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(25490984889463206)
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25793664381096069)
,p_name=>'RUN_WAITING_JOBS'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(25490984889463206)
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25793830468096071)
,p_name=>'P2_HOLDER'
,p_item_sequence=>140
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795425089096087)
,p_name=>'P2_STATUS_SUMMARY'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_prompt=>'Status Summary'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>50
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795522611096088)
,p_name=>'P2_JPLR_STATUS'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_prompt=>'Job Poller'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>50
,p_cattributes_element=>'title="Double click for history" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_grid_column=>10
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795685538096089)
,p_name=>'P2_LGWR_STATUS'
,p_item_sequence=>160
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_prompt=>'Log Writer'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>50
,p_cattributes_element=>'title="Double click for history" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795771990096090)
,p_name=>'P2_MSVR_STATUS'
,p_item_sequence=>180
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_prompt=>'Message Server'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_cMaxlength=>50
,p_cattributes_element=>'title="Double click for history" '
,p_tag_attributes=>'style="text-align: center"'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795893589096091)
,p_name=>'P2_AUTOSTART'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_api.id(33627035897995503)
,p_prompt=>'Auto Start'
,p_display_as=>'NATIVE_YES_NO'
,p_begin_on_new_line=>'N'
,p_colspan=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_security_scheme=>wwv_flow_api.id(24344557412768325)
,p_attribute_01=>'CUSTOM'
,p_attribute_02=>'ON'
,p_attribute_04=>'OFF'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25795965124096092)
,p_name=>'P2_CHANGE_LOGGING'
,p_item_sequence=>200
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25796024363096093)
,p_name=>'P2_COMP_EMAIL'
,p_item_sequence=>210
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25796209413096094)
,p_name=>'P2_FIELD_COLOURS'
,p_item_sequence=>230
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(25796244780096095)
,p_name=>'P2_NEXT_BP_CK_DTTM'
,p_item_sequence=>240
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26446466314205697)
,p_name=>'P2_MAIN_STATUS_FILTER'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26805931698463862)
,p_name=>'P2_MAIN_JOB_FREQUENCY_FILTER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(26806051978463863)
,p_name=>'P2_MAIN_JOB_NAME_FILTER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_prompt=>'Filter for Job Names Including'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_attributes=>'title="Filter is case insensitive"'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27005111668306664)
,p_name=>'P2_MAIN_TODAY_ONLY_FILTER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_prompt=>'Today Only'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:margin-top-sm'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27005152457306665)
,p_name=>'P2_MAIN_TIMED_ONLY_FILTER'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_prompt=>'Timed Only'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:margin-top-sm'
,p_attribute_01=>'APPLICATION'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27007956204306693)
,p_name=>'P2_SOURCE_FIND'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(27008022424306694)
,p_prompt=>'Search For'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_attributes=>'style="padding-top: 2px;"'
,p_colspan=>3
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27008193413306695)
,p_name=>'P2_SOURCE_FIND_MATCH_CASE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(27008022424306694)
,p_prompt=>'Match Case'
,p_display_as=>'NATIVE_YES_NO'
,p_begin_on_new_line=>'N'
,p_grid_column=>4
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'CUSTOM'
,p_attribute_02=>'T'
,p_attribute_04=>'F'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27008588347306699)
,p_name=>'P2_SOURCE_GOTO_LINE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(27008022424306694)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27211562803614266)
,p_name=>'P2_BP_ABB_HISTORY'
,p_item_sequence=>250
,p_item_plug_id=>wwv_flow_api.id(25795412944096086)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27214552189614296)
,p_name=>'P2_JRH_STATUS_FILTER'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27215173045614302)
,p_name=>'P2_JOB_LOG_GOTO_LINE'
,p_item_sequence=>130
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27215301815614303)
,p_name=>'P2_JRH_LOG_FIND'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_prompt=>'Search All Logs For'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_attributes=>'style="padding-top: 2px;"'
,p_begin_on_new_line=>'N'
,p_colspan=>8
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27215374718614304)
,p_name=>'P2_JRH_LOG_FIND_MATCH_CASE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_prompt=>'Match Case'
,p_display_as=>'NATIVE_YES_NO'
,p_begin_on_new_line=>'N'
,p_colspan=>2
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'CUSTOM'
,p_attribute_02=>'T'
,p_attribute_04=>'F'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27829214143847894)
,p_name=>'P2_JRH_ACTION_USERNAME_FILTER'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_api.id(26810795834463910)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27829318855847895)
,p_name=>'P2_DOWNLOAD_FILENAME'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(27830024548847903)
,p_name=>'P2_JRH_SUB_DTTM'
,p_item_sequence=>120
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_display_as=>'NATIVE_HIDDEN'
,p_attribute_01=>'N'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(28184188933451690)
,p_name=>'P2_DUMMY_SPACER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_attributes=>'style="padding-top: 2px;"'
,p_colspan=>8
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs:margin-top-none'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(28184761949451696)
,p_name=>'P2_DUMMY_SPACER_1'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_api.id(27215106100614301)
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_tag_attributes=>'style="padding-top: 2px;"'
,p_colspan=>8
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_template_options=>'#DEFAULT#:t-Form-fieldContainer--stretchInputs'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
);
end;
/
begin
wwv_flow_api.create_page_item(
 p_id=>wwv_flow_api.id(28550326865651362)
,p_name=>'P2_JL_FIND'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_api.id(28355542760232310)
,p_prompt=>'Search For'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>30
,p_tag_attributes=>'style="padding-top: 2px;"'
,p_colspan=>3
,p_grid_column=>1
,p_field_template=>wwv_flow_api.id(24295304255742259)
,p_item_templ