set timing off verify off echo off tab off pages 999 lines 200 trimspool on define "&" serverout on

WHENEVER SQLERROR EXIT
WHENEVER OSERROR EXIT

set term off feed off

define iv = '4.2.7'

column cronology_log new_value cronology_log noprint
select 'cronology_console_'||replace('&iv','.','_')||'_install_'||to_char(sysdate,'YYYYMMDDHH24MISS')||'.log' cronology_log from dual;

set term on feed on

declare
   script_user varchar2(30) := 'CRONOLOGY';
begin
   if user <> script_user then
      raise_application_error(-20000,'Please connect as '||script_user||' to run this script.');
   end if;
end;
/

declare
   script_user varchar2(30) := 'CRONOLOGY';
   rc number;
begin
   select count(*)
   into   rc
   from   dba_role_privs
   where  granted_role = 'APEX_ADMINISTRATOR_ROLE'
   and    grantee = script_user;
   if rc = 0 then
      raise_application_error(-20000,'Please connect as SYS and grant APEX_ADMINISTRATOR_ROLE role to '||script_user||' before running this script.');
   end if;
end;
/

clear screen

spool &cronology_log

prompt
prompt Cronology Console &iv Install
prompt ===============================
prompt

prompt
prompt Preparing APEX workspace ...
declare
   app_id number;
begin
   begin
      select application_id
      into   app_id
      from   apex_applications
      where  workspace = 'CRONOLOGY'
      and    alias = 'CRONOLOGY_CONSOLE';
   exception
      when no_data_found then
         dbms_output.put_line('Warning - no previous installation found - using application id 10101 to install the console application.');
         app_id := 10101;
   end;
   
-- remove any existing workspace (inc application) ...
   begin
      APEX_INSTANCE_ADMIN.REMOVE_WORKSPACE(p_workspace => 'CRONOLOGY');
   exception
      when others then
      -- assume does not exists
         null;
   end;

-- Create new workspace
    APEX_INSTANCE_ADMIN.ADD_WORKSPACE (
        p_workspace          => 'CRONOLOGY',
        p_primary_schema     => 'CRONOLOGY',
        p_additional_schemas => null );
        
   apex_instance_admin.set_workspace_parameter (
            p_workspace => 'CRONOLOGY',
            p_parameter => 'MAX_SESSION_LENGTH_SEC', 
            p_value     => 0 );        
            
   apex_instance_admin.set_workspace_parameter (
            p_workspace => 'CRONOLOGY',
            p_parameter => 'MAX_SESSION_IDLE_SEC' ,
            p_value     => 864000 );        

-- prepare to import the application
   apex_application_install.set_workspace('CRONOLOGY');
   apex_application_install.set_application_id(app_id);
   apex_application_install.generate_offset;

end;
/

prompt
prompt Importing the Cronology Console application into APEX ...
prompt

-- import the console application
@console_4207.sql

set verify off

declare
   app_id number;
begin
   select application_id
   into   app_id
   from   apex_applications
   where  workspace = 'CRONOLOGY'
   and    alias = 'CRONOLOGY_CONSOLE';
   
   apex_util.set_app_build_status(
        p_application_id => app_id,
        p_build_status   => 'RUN_ONLY' );
   commit;
end;
/

set pages 0 feed off
select message||chr(10)||rpad('=',length(message),'=')
from (select 'Cronology Console &iv Install Complete on '||
             upper(substr(host_name,1,decode(instr(host_name,'.'),0,9999,instr(host_name,'.')-1)))||' '||upper(instance_name) message
      from   v$instance);

prompt 
prompt To determine the console URL log in to the APEX admin services page to obtain the server, port and leading portion of the URL
prompt this will be determined by your ORDS configuration. The final portion of the URL is: f?p=CRONOLOGY_CONSOLE
prompt 
prompt

spool off
exit
