set timing off verify off echo off tab off pages 999 lines 32767 trimspool on define "&" serverout on

WHENEVER SQLERROR EXIT
WHENEVER OSERROR EXIT

set term off feed off

define iv = '4.2.7'

column cronology_log new_value cronology_log noprint
select 'sys_server_'||replace('&iv','.','_')||'_patch_'||to_char(sysdate,'YYYYMMDDHH24MISS')||'.log' cronology_log from dual;

set term on

declare
   script_user varchar2(30) := 'SYS';
begin
   if user <> script_user then
      raise_application_error(-20000,'Please connect as '||script_user||' to run this script.');
   end if;
end;
/

spool &cronology_log

prompt
prompt Cronology Server &iv Patch
prompt ============================
prompt

var curr_ver   varchar2(1000)

prompt Checking patch prerequisites ...
prompt
declare
   pv             varchar2(10) := '4.2';
   holder         varchar2(500);   
   rdbms_version  varchar2(20);
   rdbms_compat   varchar2(20);
begin

   dbms_utility.db_version(rdbms_version, rdbms_compat);
   holder := substr(rdbms_version,1,instr(rdbms_version,'.',1,2)-1);

   if to_number(holder) >= 12.1 and
         sys_context('USERENV','CON_ID') > 0 and
         sys_context('USERENV','CON_NAME') in ('PDB$SEED','CDB$ROOT') then
      -- Multitenant database ...
         select nvl(max('set LOCAL=<DB SERVICE>'),'export TWO_TASK=<DB SERVICE>')
         into   holder
         from   v$session
         where  sid = sys_context('USERENV','SID') and lower(program) like '%sqlplus.exe';
         raise_application_error(-20000,'Please connect directly to the PDB where Cronology is installed. Before starting SQL*Plus please: '||holder);
   end if;

   begin
      execute immediate 'begin
                             :v := cronology.install_info.server_ver;
                         exception
                            when others then
                              :v := sqlerrm;
                         end;' using in out :curr_ver;
   exception
      when others then
         :curr_ver := sqlerrm;
   end;

-- Assign directly so can also access outside of PL/SQL block
   :curr_ver := :curr_ver;

   if :curr_ver like 'ORA%' then
      raise_application_error(-20000,'Cronology server installation is currently invalid. Patching can only take place on a valid install. Please email support@cronology.co.uk if you require assistance.');
   elsif :curr_ver = '&iv' then
      dbms_output.put_line('Cronology server version '||:curr_ver||' detected - re-applying patch.');
   elsif :curr_ver like pv||'.%' then
      dbms_output.put_line('Cronology server version '||:curr_ver||' detected.');
   else
      raise_application_error(-20000,'Cronology server version '||:curr_ver||' not valid for patching to version &iv Please upgrade to version '||pv||'.0 first.');
   end if;
   
end;
/

declare
   ins_status  clob;
begin
   ins_status := cronology.install_info.validate_install;
   dbms_output.put_line(ins_status);
   if ins_status <> 'Installation valid.' then
      ins_status := cronology.install_info.show_invalid;
      dbms_output.put_line(ins_status);
      raise_application_error(-20000,'Cronology server installation is currently invalid. Patching can only take place on a valid install. Please email support@cronology.co.uk if you require assistance.');
   end if;
end;
/

prompt
prompt Stopping Cronology background processes ...
prompt
begin
      begin
         execute immediate 'begin cronology.external.stop_log_writer; end;';
      exception
         when others then
            null;
      end;
      begin
         execute immediate 'begin cronology.external.stop_job_poller; end;';
      exception
         when others then
            null;
      end;
      begin
         execute immediate 'begin cronology.external.stop_message_server; end;';
      exception
         when others then
            null;
      end;
end;
/
prompt Complete.

declare
   conns boolean := false;
   holder                varchar2(100);
begin
   for i in (select inst_id, username, module, program, osuser, sid, serial#
             from   gv$session
             where  username = 'CRONOLOGY'
             and   (sid, inst_id) not in (select sys_context('USERENV','SID') , sys_context('USERENV','INSTANCE') from dual)) loop
      conns := true;
      dbms_output.put_line(chr(10)||'Instance ID: '||i.inst_id);
      dbms_output.put_line('Username   : '||i.username);
      dbms_output.put_line('Module     : '||i.module);
      dbms_output.put_line('Program    : '||i.program);
      dbms_output.put_line('OS User    : '||i.osuser);
      dbms_output.put_line('SID        : '||i.sid);
      dbms_output.put_line('Serial#    : '||i.serial#);
   end loop;

   if conns then
      dbms_output.put_line(chr(10)||'Cronology database sessions still exist (see above). The Job Poller, Log Writer and Message Server have been stopped so these must be user connections.'||chr(10));
      raise_application_error(-20000,'Please disconnect all Cronology related sessions before patching.');
   end if;
end;
/

prompt
prompt Prerequisite checks complete.
prompt

set feed off

set pages 0

select 'Patch will take place on '||
upper(substr(host_name,1,decode(instr(host_name,'.'),0,9999,instr(host_name,'.')-1)))||' '||upper(instance_name)
from v$instance;

prompt

spool off

----------------------------------------------------------------------------------------------------------------------------------------------
-- Provide backup option if install already exists ...
----------------------------------------------------------------------------------------------------------------------------------------------

define do_backup=N
define spw=X

set term off
spool tmp_backup.sql
select decode(max(username), null, '',
'accept do_backup   CHAR default ''Y'' prompt ''Do you wish to backup the existing CRONOLOGY server installation? [Y] : '''
)
from   dba_users where username = 'CRONOLOGY';

spool off
set term on

spool &cronology_log append

@tmp_backup.sql

set term off

column tidy_command new_value tidy_command noprint
column esc new_value esc noprint
set null ""

select case when max(1) is null then 'rm -f tmp_backup.sql'
       else 'del tmp_backup.sql' end tidy_command
      ,case when max(1) is null then '\'
       else null end esc
from   v$session
where  sid = sys_context('USERENV','SID') and lower(program) like '%sqlplus.exe';

spool off

spool tmp_backup.sql
select 'set define "#"'||chr(10)||
       'prompt'||chr(10)||
       'accept spw   CHAR prompt ''Please enter SYS password : ''' ||chr(10)||
       'prompt'||chr(10)||
       'prompt Exporting CRONOLOGY schema to: cronology_'||:curr_ver||'_backup_'||to_char(sysdate,'YYYYMMDD_HH24MISS')||'.dmp'||chr(10)||
       'host exp userid=&esc''sys/#spw as sysdba&esc'' owner=cronology file=cronology_'||:curr_ver||'_backup_'||to_char(sysdate,'YYYYMMDD_HH24MISS')||'.dmp '||
       'log=cronology_pre_patch_backup_'||to_char(sysdate,'YYYYMMDD_HH24MISS')||'.log'||chr(10)||
       'accept pause prompt "If the backup completed successfully press any key to continue or enter QUIT to exit : "'||chr(10)||
       'set term off'||chr(10)||
       'select 1 from dual where decode (upper(''#pause''),''QUIT'',''quit'',1) = 0;'
from   dual where 'Y' = upper('&do_backup');
spool off

set term on pages 999 feed on

spool &cronology_log append

@tmp_backup.sql

set term on pages 999 feed on define "&"

host &tidy_command

prompt
prompt Cronology Server &iv Patch
prompt ============================
prompt

------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------

GRANT SELECT_CATALOG_ROLE                TO CRONOLOGY;
GRANT SELECT  ON GV_$SQL                 TO CRONOLOGY;
GRANT EXECUTE ON DBMS_LOB                TO CRONOLOGY;
GRANT SELECT  ON DBA_PROFILES            TO CRONOLOGY;
GRANT SELECT  ON JAVA$RUNTIME$EXEC$USER$ TO CRONOLOGY;
GRANT SELECT  ON V_$OSSTAT               TO CRONOLOGY;

------------------------------------------------------------------------------------------------------------
------------------------------------------------------------------------------------------------------------

prompt
prompt Script complete.
prompt
spool off
